/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressCollection;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.IPAddressSeqRangeList;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.format.util.AddressTrie;
import inet.ipaddr.format.util.BinaryTreeNode;
import inet.ipaddr.format.util.IPAddressTrie;
import inet.ipaddr.format.validate.ChangeTracker;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IPAddressContainmentTrieBase<T extends IPAddress, R extends IPAddressSeqRange>
implements IPAddressCollection<T, R> {
    private static final long serialVersionUID = 1L;
    private ChangeTracker changeTracker = new ChangeTracker();
    CollectionTrie trie = new CollectionTrie(this.changeTracker);

    private boolean removeBlock(T block) {
        AddressTrie.TrieNode<IPAddress>[] nodes = this.trie.removeElementsIntersected((IPAddress)block);
        if (nodes != null) {
            AddressTrie.TrieNode<IPAddress> deletedNode = nodes[0];
            IPAddress nodeKey = (IPAddress)deletedNode.getKey();
            if (nodeKey != null && nodeKey.contains((IPAddress)block) && !nodeKey.equals(block)) {
                IPAddress[] remainder = nodeKey.subtract((IPAddress)block);
                AddressTrie.TrieNode<IPAddress> parentNode = nodes[1];
                for (int i = 0; i < remainder.length; ++i) {
                    IPAddress[] newBlocks = remainder[i].spanWithPrefixBlocks();
                    for (int j = 0; j < newBlocks.length; ++j) {
                        this.trie.addFromParent(parentNode, newBlocks[j]);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean addBlock(T block) {
        IPAddressTrie.IPAddressTrieNode node = this.trie.addIfNoElementsContaining((IPAddress)block);
        if (node != null) {
            BinaryTreeNode largestFull = null;
            for (IPAddressTrie.IPAddressTrieNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.containingMaxElements()) continue;
                largestFull = parent;
            }
            if (largestFull == null) {
                node.removeChildren();
            } else {
                largestFull.setAdded();
                largestFull.removeChildren();
            }
            return true;
        }
        return false;
    }

    private static <T extends IPAddress> boolean addressPredicateOp(T addr, Predicate<T> op, boolean all, boolean breakEarly, boolean stripSingleAddressPrefLen) {
        if (!addr.isMultiple()) {
            if (!addr.isPrefixed()) {
                return op.test(addr);
            }
            return op.test(addr.withoutPrefixLength());
        }
        if (addr.isSinglePrefixBlock()) {
            return op.test(addr);
        }
        return IPAddressContainmentTrieBase.blocksPredicateOp((IPAddress[])addr.spanWithPrefixBlocks(), op, (boolean)all, (boolean)breakEarly, (boolean)stripSingleAddressPrefLen);
    }

    private static <T extends IPAddress> boolean blocksPredicateOp(T[] blocks, Predicate<T> op, boolean all, boolean breakEarly, boolean stripSingleAddressPrefLen) {
        boolean result = all;
        for (int i = 0; i < blocks.length; ++i) {
            Object block = blocks[i];
            if (stripSingleAddressPrefLen && ((Address)block).isPrefixed() && !((Address)block).isMultiple()) {
                block = ((IPAddress)block).withoutPrefixLength();
            }
            boolean res = op.test(block);
            if (all) {
                if (res) continue;
                result = false;
                if (!breakEarly) continue;
                break;
            }
            if (!res) continue;
            result = true;
            if (breakEarly) break;
        }
        return result;
    }

    private static <T extends IPAddress, R extends IPAddressSeqRange> boolean rangePredicateOp(R rng, Predicate<T> op, boolean all, boolean breakEarly, boolean stripSingleAddressPrefLen) {
        if (!rng.isMultiple()) {
            return op.test(rng.getLower());
        }
        return IPAddressContainmentTrieBase.blocksPredicateOp((IPAddress[])rng.spanWithPrefixBlocks(), op, (boolean)all, (boolean)breakEarly, (boolean)stripSingleAddressPrefLen);
    }

    @Override
    public void clear() {
        this.trie.clear();
    }

    @Override
    public boolean add(T addr) {
        return IPAddressContainmentTrieBase.addressPredicateOp(addr, this::addBlock, false, false, true);
    }

    @Override
    public boolean add(R rng) {
        return IPAddressContainmentTrieBase.rangePredicateOp(rng, this::addBlock, false, false, true);
    }

    @Override
    public boolean remove(T addr) {
        return IPAddressContainmentTrieBase.addressPredicateOp(addr, this::removeBlock, false, false, false);
    }

    @Override
    public boolean remove(R rng) {
        return IPAddressContainmentTrieBase.rangePredicateOp(rng, this::removeBlock, false, false, false);
    }

    @Override
    public boolean contains(T addr) {
        return IPAddressContainmentTrieBase.addressPredicateOp(addr, this.trie::elementContains, true, true, false);
    }

    @Override
    public boolean contains(R rng) {
        return IPAddressContainmentTrieBase.rangePredicateOp(rng, this.trie::elementContains, true, true, false);
    }

    @Override
    public boolean overlaps(T addr) {
        return IPAddressContainmentTrieBase.addressPredicateOp(addr, this.trie::elementOverlaps, false, true, false);
    }

    @Override
    public boolean overlaps(R rng) {
        return IPAddressContainmentTrieBase.rangePredicateOp(rng, this.trie::elementOverlaps, false, true, false);
    }

    @Override
    public T lower(T addr) {
        IPAddressTrie.IPAddressTrieNode node = this.trie.containingLowerAddedNode((IPAddress)(addr = ((IPAddress)addr).getLower()));
        if (node == null) {
            return null;
        }
        IPAddress key = (IPAddress)node.getKey();
        if (key.contains((IPAddress)addr)) {
            return (T)((IPAddress)addr).withoutPrefixLength().decrement();
        }
        return (T)key.withoutPrefixLength().getUpper();
    }

    @Override
    public T floor(T addr) {
        IPAddressTrie.IPAddressTrieNode node = this.trie.containingFloorAddedNode((IPAddress)(addr = ((IPAddress)addr).getLower()));
        if (node == null) {
            return null;
        }
        IPAddress key = (IPAddress)node.getKey();
        if (key.contains((IPAddress)addr)) {
            return (T)((IPAddress)addr).withoutPrefixLength();
        }
        return (T)key.withoutPrefixLength().getUpper();
    }

    @Override
    public T ceiling(T addr) {
        IPAddressTrie.IPAddressTrieNode node = this.trie.containingCeilingAddedNode((IPAddress)(addr = ((IPAddress)addr).getUpper()));
        if (node == null) {
            return null;
        }
        IPAddress key = (IPAddress)node.getKey();
        if (key.contains((IPAddress)addr)) {
            return (T)((IPAddress)addr).withoutPrefixLength();
        }
        return (T)key.withoutPrefixLength().getLower();
    }

    @Override
    public T higher(T addr) {
        IPAddressTrie.IPAddressTrieNode node = this.trie.containingHigherAddedNode((IPAddress)(addr = ((IPAddress)addr).getUpper()));
        if (node == null) {
            return null;
        }
        IPAddress key = (IPAddress)node.getKey();
        if (key.contains((IPAddress)addr)) {
            return (T)((IPAddress)addr).withoutPrefixLength().increment();
        }
        return (T)key.withoutPrefixLength().getLower();
    }

    public T coverWithPrefixBlock() {
        BinaryTreeNode coveringNode;
        BinaryTreeNode root = this.trie.getRoot();
        if (root.isAdded()) {
            coveringNode = root;
        } else {
            BinaryTreeNode lower = ((AddressTrie.TrieNode)root).getLowerSubNode();
            BinaryTreeNode upper = ((AddressTrie.TrieNode)root).getUpperSubNode();
            if (lower == null) {
                if (upper == null) {
                    return null;
                }
                coveringNode = upper;
            } else {
                coveringNode = upper == null ? lower : root;
            }
        }
        return (T)((IPAddress)coveringNode.getKey());
    }

    public R coverWithSequentialRange() {
        T lower = this.getLower();
        if (lower == null) {
            return null;
        }
        return (R)((IPAddress)lower).spanWithRange((IPAddress)this.getUpper());
    }

    @Override
    public BigInteger getCount() {
        return this.trie.getMatchingAddressCount();
    }

    @Override
    public T getLower() {
        IPAddressTrie.IPAddressTrieNode firstNode = this.trie.firstAddedNode();
        if (firstNode == null) {
            return null;
        }
        return (T)((IPAddress)firstNode.getKey()).getLower();
    }

    @Override
    public T getUpper() {
        IPAddressTrie.IPAddressTrieNode lastNode = this.trie.lastAddedNode();
        if (lastNode == null) {
            return null;
        }
        return (T)((IPAddress)lastNode.getKey()).getUpper();
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private ChangeTracker.Change currentChange;
            private Iterator<T> trieIterator;
            private Iterator<T> blockIterator;
            {
                this.currentChange = IPAddressContainmentTrieBase.this.changeTracker.getCurrent();
                this.trieIterator = IPAddressContainmentTrieBase.this.trie.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.blockIterator != null && this.blockIterator.hasNext() || this.trieIterator.hasNext();
            }

            @Override
            public T next() {
                if (this.blockIterator != null && this.blockIterator.hasNext()) {
                    IPAddressContainmentTrieBase.this.changeTracker.changedSince(this.currentChange);
                    return (IPAddress)this.blockIterator.next();
                }
                this.blockIterator = null;
                IPAddress block = (IPAddress)this.trieIterator.next();
                if (block.isMultiple()) {
                    this.blockIterator = block.withoutPrefixLength().iterator();
                    return (IPAddress)this.blockIterator.next();
                }
                return block;
            }
        };
    }

    @Override
    public Spliterator<T> spliterator() {
        return new ContainmentTrieSpliterator(this.trie.spliterator(), this.changeTracker, this.getCount());
    }

    public Iterator<T> prefixBlockIterator() {
        return this.trie.iterator();
    }

    public int getPrefixBlockCount() {
        return this.trie.size();
    }

    public T getLowerPrefixBlock() {
        return (T)((IPAddress)this.trie.firstAddedNode().getKey());
    }

    public T getUpperPrefixBlock() {
        return (T)((IPAddress)this.trie.lastAddedNode().getKey());
    }

    public Iterable<T> getPrefixBlockIterable() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IPAddressContainmentTrieBase.this.prefixBlockIterator();
            }

            @Override
            public Spliterator<T> spliterator() {
                return IPAddressContainmentTrieBase.this.trie.spliterator();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.trie.isEmpty();
    }

    @Override
    public boolean isMultiple() {
        IPAddressTrie.IPAddressTrieNode firstNode = this.trie.firstAddedNode();
        if (firstNode != null) {
            return ((IPAddress)firstNode.getKey()).isMultiple() || firstNode != this.trie.lastAddedNode();
        }
        return false;
    }

    @Override
    public boolean includesZero() {
        IPAddressTrie.IPAddressTrieNode firstNode = this.trie.firstAddedNode();
        return firstNode != null && ((IPAddress)firstNode.getKey()).includesZero();
    }

    @Override
    public boolean includesMax() {
        IPAddressTrie.IPAddressTrieNode lastNode = this.trie.lastAddedNode();
        return lastNode != null && ((IPAddress)lastNode.getKey()).includesMax();
    }

    @Override
    public boolean isSequential() {
        T lower = this.getLower();
        if (lower == null) {
            return true;
        }
        T upper = this.getUpper();
        return ((IPAddress)lower).enumerate((IPAddress)upper).add(BigInteger.ONE).equals(this.getCount());
    }

    public String toString() {
        return this.trie.toString(true, false, true);
    }

    static boolean collectionsEqual(IPAddressCollection<? extends IPAddress, ?> one, IPAddressCollection<? extends IPAddress, ?> other) {
        if (one.getCount().equals(other.getCount())) {
            Iterator otherIter = other.iterator();
            Iterator iter = one.iterator();
            while (iter.hasNext()) {
                if (((IPAddress)iter.next()).equals(otherIter.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IPAddressContainmentTrieBase) {
            if (this == other) {
                return true;
            }
            IPAddressContainmentTrieBase otherColl = (IPAddressContainmentTrieBase)other;
            return this.trie.equals(otherColl.trie);
        }
        if (other instanceof IPAddressSeqRangeList) {
            IPAddressSeqRangeList otherColl = (IPAddressSeqRangeList)other;
            return this.getCount().equals(otherColl.getCount()) && otherColl.contains(this);
        }
        if (other instanceof IPAddressCollection) {
            IPAddressCollection otherColl = (IPAddressCollection)other;
            return IPAddressContainmentTrieBase.collectionsEqual(this, otherColl);
        }
        return false;
    }

    @Override
    public IPAddressContainmentTrieBase<T, R> clone() {
        try {
            IPAddressContainmentTrieBase cloned = (IPAddressContainmentTrieBase)super.clone();
            cloned.changeTracker = new ChangeTracker();
            cloned.trie = this.trie.clone(cloned.changeTracker);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int hashCode() {
        return this.trie.hashCode();
    }

    private static class ContainmentTrieSpliterator<T extends IPAddress>
    implements Spliterator<T> {
        private ChangeTracker changeTracker;
        private ChangeTracker.Change currentChange;
        private Spliterator<T> trieSpliterator;
        private AddressComponentSpliterator<T> blockSpliterator;
        private BigInteger estimatedSize;

        ContainmentTrieSpliterator(Spliterator<T> trieSpliterator, ChangeTracker changeTracker, BigInteger size) {
            this.changeTracker = changeTracker;
            this.trieSpliterator = trieSpliterator;
            this.currentChange = changeTracker.getCurrent();
            this.estimatedSize = size;
        }

        ContainmentTrieSpliterator(Spliterator<T> trieSpliterator, ChangeTracker changeTracker, ChangeTracker.Change currentChange, BigInteger estimatedSize) {
            this.changeTracker = changeTracker;
            this.trieSpliterator = trieSpliterator;
            this.currentChange = currentChange;
            this.estimatedSize = estimatedSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.blockSpliterator != null) {
                this.changeTracker.changedSince(this.currentChange);
                if (this.blockSpliterator.tryAdvance(action)) {
                    return true;
                }
                this.blockSpliterator = null;
            }
            boolean hasBlock = this.trieSpliterator.tryAdvance(addr -> {
                if (addr.isMultiple()) {
                    this.blockSpliterator = addr.withoutPrefixLength().spliterator();
                    this.blockSpliterator.tryAdvance(action);
                } else {
                    action.accept(addr);
                }
            });
            return hasBlock;
        }

        @Override
        public Spliterator<T> trySplit() {
            if (this.blockSpliterator != null) {
                this.changeTracker.changedSince(this.currentChange);
                return this.blockSpliterator.trySplit();
            }
            Spliterator<T> split = this.trieSpliterator.trySplit();
            if (split == null) {
                return null;
            }
            this.estimatedSize = this.estimatedSize.shiftRight(1);
            return new ContainmentTrieSpliterator<T>(split, this.changeTracker, this.currentChange, this.estimatedSize);
        }

        @Override
        public long estimateSize() {
            if (this.estimatedSize.compareTo(IPAddressSeqRangeList.LONG_MAX) >= 0) {
                return Long.MAX_VALUE;
            }
            return this.estimatedSize.longValue();
        }

        @Override
        public int characteristics() {
            return this.trieSpliterator.characteristics();
        }

        @Override
        public Comparator<? super T> getComparator() {
            return null;
        }
    }

    static class CollectionTrie
    extends IPAddressTrie {
        private static final long serialVersionUID = 1L;

        CollectionTrie(ChangeTracker changeTracker) {
            super(changeTracker);
        }

        public AddressTrie.TrieNode<IPAddress>[] removeElementsIntersected(IPAddress addr) {
            return this.removeElementsIntersectedBy(addr, false);
        }

        @Override
        protected boolean addFromParent(AddressTrie.TrieNode<IPAddress> parent, IPAddress addr) {
            return super.addFromParent(parent, addr);
        }

        @Override
        public IPAddressTrie.IPAddressTrieNode addIfNoElementsContaining(IPAddress addr) {
            return this.addIfNoElementsContaining(addr, false);
        }

        @Override
        public IPAddressTrie.IPAddressTrieNode containingFloorAddedNode(IPAddress addr) {
            return this.containingFloorAddedNodeNoCheck(addr);
        }

        @Override
        public IPAddressTrie.IPAddressTrieNode containingHigherAddedNode(IPAddress addr) {
            return this.containingHigherAddedNodeNoCheck(addr);
        }

        @Override
        public IPAddressTrie.IPAddressTrieNode containingCeilingAddedNode(IPAddress addr) {
            return this.containingCeilingAddedNodeNoCheck(addr);
        }

        @Override
        public IPAddressTrie.IPAddressTrieNode containingLowerAddedNode(IPAddress addr) {
            return this.containingLowerAddedNodeNoCheck(addr);
        }

        @Override
        public CollectionTrie clone(ChangeTracker tracker) {
            return (CollectionTrie)super.clone(tracker);
        }
    }
}

