/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.validate.AddressParseData;
import inet.ipaddr.format.validate.IPAddressParseData;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.ParsedAddressCreator;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.io.Serializable;
import java.util.Objects;

public class ParsedIPAddress
extends IPAddressParseData
implements IPAddressProvider {
    private static final long serialVersionUID = 4L;
    private final IPAddressStringParameters options;
    private final HostIdentifierString originator;
    private CachedIPAddresses<?> values;
    private Boolean skipContains;

    ParsedIPAddress(HostIdentifierString from, CharSequence addressString, IPAddressStringParameters options) {
        super(addressString);
        this.options = options;
        this.originator = from;
    }

    private IPv6AddressNetwork.IPv6AddressCreator getIPv6AddressCreator() {
        return this.getParameters().getIPv6Parameters().getNetwork().getAddressCreator();
    }

    private IPv4AddressNetwork.IPv4AddressCreator getIPv4AddressCreator() {
        return this.getParameters().getIPv4Parameters().getNetwork().getAddressCreator();
    }

    @Override
    public boolean isProvidingIPAddress() {
        return true;
    }

    @Override
    public IPAddressProvider.IPType getType() {
        return IPAddressProvider.IPType.from(this.getProviderIPVersion());
    }

    @Override
    public IPAddressStringParameters getParameters() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedIPAddresses<?> getCachedAddresses() {
        CachedIPAddresses<?> val = this.values;
        if (val == null) {
            ParsedIPAddress parsedIPAddress = this;
            synchronized (parsedIPAddress) {
                val = this.values;
                if (val == null) {
                    this.values = val = this.createAddresses();
                    this.releaseSegmentData();
                }
            }
        }
        return val;
    }

    @Override
    public IPAddress getProviderHostAddress() {
        return this.getCachedAddresses().getHostAddress();
    }

    @Override
    public IPAddress getProviderAddress() {
        return this.getCachedAddresses().getAddress();
    }

    @Override
    public IPAddress getProviderAddress(IPAddress.IPVersion version) {
        IPAddress.IPVersion thisVersion = this.getProviderIPVersion();
        if (!version.equals((Object)thisVersion)) {
            return null;
        }
        return this.getProviderAddress();
    }

    private boolean skipContains() {
        IPAddress mask;
        Boolean result = this.skipContains;
        if (result != null) {
            return result;
        }
        AddressParseData parseData = this.getAddressParseData();
        int segmentCount = parseData.getSegmentCount();
        if (this.isProvidingIPv4()) {
            if (segmentCount != 4) {
                this.skipContains = Boolean.TRUE;
                return true;
            }
        } else if (this.isProvidingMixedIPv6() || segmentCount != 8 && !this.isCompressed()) {
            this.skipContains = Boolean.TRUE;
            return true;
        }
        if ((mask = this.getQualifier().getMask()) != null && mask.getBlockMaskPrefixLength(true) == null) {
            this.skipContains = Boolean.TRUE;
            return true;
        }
        this.skipContains = Boolean.FALSE;
        return false;
    }

    @Override
    public int providerHashCode() {
        IPAddress value = this.getProviderAddress();
        if (value != null) {
            return value.hashCode();
        }
        return Objects.hashCode((Object)this.getType());
    }

    @Override
    public Boolean contains(String other) {
        AddressParseData parseData = this.getAddressParseData();
        int[] segmentData = parseData.getSegmentData();
        if (segmentData == null) {
            return null;
        }
        if (this.skipContains()) {
            return null;
        }
        if (this.has_inet_aton_value || this.hasIPv4LeadingZeros) {
            return null;
        }
        Integer pref = this.getProviderNetworkPrefixLength();
        IPAddressStringParameters options = this.getParameters();
        IPAddressNetwork<?, ?, ?, ?, ?> network = (this.isProvidingIPv4() ? options.getIPv4Parameters() : options.getIPv6Parameters()).getNetwork();
        if (pref != null && !this.isPrefixSubnet(pref, network, segmentData)) {
            return null;
        }
        return this.matchesPrefix(other, segmentData);
    }

    @Override
    public Boolean prefixEquals(String other) {
        AddressParseData parseData = this.getAddressParseData();
        int[] segmentData = parseData.getSegmentData();
        if (segmentData == null) {
            return null;
        }
        if (this.skipContains()) {
            return null;
        }
        if (this.has_inet_aton_value || this.hasIPv4LeadingZeros) {
            return null;
        }
        return this.matchesPrefix(other, segmentData);
    }

    private Boolean matchesPrefix(String other, int[] segmentData) {
        int bytesPerSegment;
        int bitsPerSegment;
        boolean prefixIsMidSegment;
        int prefixEndCharIndex;
        int expectedCount;
        AddressParseData parseData = this.getAddressParseData();
        Integer pref = this.getProviderNetworkPrefixLength();
        boolean compressedAlready = false;
        boolean networkSegIsCompressed = false;
        boolean isIPv4 = this.isProvidingIPv4();
        int adjustment = 0;
        int networkSegsCount = 0;
        int networkSegIndex = 0;
        int networkSegCharIndex = 0;
        int remainingSegsCharIndex = 0;
        int otherLen = other.length();
        if (pref == null) {
            expectedCount = isIPv4 ? 4 : 8;
            networkSegIndex = expectedCount - 1;
            prefixEndCharIndex = ParsedIPAddress.getIndex(networkSegIndex, 15, segmentData);
            if (otherLen > prefixEndCharIndex) {
                return null;
            }
            prefixIsMidSegment = false;
        } else if (pref == 0) {
            prefixIsMidSegment = false;
            expectedCount = isIPv4 ? 4 : 8;
            prefixEndCharIndex = 0;
        } else if (isIPv4) {
            expectedCount = 4;
            bitsPerSegment = 8;
            bytesPerSegment = 1;
            networkSegIndex = ParsedAddressGrouping.getNetworkSegmentIndex(pref, bytesPerSegment, bitsPerSegment);
            prefixEndCharIndex = ParsedIPAddress.getIndex(networkSegIndex, 15, segmentData);
            Integer segPrefLength = ParsedAddressGrouping.getPrefixedSegmentPrefixLength(bitsPerSegment, pref, networkSegIndex);
            if (segPrefLength == 7) {
                prefixIsMidSegment = true;
                adjustment = 1;
                remainingSegsCharIndex = ParsedIPAddress.getIndex(networkSegIndex, 14, segmentData);
                --prefixEndCharIndex;
                networkSegsCount = networkSegIndex;
                networkSegCharIndex = ParsedIPAddress.getIndex(networkSegIndex, 11, segmentData);
            } else {
                prefixIsMidSegment = segPrefLength != bitsPerSegment;
                networkSegsCount = networkSegIndex + 1;
                remainingSegsCharIndex = prefixEndCharIndex + 1;
                if (prefixIsMidSegment) {
                    networkSegCharIndex = ParsedIPAddress.getIndex(networkSegIndex, 11, segmentData);
                }
            }
        } else {
            expectedCount = 8;
            bitsPerSegment = 16;
            bytesPerSegment = 2;
            networkSegIndex = ParsedAddressGrouping.getNetworkSegmentIndex(pref, bytesPerSegment, bitsPerSegment);
            prefixEndCharIndex = ParsedIPAddress.getIndex(networkSegIndex, 15, segmentData);
            int missingSegmentCount = 8 - parseData.getSegmentCount();
            int compressedSegIndex = this.getConsecutiveSeparatorSegmentIndex();
            compressedAlready = compressedSegIndex <= networkSegIndex;
            boolean bl = networkSegIsCompressed = compressedAlready && compressedSegIndex + missingSegmentCount > networkSegIndex;
            if (networkSegIsCompressed) {
                prefixIsMidSegment = false;
                networkSegsCount = networkSegIndex + 1;
                remainingSegsCharIndex = prefixEndCharIndex + 1;
            } else {
                Integer segPrefLength = ParsedAddressGrouping.getPrefixedSegmentPrefixLength(bitsPerSegment, pref, networkSegIndex);
                adjustment = 4 - (segPrefLength + 3 >> 2);
                if (adjustment > 0) {
                    prefixIsMidSegment = true;
                    remainingSegsCharIndex = ParsedIPAddress.getIndex(networkSegIndex, 14, segmentData);
                    prefixEndCharIndex = Math.max(prefixEndCharIndex - adjustment, remainingSegsCharIndex);
                    networkSegsCount = networkSegIndex;
                    networkSegCharIndex = ParsedIPAddress.getIndex(networkSegIndex, 11, segmentData);
                } else {
                    prefixIsMidSegment = segPrefLength != bitsPerSegment;
                    networkSegsCount = networkSegIndex + 1;
                    remainingSegsCharIndex = prefixEndCharIndex + 1;
                    if (prefixIsMidSegment) {
                        networkSegCharIndex = ParsedIPAddress.getIndex(networkSegIndex, 11, segmentData);
                    }
                }
            }
        }
        CharSequence str = this.str;
        int otherSegmentCount = 0;
        boolean currentSegHasNonZeroDigits = false;
        for (int i = 0; i < prefixEndCharIndex; ++i) {
            boolean isSegmentEnd;
            char otherChar;
            char c = str.charAt(i);
            if (c != (otherChar = i < otherLen ? other.charAt(i) : (char)'\u0000')) {
                int k;
                char adjustedChar;
                if (!(c >= '1' && c <= '9' || c >= 'a' && c <= 'f')) {
                    if (c >= 'A' && c <= 'F') {
                        adjustedChar = (char)(c - -32);
                        if (c == adjustedChar) {
                            continue;
                        }
                    } else if (c <= '-' && c >= '%' ? c == '*' || c == '-' || c == '%' : c == '_') {
                        return null;
                    }
                }
                if (prefixIsMidSegment && i >= networkSegCharIndex) {
                    return null;
                }
                if (!(otherChar >= '1' && otherChar <= '9' || otherChar >= 'a' && otherChar <= 'f')) {
                    if (otherChar >= 'A' && otherChar <= 'F') {
                        adjustedChar = (char)(otherChar - -32);
                        if (otherChar == adjustedChar) {
                            continue;
                        }
                    } else {
                        if (otherChar <= '-' && otherChar >= '%' ? otherChar == '*' || otherChar == '-' || otherChar == '%' : otherChar == '_') {
                            return null;
                        }
                        if (!currentSegHasNonZeroDigits) {
                            if (c == '0') {
                                char nextChar;
                                if (otherChar == ':' || otherChar == '\u0000') {
                                    return null;
                                }
                                k = i + 1;
                                if (k < str.length() && (nextChar = str.charAt(k)) != '.' && nextChar != ':') {
                                    return null;
                                }
                            } else if (otherChar == '0') {
                                char nextChar;
                                if (c == ':') {
                                    return null;
                                }
                                k = i + 1;
                                if (k < otherLen && (nextChar = other.charAt(k)) != '.' && nextChar != ':') {
                                    return null;
                                }
                                return Boolean.FALSE;
                            }
                        }
                        if (otherChar == ':') {
                            return Boolean.FALSE;
                        }
                        if (otherChar == '.') {
                            if (!isIPv4) {
                                return null;
                            }
                            ++otherSegmentCount;
                        }
                    }
                }
                for (k = i + 1; k < otherLen; ++k) {
                    otherChar = other.charAt(k);
                    if (otherChar == ':') {
                        return Boolean.FALSE;
                    }
                    if (otherChar > '/' || otherChar < '%') continue;
                    if (otherChar == '.') {
                        if (!isIPv4) {
                            return null;
                        }
                        ++otherSegmentCount;
                        continue;
                    }
                    if (otherChar != '/' && otherChar != '*' && otherChar != '-' && otherChar != '%') continue;
                    return null;
                }
                if (isIPv4 ? otherSegmentCount + 1 == 4 : otherSegmentCount > 0) {
                    return Boolean.FALSE;
                }
                return null;
            }
            if (c == '0') continue;
            boolean bl = isSegmentEnd = c == ':' || c == '.';
            if (isSegmentEnd) {
                ++otherSegmentCount;
                currentSegHasNonZeroDigits = false;
                continue;
            }
            currentSegHasNonZeroDigits = true;
        }
        if (pref != null) {
            int digitCount;
            if (prefixEndCharIndex == otherLen) {
                if (!(networkSegsCount == expectedCount || compressedAlready && networkSegsCount <= expectedCount)) {
                    return null;
                }
            } else if (isIPv4) {
                if (adjustment == 0 && pref != 0 && other.charAt(prefixEndCharIndex) != '.') {
                    return null;
                }
                digitCount = 0;
                int remainingSegCount = 0;
                boolean firstIsHighIPv4 = false;
                for (int i = remainingSegsCharIndex; i < otherLen; ++i) {
                    char otherChar = other.charAt(i);
                    if (otherChar <= '9' && otherChar >= '0') {
                        if (digitCount == 0 && otherChar >= '3') {
                            firstIsHighIPv4 = true;
                        }
                        ++digitCount;
                        continue;
                    }
                    if (otherChar == '.') {
                        if (digitCount == 0) {
                            return Boolean.FALSE;
                        }
                        if (firstIsHighIPv4) {
                            if (digitCount >= 3) {
                                return Boolean.FALSE;
                            }
                        } else if (digitCount > 3) {
                            return null;
                        }
                        digitCount = 0;
                        ++remainingSegCount;
                        firstIsHighIPv4 = false;
                        continue;
                    }
                    return null;
                }
                if (digitCount == 0) {
                    return Boolean.FALSE;
                }
                if (digitCount > 3) {
                    return null;
                }
                if (firstIsHighIPv4 && digitCount == 3) {
                    return null;
                }
                int totalSegCount = networkSegsCount + remainingSegCount + 1;
                if (totalSegCount != expectedCount) {
                    return null;
                }
            } else {
                if (adjustment == 0 && pref != 0 && other.charAt(prefixEndCharIndex) != ':') {
                    return null;
                }
                digitCount = 0;
                int remainingSegCount = 0;
                for (int i = remainingSegsCharIndex; i < otherLen; ++i) {
                    char otherChar = other.charAt(i);
                    if (otherChar <= '9' && otherChar >= '0') {
                        ++digitCount;
                        continue;
                    }
                    if (otherChar >= 'a' && otherChar <= 'f' || otherChar >= 'A' && otherChar <= 'F') {
                        ++digitCount;
                        continue;
                    }
                    if (otherChar == '.') {
                        return null;
                    }
                    if (otherChar == ':') {
                        if (digitCount > 4) {
                            return null;
                        }
                        if (digitCount == 0) {
                            if (compressedAlready) {
                                return Boolean.FALSE;
                            }
                            compressedAlready = true;
                        } else {
                            digitCount = 0;
                        }
                        ++remainingSegCount;
                        continue;
                    }
                    return null;
                }
                if (digitCount == 0) {
                    if (compressedAlready) {
                        return Boolean.FALSE;
                    }
                    compressedAlready = true;
                } else if (digitCount > 4) {
                    return null;
                }
                int totalSegCount = networkSegsCount + remainingSegCount + 1;
                if (totalSegCount > expectedCount || totalSegCount < expectedCount && !compressedAlready) {
                    return null;
                }
                if (networkSegIsCompressed && expectedCount - remainingSegCount <= networkSegIndex) {
                    return null;
                }
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean contains(IPAddressProvider other) {
        if (other instanceof ParsedIPAddress) {
            CachedIPAddresses<?> vals = this.values;
            CachedIPAddresses<?> otherVals = this.values;
            if (vals == null || otherVals == null) {
                return this.contains((ParsedIPAddress)other, false, false);
            }
        }
        return null;
    }

    @Override
    public Boolean parsedEquals(IPAddressProvider other) {
        if (other instanceof ParsedIPAddress) {
            ParsedIPAddress parsedOther;
            Boolean result;
            CachedIPAddresses<?> vals = this.values;
            CachedIPAddresses<?> otherVals = this.values;
            if ((vals == null || otherVals == null) && (result = this.contains(parsedOther = (ParsedIPAddress)other, false, true)) != null) {
                return result != false && Objects.equals(this.getQualifier().getZone(), parsedOther.getQualifier().getZone());
            }
        }
        return null;
    }

    @Override
    public Boolean prefixEquals(IPAddressProvider other) {
        if (other instanceof ParsedIPAddress) {
            CachedIPAddresses<?> vals = this.values;
            CachedIPAddresses<?> otherVals = this.values;
            if (vals == null || otherVals == null) {
                return this.contains((ParsedIPAddress)other, true, true);
            }
        }
        return null;
    }

    private Boolean contains(ParsedIPAddress other, boolean networkOnly, boolean equals) {
        int networkSegIndex;
        int hostSegIndex;
        boolean otherCompressedAlready;
        boolean compressedAlready;
        IPAddressNetwork network;
        int bytesPerSegment;
        int bitsPerSegment;
        int expectedSegCount;
        int max;
        AddressParseData parseData = this.getAddressParseData();
        AddressParseData otherParseData = other.getAddressParseData();
        int[] segmentData = parseData.getSegmentData();
        int[] otherSegmentData = otherParseData.getSegmentData();
        if (segmentData == null || otherSegmentData == null) {
            return null;
        }
        if (this.skipContains() || other.skipContains()) {
            return null;
        }
        IPAddress.IPVersion ipVersion = this.getProviderIPVersion();
        if (!ipVersion.equals((Object)other.getProviderIPVersion())) {
            return Boolean.FALSE;
        }
        int segmentCount = parseData.getSegmentCount();
        int otherSegmentCount = otherParseData.getSegmentCount();
        IPAddressStringParameters options = this.getParameters();
        if (this.isProvidingIPv4()) {
            max = 255;
            expectedSegCount = 4;
            bitsPerSegment = 8;
            bytesPerSegment = 1;
            network = options.getIPv4Parameters().getNetwork();
            compressedAlready = true;
            otherCompressedAlready = true;
        } else {
            max = 65535;
            expectedSegCount = 8;
            bitsPerSegment = 16;
            bytesPerSegment = 2;
            network = options.getIPv6Parameters().getNetwork();
            compressedAlready = expectedSegCount == segmentCount;
            otherCompressedAlready = expectedSegCount == otherSegmentCount;
        }
        AddressNetwork.PrefixConfiguration prefConf = network.getPrefixConfiguration();
        boolean zeroHostsAreSubnets = prefConf.zeroHostsAreSubnets();
        boolean allPrefixedAddressesAreSubnets = prefConf.allPrefixedAddressesAreSubnets();
        Integer pref = this.getProviderNetworkPrefixLength();
        Integer otherPref = other.getProviderNetworkPrefixLength();
        int hostAllSegIndex = expectedSegCount;
        int endIndex = segmentCount;
        if (pref == null) {
            networkOnly = false;
            hostSegIndex = expectedSegCount;
            networkSegIndex = hostSegIndex - 1;
        } else {
            hostSegIndex = ParsedAddressGrouping.getHostSegmentIndex(pref, bytesPerSegment, bitsPerSegment);
            networkSegIndex = ParsedAddressGrouping.getNetworkSegmentIndex(pref, bytesPerSegment, bitsPerSegment);
            if (!networkOnly || networkSegIndex == hostSegIndex) {
                boolean isPrefixSubnet;
                boolean bl = isPrefixSubnet = allPrefixedAddressesAreSubnets || zeroHostsAreSubnets && this.isPrefixSubnet(pref, network, segmentData);
                if (!equals) {
                    networkOnly |= isPrefixSubnet;
                }
                if (isPrefixSubnet) {
                    hostAllSegIndex = ParsedAddressGrouping.getHostSegmentIndex(pref, bytesPerSegment, bitsPerSegment);
                }
            }
        }
        int otherHostAllSegIndex = otherPref != null && (allPrefixedAddressesAreSubnets || zeroHostsAreSubnets && other.isPrefixSubnet(otherPref, network, otherSegmentData)) ? ParsedAddressGrouping.getHostSegmentIndex(otherPref, bytesPerSegment, bitsPerSegment) : expectedSegCount;
        int i = 0;
        int j = 0;
        int otherCompressedCount = 0;
        int compressedCount = 0;
        for (int normalizedCount = 0; !(i >= endIndex && compressedCount <= 0 || networkOnly && normalizedCount > networkSegIndex); ++normalizedCount) {
            long otherUpper;
            long otherLower;
            long lower;
            long upper;
            if (compressedCount > 0) {
                upper = 0L;
                lower = 0L;
            } else {
                lower = ParsedIPAddress.getValue(i, 2, segmentData);
                upper = ParsedIPAddress.getValue(i, 4, segmentData);
            }
            if (normalizedCount >= hostAllSegIndex) {
                Integer segPrefLength = ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, pref, normalizedCount);
                lower &= (long)network.getSegmentNetworkMask(segPrefLength);
                upper |= (long)network.getSegmentHostMask(segPrefLength);
            }
            if (normalizedCount > otherHostAllSegIndex) {
                otherLower = 0L;
                otherUpper = max;
            } else {
                if (otherCompressedCount > 0) {
                    otherUpper = 0L;
                    otherLower = 0L;
                } else {
                    otherLower = ParsedIPAddress.getValue(j, 2, otherSegmentData);
                    otherUpper = ParsedIPAddress.getValue(j, 4, otherSegmentData);
                }
                if (normalizedCount == otherHostAllSegIndex) {
                    Integer segPrefLength = ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, otherPref, normalizedCount);
                    otherLower &= (long)network.getSegmentNetworkMask(segPrefLength);
                    otherUpper |= (long)network.getSegmentHostMask(segPrefLength);
                }
            }
            if (equals ? lower != otherLower || upper != otherUpper : lower > otherLower || upper < otherUpper) {
                return Boolean.FALSE;
            }
            if (!compressedAlready) {
                if (compressedCount > 0) {
                    if (--compressedCount == 0) {
                        compressedAlready = true;
                    }
                } else if (this.isCompressed(i, segmentData)) {
                    ++i;
                    compressedCount = expectedSegCount - segmentCount;
                } else {
                    ++i;
                }
            } else {
                ++i;
            }
            if (!otherCompressedAlready) {
                if (otherCompressedCount > 0) {
                    if (--otherCompressedCount != 0) continue;
                    otherCompressedAlready = true;
                    continue;
                }
                if (other.isCompressed(j, otherSegmentData)) {
                    ++j;
                    otherCompressedCount = expectedSegCount - otherSegmentCount;
                    continue;
                }
                ++j;
                continue;
            }
            ++j;
        }
        return Boolean.TRUE;
    }

    protected boolean isPrefixSubnet(Integer networkPrefixLength, IPAddressNetwork<?, ?, ?, ?, ?> network, int[] segmentData) {
        IPAddress.IPVersion version = network.getIPVersion();
        int bytesPerSegment = IPAddressSection.bytesPerSegment(version);
        int bitsPerSegment = IPAddressSection.bitsPerSegment(version);
        int max = IPAddressSegment.getMaxSegmentValue(version);
        AddressNetwork.PrefixConfiguration prefConf = network.getPrefixConfiguration();
        AddressParseData addressParseData = this.getAddressParseData();
        int segmentCount = addressParseData.getSegmentCount();
        if (this.isCompressed()) {
            int compressedCount = 8 - segmentCount;
            int compressedIndex = addressParseData.getConsecutiveSeparatorSegmentIndex();
            return ParsedAddressGrouping.isPrefixSubnet(segmentIndex -> {
                if (segmentIndex >= compressedIndex) {
                    if (segmentIndex - compressedIndex < compressedCount) {
                        return 0;
                    }
                    segmentIndex -= compressedCount;
                }
                return (int)ParsedIPAddress.getValue(segmentIndex, 2, segmentData);
            }, segmentIndex -> {
                if (segmentIndex >= compressedIndex) {
                    if (segmentIndex - compressedIndex < compressedCount) {
                        return 0;
                    }
                    segmentIndex -= compressedCount;
                }
                return (int)ParsedIPAddress.getValue(segmentIndex, 4, segmentData);
            }, segmentCount + compressedCount, bytesPerSegment, bitsPerSegment, max, networkPrefixLength, prefConf, false);
        }
        return ParsedAddressGrouping.isPrefixSubnet(segmentIndex -> (int)ParsedIPAddress.getValue(segmentIndex, 2, segmentData), segmentIndex -> (int)ParsedIPAddress.getValue(segmentIndex, 4, segmentData), segmentCount, bytesPerSegment, bitsPerSegment, max, networkPrefixLength, prefConf, false);
    }

    @Override
    public Integer getProviderNetworkPrefixLength() {
        return this.getQualifier().getEquivalentPrefixLength();
    }

    IPAddresses<?, ?> createAddresses() {
        IPAddress.IPVersion version = this.getProviderIPVersion();
        if (version == IPAddress.IPVersion.IPV4) {
            return this.createIPv4Addresses();
        }
        if (version == IPAddress.IPVersion.IPV6) {
            return this.createIPv6Addresses();
        }
        return null;
    }

    private static <S extends IPAddressSegment> S[] allocateHostSegments(S[] segments, S[] originalSegments, AddressNetwork.AddressSegmentCreator<S> creator, int segmentCount, int originalCount) {
        if (segments == null) {
            segments = (IPAddressSegment[])creator.createSegmentArray(segmentCount);
            System.arraycopy(originalSegments, 0, segments, 0, originalCount);
        }
        return segments;
    }

    private IPAddresses<IPv4Address, IPv4AddressSection> createIPv4Addresses() {
        ParsedHostIdentifierStringQualifier qualifier = this.getQualifier();
        IPAddress mask = qualifier.getMask();
        if (mask != null && mask.getBlockMaskPrefixLength(true) != null) {
            mask = null;
        }
        boolean hasMask = mask != null;
        AddressParseData addrParseData = this.getAddressParseData();
        int segmentCount = addrParseData.getSegmentCount();
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getIPv4AddressCreator();
        int ipv4SegmentCount = 4;
        int missingCount = ipv4SegmentCount - segmentCount;
        IPAddressSegment[] hostSegments = null;
        AddressSegment[] segments = creator.createSegmentArray(ipv4SegmentCount);
        boolean expandedSegments = missingCount <= 0;
        int expandedEnd = -1;
        int expandedStart = -1;
        CharSequence addressString = this.str;
        int i = 0;
        int normalizedSegmentIndex = 0;
        while (i < segmentCount) {
            boolean isLastSegment;
            long lower = addrParseData.getValue(i, 2);
            long upper = addrParseData.getValue(i, 4);
            boolean bl = isLastSegment = i == segmentCount - 1;
            if (!expandedSegments && isLastSegment && !addrParseData.isWildcard(i)) {
                int count;
                boolean useStringIndicators = true;
                expandedSegments = true;
                expandedStart = i;
                expandedEnd = i + count;
                for (count = missingCount; count >= 0; --count) {
                    Integer segmentMask;
                    int newUpper;
                    int newLower;
                    Integer currentPrefix = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, qualifier);
                    if (lower != upper) {
                        int shift = 8 * count;
                        int segmentMask2 = 255;
                        newLower = (int)(lower >>> shift) & segmentMask2;
                        newUpper = (int)(upper >>> shift) & segmentMask2;
                        if (count == 0 && (long)newLower == lower) {
                            if ((long)newUpper != upper) {
                                addrParseData.setFlag(i, 8, false);
                            }
                        } else {
                            useStringIndicators = false;
                        }
                    } else {
                        newLower = newUpper = (int)(lower >> 8 * count) & 0xFF;
                        if (count != 0 || (long)newLower != lower) {
                            useStringIndicators = false;
                        }
                    }
                    Integer n = segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(normalizedSegmentIndex)).getSegmentValue()) : null;
                    if (segmentMask != null || currentPrefix != null) {
                        hostSegments = (IPv4AddressSegment[])ParsedIPAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv4SegmentCount, (int)normalizedSegmentIndex);
                        hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV4, newLower, newUpper, useStringIndicators, addrParseData, i, null, null, creator);
                    }
                    segments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV4, newLower, newUpper, useStringIndicators, addrParseData, i, currentPrefix, segmentMask, creator);
                    ++normalizedSegmentIndex;
                }
                break;
            }
            Integer segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(normalizedSegmentIndex)).getSegmentValue()) : null;
            Integer segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, qualifier);
            if (segmentMask != null || segmentPrefixLength != null) {
                hostSegments = (IPv4AddressSegment[])ParsedIPAddress.allocateHostSegments(hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv4SegmentCount, (int)normalizedSegmentIndex);
                hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)upper, true, addrParseData, i, null, null, creator);
            }
            segments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)upper, true, addrParseData, i, segmentPrefixLength, segmentMask, creator);
            if (!expandedSegments && addrParseData.isWildcard(i) && (!this.is_inet_aton_joined() || isLastSegment)) {
                boolean expandSegments = true;
                for (int j = i + 1; j < segmentCount; ++j) {
                    if (!addrParseData.isWildcard(j)) continue;
                    expandSegments = false;
                    break;
                }
                if (expandSegments) {
                    expandedSegments = true;
                    int count = missingCount;
                    while (count-- > 0) {
                        segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(++normalizedSegmentIndex)).getSegmentValue()) : null;
                        segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, qualifier);
                        if (segmentMask != null || segmentPrefixLength != null) {
                            hostSegments = (IPv4AddressSegment[])ParsedIPAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv4SegmentCount, (int)normalizedSegmentIndex);
                            hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)upper, false, addrParseData, i, null, null, creator);
                        }
                        segments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV4, 0, 255, false, addrParseData, i, segmentPrefixLength, segmentMask, creator);
                    }
                }
            }
            ++i;
            ++normalizedSegmentIndex;
        }
        IPv4AddressNetwork.IPv4AddressCreator addressCreator = creator;
        Integer prefLength = ParsedIPAddress.getPrefixLength(qualifier);
        IPv4AddressSection result = (IPv4AddressSection)addressCreator.createPrefixedSectionInternal(segments, prefLength);
        IPv4AddressSection hostResult = hostSegments != null ? (IPv4AddressSection)addressCreator.createSectionInternal(hostSegments) : null;
        if (this.checkExpandedValues(result, expandedStart, expandedEnd)) {
            throw new IncompatibleAddressException(addressString, "ipaddress.error.invalid.joined.ranges");
        }
        if (this.checkExpandedValues(hostResult, expandedStart, expandedEnd)) {
            hostResult = null;
        }
        return new IPAddresses<IPv4Address, IPv4AddressSection>(result, hostResult){

            @Override
            ParsedAddressCreator<IPv4Address, IPv4AddressSection, ?, ?> getCreator() {
                return ParsedIPAddress.this.getIPv4AddressCreator();
            }
        };
    }

    private boolean checkExpandedValues(IPAddressSection section, int start, int end) {
        if (section != null && start < end) {
            IPAddressSegment seg = section.getSegment(start);
            boolean lastWasRange = seg.isMultiple();
            do {
                seg = section.getSegment(++start);
                if (lastWasRange) {
                    if (seg.isFullRange()) continue;
                    return true;
                }
                lastWasRange = seg.isMultiple();
            } while (start < end);
        }
        return false;
    }

    private IPAddresses<IPv6Address, IPv6AddressSection> createIPv6Addresses() {
        ParsedHostIdentifierStringQualifier qualifier = this.getQualifier();
        IPAddress mask = qualifier.getMask();
        if (mask != null && mask.getBlockMaskPrefixLength(true) != null) {
            mask = null;
        }
        boolean hasMask = mask != null;
        AddressParseData addressParseData = this.getAddressParseData();
        int segmentCount = addressParseData.getSegmentCount();
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getIPv6AddressCreator();
        int ipv6SegmentCount = 8;
        IPAddressSegment[] hostSegments = null;
        AddressSegment[] segments = creator.createSegmentArray(ipv6SegmentCount);
        boolean mixed = this.isProvidingMixedIPv6();
        int normalizedSegmentIndex = 0;
        int missingSegmentCount = (mixed ? 6 : ipv6SegmentCount) - segmentCount;
        boolean expandedSegments = missingSegmentCount <= 0;
        int expandedEnd = -1;
        int expandedStart = -1;
        CharSequence addressString = this.str;
        for (int i = 0; i < segmentCount; ++i) {
            long lower = addressParseData.getValue(i, 2);
            long upper = addressParseData.getValue(i, 4);
            if (!expandedSegments && i == segmentCount - 1 && !addressParseData.isWildcard(i)) {
                boolean isRange;
                long upperHighBytes;
                long lowerHighBytes;
                boolean useStringIndicators = true;
                expandedSegments = true;
                int count = missingSegmentCount;
                if (count >= 4) {
                    lowerHighBytes = addressParseData.getValue(i, 6);
                    upperHighBytes = addressParseData.getValue(i, 8);
                    isRange = lower != upper || lowerHighBytes != upperHighBytes;
                } else {
                    upperHighBytes = 0L;
                    lowerHighBytes = 0L;
                    isRange = lower != upper;
                }
                expandedStart = i;
                expandedEnd = i + count;
                while (count >= 0) {
                    Integer segmentMask;
                    int newUpper;
                    int newLower;
                    Integer currentPrefix = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, qualifier);
                    if (isRange) {
                        int shift;
                        int segmentMask2 = 65535;
                        if (count >= 4) {
                            shift = 16 * (count % 4);
                            newLower = (int)(lowerHighBytes >>> shift) & segmentMask2;
                            newUpper = (int)(upperHighBytes >>> shift) & segmentMask2;
                        } else {
                            shift = 16 * count;
                            newLower = (int)(lower >>> shift) & segmentMask2;
                            newUpper = (int)(upper >>> shift) & segmentMask2;
                        }
                        if (count == 0 && (long)newLower == lower && lowerHighBytes == 0L) {
                            if ((long)newUpper != upper || upperHighBytes != 0L) {
                                addressParseData.setFlag(i, 8, false);
                            }
                        } else {
                            useStringIndicators = false;
                        }
                    } else if (count >= 4) {
                        newLower = newUpper = (int)(lowerHighBytes >>> 16 * (count % 4)) & 0xFFFF;
                        useStringIndicators = false;
                    } else {
                        newLower = newUpper = (int)(lower >>> 16 * count) & 0xFFFF;
                        if (count != 0 || (long)newLower != lower || lowerHighBytes != 0L) {
                            useStringIndicators = false;
                        }
                    }
                    Integer n = segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(normalizedSegmentIndex)).getSegmentValue()) : null;
                    if (segmentMask != null || currentPrefix != null) {
                        hostSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                        hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV6, newLower, newUpper, useStringIndicators, addressParseData, i, null, null, creator);
                    }
                    segments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV6, newLower, newUpper, useStringIndicators, addressParseData, i, currentPrefix, segmentMask, creator);
                    ++normalizedSegmentIndex;
                    --count;
                }
                break;
            }
            Integer segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(normalizedSegmentIndex)).getSegmentValue()) : null;
            Integer segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, qualifier);
            if (segmentMask != null || segmentPrefixLength != null) {
                hostSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateHostSegments(hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV6, (int)lower, (int)upper, true, addressParseData, i, null, null, creator);
            }
            segments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV6, (int)lower, (int)upper, true, addressParseData, i, segmentPrefixLength, segmentMask, creator);
            ++normalizedSegmentIndex;
            int expandValueLower = 0;
            int expandValueUpper = 0;
            if (expandedSegments) continue;
            boolean expandSegments = false;
            if (addressParseData.isWildcard(i)) {
                expandValueLower = 0;
                expandValueUpper = 65535;
                expandSegments = true;
                for (int j = i + 1; j < segmentCount; ++j) {
                    if (!addressParseData.isWildcard(j) && !this.isCompressed(j)) continue;
                    expandSegments = false;
                    break;
                }
            } else if (this.isCompressed(i)) {
                expandSegments = true;
                expandValueUpper = 0;
                expandValueLower = 0;
            }
            if (!expandSegments) continue;
            expandedSegments = true;
            int count = missingSegmentCount;
            while (count-- > 0) {
                segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(normalizedSegmentIndex)).getSegmentValue()) : null;
                segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, qualifier);
                if (segmentMask != null || segmentPrefixLength != null) {
                    hostSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                    hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV6, expandValueLower, expandValueUpper, false, addressParseData, i, null, null, creator);
                }
                segments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(addressString, IPAddress.IPVersion.IPV6, expandValueLower, expandValueUpper, false, addressParseData, i, segmentPrefixLength, segmentMask, creator);
                ++normalizedSegmentIndex;
            }
        }
        IPv6AddressSection result = null;
        IPv6AddressSection hostResult = null;
        IPv6AddressNetwork.IPv6AddressCreator addressCreator = creator;
        if (mixed) {
            IPv4AddressSection ipv4AddressSection = this.getMixedParsedAddress().createIPv4Addresses().getSection();
            boolean embeddedSectionIsChanged = false;
            for (int n = 0; n < 2; ++n) {
                IPv6AddressSegment newSegment;
                boolean doHostSegment;
                int m = n << 1;
                IPv4AddressSegment one = ipv4AddressSection.getSegment(m);
                IPv4AddressSegment two = ipv4AddressSection.getSegment(m + 1);
                Integer segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(normalizedSegmentIndex)).getSegmentValue()) : null;
                Integer segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, qualifier);
                boolean bl = doHostSegment = segmentMask != null || segmentPrefixLength != null;
                if (doHostSegment) {
                    hostSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                }
                int oneLower = one.getSegmentValue();
                int twoLower = two.getSegmentValue();
                if (!one.isMultiple() && !two.isMultiple()) {
                    if (doHostSegment) {
                        hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(oneLower, twoLower, null, null, creator);
                    }
                    newSegment = ParsedIPAddress.createSegment(oneLower, twoLower, segmentPrefixLength, segmentMask, creator);
                    segments[normalizedSegmentIndex] = newSegment;
                } else {
                    int oneUpper = one.getUpperSegmentValue();
                    int twoUpper = two.getUpperSegmentValue();
                    if (doHostSegment) {
                        hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(one, two, oneLower, oneUpper, twoLower, twoUpper, null, null, creator);
                    }
                    newSegment = ParsedIPAddress.createSegment(one, two, oneLower, oneUpper, twoLower, twoUpper, segmentPrefixLength, segmentMask, creator);
                    segments[normalizedSegmentIndex] = newSegment;
                }
                embeddedSectionIsChanged |= newSegment.isPrefixed() || newSegment.getSegmentValue() != (one.getSegmentValue() << 8 | two.getSegmentValue()) || newSegment.getUpperSegmentValue() != (one.getUpperSegmentValue() << 8 | two.getUpperSegmentValue());
                ++normalizedSegmentIndex;
            }
            if (!embeddedSectionIsChanged) {
                if (hostSegments != null) {
                    hostResult = (IPv6AddressSection)addressCreator.createSectionInternal(hostSegments, ipv4AddressSection);
                }
                result = (IPv6AddressSection)addressCreator.createSectionInternal(segments, ipv4AddressSection, ParsedIPAddress.getPrefixLength(qualifier));
            }
        }
        if (result == null) {
            if (hostSegments != null) {
                hostResult = (IPv6AddressSection)addressCreator.createSectionInternal(hostSegments);
            }
            result = (IPv6AddressSection)addressCreator.createPrefixedSectionInternal(segments, ParsedIPAddress.getPrefixLength(qualifier));
        }
        if (this.checkExpandedValues(result, expandedStart, expandedEnd)) {
            throw new IncompatibleAddressException(addressString, "ipaddress.error.invalid.joined.ranges");
        }
        if (this.checkExpandedValues(hostResult, expandedStart, expandedEnd)) {
            hostResult = null;
        }
        return new IPAddresses<IPv6Address, IPv6AddressSection>(result, hostResult){

            @Override
            ParsedAddressCreator<IPv6Address, IPv6AddressSection, ?, ?> getCreator() {
                return ParsedIPAddress.this.getIPv6AddressCreator();
            }
        };
    }

    private static <S extends IPAddressSegment> S createSegment(CharSequence addressString, IPAddress.IPVersion version, int val, int upperVal, boolean useFlags, AddressParseData parseData, int parsedSegIndex, Integer segmentPrefixLength, Integer mask, ParsedAddressCreator<?, ?, ?, S> creator) {
        if (val != upperVal) {
            return ParsedIPAddress.createRangeSegment(addressString, version, val, upperVal, useFlags, parseData, parsedSegIndex, segmentPrefixLength, mask, creator);
        }
        int stringVal = val;
        if (mask != null) {
            val &= mask.intValue();
        }
        IPAddressSegment result = !useFlags ? (IPAddressSegment)creator.createSegment(val, val, segmentPrefixLength) : (IPAddressSegment)creator.createSegmentInternal(val, segmentPrefixLength, addressString, stringVal, parseData.getFlag(parsedSegIndex, 4), parseData.getIndex(parsedSegIndex, 11), parseData.getIndex(parsedSegIndex, 12));
        return (S)result;
    }

    private static IPv6AddressSegment createSegment(int value1, int value2, Integer segmentPrefixLength, Integer mask, IPv6AddressNetwork.IPv6AddressCreator creator) {
        int value = value1 << 8 | value2;
        if (mask != null) {
            value &= mask.intValue();
        }
        IPv6AddressSegment result = creator.createSegment(value, segmentPrefixLength);
        return result;
    }

    private static IPv6AddressSegment createSegment(IPv4AddressSegment one, IPv4AddressSegment two, int upperRangeLower, int upperRangeUpper, int lowerRangeLower, int lowerRangeUpper, Integer segmentPrefixLength, Integer mask, IPv6AddressNetwork.IPv6AddressCreator creator) throws IncompatibleAddressException {
        boolean hasMask;
        boolean bl = hasMask = mask != null;
        if (hasMask) {
            int maskInt = mask;
            int shift = 8;
            int shiftedMask = maskInt >> shift;
            upperRangeLower &= shiftedMask;
            upperRangeUpper &= shiftedMask;
            lowerRangeLower &= maskInt;
            lowerRangeUpper &= maskInt;
        }
        IPv6AddressSegment result = ParsedIPAddress.join(one, two, upperRangeLower, upperRangeUpper, lowerRangeLower, lowerRangeUpper, segmentPrefixLength, creator);
        if (hasMask && !result.isMaskCompatibleWithRange(mask, segmentPrefixLength)) {
            throw new IncompatibleAddressException((AddressItem)result, mask, "ipaddress.error.maskMismatch");
        }
        return result;
    }

    private static IPv6AddressSegment join(IPv4AddressSegment one, IPv4AddressSegment two, int upperRangeLower, int upperRangeUpper, int lowerRangeLower, int lowerRangeUpper, Integer segmentPrefixLength, IPv6AddressNetwork.IPv6AddressCreator creator) throws IncompatibleAddressException {
        int shift = 8;
        if (upperRangeLower != upperRangeUpper) {
            if (segmentPrefixLength != null && creator.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                if (segmentPrefixLength > shift) {
                    int lowerPrefixLength = segmentPrefixLength - shift;
                    int fullMask = ~(-1 << shift);
                    int networkMask = fullMask & fullMask << shift - lowerPrefixLength;
                    int hostMask = ~networkMask & fullMask;
                    if ((lowerRangeLower &= networkMask) != 0 || (lowerRangeUpper |= hostMask) != 255) {
                        throw new IncompatibleAddressException((AddressItem)one, two, "ipaddress.error.invalidMixedRange");
                    }
                } else {
                    lowerRangeLower = 0;
                    lowerRangeUpper = 255;
                }
            } else if (lowerRangeLower != 0 || lowerRangeUpper != 255) {
                throw new IncompatibleAddressException((AddressItem)one, two, "ipaddress.error.invalidMixedRange");
            }
        }
        return creator.createSegment(upperRangeLower << shift | lowerRangeLower, upperRangeUpper << shift | lowerRangeUpper, segmentPrefixLength);
    }

    private static <S extends IPAddressSegment> S createRangeSegment(CharSequence addressString, IPAddress.IPVersion version, int stringLower, int stringUpper, boolean useFlags, AddressParseData parseData, int parsedSegIndex, Integer segmentPrefixLength, Integer mask, ParsedAddressCreator<?, ?, ?, S> creator) {
        boolean hasMask;
        int lower = stringLower;
        int upper = stringUpper;
        boolean bl = hasMask = mask != null;
        if (hasMask) {
            int maskInt = mask;
            lower &= maskInt;
            upper &= maskInt;
        }
        IPAddressSegment result = !useFlags ? (IPAddressSegment)creator.createSegment(lower, upper, segmentPrefixLength) : (IPAddressSegment)creator.createSegmentInternal(lower, upper, segmentPrefixLength, addressString, stringLower, stringUpper, parseData.getFlag(parsedSegIndex, 4), parseData.getFlag(parsedSegIndex, 8), parseData.getIndex(parsedSegIndex, 11), parseData.getIndex(parsedSegIndex, 12), parseData.getIndex(parsedSegIndex, 15));
        if (hasMask && !result.isMaskCompatibleWithRange(mask, segmentPrefixLength)) {
            throw new IncompatibleAddressException((AddressItem)result, mask, "ipaddress.error.maskMismatch");
        }
        return (S)result;
    }

    static IPAddress createAllAddress(IPAddress.IPVersion version, ParsedHostIdentifierStringQualifier qualifier, HostIdentifierString originator, IPAddressStringParameters options) {
        int segmentCount = IPAddress.getSegmentCount(version);
        IPAddress mask = qualifier.getMask();
        if (mask != null && mask.getBlockMaskPrefixLength(true) != null) {
            mask = null;
        }
        boolean hasMask = mask != null;
        Integer prefLength = ParsedIPAddress.getPrefixLength(qualifier);
        if (version.isIPv4()) {
            IPv4AddressNetwork.IPv4AddressCreator creator = options.getIPv4Parameters().getNetwork().getAddressCreator();
            AddressSegment[] segments = (IPv4AddressSegment[])creator.createSegmentArray(segmentCount);
            for (int i = 0; i < segmentCount; ++i) {
                Integer segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(i)).getSegmentValue()) : null;
                segments[i] = ParsedIPAddress.createRangeSegment(null, version, 0, 255, false, null, i, ParsedIPAddress.getSegmentPrefixLength(i, version, qualifier), segmentMask, creator);
            }
            return (IPAddress)creator.createAddressInternal(segments, originator, prefLength);
        }
        IPv6AddressNetwork.IPv6AddressCreator creator = options.getIPv6Parameters().getNetwork().getAddressCreator();
        AddressSegment[] segments = (IPv6AddressSegment[])creator.createSegmentArray(segmentCount);
        for (int i = 0; i < segmentCount; ++i) {
            Integer segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(i)).getSegmentValue()) : null;
            segments[i] = ParsedIPAddress.createRangeSegment(null, version, 0, 65535, false, null, i, ParsedIPAddress.getSegmentPrefixLength(i, version, qualifier), segmentMask, creator);
        }
        return (IPAddress)creator.createAddressInternal(segments, qualifier.getZone(), originator, prefLength);
    }

    private static Integer getPrefixLength(ParsedHostIdentifierStringQualifier qualifier) {
        return qualifier.getEquivalentPrefixLength();
    }

    private static Integer getSegmentPrefixLength(int segmentIndex, int bitsPerSegment, ParsedHostIdentifierStringQualifier qualifier) {
        Integer bits = ParsedIPAddress.getPrefixLength(qualifier);
        return ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, bits, segmentIndex);
    }

    private static Integer getSegmentPrefixLength(int segmentIndex, IPAddress.IPVersion version, ParsedHostIdentifierStringQualifier qualifier) {
        return ParsedIPAddress.getSegmentPrefixLength(segmentIndex, IPAddressSection.bitsPerSegment(version), qualifier);
    }

    private static Integer cacheSegmentMask(int i) {
        return ParsedAddressGrouping.cache(i);
    }

    static abstract class IPAddresses<T extends IPAddress, R extends IPAddressSection>
    extends CachedIPAddresses<T> {
        private static final long serialVersionUID = 4L;
        private final R section;
        private final R hostSection;
        final /* synthetic */ ParsedIPAddress this$0;

        IPAddresses(R section, R hostSection) {
            this.this$0 = this$0;
            this.section = section;
            this.hostSection = hostSection;
        }

        abstract ParsedAddressCreator<T, R, ?, ?> getCreator();

        @Override
        public T getAddress() {
            if (this.address == null) {
                this.address = (IPAddress)this.getCreator().createAddressInternal(this.section, this.this$0.getQualifier().getZone(), this.this$0.originator);
            }
            return (T)this.address;
        }

        @Override
        public T getHostAddress() {
            if (this.hostSection == null) {
                return this.getAddress();
            }
            if (this.hostAddress == null) {
                this.hostAddress = (IPAddress)this.getCreator().createAddressInternal(this.hostSection, this.this$0.getQualifier().getZone(), null);
            }
            return (T)this.hostAddress;
        }

        R getSection() {
            return this.section;
        }
    }

    static class CachedIPAddresses<T extends IPAddress>
    implements Serializable {
        private static final long serialVersionUID = 4L;
        protected T address;
        protected T hostAddress;

        CachedIPAddresses() {
        }

        public CachedIPAddresses(T address) {
            this(address, address);
        }

        public CachedIPAddresses(T address, T hostAddress) {
            this.address = address;
            this.hostAddress = hostAddress;
        }

        public T getAddress() {
            return this.address;
        }

        public T getHostAddress() {
            return this.hostAddress;
        }
    }
}

