/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.format.AddressStringDivisionGrouping;
import inet.ipaddr.format.IPAddressStringDivision;
import inet.ipaddr.format.IPAddressStringDivisionSeries;

public class IPAddressStringDivisionGrouping
extends AddressStringDivisionGrouping
implements IPAddressStringDivisionSeries {
    private static final long serialVersionUID = 4L;
    private IPAddressNetwork<?, ?, ?, ?, ?> network;
    private final Integer prefixLength;

    public IPAddressStringDivisionGrouping(IPAddressStringDivision[] divisions, IPAddressNetwork<?, ?, ?, ?, ?> network, Integer prefixLength) {
        super(divisions);
        this.prefixLength = prefixLength;
        this.network = network;
    }

    @Override
    public IPAddressNetwork<?, ?, ?, ?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public IPAddressStringDivision getDivision(int index) {
        return (IPAddressStringDivision)this.divisions[index];
    }

    @Override
    public boolean isPrefixed() {
        return this.prefixLength != null;
    }

    @Override
    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    @Override
    public boolean isPrefixBlock() {
        Integer networkPrefixLength = this.getPrefixLength();
        if (networkPrefixLength == null) {
            return false;
        }
        if (this.network.getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            return true;
        }
        int divCount = this.getDivisionCount();
        int i = 0;
        while (i < divCount) {
            IPAddressStringDivision div = this.getDivision(i);
            Integer segmentPrefixLength = div.getDivisionPrefixLength();
            if (segmentPrefixLength != null) {
                if (!div.isPrefixBlock(segmentPrefixLength)) {
                    return false;
                }
                ++i;
                while (i < divCount) {
                    div = this.getDivision(i);
                    if (!div.isFullRange()) {
                        return false;
                    }
                    ++i;
                }
            }
            ++i;
        }
        return true;
    }
}

