/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.AddressDivisionBase;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AddressDivision
extends AddressDivisionBase
implements Comparable<AddressDivision> {
    private static final long serialVersionUID = 4L;

    protected AddressDivision() {
    }

    @Override
    protected byte[] getBytesImpl(boolean low) {
        int bitCount = this.getBitCount();
        byte[] bytes = new byte[bitCount + 7 >> 3];
        int byteIndex = bytes.length - 1;
        int bitIndex = 8;
        long segmentValue = low ? this.getLowerValue() : this.getUpperValue();
        while (true) {
            int n = byteIndex--;
            bytes[n] = (byte)((long)bytes[n] | segmentValue << 8 - bitIndex);
            segmentValue >>= bitIndex;
            if (bitCount <= bitIndex) {
                return bytes;
            }
            bitCount -= bitIndex;
            bitIndex = 8;
        }
    }

    @Override
    public boolean isMultiple() {
        return this.getLowerValue() != this.getUpperValue();
    }

    protected int getMinPrefixLengthForBlock() {
        int upperOnes;
        int result = this.getBitCount();
        int lowerZeros = Long.numberOfTrailingZeros(this.getLowerValue());
        if (lowerZeros != 0 && (upperOnes = Long.numberOfTrailingZeros(this.getUpperValue() ^ 0xFFFFFFFFFFFFFFFFL)) != 0) {
            int prefixedBitCount = Math.min(lowerZeros, upperOnes);
            result -= prefixedBitCount;
        }
        return result;
    }

    @Override
    protected String getDefaultSegmentWildcardString() {
        return Address.SEGMENT_WILDCARD_STR;
    }

    @Override
    protected String getDefaultRangeSeparatorString() {
        return Address.RANGE_SEPARATOR_STR;
    }

    public long getMaxValue() {
        return -1L << this.getBitCount() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public boolean isZero() {
        return !this.isMultiple() && this.includesZero();
    }

    @Override
    public boolean includesZero() {
        return this.getLowerValue() == 0L;
    }

    @Override
    public boolean isMax() {
        return !this.isMultiple() && this.includesMax();
    }

    @Override
    public boolean includesMax() {
        return this.getUpperValue() == this.getMaxValue();
    }

    public abstract long getLowerValue();

    public abstract long getUpperValue();

    public long getDivisionValueCount() {
        return this.getUpperValue() - this.getLowerValue() + 1L;
    }

    @Override
    public BigInteger getCount() {
        return BigInteger.valueOf(this.getDivisionValueCount());
    }

    @Override
    public boolean isBoundedBy(int value) {
        return this.getUpperValue() < (long)value;
    }

    public boolean matches(long value) {
        return !this.isMultiple() && value == this.getLowerValue();
    }

    public boolean matchesWithMask(long value, long mask) {
        long diffBits;
        int leadingZeros;
        long fullMask;
        if (this.isMultiple() && ((fullMask = -1L >>> (leadingZeros = Long.numberOfLeadingZeros(diffBits = this.getLowerValue() ^ this.getUpperValue()))) & mask) != 0L) {
            return false;
        }
        return value == (this.getLowerValue() & mask);
    }

    public boolean matchesWithMask(long lowerValue, long upperValue, long mask) {
        long thisUpperValue;
        if (lowerValue == upperValue) {
            return this.matchesWithMask(lowerValue, mask);
        }
        if (!this.isMultiple()) {
            return false;
        }
        long thisValue = this.getLowerValue();
        if (!AddressDivision.isMaskCompatibleWithRange(thisValue, thisUpperValue = this.getUpperValue(), mask, this.getMaxValue())) {
            return false;
        }
        return lowerValue == (thisValue & mask) && upperValue == (thisUpperValue & mask);
    }

    protected abstract boolean isSameValues(AddressDivision var1);

    @Override
    public boolean isFullRange() {
        return this.includesZero() && this.includesMax();
    }

    @Override
    public int compareTo(AddressDivision other) {
        return IPAddress.DEFAULT_ADDRESS_COMPARATOR.compare(this, other);
    }

    protected static boolean isMaskCompatibleWithRange(long value, long upperValue, long maskValue, long maxValue) {
        boolean differingIsLowestBit;
        if (value == upperValue || maskValue == maxValue || maskValue == 0L) {
            return true;
        }
        long differing = value ^ upperValue;
        boolean foundDiffering = differing != 0L;
        boolean bl = differingIsLowestBit = differing == 1L;
        if (foundDiffering && !differingIsLowestBit) {
            int highestDifferingBitInRange = Long.numberOfLeadingZeros(differing);
            long maskMask = -1L >>> highestDifferingBitInRange;
            long differingMasked = maskValue & maskMask;
            foundDiffering = differingMasked != 0L;
            boolean bl2 = differingIsLowestBit = differingMasked == 1L;
            if (foundDiffering && !differingIsLowestBit) {
                long hostMaskUpper;
                int highestDifferingBitMasked = Long.numberOfLeadingZeros(differingMasked);
                long hostMask = -1L >>> highestDifferingBitMasked + 1;
                if ((maskValue & hostMask) != hostMask) {
                    return false;
                }
                if (highestDifferingBitMasked > highestDifferingBitInRange && (upperValue & (hostMaskUpper = -1L >>> highestDifferingBitMasked)) != hostMaskUpper) {
                    return false;
                }
            }
        }
        return true;
    }

    protected static boolean isBitwiseOrCompatibleWithRange(long value, long upperValue, long maskValue, long maxValue) {
        boolean differingIsLowestBit;
        if (value == upperValue || maskValue == maxValue || maskValue == 0L) {
            return true;
        }
        long differing = value ^ upperValue;
        boolean foundDiffering = differing != 0L;
        boolean bl = differingIsLowestBit = differing == 1L;
        if (foundDiffering && !differingIsLowestBit) {
            int highestDifferingBitInRange = Long.numberOfLeadingZeros(differing);
            long maskMask = -1L >>> highestDifferingBitInRange;
            long differingMasked = maskValue & maskMask;
            foundDiffering = differingMasked != maskMask;
            boolean bl2 = differingIsLowestBit = (differingMasked | 1L) == maskMask;
            if (foundDiffering && !differingIsLowestBit) {
                long hostMaskLower;
                int highestDifferingBitMasked = Long.numberOfLeadingZeros((differingMasked ^ 0xFFFFFFFFFFFFFFFFL) & maskMask);
                long hostMask = -1L >>> highestDifferingBitMasked + 1;
                if ((maskValue & hostMask) != 0L) {
                    return false;
                }
                if (highestDifferingBitMasked > highestDifferingBitInRange && (value & (hostMaskLower = -1L >>> highestDifferingBitMasked)) != 0L) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean hasUppercaseVariations(int radix, boolean lowerOnly) {
        boolean isPowerOfTwo;
        if (radix <= 1) {
            throw new IllegalArgumentException();
        }
        if (radix <= 10) {
            return false;
        }
        int shift = 0;
        long mask = 0L;
        switch (radix) {
            case 16: {
                isPowerOfTwo = true;
                shift = 4;
                mask = 15L;
                break;
            }
            default: {
                boolean bl = isPowerOfTwo = (radix & radix - 1) == 0;
                if (!isPowerOfTwo) break;
                shift = Integer.numberOfTrailingZeros(radix);
                mask = -1L << shift ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        boolean handledUpper = false;
        long value = this.getLowerValue();
        while (true) {
            if (value > 0L) {
                long checkVal;
                long l = checkVal = isPowerOfTwo ? mask & value : value % (long)radix;
                if (checkVal >= 10L) {
                    return true;
                }
                long l2 = value = isPowerOfTwo ? value >> shift : value / (long)radix;
                continue;
            }
            if (handledUpper || lowerOnly) break;
            value = this.getUpperValue();
            handledUpper = true;
        }
        return false;
    }

    @Override
    public int getDigitCount(int radix) {
        if (!this.isMultiple() && radix == this.getDefaultTextualRadix()) {
            return this.getWildcardString().length();
        }
        return AddressDivision.getDigitCount(this.getUpperValue(), radix);
    }

    @Override
    public int getMaxDigitCount(int radix) {
        int defaultRadix = this.getDefaultTextualRadix();
        if (radix == defaultRadix) {
            return this.getMaxDigitCount();
        }
        return AddressDivision.getMaxDigitCount(radix, this.getBitCount(), this.getMaxValue());
    }

    @Override
    protected int adjustLowerLeadingZeroCount(int leadingZeroCount, int radix) {
        return this.adjustLeadingZeroCount(leadingZeroCount, this.getLowerValue(), radix);
    }

    @Override
    protected int adjustUpperLeadingZeroCount(int leadingZeroCount, int radix) {
        return this.adjustLeadingZeroCount(leadingZeroCount, this.getUpperValue(), radix);
    }

    private int adjustLeadingZeroCount(int leadingZeroCount, long value, int radix) {
        if (leadingZeroCount < 0) {
            int width = AddressDivision.getDigitCount(value, radix);
            return Math.max(0, this.getMaxDigitCount(radix) - width);
        }
        return leadingZeroCount;
    }

    @Override
    protected int getLowerStringLength(int radix) {
        return AddressDivision.toUnsignedStringLength(this.getLowerValue(), radix);
    }

    @Override
    protected int getUpperStringLength(int radix) {
        return AddressDivision.toUnsignedStringLength(this.getUpperValue(), radix);
    }

    @Override
    protected void getLowerString(int radix, boolean uppercase, StringBuilder appendable) {
        AddressDivision.toUnsignedString(this.getLowerValue(), radix, 0, uppercase, uppercase ? UPPERCASE_DIGITS : DIGITS, appendable);
    }

    @Override
    protected void getUpperString(int radix, boolean uppercase, StringBuilder appendable) {
        AddressDivision.toUnsignedString(this.getUpperValue(), radix, 0, uppercase, uppercase ? UPPERCASE_DIGITS : DIGITS, appendable);
    }

    @Override
    protected void getUpperStringMasked(int radix, boolean uppercase, StringBuilder appendable) {
        this.getUpperString(radix, uppercase, appendable);
    }

    @Override
    protected void getLowerString(int radix, int rangeDigits, boolean uppercase, StringBuilder appendable) {
        AddressDivision.toUnsignedString(this.getLowerValue(), radix, rangeDigits, uppercase, uppercase ? UPPERCASE_DIGITS : DIGITS, appendable);
    }

    @Override
    protected void getSplitLowerString(int radix, int choppedDigits, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        AddressDivision.toSplitUnsignedString(this.getLowerValue(), radix, choppedDigits, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
    }

    @Override
    protected void getSplitRangeString(String rangeSeparator, String wildcard, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        AddressDivision.toUnsignedSplitRangeString(this.getLowerValue(), this.getUpperValue(), rangeSeparator, wildcard, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
    }

    @Override
    protected int getSplitRangeStringLength(String rangeSeparator, String wildcard, int leadingZeroCount, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix) {
        return AddressDivision.toUnsignedSplitRangeStringLength(this.getLowerValue(), this.getUpperValue(), rangeSeparator, wildcard, leadingZeroCount, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix);
    }

    @Override
    protected String getDefaultString() {
        return AddressDivision.toDefaultString(this.getLowerValue(), this.getDefaultTextualRadix());
    }

    @Override
    protected String getDefaultRangeString() {
        return this.getDefaultRangeString(this.getLowerValue(), this.getUpperValue(), this.getDefaultTextualRadix());
    }

    protected String getDefaultRangeString(long val1, long val2, int radix) {
        if (radix == 10) {
            int remainder;
            int quotient;
            int len1;
            int len2;
            if (val2 < 10L) {
                len2 = 1;
            } else if (val2 < 100L) {
                len2 = 2;
            } else if (val2 < 1000L) {
                len2 = 3;
            } else {
                return this.buildDefaultRangeString(radix);
            }
            int value2 = (int)val2;
            if (val1 < 10L) {
                len1 = 1;
            } else if (val1 < 100L) {
                len1 = 2;
            } else if (val1 < 1000L) {
                len1 = 3;
            } else {
                return this.buildDefaultRangeString(radix);
            }
            int value1 = (int)val1;
            char[] chars = new char[len2 += len1 + 1];
            chars[len1] = 45;
            char[] dig = DIGITS;
            do {
                quotient = value1 * 52429 >>> 19;
                remainder = value1 - ((quotient << 3) + (quotient << 1));
                chars[--len1] = dig[remainder];
            } while ((value1 = quotient) != 0);
            do {
                quotient = value2 * 52429 >>> 19;
                remainder = value2 - ((quotient << 3) + (quotient << 1));
                chars[--len2] = dig[remainder];
            } while ((value2 = quotient) != 0);
            return new String(chars);
        }
        if (radix == 16) {
            int remainder;
            int quotient;
            int len1;
            int len2;
            if (val2 < 16L) {
                len2 = 1;
            } else if (val2 < 256L) {
                len2 = 2;
            } else if (val2 < 4096L) {
                len2 = 3;
            } else if (val2 < 65536L) {
                len2 = 4;
            } else {
                return this.buildDefaultRangeString(radix);
            }
            int value2 = (int)val2;
            if (val1 < 16L) {
                len1 = 1;
            } else if (val1 < 256L) {
                len1 = 2;
            } else if (val1 < 4096L) {
                len1 = 3;
            } else if (val1 < 65536L) {
                len1 = 4;
            } else {
                return this.buildDefaultRangeString(radix);
            }
            int value1 = (int)val1;
            char[] chars = new char[len2 += len1 + 1];
            chars[len1] = 45;
            char[] dig = DIGITS;
            do {
                quotient = value1 >>> 4;
                remainder = value1 - (quotient << 4);
                chars[--len1] = dig[remainder];
            } while ((value1 = quotient) != 0);
            do {
                quotient = value2 >>> 4;
                remainder = value2 - (quotient << 4);
                chars[--len2] = dig[remainder];
            } while ((value2 = quotient) != 0);
            return new String(chars);
        }
        return this.buildDefaultRangeString(radix);
    }

    private String buildDefaultRangeString(int radix) {
        StringBuilder builder = new StringBuilder(20);
        this.getRangeString(IPAddress.RANGE_SEPARATOR_STR, 0, 0, "", radix, false, false, builder);
        return builder.toString();
    }

    protected static String toDefaultString(long val, int radix) {
        if (val == 0L) {
            return "0";
        }
        if (val == 1L) {
            return "1";
        }
        if (radix == 10) {
            int quotient;
            int value;
            int len;
            if (val < 10L) {
                return String.valueOf(DIGITS, (int)val, 1);
            }
            if (val < 100L) {
                len = 2;
                value = (int)val;
            } else if (val < 1000L) {
                len = 3;
                value = (int)val;
            } else {
                return Long.toString(val, radix);
            }
            char[] chars = new char[len];
            char[] dig = DIGITS;
            do {
                quotient = value * 52429 >>> 19;
                int remainder = value - ((quotient << 3) + (quotient << 1));
                chars[--len] = dig[remainder];
            } while ((value = quotient) != 0);
            return new String(chars);
        }
        if (radix == 16) {
            int quotient;
            int value;
            int len;
            if (val < 16L) {
                return String.valueOf(DIGITS, (int)val, 1);
            }
            if (val < 256L) {
                len = 2;
                value = (int)val;
            } else if (val < 4096L) {
                len = 3;
                value = (int)val;
            } else if (val < 65536L) {
                if (val == 65535L) {
                    return "ffff";
                }
                value = (int)val;
                len = 4;
            } else {
                return Long.toString(val, radix);
            }
            char[] chars = new char[len];
            char[] dig = DIGITS;
            do {
                quotient = value >>> 4;
                int remainder = value - (quotient << 4);
                chars[--len] = dig[remainder];
            } while ((value = quotient) != 0);
            return new String(chars);
        }
        return Long.toString(val, radix);
    }

    private static boolean toUnsignedStringFast(int value, int radix, int choppedDigits, boolean uppercase, char[] dig, StringBuilder appendable) {
        if (AddressDivision.toUnsignedStringFast(value, radix, uppercase, dig, appendable)) {
            if (choppedDigits > 0) {
                appendable.setLength(appendable.length() - choppedDigits);
            }
            return true;
        }
        return false;
    }

    private static boolean toUnsignedStringFast(int value, int radix, boolean uppercase, char[] dig, StringBuilder appendable) {
        if (value <= 1) {
            if (value == 0) {
                appendable.append('0');
            } else {
                appendable.append('1');
            }
            return true;
        }
        if (radix == 10) {
            int quotient;
            if (value < 10) {
                appendable.append(dig[value]);
                return true;
            }
            if (value < 100) {
                appendable.append("  ");
            } else if (value < 1000) {
                if (value == 127) {
                    appendable.append("127");
                    return true;
                }
                if (value == 255) {
                    appendable.append("255");
                    return true;
                }
                appendable.append("   ");
            } else if (value < 10000) {
                appendable.append("    ");
            } else {
                appendable.append("     ");
            }
            int index = appendable.length();
            do {
                quotient = value * 52429 >>> 19;
                int remainder = value - ((quotient << 3) + (quotient << 1));
                appendable.setCharAt(--index, dig[remainder]);
            } while ((value = quotient) != 0);
            return true;
        }
        if (radix == 16) {
            int quotient;
            if (value < 10) {
                appendable.append(dig[value]);
                return true;
            }
            if (value < 16) {
                appendable.append(dig[value]);
                return true;
            }
            if (value < 256) {
                appendable.append("  ");
            } else if (value < 4096) {
                appendable.append("   ");
            } else {
                if (value == 65535) {
                    appendable.append(uppercase ? "FFFF" : "ffff");
                    return true;
                }
                appendable.append("    ");
            }
            int index = appendable.length();
            do {
                quotient = value >>> 4;
                int remainder = value - (quotient << 4);
                appendable.setCharAt(--index, dig[remainder]);
            } while ((value = quotient) != 0);
            return true;
        }
        if (radix == 8) {
            int quotient;
            if (value < 8) {
                appendable.append(dig[value]);
                return true;
            }
            if (value < 64) {
                appendable.append("  ");
            } else if (value < 512) {
                appendable.append("   ");
            } else if (value < 4096) {
                appendable.append("    ");
            } else if (value < 32768) {
                appendable.append("     ");
            } else {
                appendable.append("      ");
            }
            int index = appendable.length();
            do {
                quotient = value >>> 3;
                int remainder = value - (quotient << 3);
                appendable.setCharAt(--index, dig[remainder]);
            } while ((value = quotient) != 0);
            return true;
        }
        if (radix == 2) {
            int digitCount = 15;
            int val = value;
            if (val >>> 8 == 0) {
                digitCount -= 8;
            } else {
                val >>>= 8;
            }
            if (val >>> 4 == 0) {
                digitCount -= 4;
            } else {
                val >>>= 4;
            }
            if (val >>> 2 == 0) {
                digitCount -= 2;
            } else {
                val >>>= 2;
            }
            if ((val & 2) == 0) {
                --digitCount;
            }
            appendable.append('1');
            while (digitCount > 0) {
                char c = dig[value >>> --digitCount & 1];
                appendable.append(c);
            }
            return true;
        }
        return false;
    }

    protected static StringBuilder toUnsignedString(long value, int radix, int choppedDigits, boolean uppercase, char[] dig, StringBuilder appendable) {
        if (value > 65535L || !AddressDivision.toUnsignedStringFast((int)value, radix, choppedDigits, uppercase, dig, appendable)) {
            AddressDivision.toUnsignedString(value, radix, choppedDigits, dig, appendable);
        }
        return appendable;
    }

    private static int toUnsignedSplitRangeStringLength(long lower, long upper, String rangeSeparator, String wildcard, int leadingZerosCount, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix) {
        int remaining;
        int digitsLength = -1;
        int stringPrefixLength = stringPrefix.length();
        do {
            boolean isFull;
            int upperDigit = (int)(upper % (long)radix);
            int lowerDigit = (int)(lower % (long)radix);
            boolean bl = isFull = lowerDigit == 0 && upperDigit == radix - 1;
            if (isFull) {
                digitsLength += wildcard.length() + 1;
                continue;
            }
            digitsLength += (stringPrefixLength << 1) + 4;
        } while ((upper /= (long)radix) != (lower /= (long)radix));
        int n = remaining = upper == 0L ? 0 : AddressDivision.toUnsignedStringLength(upper, radix);
        if ((remaining += leadingZerosCount) > 0) {
            digitsLength += remaining * (stringPrefixLength + 2);
        }
        return digitsLength;
    }

    protected static int toUnsignedStringLength(long value, int radix) {
        int result;
        if (value > 65535L || (result = AddressDivision.toUnsignedStringLengthFast((int)value, radix)) < 0) {
            result = AddressDivision.toUnsignedStringLengthSlow(value, radix);
        }
        return result;
    }

    private static int toUnsignedStringLengthSlow(long value, int radix) {
        int count = 1;
        boolean useInts = value <= Integer.MAX_VALUE;
        int value2 = useInts ? (int)value : radix;
        while (value2 >= radix) {
            if (useInts) {
                value2 /= radix;
            } else if ((value /= (long)radix) <= Integer.MAX_VALUE) {
                useInts = true;
                value2 = (int)value;
            }
            ++count;
        }
        return count;
    }

    protected static int toUnsignedStringLengthFast(int value, int radix) {
        if (value <= 1) {
            return 1;
        }
        if (radix == 10) {
            if (value < 10) {
                return 1;
            }
            if (value < 100) {
                return 2;
            }
            if (value < 1000) {
                return 3;
            }
            if (value < 10000) {
                return 4;
            }
            return 5;
        }
        if (radix == 16) {
            if (value < 16) {
                return 1;
            }
            if (value < 256) {
                return 2;
            }
            if (value < 4096) {
                return 3;
            }
            return 4;
        }
        if (radix == 8) {
            if (value < 8) {
                return 1;
            }
            if (value < 64) {
                return 2;
            }
            if (value < 512) {
                return 3;
            }
            if (value < 4096) {
                return 4;
            }
            if (value < 32768) {
                return 5;
            }
            return 6;
        }
        if (radix == 2) {
            int digitCount = 15;
            int val = value;
            if (val >>> 8 == 0) {
                digitCount -= 8;
            } else {
                val >>>= 8;
            }
            if (val >>> 4 == 0) {
                digitCount -= 4;
            } else {
                val >>>= 4;
            }
            if (val >>> 2 == 0) {
                digitCount -= 2;
            } else {
                val >>>= 2;
            }
            if ((val & 2) != 0) {
                ++digitCount;
            }
            return digitCount;
        }
        return -1;
    }

    private static void toUnsignedString(long value, int radix, int choppedDigits, char[] dig, StringBuilder appendable) {
        int front = appendable.length();
        AddressDivision.appendDigits(value, radix, choppedDigits, dig, appendable);
        int back = appendable.length() - 1;
        while (front < back) {
            char frontChar = appendable.charAt(front);
            appendable.setCharAt(front++, appendable.charAt(back));
            appendable.setCharAt(back--, frontChar);
        }
    }

    private static void toSplitUnsignedString(long value, int radix, int choppedDigits, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        int front = appendable.length();
        AddressDivision.appendDigits(value, radix, choppedDigits, uppercase, splitDigitSeparator, stringPrefix, appendable);
        if (!reverseSplitDigits) {
            int back = appendable.length() - 1;
            int stringPrefixLen = stringPrefix.length();
            front += stringPrefixLen;
            while (front < back) {
                char frontChar = appendable.charAt(front);
                appendable.setCharAt(front, appendable.charAt(back));
                appendable.setCharAt(back, frontChar);
                front += 2;
                back -= 2;
                front += stringPrefixLen;
                back -= stringPrefixLen;
            }
        }
    }

    private static void toUnsignedSplitRangeString(long lower, long upper, String rangeSeparator, String wildcard, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        int front = appendable.length();
        AddressDivision.appendDigits(lower, upper, rangeSeparator, wildcard, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
        if (!reverseSplitDigits) {
            int back = appendable.length() - 1;
            while (front < back) {
                char frontChar = appendable.charAt(front);
                appendable.setCharAt(front++, appendable.charAt(back));
                appendable.setCharAt(back--, frontChar);
            }
        }
    }

    private static void appendDigits(long value, int radix, int choppedDigits, char[] dig, StringBuilder appendable) {
        boolean useInts = value <= Integer.MAX_VALUE;
        int value2 = useInts ? (int)value : radix;
        while (value2 >= radix) {
            int index;
            if (useInts) {
                int val2 = value2;
                value2 /= radix;
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = val2 % radix;
            } else {
                long val = value;
                if ((value /= (long)radix) <= Integer.MAX_VALUE) {
                    useInts = true;
                    value2 = (int)value;
                }
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = (int)(val % (long)radix);
            }
            appendable.append(dig[index]);
        }
        if (choppedDigits == 0) {
            appendable.append(dig[value2]);
        }
    }

    private static void appendDigits(long value, int radix, int choppedDigits, boolean uppercase, char splitDigitSeparator, String stringPrefix, StringBuilder appendable) {
        boolean useInts = value <= Integer.MAX_VALUE;
        int value2 = useInts ? (int)value : radix;
        char[] dig = uppercase ? UPPERCASE_DIGITS : DIGITS;
        int prefLen = stringPrefix.length();
        while (value2 >= radix) {
            int index;
            if (useInts) {
                int val = value2;
                value2 /= radix;
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = val % radix;
            } else {
                long val = value;
                if ((value /= (long)radix) <= Integer.MAX_VALUE) {
                    useInts = true;
                    value2 = (int)value;
                }
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = (int)(val % (long)radix);
            }
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            appendable.append(dig[index]);
            appendable.append(splitDigitSeparator);
        }
        if (choppedDigits == 0) {
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            appendable.append(dig[value2]);
        }
    }

    private static void appendDigits(long lower, long upper, String rangeSeparator, String wildcard, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        int lowerInt;
        int upperInt;
        boolean useInts;
        char[] dig = uppercase ? UPPERCASE_DIGITS : DIGITS;
        boolean previousWasFullRange = true;
        boolean bl = useInts = upper <= Integer.MAX_VALUE;
        if (useInts) {
            upperInt = (int)upper;
            lowerInt = (int)lower;
        } else {
            upperInt = lowerInt = radix;
        }
        int prefLen = stringPrefix.length();
        while (true) {
            int k;
            int lowerDigit;
            int upperDigit;
            if (useInts) {
                int ud = upperInt;
                upperDigit = upperInt % radix;
                upperInt /= radix;
                if (ud == lowerInt) {
                    lowerInt = upperInt;
                    lowerDigit = upperDigit;
                } else {
                    lowerDigit = lowerInt % radix;
                    lowerInt /= radix;
                }
            } else {
                long ud = upper;
                upperDigit = (int)(upper % (long)radix);
                upper /= (long)radix;
                if (ud == lower) {
                    lower = upper;
                    lowerDigit = upperDigit;
                } else {
                    lowerDigit = (int)(lower % (long)radix);
                    lower /= (long)radix;
                }
                if (upper <= Integer.MAX_VALUE) {
                    useInts = true;
                    upperInt = (int)upper;
                    lowerInt = (int)lower;
                }
            }
            if (lowerDigit == upperDigit) {
                previousWasFullRange = false;
                if (reverseSplitDigits) {
                    if (prefLen > 0) {
                        appendable.append(stringPrefix);
                    }
                    appendable.append(dig[lowerDigit]);
                } else {
                    appendable.append(dig[lowerDigit]);
                    k = prefLen - 1;
                    while (k >= 0) {
                        appendable.append(stringPrefix.charAt(k));
                        --k;
                    }
                }
            } else {
                if (!previousWasFullRange) {
                    throw new IncompatibleAddressException(lower, upper, "ipaddress.error.splitMismatch");
                }
                boolean bl2 = previousWasFullRange = lowerDigit == 0 && upperDigit == radix - 1;
                if (previousWasFullRange && wildcard != null) {
                    if (reverseSplitDigits) {
                        appendable.append(wildcard);
                    } else {
                        k = wildcard.length() - 1;
                        while (k >= 0) {
                            appendable.append(wildcard.charAt(k));
                            --k;
                        }
                    }
                } else if (reverseSplitDigits) {
                    if (prefLen > 0) {
                        appendable.append(stringPrefix);
                    }
                    appendable.append(dig[lowerDigit]);
                    appendable.append(rangeSeparator);
                    appendable.append(dig[upperDigit]);
                } else {
                    appendable.append(dig[upperDigit]);
                    appendable.append(rangeSeparator);
                    appendable.append(dig[lowerDigit]);
                    k = prefLen - 1;
                    while (k >= 0) {
                        appendable.append(stringPrefix.charAt(k));
                        --k;
                    }
                }
            }
            if (upperInt == 0) break;
            appendable.append(splitDigitSeparator);
        }
    }

    @Override
    protected int getRangeDigitCount(int radix) {
        if (!this.isMultiple()) {
            return 0;
        }
        if (radix == this.getDefaultTextualRadix()) {
            return this.getRangeDigitCountImpl();
        }
        return AddressDivision.calculateRangeDigitCount(radix, this.getLowerValue(), this.getUpperValue(), this.getMaxValue());
    }

    protected int getRangeDigitCountImpl() {
        return AddressDivision.calculateRangeDigitCount(this.getDefaultTextualRadix(), this.getLowerValue(), this.getUpperValue(), this.getMaxValue());
    }

    private static int calculateRangeDigitCount(int radix, long value, long upperValue, long maxValue) {
        long max;
        long upperRemainder;
        long lowerRemainder;
        int factor = radix;
        int numDigits = 1;
        while ((lowerRemainder = value % (long)factor) == 0L && (upperRemainder = upperValue % (long)factor) == (max = maxValue / (long)factor == upperValue / (long)factor ? maxValue % (long)factor : (long)(factor - 1))) {
            if (upperValue - upperRemainder == value) {
                return numDigits;
            }
            ++numDigits;
            factor *= radix;
        }
        return 0;
    }

    protected static int reverseBits(byte b) {
        int x = b;
        x = (x & 0xAA) >>> 1 | (x & 0x55) << 1;
        x = (x & 0xCC) >>> 2 | (x & 0x33) << 2;
        x = 0xFF & (x >>> 4 | x << 4);
        return x;
    }

    protected static int reverseBits(short b) {
        int x = b;
        x = (x & 0xAAAA) >>> 1 | (x & 0x5555) << 1;
        x = (x & 0xCCCC) >>> 2 | (x & 0x3333) << 2;
        x = (x & 0xF0F0) >>> 4 | (x & 0xF0F) << 4;
        return 0xFFFF & (x >>> 8 | x << 8);
    }

    protected static int reverseBits(int i) {
        int x = i;
        x = (x & 0xAAAAAAAA) >>> 1 | (x & 0x55555555) << 1;
        x = (x & 0xCCCCCCCC) >>> 2 | (x & 0x33333333) << 2;
        x = (x & 0xF0F0F0F0) >>> 4 | (x & 0xF0F0F0F) << 4;
        x = (x & 0xFF00FF00) >>> 8 | (x & 0xFF00FF) << 8;
        return x >>> 16 | x << 16;
    }

    protected static <S extends AddressSegment> Iterator<S> iterator(final S original, final AddressNetwork.AddressSegmentCreator<S> creator, final boolean returnThisSegment) {
        if (!original.isMultiple()) {
            return new Iterator<S>(){
                boolean done;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public S next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    AddressSegment thisSegment = original;
                    if (!returnThisSegment) {
                        Object result = creator.createSegment(thisSegment.getLowerSegmentValue());
                        return result;
                    }
                    return thisSegment;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<S>(){
            boolean done;
            int current;
            {
                this.current = addressSegment.getLowerSegmentValue();
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public S next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                Object result = creator.createSegment(this.current);
                this.done = ++this.current > original.getUpperSegmentValue();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static <S extends AddressSegment> S setPrefixedSegment(S original, Integer oldPrefixLength, Integer segmentPrefixLength, AddressNetwork.AddressSegmentCreator<S> creator) {
        if (oldPrefixLength == null) {
            return creator.createSegment(original.getLowerSegmentValue(), original.getUpperSegmentValue(), segmentPrefixLength);
        }
        if (segmentPrefixLength == null || segmentPrefixLength > oldPrefixLength) {
            int prefixMask = -1 << original.getBitCount() - oldPrefixLength;
            if (segmentPrefixLength != null) {
                int newPrefixMask = ~(-1 << original.getBitCount() - segmentPrefixLength);
                prefixMask |= newPrefixMask;
            }
            int newLower = original.getLowerSegmentValue() & prefixMask;
            int newUpper = original.getUpperSegmentValue() & prefixMask;
            return creator.createSegment(newLower, newUpper, segmentPrefixLength);
        }
        return creator.createSegment(original.getLowerSegmentValue(), original.getUpperSegmentValue(), segmentPrefixLength);
    }

    protected static <S extends AddressSegment> boolean isReversibleRange(S segment) {
        return segment.getLowerSegmentValue() <= 1 && segment.getUpperSegmentValue() >= segment.getMaxSegmentValue() - 1;
    }
}

