/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressComparator;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressSegmentSeries;
import inet.ipaddr.HostIdentifierException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.NetworkMismatchException;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressDivisionSeries;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.mac.MACAddressNetwork;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.function.Function;

public abstract class Address
implements AddressSegmentSeries,
Comparable<Address> {
    private static final long serialVersionUID = 4L;
    public static final String HEX_PREFIX = "0x";
    public static final String OCTAL_PREFIX = "0";
    public static final char RANGE_SEPARATOR = '-';
    public static final String RANGE_SEPARATOR_STR = String.valueOf('-');
    public static final char ALTERNATIVE_RANGE_SEPARATOR = '\u203a';
    public static final String ALTERNATIVE_RANGE_SEPARATOR_STR = String.valueOf('\u203a');
    public static final char SEGMENT_WILDCARD = '*';
    public static final String SEGMENT_WILDCARD_STR = String.valueOf('*');
    public static final String ALTERNATIVE_SEGMENT_WILDCARD_STR = "\u00bf";
    public static final char SEGMENT_SQL_WILDCARD = '%';
    public static final String SEGMENT_SQL_WILDCARD_STR = String.valueOf('%');
    public static final char SEGMENT_SQL_SINGLE_WILDCARD = '_';
    public static final String SEGMENT_SQL_SINGLE_WILDCARD_STR = String.valueOf('_');
    public static final AddressComparator DEFAULT_ADDRESS_COMPARATOR = new AddressComparator.CountComparator();
    private static MACAddressNetwork macNetwork;
    private static IPv6AddressNetwork ipv6Network;
    private static IPv4AddressNetwork ipv4Network;
    final AddressSection addressSection;
    protected HostIdentifierString fromString;

    protected Address(AddressSection section) {
        this.addressSection = section;
        if (!this.getNetwork().equals(this.addressSection.getNetwork())) {
            throw new NetworkMismatchException(this.addressSection);
        }
    }

    protected Address(Function<Address, AddressSection> supplier) {
        this.addressSection = supplier.apply(this);
        if (!this.getNetwork().equals(this.addressSection.getNetwork())) {
            throw new NetworkMismatchException(this.addressSection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPv6AddressNetwork defaultIpv6Network() {
        if (ipv6Network != null) return ipv6Network;
        Class<Address> clazz = Address.class;
        synchronized (Address.class) {
            if (ipv6Network != null) return ipv6Network;
            ipv6Network = new IPv6AddressNetwork();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ipv6Network;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPv4AddressNetwork defaultIpv4Network() {
        if (ipv4Network != null) return ipv4Network;
        Class<Address> clazz = Address.class;
        synchronized (Address.class) {
            if (ipv4Network != null) return ipv4Network;
            ipv4Network = new IPv4AddressNetwork();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ipv4Network;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MACAddressNetwork defaultMACNetwork() {
        if (macNetwork != null) return macNetwork;
        Class<Address> clazz = Address.class;
        synchronized (Address.class) {
            if (macNetwork != null) return macNetwork;
            macNetwork = new MACAddressNetwork();
            // ** MonitorExit[var0] (shouldn't be in output)
            return macNetwork;
        }
    }

    protected static String getMessage(String key) {
        return HostIdentifierException.getMessage(key);
    }

    @Override
    public int getSegmentCount() {
        return this.getSection().getSegmentCount();
    }

    @Override
    public int getDivisionCount() {
        return this.getSection().getDivisionCount();
    }

    @Override
    public int getBitCount() {
        return this.getSection().getBitCount();
    }

    @Override
    public int getByteCount() {
        return this.getSection().getByteCount();
    }

    public AddressSection getSection() {
        return this.addressSection;
    }

    @Override
    public AddressSection getSection(int index) {
        return this.getSection().getSection(index);
    }

    @Override
    public AddressSection getSection(int index, int endIndex) {
        return this.getSection().getSection(index, endIndex);
    }

    @Override
    public AddressDivision getDivision(int index) {
        return this.getSection().getDivision(index);
    }

    @Override
    public AddressSegment getSegment(int index) {
        return this.getSection().getSegment(index);
    }

    @Override
    public AddressSegment[] getSegments() {
        return this.getSection().getSegments();
    }

    @Override
    public void getSegments(AddressSegment[] segs) {
        this.getSection().getSegments(segs);
    }

    @Override
    public void getSegments(int start, int end, AddressSegment[] segs, int index) {
        this.getSection().getSegments(start, end, segs, index);
    }

    public abstract int getMaxSegmentValue();

    public abstract Iterable<? extends Address> getIterable();

    public abstract Iterator<? extends Address> iterator();

    @Override
    public Iterator<? extends AddressSegment[]> segmentsIterator() {
        return this.getSection().segmentsIterator();
    }

    @Override
    public abstract Address getLower();

    @Override
    public abstract Address getUpper();

    @Override
    public boolean isMultiple() {
        return this.getSection().isMultiple();
    }

    @Override
    public boolean isPrefixed() {
        return this.getSection().isPrefixed();
    }

    @Override
    public Integer getPrefixLength() {
        return this.getSection().getPrefixLength();
    }

    @Override
    public int getMinPrefixLengthForBlock() {
        return this.getSection().getMinPrefixLengthForBlock();
    }

    @Override
    public Integer getPrefixLengthForSingleBlock() {
        return this.getSection().getPrefixLengthForSingleBlock();
    }

    public abstract boolean isMulticast();

    @Override
    public BigInteger getCount() {
        return this.getSection().getCount();
    }

    @Override
    public int isMore(AddressDivisionSeries other) {
        return this.getSection().isMore(other);
    }

    @Override
    public byte[] getBytes() {
        return this.getSection().getBytes();
    }

    @Override
    public byte[] getBytes(byte[] bytes) {
        return this.getSection().getBytes(bytes);
    }

    @Override
    public byte[] getUpperBytes() {
        return this.getSection().getUpperBytes();
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        return this.getSection().getUpperBytes(bytes);
    }

    @Override
    public BigInteger getValue() {
        return this.getSection().getValue();
    }

    @Override
    public BigInteger getUpperValue() {
        return this.getSection().getUpperValue();
    }

    @Override
    public boolean isZero() {
        return this.getSection().isZero();
    }

    @Override
    public boolean includesZero() {
        return this.getSection().includesZero();
    }

    @Override
    public boolean isMax() {
        return this.getSection().isMax();
    }

    @Override
    public boolean includesMax() {
        return this.getSection().includesMax();
    }

    @Override
    public boolean isFullRange() {
        return this.getSection().isFullRange();
    }

    public abstract boolean isLocal();

    public int hashCode() {
        return this.getSection().hashCode();
    }

    @Override
    public int compareTo(Address other) {
        if (this == other) {
            return 0;
        }
        return DEFAULT_ADDRESS_COMPARATOR.compare(this, other);
    }

    protected abstract boolean isFromSameString(HostIdentifierString var1);

    public boolean isSameAddress(Address other) {
        return other == this || this.getSection().equals(other.getSection());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Address) {
            Address other = (Address)o;
            if (this.isFromSameString(other.fromString)) {
                return true;
            }
            return this.isSameAddress(other);
        }
        return false;
    }

    public abstract boolean contains(Address var1);

    @Override
    public boolean isPrefixBlock() {
        return this.getSection().isPrefixBlock();
    }

    @Override
    public boolean isSinglePrefixBlock() {
        return this.getSection().isSinglePrefixBlock();
    }

    public HostIdentifierString toAddressString() {
        return this.fromString;
    }

    @Override
    public String toHexString(boolean with0xPrefix) {
        return this.getSection().toHexString(with0xPrefix);
    }

    @Override
    public String toNormalizedString() {
        return this.getSection().toNormalizedString();
    }

    @Override
    public String toCanonicalString() {
        return this.getSection().toCanonicalString();
    }

    @Override
    public String toCompressedString() {
        return this.getSection().toCompressedString();
    }

    public String toString() {
        return this.toCanonicalString();
    }

    @Override
    public String[] getDivisionStrings() {
        return this.getSection().getDivisionStrings();
    }

    @Override
    public String[] getSegmentStrings() {
        return this.getSection().getSegmentStrings();
    }

    @Override
    public abstract Address reverseSegments();

    @Override
    public abstract Address reverseBits(boolean var1);

    @Override
    public abstract Address reverseBytes();

    @Override
    public abstract Address reverseBytesPerSegment();

    @Override
    public abstract Address toPrefixBlock();

    @Override
    public abstract Address removePrefixLength();

    @Override
    public abstract Address adjustPrefixBySegment(boolean var1);

    @Override
    public abstract Address adjustPrefixLength(int var1);

    @Override
    public abstract Address setPrefixLength(int var1);

    @Override
    public abstract Address applyPrefixLength(int var1);

    public static interface AddressProvider {
        public int getSegmentCount();

        public SegmentValueProvider getValues();

        public SegmentValueProvider getUpperValues();

        public Integer getPrefixLength();

        public String getZone();
    }

    public static interface SegmentValueProvider {
        public int getValue(int var1);
    }
}

