/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import java.io.Serializable;
import java.math.BigInteger;

class AddressParseData
implements Serializable {
    private static final long serialVersionUID = 4L;
    public static final int LOWER_INDEX = 0;
    public static final int UPPER_INDEX = 1;
    public static final int EXTENDED_LOWER_INDEX = 2;
    public static final int EXTENDED_UPPER_INDEX = 3;
    public static final int LOWER_RADIX_INDEX = 0;
    public static final int UPPER_RADIX_INDEX = 1;
    public static final int LOWER_STR_DIGITS_INDEX = 2;
    public static final int LOWER_STR_START_INDEX = 3;
    public static final int LOWER_STR_END_INDEX = 4;
    public static final int UPPER_STR_DIGITS_INDEX = 5;
    public static final int UPPER_STR_START_INDEX = 6;
    public static final int UPPER_STR_END_INDEX = 7;
    public static final int WILDCARD_INDEX = 0;
    public static final int SINGLE_WILDCARD_INDEX = 1;
    public static final int STANDARD_STR_INDEX = 2;
    public static final int STANDARD_RANGE_STR_INDEX = 3;
    boolean[][] flags;
    int[][] indices;
    long[][] values;
    int segmentCount;
    boolean anyWildcard;
    boolean isEmpty;
    boolean isAll;
    boolean isSingleSegment;
    int consecutiveSepIndex = -1;
    int addressEndIndex;
    final CharSequence str;

    AddressParseData(CharSequence str) {
        this.str = str;
    }

    void initSegmentData(int segmentCapacity) {
        this.flags = new boolean[segmentCapacity][4];
        this.indices = new int[segmentCapacity][8];
        this.values = new long[segmentCapacity][4];
    }

    boolean isWildcard(int index) {
        return this.flags[index][0];
    }

    void reverseSegments() {
        int mid = this.segmentCount >>> 1;
        int i = 0;
        int reverseIndex = this.segmentCount - 1;
        while (i < mid) {
            boolean[] tmpb = this.flags[i];
            int[] tmpi = this.indices[i];
            long[] tmpl = this.values[i];
            this.flags[i] = this.flags[reverseIndex];
            this.indices[i] = this.indices[reverseIndex];
            this.values[i] = this.values[reverseIndex];
            this.flags[reverseIndex] = tmpb;
            this.indices[reverseIndex] = tmpi;
            this.values[reverseIndex] = tmpl;
            ++i;
            --reverseIndex;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("address string: ").append(this.str).append('\n');
        if (this.addressEndIndex > 0 && this.addressEndIndex < this.str.length()) {
            builder.append("address end: ").append(this.str.subSequence(this.addressEndIndex, this.str.length())).append('\n');
        }
        builder.append("segment count: ").append(this.segmentCount).append('\n');
        if (this.segmentCount > 0) {
            int i = 0;
            while (i < this.segmentCount) {
                builder.append("segment ").append(i).append(":\n");
                boolean[] flags = this.flags[i];
                boolean isWildcard = flags[0];
                if (isWildcard) {
                    builder.append("\tis wildcard").append('\n');
                } else {
                    BigInteger lowerResult;
                    long[] values = this.values[i];
                    long lower = values[0];
                    long upper = values[1];
                    long extendedUpper = values[3];
                    long extendedLower = values[2];
                    if (extendedLower != 0L) {
                        BigInteger extended = BigInteger.valueOf(extendedLower);
                        BigInteger shiftMore = extended.shiftLeft(64);
                        BigInteger notExtended = BigInteger.valueOf(lower);
                        lowerResult = shiftMore.or(notExtended);
                        builder.append("\tvalue: ").append(lowerResult).append('\n');
                        builder.append("\tvalue in hex: ").append(lowerResult.toString(16)).append('\n');
                    } else {
                        builder.append("\tvalue: ").append(lower).append('\n');
                        builder.append("\tvalue in hex: ").append(Long.toHexString(lower)).append('\n');
                        lowerResult = null;
                    }
                    int[] indices = this.indices[i];
                    builder.append("\tstring: ").append(this.str.subSequence(indices[3], indices[4])).append('\n');
                    builder.append("\tradix: ").append(indices[0]).append('\n');
                    builder.append("\tis standard: ").append(flags[2]).append('\n');
                    if (extendedUpper != 0L) {
                        BigInteger notExtended;
                        BigInteger extended = BigInteger.valueOf(extendedUpper);
                        BigInteger shiftMore = extended.shiftLeft(64);
                        BigInteger result = shiftMore.or(notExtended = BigInteger.valueOf(upper));
                        if (!result.equals(lowerResult)) {
                            builder.append("\tupper value: ").append(result).append('\n');
                            builder.append("\tupper value in hex: ").append(result.toString(16)).append('\n');
                            builder.append("\tupper string: ").append(this.str.subSequence(indices[6], indices[7])).append('\n');
                            builder.append("\tupper radix: ").append(indices[1]).append('\n');
                            builder.append("\tis standard range: ").append(flags[3]).append('\n');
                        }
                    } else if (upper != lower) {
                        builder.append("\tupper value: ").append(upper).append('\n');
                        builder.append("\tupper value in hex: ").append(Long.toHexString(upper)).append('\n');
                        builder.append("\tupper string: ").append(this.str.subSequence(indices[6], indices[7])).append('\n');
                        builder.append("\tupper radix: ").append(indices[1]).append('\n');
                        builder.append("\tis standard range: ").append(flags[3]).append('\n');
                    }
                    if (flags[1]) {
                        builder.append("\thas single wildcard: ").append('\n');
                    }
                }
                ++i;
            }
            builder.append("has a wildcard segment: ").append(this.anyWildcard).append('\n');
            if (this.consecutiveSepIndex >= 0) {
                builder.append("has compressed segment(s) at character ").append(this.consecutiveSepIndex + 1).append('\n');
            }
            if (this.isSingleSegment) {
                builder.append("is single segment").append('\n');
            }
        } else if (this.isEmpty) {
            builder.append("is empty").append('\n');
        } else if (this.isAll) {
            builder.append("is all addresses").append('\n');
        }
        return builder.toString();
    }
}

