/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import java.util.Iterator;

public class IPv6AddressSegment
extends IPAddressSegment
implements Iterable<IPv6AddressSegment> {
    private static final long serialVersionUID = 3L;
    public static final int MAX_CHARS = 4;
    static final IPv6AddressSegment ZERO_SEGMENT = IPv6AddressSegment.getSegmentCreator().createSegment(0);
    static final IPv6AddressSegment ALL_SEGMENT = IPv6AddressSegment.getSegmentCreator().createSegment(65535);
    static final IPv6AddressSegment ZERO_PREFIX_SEGMENT = new IPv6AddressSegment(0, 0);
    static final IPv6AddressSegment ALL_RANGE_SEGMENT = new IPv6AddressSegment(0, 65535, null);

    public IPv6AddressSegment(int value) {
        super(value);
        if (value > 65535) {
            throw new IllegalArgumentException();
        }
    }

    public IPv6AddressSegment(int value, Integer segmentPrefixLength) {
        super(value, segmentPrefixLength == null ? null : Integer.valueOf(Math.min(16, segmentPrefixLength)));
        if (this.getLowerSegmentValue() > 65535) {
            throw new IllegalArgumentException();
        }
    }

    public IPv6AddressSegment(int lower, int upper, Integer segmentPrefixLength) {
        super(lower, upper, segmentPrefixLength == null ? null : Integer.valueOf(Math.min(16, segmentPrefixLength)));
        if (this.getUpperSegmentValue() > 65535) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isIPv6() {
        return true;
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV6;
    }

    @Override
    protected byte[] getBytesImpl(boolean low) {
        int val = low ? this.getLowerSegmentValue() : this.getUpperSegmentValue();
        return new byte[]{(byte)(val >> 8), (byte)(0xFF & val)};
    }

    @Override
    protected int getSegmentNetworkMask(int bits) {
        return IPv6Address.network().getSegmentNetworkMask(bits);
    }

    @Override
    protected int getSegmentHostMask(int bits) {
        return IPv6Address.network().getSegmentHostMask(bits);
    }

    @Override
    public int getMaxSegmentValue() {
        return IPv6AddressSegment.getMaxSegmentValue(IPAddress.IPVersion.IPV6);
    }

    @Override
    public IPv6AddressSegment toNetworkSegment(Integer segmentPrefixLength) {
        return this.toNetworkSegment(segmentPrefixLength, true);
    }

    @Override
    public IPv6AddressSegment toNetworkSegment(Integer segmentPrefixLength, boolean withPrefixLength) {
        if (this.isNetworkChangedByPrefix(segmentPrefixLength, withPrefixLength)) {
            return super.toNetworkSegment(segmentPrefixLength, withPrefixLength, IPv6AddressSegment.getSegmentCreator());
        }
        return this;
    }

    @Override
    public IPv6AddressSegment toHostSegment(Integer bits) {
        if (this.isHostChangedByPrefix(bits)) {
            return super.toHostSegment(bits, IPv6AddressSegment.getSegmentCreator());
        }
        return this;
    }

    @Override
    public IPv6AddressSegment toMaskedSegment(IPAddressSegment maskSegment, Integer segmentPrefixLength) throws AddressTypeException {
        if (this.isChangedByMask(maskSegment, segmentPrefixLength)) {
            if (!this.isMaskCompatibleWithRange(maskSegment, segmentPrefixLength)) {
                throw new AddressTypeException(this, maskSegment, "ipaddress.error.maskMismatch");
            }
            int maskValue = maskSegment.getLowerSegmentValue();
            return IPv6AddressSegment.getSegmentCreator().createSegment(this.getLowerSegmentValue() & maskValue, this.getUpperSegmentValue() & maskValue, segmentPrefixLength);
        }
        return this;
    }

    protected boolean isChangedByMask(IPAddressSegment maskSegment, Integer segmentPrefixLength) throws AddressTypeException {
        if (!(maskSegment instanceof IPv6AddressSegment)) {
            throw new AddressTypeException(this, maskSegment, "ipaddress.error.typeMismatch");
        }
        return super.isChangedByMask(maskSegment.getLowerSegmentValue(), segmentPrefixLength);
    }

    @Override
    public IPv6AddressSegment getLower() {
        return IPv6AddressSegment.getLowestOrHighest(this, IPv6AddressSegment.getSegmentCreator(), true);
    }

    @Override
    public IPv6AddressSegment getUpper() {
        return IPv6AddressSegment.getLowestOrHighest(this, IPv6AddressSegment.getSegmentCreator(), false);
    }

    @Override
    public IPv6AddressSegment reverseBits(boolean perByte) {
        if (this.isMultiple()) {
            if (IPv6AddressSegment.isReversibleRange(this)) {
                if (this.isPrefixed()) {
                    IPv6AddressNetwork.IPv6AddressCreator creator = IPv6AddressSegment.getSegmentCreator();
                    return (IPv6AddressSegment)creator.createSegment(this.getLowerSegmentValue(), this.getUpperSegmentValue(), null);
                }
                return this;
            }
            throw new AddressTypeException(this, "ipaddress.error.reverseRange");
        }
        IPv6AddressNetwork.IPv6AddressCreator creator = IPv6AddressSegment.getSegmentCreator();
        int oldVal = this.getLowerSegmentValue();
        int newVal = IPv6AddressSegment.reverseBits((short)oldVal);
        if (perByte) {
            newVal = (newVal & 0xFF) << 8 | newVal >>> 8;
        }
        if (oldVal == newVal && !this.isPrefixed()) {
            return this;
        }
        return (IPv6AddressSegment)creator.createSegment(newVal);
    }

    @Override
    public IPv6AddressSegment reverseBytes() {
        int newValue;
        if (this.isMultiple()) {
            if (IPv6AddressSegment.isReversibleRange(this)) {
                if (this.isPrefixed()) {
                    IPv6AddressNetwork.IPv6AddressCreator creator = IPv6AddressSegment.getSegmentCreator();
                    return (IPv6AddressSegment)creator.createSegment(this.getLowerSegmentValue(), this.getUpperSegmentValue(), null);
                }
                return this;
            }
            throw new AddressTypeException(this, "ipaddress.error.reverseRange");
        }
        IPv6AddressNetwork.IPv6AddressCreator creator = IPv6AddressSegment.getSegmentCreator();
        int value = this.getLowerSegmentValue();
        if (value == (newValue = (value & 0xFF) << 8 | value >>> 8) && !this.isPrefixed()) {
            return this;
        }
        return (IPv6AddressSegment)creator.createSegment(newValue);
    }

    @Override
    public IPv6AddressSegment removePrefixLength(boolean zeroed) {
        return IPv6AddressSegment.removePrefix(this, zeroed, IPv6AddressSegment.getSegmentCreator());
    }

    @Override
    public IPv6AddressSegment removePrefixLength() {
        return this.removePrefixLength(true);
    }

    private static IPv6AddressNetwork.IPv6AddressCreator getSegmentCreator() {
        return IPv6Address.network().getAddressCreator();
    }

    public Iterable<IPv6AddressSegment> getIterable() {
        return this;
    }

    @Override
    public Iterator<IPv6AddressSegment> iterator() {
        return IPv6AddressSegment.iterator(this, IPv6AddressSegment.getSegmentCreator(), !this.isPrefixed());
    }

    static IPv6AddressSegment getZeroSegment() {
        return ZERO_SEGMENT;
    }

    @Override
    public int getBitCount() {
        return 16;
    }

    @Override
    public int getByteCount() {
        return 2;
    }

    @Override
    public int getDefaultTextualRadix() {
        return 16;
    }

    @Override
    public int getMaxDigitCount() {
        return 4;
    }

    public <S extends AddressSegment> void getSplitSegments(S[] segs, int index, AddressNetwork.AddressSegmentCreator<S> creator) {
        if (!this.isMultiple()) {
            Integer myPrefix = this.getSegmentPrefixLength();
            Integer highPrefixBits = IPv6AddressSegment.getSplitSegmentPrefix(8, myPrefix, 0);
            Integer lowPrefixBits = IPv6AddressSegment.getSplitSegmentPrefix(8, myPrefix, 1);
            if (index >= 0 && index < segs.length) {
                segs[index] = creator.createSegment(this.highByte(), highPrefixBits);
            }
            if (++index >= 0 && index < segs.length) {
                segs[index] = creator.createSegment(this.lowByte(), lowPrefixBits);
            }
        } else {
            this.getSplitSegmentsMultiple((AddressSegment[])segs, index, creator);
        }
    }

    private <S extends AddressSegment> void getSplitSegmentsMultiple(S[] segs, int index, AddressNetwork.AddressSegmentCreator<S> creator) {
        Integer myPrefix = this.getSegmentPrefixLength();
        if (index >= 0 && index < segs.length) {
            int highLower = IPv6AddressSegment.highByte(this.getLowerSegmentValue());
            int highUpper = IPv6AddressSegment.highByte(this.getUpperSegmentValue());
            Integer highPrefixBits = IPv6AddressSegment.getSplitSegmentPrefix(8, myPrefix, 0);
            segs[index] = highLower == highUpper ? creator.createSegment(highLower, highPrefixBits) : creator.createSegment(highLower, highUpper, highPrefixBits);
        }
        if (++index >= 0 && index < segs.length) {
            int lowLower = IPv6AddressSegment.lowByte(this.getLowerSegmentValue());
            int lowUpper = IPv6AddressSegment.lowByte(this.getUpperSegmentValue());
            Integer lowPrefixBits = IPv6AddressSegment.getSplitSegmentPrefix(8, myPrefix, 1);
            segs[index] = lowLower == lowUpper ? creator.createSegment(lowLower, lowPrefixBits) : creator.createSegment(lowLower, lowUpper, lowPrefixBits);
        }
    }

    public IPv4AddressSegment[] split() {
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv6AddressSegment.getIPv4AddressCreator();
        AddressSegment[] segs = creator.createSegmentArray(2);
        this.getSplitSegments(segs, 0, creator);
        return segs;
    }

    static IPv4AddressSegment[] split(IPv6AddressSegment high, IPv6AddressSegment low) {
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv6AddressSegment.getIPv4AddressCreator();
        AddressSegment[] segs = creator.createSegmentArray(4);
        high.getSplitSegments(segs, 0, creator);
        low.getSplitSegments(segs, 2, creator);
        return segs;
    }

    private static IPv4AddressNetwork.IPv4AddressCreator getIPv4AddressCreator() {
        return IPv4Address.network().getAddressCreator();
    }

    static IPv6AddressSegment join(IPv4AddressSegment high, IPv4AddressSegment low) throws AddressTypeException {
        int shift = 8;
        Integer prefix = IPv6AddressSegment.getJoinedSegmentPrefix(shift, high.getSegmentPrefixLength(), low.getSegmentPrefixLength());
        if (high.isMultiple() && !low.isFullRange()) {
            throw new AddressTypeException(high, low, "ipaddress.error.invalidMixedRange");
        }
        return IPv6AddressSegment.getSegmentCreator().createSegment(high.getLowerSegmentValue() << shift | low.getLowerSegmentValue(), high.getUpperSegmentValue() << shift | low.getUpperSegmentValue(), prefix);
    }

    public static IPv6AddressSegment join(IPv4AddressSegment one, IPv4AddressSegment two, int upperRangeLower, int upperRangeUpper, int lowerRangeLower, int lowerRangeUpper, Integer segmentPrefixLength) throws AddressTypeException {
        int shift = 8;
        if (upperRangeLower != upperRangeUpper) {
            if (segmentPrefixLength != null) {
                segmentPrefixLength = segmentPrefixLength > shift ? Integer.valueOf(segmentPrefixLength - shift) : Integer.valueOf(0);
            }
            if (!IPv6AddressSegment.isFullRange(lowerRangeLower, lowerRangeUpper, segmentPrefixLength, IPAddress.IPVersion.IPV4)) {
                throw new AddressTypeException(one, two, "ipaddress.error.invalidMixedRange");
            }
        }
        return IPv6AddressSegment.getSegmentCreator().createSegment(upperRangeLower << shift | lowerRangeLower, upperRangeUpper << shift | lowerRangeUpper, segmentPrefixLength);
    }

    static IPv6AddressSegment[] join(IPv4AddressSegment highHigh, IPv4AddressSegment highlow, IPv4AddressSegment lowHigh, IPv4AddressSegment lowLow) throws AddressTypeException {
        IPv6AddressSegment[] segs = IPv6AddressSegment.getSegmentCreator().createSegmentArray(2);
        segs[0] = IPv6AddressSegment.join(highHigh, highlow);
        segs[1] = IPv6AddressSegment.join(lowHigh, lowLow);
        return segs;
    }

    @Override
    public boolean contains(AddressSegment other) {
        return other instanceof IPv6AddressSegment && super.contains(other);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IPv6AddressSegment && this.isSameValues((IPv6AddressSegment)other);
    }

    @Override
    protected int getRangeDigitCountImpl() {
        int bitsPerCharacter;
        int bitCount;
        int prefix = this.getMinPrefix();
        if (prefix < (bitCount = this.getBitCount()) && this.isRangeEquivalent(prefix) && prefix % (bitsPerCharacter = 4) == 0) {
            return (bitCount - prefix) / bitsPerCharacter;
        }
        return 0;
    }
}

