/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.format.AddressDivision;

public class AddressBitsDivision
extends AddressDivision {
    private static final long serialVersionUID = 3L;
    protected final int value;
    protected final int upperValue;
    private final int bitCount;
    private final int defaultRadix;

    public AddressBitsDivision(int value, int bitCount, int defaultRadix) {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        this.value = this.upperValue = value;
        this.bitCount = bitCount;
        this.defaultRadix = defaultRadix;
    }

    public AddressBitsDivision(int lower, int upper, int bitCount, int defaultRadix) {
        if (lower < 0 || upper < 0) {
            throw new IllegalArgumentException();
        }
        if (lower > upper) {
            int tmp = lower;
            lower = upper;
            upper = tmp;
        }
        this.value = lower;
        this.upperValue = upper;
        this.bitCount = bitCount;
        this.defaultRadix = defaultRadix;
    }

    @Override
    public long getLowerValue() {
        return this.value;
    }

    @Override
    public long getUpperValue() {
        return this.upperValue;
    }

    @Override
    protected byte[] getBytesImpl(boolean low) {
        byte[] byArray;
        if (low) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = (byte)(this.value >> 8);
            byArray = byArray2;
            byArray2[1] = (byte)(0xFF & this.value);
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = (byte)(this.upperValue >> 8);
            byArray = byArray3;
            byArray3[1] = (byte)(0xFF & this.upperValue);
        }
        return byArray;
    }

    @Override
    public int getBitCount() {
        return this.bitCount;
    }

    @Override
    public int getMaxDigitCount() {
        return this.getBitCount() + 3 >> 2;
    }

    @Override
    protected boolean isSameValues(AddressDivision other) {
        if (other instanceof AddressBitsDivision) {
            return this.isSameValues((AddressBitsDivision)other);
        }
        return false;
    }

    protected boolean isSameValues(AddressBitsDivision otherSegment) {
        return this.value == otherSegment.value && this.upperValue == otherSegment.upperValue;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AddressBitsDivision) {
            AddressBitsDivision otherSegments = (AddressBitsDivision)other;
            return this.isSameValues(otherSegments);
        }
        return false;
    }

    public int hashCode() {
        return this.value | this.upperValue << this.getBitCount();
    }

    @Override
    public int getDefaultTextualRadix() {
        return this.defaultRadix;
    }
}

