/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressPart;
import inet.ipaddr.format.IPAddressSegmentGrouping;
import inet.ipaddr.format.util.IPAddressPartConfiguredString;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.util.IPAddressPartStringParams;
import inet.ipaddr.format.util.IPAddressPartStringSubCollection;
import inet.ipaddr.format.util.sql.IPAddressSQLTranslator;
import inet.ipaddr.format.util.sql.SQLStringMatcher;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;

public class IPv6AddressSection
extends IPAddressSection {
    private static final long serialVersionUID = 1L;
    private static IPv6AddressNetwork.IPv6AddressCreator[] creators = new IPv6AddressNetwork.IPv6AddressCreator[9];
    transient IPv6StringCache stringCache;
    transient IPv4AddressSection embeddedIPv4Section;
    transient IPv6v4MixedAddressSection defaultMixedAddressSection;
    public final int startIndex;
    private transient IPAddressSegmentGrouping.RangeList zeroSegments;
    private transient IPAddressSegmentGrouping.RangeList zeroRanges;

    public IPv6AddressSection(IPv6AddressSegment[] segments) {
        this(segments, 0, true);
    }

    public IPv6AddressSection(IPv6AddressSegment[] segments, Integer networkPrefixLength) {
        this(segments, 0, networkPrefixLength);
    }

    public IPv6AddressSection(IPv6AddressSegment[] segments, int startIndex, Integer networkPrefixLength) {
        this((IPv6AddressSegment[])IPv6AddressSection.toCIDRSegments((Integer)networkPrefixLength, (IPAddressSegment[])segments, (IPAddressTypeNetwork.IPAddressSegmentCreator)IPv6AddressSection.getIPv6SegmentCreator(), IPv6AddressSegment::toNetworkSegment), startIndex, false);
    }

    IPv6AddressSection(IPv6AddressSegment[] segments, int startIndex, boolean cloneSegments) {
        super(segments, null, cloneSegments, false);
        if (startIndex < 0) {
            throw new IllegalArgumentException();
        }
        this.startIndex = startIndex;
    }

    IPv6AddressSection(byte[] bytes, Integer prefix, boolean cloneBytes) {
        super(IPv6AddressSection.toSegments((byte[])bytes, (int)8, (int)2, (int)16, (IPAddressTypeNetwork.IPAddressSegmentCreator)IPv6AddressSection.getIPv6SegmentCreator(), (Integer)prefix), bytes, false, cloneBytes);
        this.startIndex = 0;
    }

    public IPv6AddressSection(byte[] bytes, Integer prefix) {
        this(bytes, prefix, true);
    }

    @Override
    protected void initCachedValues(Integer prefixLen, boolean network, Integer cachedNetworkPrefix, Integer cachedMinPrefix, Integer cachedEquivalentPrefix, BigInteger cachedCount, IPAddressSegmentGrouping.RangeList zeroSegments, IPAddressSegmentGrouping.RangeList zeroRanges) {
        super.initCachedValues(prefixLen, network, cachedNetworkPrefix, cachedMinPrefix, cachedEquivalentPrefix, cachedCount, zeroSegments, zeroRanges);
        this.zeroSegments = zeroSegments;
        this.zeroRanges = zeroRanges;
    }

    private IPv6AddressSegment[] getLowestOrHighestSegments(boolean lowest) {
        return (IPv6AddressSegment[])IPv6AddressSection.getSingle((IPAddressSection)this, (IPAddressSegment[])((IPv6AddressSegment[])this.divisions), (IPAddressTypeNetwork.IPAddressSegmentCreator)this.getAddressCreator(), (int i) -> {
            IPv6AddressSegment seg = this.getSegment(i);
            return lowest ? seg.getLower() : seg.getUpper();
        }, (boolean)false);
    }

    public IPv6AddressSegment[] getSegments() {
        return (IPv6AddressSegment[])this.divisions.clone();
    }

    public IPv6AddressSegment[] getLowerSegments() {
        return this.getLowestOrHighestSegments(true);
    }

    public IPv6AddressSegment[] getUpperSegments() {
        return this.getLowestOrHighestSegments(false);
    }

    private IPv6AddressSection getLowestOrHighestSection(boolean lowest) {
        return IPv6AddressSection.getSingle(this, () -> {
            IPAddressSection result;
            if (this.hasNoSectionCache() || (result = lowest ? this.sectionCache.lowerSection : this.sectionCache.upperSection) == null) {
                IPv6AddressNetwork.IPv6AddressCreator creator = this.getAddressCreator();
                IPv6AddressSegment[] segs = (IPv6AddressSegment[])IPv6AddressSection.createSingle((IPAddressSection)this, (IPAddressTypeNetwork.IPAddressSegmentCreator)creator, (int i) -> {
                    IPv6AddressSegment seg = this.getSegment(i);
                    return lowest ? seg.getLower() : seg.getUpper();
                });
                IPv6AddressSection newSection = creator.createSectionInternal(segs);
                if (lowest) {
                    this.sectionCache.lowerSection = newSection;
                } else {
                    this.sectionCache.upperSection = newSection;
                }
                return newSection;
            }
            return (IPv6AddressSection)result;
        });
    }

    @Override
    public IPv6AddressSection getLowerSection() {
        return this.getLowestOrHighestSection(true);
    }

    @Override
    public IPv6AddressSection getUpperSection() {
        return this.getLowestOrHighestSection(false);
    }

    public Iterator<IPv6AddressSection> sectionIterator() {
        return new IPAddressSection.SectionIterator<IPv6Address, IPv6AddressSection, IPv6AddressSegment>(this, this.getAddressCreator(), this.iterator());
    }

    public Iterator<IPv6AddressSegment[]> iterator() {
        return super.iterator(this.getSegmentCreator(), false, this::getLowerSegments, index -> this.getSegment(index).iterator());
    }

    protected IPv6AddressNetwork.IPv6AddressCreator getSegmentCreator() {
        return IPv6AddressSection.getIPv6SegmentCreator();
    }

    private static IPv6AddressNetwork.IPv6AddressCreator getIPv6SegmentCreator() {
        return IPv6Address.network().getAddressCreator();
    }

    protected IPv6AddressNetwork.IPv6AddressCreator getAddressCreator() {
        return IPv6AddressSection.getAddressCreator(this.startIndex);
    }

    protected static IPv6AddressNetwork.IPv6AddressCreator getAddressCreator(final int startIndex) {
        IPv6AddressNetwork.IPv6AddressCreator result = creators[startIndex];
        if (result == null) {
            IPv6AddressSection.creators[startIndex] = result = new IPv6AddressNetwork.IPv6AddressCreator(){

                @Override
                protected IPv6AddressSection createSectionInternal(IPv6AddressSegment[] segments) {
                    return IPv6Address.network().getAddressCreator().createSectionInternal(segments, startIndex);
                }
            };
        }
        return result;
    }

    @Override
    public IPv6AddressSegment getSegment(int index) {
        return (IPv6AddressSegment)super.getSegment(index);
    }

    public IPv4AddressSection getEmbeddedIPv4AddressSection(int startIndex, int endIndex) {
        IPv6AddressSegment ipv6Segment;
        if (startIndex == 6 - this.startIndex << 1 && endIndex == this.getSegmentCount() << 1) {
            return this.getEmbeddedIPv4AddressSection();
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
        IPAddressSegment[] segments = creator.createSegmentArray(endIndex - startIndex >> 1);
        int i = startIndex;
        int j = 0;
        if (i % 2 == 1) {
            ipv6Segment = this.getSegment(i++ / 2);
            ipv6Segment.getIPv4Segments((IPv4AddressSegment[])segments, j++ - 1);
        }
        while (i < endIndex) {
            ipv6Segment = this.getSegment(i / 2);
            ipv6Segment.getIPv4Segments((IPv4AddressSegment[])segments, j);
            i <<= 1;
            j <<= 1;
        }
        return (IPv4AddressSection)IPv6AddressSection.createSection((IPAddressTypeNetwork.IPAddressCreator)creator, (IPAddressSegment[])segments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPv4AddressSection getEmbeddedIPv4AddressSection() {
        if (this.embeddedIPv4Section == null) {
            IPv6AddressSection iPv6AddressSection = this;
            synchronized (iPv6AddressSection) {
                if (this.embeddedIPv4Section == null) {
                    int mixedCount = this.getSegmentCount() - Math.max(6 - this.startIndex, 0);
                    int lastIndex = this.getSegmentCount() - 1;
                    IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
                    IPAddressSegment[] mixed = mixedCount == 0 ? creator.createSegmentArray(0) : (mixedCount == 1 ? this.getSegment(lastIndex).split() : IPv6AddressSegment.split(this.getSegment(lastIndex - 1), this.getSegment(lastIndex)));
                    this.embeddedIPv4Section = (IPv4AddressSection)IPv6AddressSection.createSection((IPAddressTypeNetwork.IPAddressCreator)creator, (IPAddressSegment[])mixed);
                }
            }
        }
        return this.embeddedIPv4Section;
    }

    public IPv6AddressSection createNonMixedSection() {
        int mixedCount = this.getSegmentCount() - Math.max(6 - this.startIndex, 0);
        if (mixedCount <= 0) {
            return this;
        }
        int nonMixedCount = Math.max(0, this.getSegmentCount() - mixedCount);
        IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.network().getAddressCreator();
        IPAddressSegment[] nonMixed = creator.createSegmentArray(nonMixedCount);
        this.copySegments(0, nonMixedCount, nonMixed, 0);
        return creator.createSectionInternal((IPv6AddressSegment[])nonMixed, this.startIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPv6v4MixedAddressSection getMixedAddressSection() {
        if (this.defaultMixedAddressSection == null) {
            IPv6AddressSection iPv6AddressSection = this;
            synchronized (iPv6AddressSection) {
                if (this.defaultMixedAddressSection == null) {
                    this.defaultMixedAddressSection = new IPv6v4MixedAddressSection(this.createNonMixedSection(), this.getEmbeddedIPv4AddressSection());
                }
            }
        }
        return this.defaultMixedAddressSection;
    }

    @Override
    public int getBitsPerSegment() {
        return 16;
    }

    @Override
    public int getBytesPerSegment() {
        return 2;
    }

    public boolean hasAlphabeticDigits(int base, boolean lowerOnly) {
        if (base > 10) {
            int count = this.getSegmentCount();
            int i = 0;
            while (i < count) {
                IPv6AddressSegment seg = this.getSegment(i);
                if (seg.hasAlphabeticDigits(base, lowerOnly)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean isIPv6() {
        return true;
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV6;
    }

    @Override
    public boolean contains(IPAddressSection other) {
        return other.isIPv6() && this.startIndex == ((IPv6AddressSection)other).startIndex && super.contains(other);
    }

    @Override
    protected boolean isSameGrouping(IPAddressSegmentGrouping other) {
        return other instanceof IPv6AddressSection && this.startIndex == ((IPv6AddressSection)other).startIndex && super.isSameGrouping(other);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPv6AddressSection) {
            IPv6AddressSection other = (IPv6AddressSection)o;
            return this.startIndex == other.startIndex && super.isSameGrouping(other);
        }
        return false;
    }

    public IPv6AddressSection[] subtract(IPAddressSection other) {
        if (!(other instanceof IPv6AddressSection)) {
            throw new IPAddressTypeException((IPAddressSection)this, other, "ipaddress.error.typeMismatch");
        }
        return (IPv6AddressSection[])IPv6AddressSection.subtract((IPAddressSection)this, (IPAddressSection)((IPv6AddressSection)other), (IPAddressTypeNetwork.IPAddressCreator)this.getAddressCreator(), this::getSegment, (T section, U prefix) -> section.toSubnet((int)prefix));
    }

    @Override
    public int getByteIndex(Integer networkPrefixLength) {
        return IPv6AddressSection.getByteIndex(networkPrefixLength, 16);
    }

    @Override
    public int getSegmentIndex(Integer networkPrefixLength) {
        return IPv6AddressSection.getSegmentIndex(networkPrefixLength, 16, 2);
    }

    @Override
    public IPv6AddressNetwork getNetwork() {
        return IPv6Address.network();
    }

    @Override
    public IPv6AddressSection toSubnet(int networkPrefixLength) throws IPAddressTypeException {
        super.checkSubnet(networkPrefixLength);
        if (this.isPrefixed() && networkPrefixLength >= this.getNetworkPrefixLength()) {
            return this;
        }
        IPv6Address addressMask = (IPv6Address)this.getNetwork().getNetworkMask(networkPrefixLength, false);
        IPv6AddressSection mask = addressMask.getNetworkSection(this.getBitCount(), false);
        return IPv6AddressSection.getSubnetSegments(this, mask, networkPrefixLength, this.getAddressCreator(), false, this::getSegment, mask::getSegment);
    }

    @Override
    public IPv6AddressSection toSubnet(IPAddressSection mask) throws IPAddressTypeException {
        return this.toSubnet(mask, null);
    }

    @Override
    public IPv6AddressSection toSubnet(IPAddressSection mask, Integer networkPrefixLength) throws IPAddressTypeException {
        if (!(mask instanceof IPv6AddressSection)) {
            throw new IPAddressTypeException((IPAddressSection)this, mask, "ipaddress.error.typeMismatch");
        }
        IPv6AddressSection theMask = (IPv6AddressSection)mask;
        super.checkSubnet(theMask, networkPrefixLength);
        return IPv6AddressSection.getSubnetSegments(this, theMask, networkPrefixLength, this.getAddressCreator(), true, this::getSegment, theMask::getSegment);
    }

    @Override
    public IPv6AddressSection getNetworkSection(int networkPrefixLength) {
        return this.getNetworkSection(networkPrefixLength, true);
    }

    @Override
    public IPv6AddressSection getNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        int cidrSegmentCount = this.getNetworkSegmentCount(networkPrefixLength);
        return IPv6AddressSection.getNetworkSegments(this, networkPrefixLength, cidrSegmentCount, withPrefixLength, this.getAddressCreator(), (i, prefix) -> this.getSegment((int)i).toNetworkSegment((Integer)prefix, withPrefixLength));
    }

    @Override
    public IPv6AddressSection getHostSection(int networkPrefixLength) {
        int cidrSegmentCount = this.getHostSegmentCount(networkPrefixLength);
        IPv6AddressNetwork.IPv6AddressCreator creator = IPv6AddressSection.getAddressCreator(this.startIndex + (this.getSegmentCount() - cidrSegmentCount));
        return IPv6AddressSection.getHostSegments(this, networkPrefixLength, cidrSegmentCount, creator, (i, prefix) -> this.getSegment((int)i).toHostSegment((Integer)prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasNoStringCache() {
        if (this.stringCache == null) {
            IPv6AddressSection iPv6AddressSection = this;
            synchronized (iPv6AddressSection) {
                block5: {
                    if (this.stringCache != null) break block5;
                    this.stringCache = new IPv6StringCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected IPAddressSection.StringCache getStringCache() {
        return this.stringCache;
    }

    @Override
    public String toCompressedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.compressedString) == null) {
            this.stringCache.compressedString = result = this.toNormalizedString(IPv6StringCache.compressedParams);
        }
        return result;
    }

    @Override
    public String toCanonicalString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalString) == null) {
            this.stringCache.canonicalString = result = this.toNormalizedString(IPv6StringCache.canonicalParams);
        }
        return result;
    }

    public String toMixedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.mixedString) == null) {
            this.stringCache.mixedString = result = this.toNormalizedString(IPv6StringCache.mixedParams);
        }
        return result;
    }

    @Override
    public String toFullString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.fullString) == null) {
            this.stringCache.fullString = result = this.toNormalizedString(IPv6StringCache.fullParams);
        }
        return result;
    }

    @Override
    public String toCompressedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.compressedWildcardString) == null) {
            this.stringCache.compressedWildcardString = result = this.toNormalizedString(IPv6StringCache.wildcardCompressedParams);
        }
        return result;
    }

    @Override
    public String toNetworkPrefixLengthString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.networkPrefixLengthString) == null) {
            this.stringCache.networkPrefixLengthString = result = this.toNormalizedString(IPv6StringCache.networkPrefixLengthParams);
        }
        return result;
    }

    @Override
    public String toSubnetString() {
        return this.toNetworkPrefixLengthString();
    }

    @Override
    public String toCanonicalWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalWildcardString) == null) {
            this.stringCache.canonicalWildcardString = result = this.toNormalizedString(IPv6StringCache.wildcardCanonicalParams);
        }
        return result;
    }

    @Override
    public String toNormalizedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedWildcardString) == null) {
            this.stringCache.normalizedWildcardString = result = this.toNormalizedString(IPv6StringCache.wildcardNormalizedParams);
        }
        return result;
    }

    @Override
    public String toSQLWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.sqlWildcardString) == null) {
            this.stringCache.sqlWildcardString = result = this.toNormalizedString(IPv6StringCache.sqlWildcardParams);
        }
        return result;
    }

    @Override
    public String toNormalizedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedString) == null) {
            this.stringCache.normalizedString = result = this.toNormalizedString(IPv6StringCache.normalizedParams);
        }
        return result;
    }

    @Override
    protected String toHexString(boolean withPrefix, String zone) {
        return super.toHexString(withPrefix, zone);
    }

    @Override
    protected void cacheNormalizedString(String str) {
        if (this.hasNoStringCache() || this.stringCache.normalizedString == null) {
            this.stringCache.normalizedString = str;
        }
    }

    @Override
    public String toNormalizedStringRange(IPAddressSection.StringOptions options, String zone) {
        if (options instanceof IPv6StringOptions) {
            return this.toNormalizedStringRange((IPv6StringOptions)options, zone);
        }
        if (zone != null) {
            return this.toNormalizedStringRange(IPv6StringOptions.from(options), zone);
        }
        return super.toNormalizedStringRange(options, null);
    }

    public String toNormalizedStringRange(IPv6StringOptions options, String zone) {
        IPv6AddressSection section1 = this.getLowerSection();
        IPv6AddressSection section2 = this.getUpperSection();
        IPv6StringCollection.IPv6StringParams stringParams1 = options.from(section1);
        IPv6StringCollection.IPv6StringParams stringParams2 = options.from(section2);
        stringParams1.zone = zone;
        stringParams2.zone = zone;
        int length = 0;
        IPv6v4MixedAddressSection mixed2 = null;
        IPv6v4MixedAddressSection mixed1 = null;
        IPv6StringCollection.IPv6v4MixedParams mixedParams2 = null;
        IPv6StringCollection.IPv6v4MixedParams mixedParams1 = null;
        if (options.makeMixed()) {
            if (stringParams1.nextUncompressedIndex <= 6 - this.startIndex) {
                mixedParams1 = new IPv6StringCollection.IPv6v4MixedParams(stringParams1, options.ipv4Opts);
                mixed1 = section1.getMixedAddressSection();
                length += mixedParams1.getStringLength(mixed1);
            } else {
                length += stringParams1.getStringLength(section1);
            }
            if (stringParams2.nextUncompressedIndex <= 6 - this.startIndex) {
                mixedParams2 = new IPv6StringCollection.IPv6v4MixedParams(stringParams2, options.ipv4Opts);
                mixed2 = section2.getMixedAddressSection();
                length += mixedParams2.getStringLength(mixed2);
            } else {
                length += stringParams2.getStringLength(section2);
            }
        } else {
            length += stringParams1.getStringLength(section1) + stringParams2.getStringLength(section2);
        }
        String separator = stringParams1.getWildcardOption().wildcards.rangeSeparator;
        StringBuilder builder = new StringBuilder(length += separator.length());
        if (mixed1 == null) {
            stringParams1.append(builder, section1);
        } else {
            mixedParams1.append(builder, mixed1);
        }
        builder.append(separator);
        if (mixed2 == null) {
            stringParams2.append(builder, section2);
        } else {
            mixedParams2.append(builder, mixed2);
        }
        stringParams1.checkLengths(length, builder);
        return builder.toString();
    }

    @Override
    public String toNormalizedString(IPAddressSection.StringOptions options) {
        if (options instanceof IPv6StringOptions) {
            return this.toNormalizedString((IPv6StringOptions)options);
        }
        return super.toNormalizedString(options);
    }

    @Override
    public String toNormalizedString(IPAddressSection.StringOptions options, String zone) {
        if (zone == null) {
            return this.toNormalizedString(options);
        }
        return this.toNormalizedString(IPv6StringOptions.from(options), zone);
    }

    public String toNormalizedString(IPv6StringOptions options) {
        return this.toNormalizedString(options, null);
    }

    private String toNormalizedMixedString(IPv6StringCollection.IPv6v4MixedParams mixedParams) {
        IPv6v4MixedAddressSection mixed = this.getMixedAddressSection();
        String result = mixedParams.toString(mixed);
        return result;
    }

    public String toNormalizedString(IPv6StringOptions options, String zone) {
        IPv6StringCollection.IPv6StringParams stringParams;
        if (options.compressOptions == null && zone == null) {
            IPAddressPartStringParams<?> cachedParams = IPv6AddressSection.getCachedParams(options);
            if (cachedParams == null) {
                stringParams = options.from(this);
                if (options.makeMixed()) {
                    IPv6StringCollection.IPv6v4MixedParams mixedParams = new IPv6StringCollection.IPv6v4MixedParams(stringParams, options.ipv4Opts);
                    IPv6AddressSection.setCachedParams(options, mixedParams);
                    return this.toNormalizedMixedString(mixedParams);
                }
                IPv6AddressSection.setCachedParams(options, stringParams);
            } else {
                if (cachedParams instanceof IPv6StringCollection.IPv6v4MixedParams) {
                    return this.toNormalizedMixedString((IPv6StringCollection.IPv6v4MixedParams)cachedParams);
                }
                stringParams = (IPv6StringCollection.IPv6StringParams)cachedParams;
            }
        } else {
            stringParams = options.from(this);
            stringParams.zone = zone;
            if (options.makeMixed() && stringParams.nextUncompressedIndex <= 6 - this.startIndex) {
                return this.toNormalizedMixedString(new IPv6StringCollection.IPv6v4MixedParams(stringParams, options.ipv4Opts));
            }
        }
        return stringParams.toString(this);
    }

    @Override
    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(IPv6StringBuilderOptions.STANDARD_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(IPv6StringBuilderOptions.ALL_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toDatabaseSearchStringCollection() {
        return this.toStringCollection(IPv6StringBuilderOptions.DATABASE_SEARCH_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions options) {
        return this.toStringCollection(IPv6StringBuilderOptions.from(options));
    }

    public IPAddressPartStringCollection toStringCollection(IPv6StringBuilderOptions opts) {
        return this.toStringCollection(opts, null);
    }

    IPv6StringCollection toStringCollection(IPv6StringBuilderOptions opts, String zone) {
        IPv6StringCollection collection = new IPv6StringCollection();
        int mixedCount = this.getSegmentCount() - Math.max(6 - this.startIndex, 0);
        if (mixedCount > 0 && opts.includes(2)) {
            IPv6v4MixedAddressSection mixed = this.getMixedAddressSection();
            IPv6StringCollection.IPv6v4MixedStringBuilder mixedBuilder = new IPv6StringCollection.IPv6v4MixedStringBuilder(mixed, opts, zone);
            IPv6v4MixedStringCollection mixedCollection = (IPv6v4MixedStringCollection)mixedBuilder.getVariations();
            collection.add((IPAddressPartStringSubCollection<?, ?, ?>)mixedCollection);
        }
        if (opts.includes(1)) {
            IPv6StringCollection.IPv6StringBuilder ipv6Builder = new IPv6StringCollection.IPv6StringBuilder(this, opts, zone);
            IPv6AddressSectionStringCollection ipv6Collection = (IPv6AddressSectionStringCollection)ipv6Builder.getVariations();
            collection.add((IPAddressPartStringSubCollection<?, ?, ?>)ipv6Collection);
        }
        return collection;
    }

    @Override
    public IPAddressPart[] getParts(IPAddressSection.IPStringBuilderOptions opts) {
        return this.getParts(IPv6StringBuilderOptions.from(opts));
    }

    public IPAddressPart[] getParts(IPv6StringBuilderOptions opts) {
        if (opts.includes(2)) {
            if (opts.includes(1)) {
                return new IPAddressPart[]{this, this.getMixedAddressSection()};
            }
            return new IPAddressPart[]{this.getMixedAddressSection()};
        }
        return super.getParts(opts);
    }

    @Override
    public IPAddressSegmentGrouping.RangeList getZeroSegments() {
        if (this.zeroSegments == null) {
            this.zeroSegments = super.getZeroSegments();
        }
        return this.zeroSegments;
    }

    @Override
    public IPAddressSegmentGrouping.RangeList getZeroRangeSegments() {
        if (this.zeroRanges == null) {
            this.zeroRanges = super.getZeroRangeSegments();
        }
        return this.zeroRanges;
    }

    @Override
    public boolean isZero() {
        IPAddressSegmentGrouping.RangeList ranges = this.getZeroSegments();
        return ranges.size() == 1 && ranges.getRange((int)0).length == this.getSegmentCount();
    }

    private int[] getCompressIndexAndCount(CompressOptions options) {
        return this.getCompressIndexAndCount(options, false);
    }

    private int[] getCompressIndexAndCount(CompressOptions options, boolean createMixed) {
        if (options != null) {
            CompressOptions.CompressionChoiceOptions rangeSelection = options.rangeSelection;
            IPAddressSegmentGrouping.RangeList compressibleSegs = rangeSelection.compressHost() ? this.getZeroRangeSegments() : this.getZeroSegments();
            int maxIndex = -1;
            int maxCount = 0;
            int segmentCount = this.getSegmentCount();
            boolean compressMixed = createMixed && options.compressMixedOptions.compressMixed(this);
            boolean preferHost = rangeSelection == CompressOptions.CompressionChoiceOptions.HOST_PREFERRED;
            boolean preferMixed = createMixed && rangeSelection == CompressOptions.CompressionChoiceOptions.MIXED_PREFERRED;
            int i = compressibleSegs.size() - 1;
            while (i >= 0) {
                IPAddressSegmentGrouping.Range range = compressibleSegs.getRange(i);
                int index = range.index;
                int count = range.length;
                if (createMixed) {
                    int mixedIndex = 6 - this.startIndex;
                    if (!compressMixed || index > mixedIndex || index + count < segmentCount) {
                        count = Math.min(count, mixedIndex - index);
                    }
                }
                if (count > 0 && count >= maxCount && (options.compressSingle || count > 1)) {
                    maxIndex = index;
                    maxCount = count;
                }
                if (preferHost && this.isPrefixed() && (index + count) * 16 > this.getNetworkPrefixLength() || preferMixed && index + count >= segmentCount) break;
                --i;
            }
            if (maxIndex >= 0) {
                return new int[]{maxIndex, maxCount};
            }
        }
        return null;
    }

    public static class CompressOptions {
        public final boolean compressSingle;
        public final CompressionChoiceOptions rangeSelection;
        public final MixedCompressionOptions compressMixedOptions;

        public CompressOptions(boolean compressSingle, CompressionChoiceOptions rangeSelection) {
            this(compressSingle, rangeSelection, MixedCompressionOptions.YES);
        }

        public CompressOptions(boolean compressSingle, CompressionChoiceOptions rangeSelection, MixedCompressionOptions compressMixedOptions) {
            this.compressSingle = compressSingle;
            this.rangeSelection = rangeSelection;
            this.compressMixedOptions = compressMixedOptions == null ? MixedCompressionOptions.YES : compressMixedOptions;
        }

        public static enum CompressionChoiceOptions {
            HOST_PREFERRED,
            MIXED_PREFERRED,
            ZEROS_OR_HOST,
            ZEROS;


            boolean compressHost() {
                return this != ZEROS;
            }
        }

        public static enum MixedCompressionOptions {
            NO,
            NO_HOST,
            COVERED_BY_HOST,
            YES;


            boolean compressMixed(IPv6AddressSection addressSection) {
                switch (this) {
                    default: {
                        return true;
                    }
                    case NO: {
                        return false;
                    }
                    case NO_HOST: {
                        return !addressSection.isPrefixed();
                    }
                    case COVERED_BY_HOST: 
                }
                if (addressSection.isPrefixed()) {
                    int mixedDistance = 6 - addressSection.startIndex;
                    int mixedCount = addressSection.getSegmentCount() - Math.max(mixedDistance, 0);
                    if (mixedCount > 0) {
                        return mixedDistance * addressSection.getBitsPerSegment() >= addressSection.getNetworkPrefixLength();
                    }
                }
                return true;
            }
        }
    }

    private static class IPv6AddressSectionString
    extends IPAddressPartConfiguredString<IPv6AddressSection, IPv6StringCollection.IPv6StringParams> {
        IPv6AddressSectionString(IPv6AddressSection addr, IPv6StringCollection.IPv6StringParams stringParams) {
            super(addr, stringParams);
        }

        public IPv6StringMatcher getNetworkStringMatcher(boolean isEntireAddress, IPAddressSQLTranslator translator) {
            return new IPv6StringMatcher(this, translator);
        }

        public boolean endIsCompressed() {
            return ((IPv6StringCollection.IPv6StringParams)this.stringParams).endIsCompressed(this.addr);
        }

        public boolean isCompressed() {
            return ((IPv6StringCollection.IPv6StringParams)this.stringParams).isCompressed(this.addr);
        }
    }

    static class IPv6AddressSectionStringCollection
    extends IPAddressPartStringSubCollection<IPv6AddressSection, IPv6StringCollection.IPv6StringParams, IPv6AddressSectionString> {
        IPv6AddressSectionStringCollection(IPv6AddressSection addr) {
            super(addr);
        }

        @Override
        public Iterator<IPv6AddressSectionString> iterator() {
            return new IPAddressPartStringSubCollection.IPAddressConfigurableStringIterator(this){

                @Override
                public IPv6AddressSectionString next() {
                    return new IPv6AddressSectionString((IPv6AddressSection)part, (IPv6StringCollection.IPv6StringParams)this.iterator.next());
                }
            };
        }
    }

    public static class IPv6StringBuilderOptions
    extends IPAddressSection.IPStringBuilderOptions {
        public static final int MIXED = 2;
        public static final int UPPERCASE = 4;
        public static final int COMPRESSION_CANONICAL = 256;
        public static final int COMPRESSION_SINGLE = 768;
        public static final int COMPRESSION_LARGEST = 1792;
        public static final int COMPRESSION_ALL_FULL = 3840;
        public static final int COMPRESSION_ALL_PARTIAL = 7936;
        public static final int IPV4_CONVERSIONS = 65536;
        public final IPv4AddressSection.IPv4StringBuilderOptions mixedOptions;
        public final IPv4AddressSection.IPv4StringBuilderOptions ipv4ConverterOptions;
        public final IPv4Address.IPv4AddressConverter converter;
        public static final IPv6StringBuilderOptions STANDARD_OPTS = new IPv6StringBuilderOptions(3861, new IPv4AddressSection.IPv4StringBuilderOptions(17));
        public static final IPv6StringBuilderOptions ALL_OPTS = new IPv6StringBuilderOptions(69431, new IPv4AddressSection.IPv4StringBuilderOptions(49), null, new IPv4AddressSection.IPv4StringBuilderOptions(831));
        public static final IPv6StringBuilderOptions DATABASE_SEARCH_OPTS = new IPv6StringBuilderOptions(1793);

        public IPv6StringBuilderOptions(int options) {
            this(options, null, null, null);
        }

        public IPv6StringBuilderOptions(int options, IPv4AddressSection.IPv4StringBuilderOptions mixedOptions) {
            this(options, mixedOptions, null, null);
        }

        public IPv6StringBuilderOptions(int options, IPv4AddressSection.IPv4StringBuilderOptions mixedOptions, IPv4Address.IPv4AddressConverter ipv4AddressConverter, IPv4AddressSection.IPv4StringBuilderOptions ipv4ConverterOptions) {
            super(options | (mixedOptions == null ? 0 : 2) | (ipv4ConverterOptions == null ? 0 : 65536));
            if (this.includes(2) && mixedOptions == null) {
                mixedOptions = new IPv4AddressSection.IPv4StringBuilderOptions();
            }
            this.mixedOptions = mixedOptions;
            if (this.includes(65536)) {
                if (ipv4ConverterOptions == null) {
                    ipv4ConverterOptions = new IPv4AddressSection.IPv4StringBuilderOptions();
                }
                if (ipv4AddressConverter == null && (ipv4AddressConverter = IPAddress.addressConverter) == null) {
                    ipv4AddressConverter = new IPAddressConverter.DefaultAddressConverter();
                }
            }
            this.ipv4ConverterOptions = ipv4ConverterOptions;
            this.converter = ipv4AddressConverter;
        }

        public static IPv6StringBuilderOptions from(IPAddressSection.IPStringBuilderOptions opts) {
            if (opts instanceof IPv6StringBuilderOptions) {
                return (IPv6StringBuilderOptions)opts;
            }
            return new IPv6StringBuilderOptions(opts.options & 0xFFFEE0F9);
        }
    }

    static class IPv6StringCache
    extends IPAddressSection.StringCache {
        static final IPv6StringOptions mixedParams;
        static final IPv6StringOptions fullParams;
        static final IPv6StringOptions normalizedParams;
        static final IPv6StringOptions canonicalParams;
        static final IPv6StringOptions uncParams;
        static final IPv6StringOptions compressedParams;
        static final IPv6StringOptions wildcardNormalizedParams;
        static final IPv6StringOptions wildcardCanonicalParams;
        static final IPv6StringOptions sqlWildcardParams;
        static final IPv6StringOptions wildcardCompressedParams;
        static final IPv6StringOptions networkPrefixLengthParams;
        static final IPv6StringOptions reverseDNSParams;
        public String normalizedString;
        public String compressedString;
        public String mixedString;
        public String compressedWildcardString;
        public String canonicalWildcardString;
        public String networkPrefixLengthString;
        public String uncString;

        static {
            CompressOptions compressAll = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.ZEROS_OR_HOST);
            CompressOptions compressMixed = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.MIXED_PREFERRED);
            CompressOptions compressAllNoSingles = new CompressOptions(false, CompressOptions.CompressionChoiceOptions.ZEROS_OR_HOST);
            CompressOptions compressHostPreferred = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.HOST_PREFERRED);
            CompressOptions compressZeros = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.ZEROS);
            CompressOptions compressZerosNoSingles = new CompressOptions(false, CompressOptions.CompressionChoiceOptions.ZEROS);
            mixedParams = new IPv6StringOptions.Builder().setMakeMixed(true).setCompressOptions(compressMixed).toParams();
            fullParams = new IPv6StringOptions.Builder().setExpandedSegments(true).setWildcardOptions(new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY, new IPAddressSection.WildcardOptions.Wildcards(IPAddress.RANGE_SEPARATOR_STR))).toParams();
            canonicalParams = new IPv6StringOptions.Builder().setCompressOptions(compressAllNoSingles).toParams();
            uncParams = new IPv6StringOptions.Builder().setSeparator(Character.valueOf('-')).setZoneSeparator('s').setAddressSuffix(".ipv6-literal.net").setWildcardOptions(new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY, new IPAddressSection.WildcardOptions.Wildcards(IPv6Address.UNC_RANGE_SEPARATOR_STR, IPAddress.SEGMENT_WILDCARD_STR, null))).toParams();
            compressedParams = new IPv6StringOptions.Builder().setCompressOptions(compressAll).toParams();
            normalizedParams = new IPv6StringOptions.Builder().toParams();
            IPAddressSection.WildcardOptions allWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL);
            IPAddressSection.WildcardOptions allSQLWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL, new IPAddressSection.WildcardOptions.Wildcards(IPAddress.SEGMENT_SQL_WILDCARD_STR, IPAddress.SEGMENT_SQL_SINGLE_WILDCARD_STR));
            wildcardCanonicalParams = new IPv6StringOptions.Builder().setWildcardOptions(allWildcards).setCompressOptions(compressZerosNoSingles).toParams();
            wildcardNormalizedParams = new IPv6StringOptions.Builder().setWildcardOptions(allWildcards).toParams();
            sqlWildcardParams = new IPv6StringOptions.Builder().setWildcardOptions(allSQLWildcards).toParams();
            wildcardCompressedParams = new IPv6StringOptions.Builder().setWildcardOptions(allWildcards).setCompressOptions(compressZeros).toParams();
            networkPrefixLengthParams = new IPv6StringOptions.Builder().setCompressOptions(compressHostPreferred).toParams();
            reverseDNSParams = new IPv6StringOptions.Builder().setReverse(true).setAddressSuffix(".ip6.arpa").setSplitDigits(true).setExpandedSegments(true).setSeparator(Character.valueOf('.')).toParams();
        }

        IPv6StringCache() {
        }
    }

    static class IPv6StringCollection
    extends IPAddressPartStringCollection {
        IPv6StringCollection() {
        }

        protected void add(IPAddressPartStringSubCollection<?, ?, ?> collection) {
            super.add(collection);
        }

        @Override
        protected void addAll(IPAddressPartStringCollection collections) {
            super.addAll(collections);
        }

        static class IPv6StringBuilder
        extends IPAddressPartStringCollection.AddressPartStringBuilder<IPv6AddressSection, IPv6StringParams, IPv6AddressSectionString, IPv6AddressSectionStringCollection, IPv6StringBuilderOptions> {
            private final String zone;

            IPv6StringBuilder(IPv6AddressSection address, IPv6StringBuilderOptions opts, String zone) {
                super(address, opts, new IPv6AddressSectionStringCollection(address));
                this.zone = zone;
            }

            private void addUppercaseVariations(ArrayList<IPv6StringParams> allParams, int base) {
                boolean lowerOnly = true;
                if (((IPv6StringBuilderOptions)this.options).includes(4) && ((IPv6AddressSection)this.addressSection).hasAlphabeticDigits(base, lowerOnly)) {
                    int len = allParams.size();
                    int j = 0;
                    while (j < len) {
                        IPv6StringParams clone = allParams.get(j);
                        clone = clone.clone();
                        clone.setUppercase(true);
                        allParams.add(clone);
                        ++j;
                    }
                }
            }

            private void addAllExpansions(int firstCompressedIndex, int count, int segmentCount) {
                boolean isExpandable;
                IPv6StringParams stringParams = new IPv6StringParams(firstCompressedIndex, count);
                stringParams.zone = this.zone;
                int base = stringParams.getRadix();
                ArrayList<IPv6StringParams> allParams = new ArrayList<IPv6StringParams>();
                allParams.add(stringParams);
                int radix = 16;
                if (((IPv6StringBuilderOptions)this.options).includes(48)) {
                    int[] expandables = this.getExpandableSegments(radix);
                    int nextUncompressedIndex = firstCompressedIndex + count;
                    int ipv6SegmentEnd = ((IPv6AddressSection)this.addressSection).getSegmentCount();
                    int i = 0;
                    while (i < ipv6SegmentEnd) {
                        if (i < firstCompressedIndex || i >= nextUncompressedIndex) {
                            int expansionLength = expandables[i];
                            int len = allParams.size();
                            while (expansionLength > 0) {
                                int j = 0;
                                while (j < len) {
                                    IPv6StringParams clone = allParams.get(j);
                                    clone = clone.clone();
                                    clone.expandSegment(i, expansionLength, ((IPv6AddressSection)this.addressSection).getSegmentCount());
                                    allParams.add(clone);
                                    ++j;
                                }
                                if (!((IPv6StringBuilderOptions)this.options).includes(112)) break;
                                --expansionLength;
                            }
                        }
                        ++i;
                    }
                } else if (((IPv6StringBuilderOptions)this.options).includes(16) && (isExpandable = this.isExpandableOutsideRange(radix, firstCompressedIndex, count))) {
                    int len = allParams.size();
                    int j = 0;
                    while (j < len) {
                        IPv6StringParams clone = allParams.get(j);
                        clone = clone.clone();
                        clone.expandSegments(true);
                        allParams.add(clone);
                        ++j;
                    }
                }
                this.addUppercaseVariations(allParams, base);
                int i = 0;
                while (i < allParams.size()) {
                    IPv6StringParams param = allParams.get(i);
                    this.addStringParam(param);
                    ++i;
                }
            }

            private void addAllCompressedStrings(int zeroStartIndex, int count, boolean partial, int segmentCount) {
                int end = zeroStartIndex + count;
                if (partial) {
                    int i = zeroStartIndex;
                    while (i < end) {
                        int j = i + 1;
                        while (j <= end) {
                            this.addAllExpansions(i, j - i, segmentCount);
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int len = end - zeroStartIndex;
                    if (len > 0) {
                        this.addAllExpansions(zeroStartIndex, len, segmentCount);
                    }
                }
            }

            @Override
            protected void addAllVariations() {
                CompressOptions opts;
                int[] indexes;
                int segmentCount = ((IPv6AddressSection)this.addressSection).getSegmentCount();
                this.addAllExpansions(-1, 0, segmentCount);
                if (((IPv6StringBuilderOptions)this.options).includes(3840)) {
                    IPAddressSegmentGrouping.RangeList zeroSegs = ((IPv6AddressSection)this.addressSection).getZeroSegments();
                    int i = 0;
                    while (i < zeroSegs.size()) {
                        IPAddressSegmentGrouping.Range range = zeroSegs.getRange(i);
                        this.addAllCompressedStrings(range.index, range.length, ((IPv6StringBuilderOptions)this.options).includes(7936), segmentCount);
                        ++i;
                    }
                } else if (((IPv6StringBuilderOptions)this.options).includes(256) && (indexes = ((IPv6AddressSection)this.addressSection).getCompressIndexAndCount(opts = new CompressOptions(((IPv6StringBuilderOptions)this.options).includes(768), CompressOptions.CompressionChoiceOptions.ZEROS))) != null) {
                    if (((IPv6StringBuilderOptions)this.options).includes(1792)) {
                        int maxCount = indexes[1];
                        IPAddressSegmentGrouping.RangeList zeroSegs = ((IPv6AddressSection)this.addressSection).getZeroSegments();
                        int i = 0;
                        while (i < zeroSegs.size()) {
                            IPAddressSegmentGrouping.Range range = zeroSegs.getRange(i);
                            int count = range.length;
                            if (count == maxCount) {
                                this.addAllCompressedStrings(range.index, count, ((IPv6StringBuilderOptions)this.options).includes(7936), segmentCount);
                            }
                            ++i;
                        }
                    } else {
                        int maxIndex = indexes[0];
                        int maxCount = indexes[1];
                        this.addAllCompressedStrings(maxIndex, maxCount, false, segmentCount);
                    }
                }
            }
        }

        static class IPv6StringParams
        extends IPAddressPartStringCollection.StringParams<IPv6AddressSection> {
            int firstCompressedSegmentIndex;
            int nextUncompressedIndex;
            boolean hostCompressed;
            String zone;
            char zoneSeparator;

            IPv6StringParams() {
                this(-1, 0);
            }

            IPv6StringParams(int firstCompressedSegmentIndex, int compressedCount) {
                this(false, firstCompressedSegmentIndex, compressedCount, false, ':', '%');
            }

            private IPv6StringParams(boolean expandSegments, int firstCompressedSegmentIndex, int compressedCount, boolean uppercase, char separator, char zoneSeparator) {
                super(16, Character.valueOf(separator), uppercase);
                this.expandSegments(expandSegments);
                this.firstCompressedSegmentIndex = firstCompressedSegmentIndex;
                this.nextUncompressedIndex = firstCompressedSegmentIndex + compressedCount;
                this.zoneSeparator = zoneSeparator;
            }

            public void setZoneSeparator(char zoneSeparator) {
                this.zoneSeparator = zoneSeparator;
            }

            public boolean endIsCompressed(IPAddressPart addr) {
                return this.nextUncompressedIndex >= addr.getDivisionCount();
            }

            public boolean isCompressed(IPAddressPart addr) {
                return this.firstCompressedSegmentIndex >= 0;
            }

            @Override
            public int getTrailingSeparatorCount(IPv6AddressSection addr) {
                return this.getTrailingSepCount(addr);
            }

            public int getTrailingSepCount(IPAddressPart addr) {
                int divisionCount = addr.getDivisionCount();
                if (divisionCount == 0) {
                    return 0;
                }
                int count = divisionCount - 1;
                if (this.isCompressed(addr)) {
                    count -= this.nextUncompressedIndex - this.firstCompressedSegmentIndex - 1;
                    if (this.firstCompressedSegmentIndex == 0 || this.nextUncompressedIndex >= divisionCount) {
                        ++count;
                    }
                }
                return count;
            }

            @Override
            public int getStringLength(IPv6AddressSection addr) {
                int count = this.getSegmentsStringLength(addr);
                if (!this.isReverse() && (this.getWildcardOption().wildcardOption != IPAddressSection.WildcardOptions.WildcardOption.ALL || this.hostCompressed)) {
                    count += addr.getPrefixStringLength();
                }
                count += this.getZoneLength();
                count += this.getAddressSuffixLength();
                return count += this.getAddressLabelLength();
            }

            @Override
            public StringBuilder append(StringBuilder builder, IPv6AddressSection addr) {
                this.appendLabel(builder);
                this.appendSegments(builder, addr);
                this.appendZone(builder);
                this.appendSuffix(builder);
                if (!this.isReverse() && (this.getWildcardOption().wildcardOption != IPAddressSection.WildcardOptions.WildcardOption.ALL || this.hostCompressed)) {
                    this.appendPrefixIndicator(builder, addr);
                }
                return builder;
            }

            protected int getZoneLength() {
                if (this.zone != null && this.zone.length() > 0) {
                    return this.zone.length() + 1;
                }
                return 0;
            }

            protected void appendZone(StringBuilder builder) {
                if (this.zone != null && this.zone.length() > 0) {
                    builder.append(this.zoneSeparator).append(this.zone);
                }
            }

            @Override
            public StringBuilder appendSegments(StringBuilder builder, IPv6AddressSection addr) {
                int divisionCount = addr.getDivisionCount();
                if (divisionCount <= 0) {
                    return builder;
                }
                int lastIndex = divisionCount - 1;
                Character separator = this.getSeparator();
                IPAddressSection.WildcardOptions wildcardOptions = this.getWildcardOption();
                IPAddressSection.WildcardOptions.WildcardOption wildcardOption = wildcardOptions.wildcardOption;
                boolean isAll = wildcardOption == IPAddressSection.WildcardOptions.WildcardOption.ALL;
                boolean reverse = this.isReverse();
                int i = 0;
                while (true) {
                    int segIndex;
                    int n = segIndex = reverse ? lastIndex - i : i;
                    if (segIndex < this.firstCompressedSegmentIndex || segIndex >= this.nextUncompressedIndex) {
                        IPAddressDivision seg = addr.getDivision(segIndex);
                        int leadingZeroCount = this.getLeadingZeros(segIndex);
                        if (isAll || this.isSplitDigits()) {
                            seg.getWildcardString(wildcardOptions.wildcards, leadingZeroCount, this.getSegmentStrPrefix(), this.getRadix(), this.isUppercase(), this.isSplitDigits(), separator.charValue(), this.isReverse(), builder);
                        } else {
                            seg.getPrefixAdjustedWildcardString(wildcardOptions.wildcards, leadingZeroCount, this.getSegmentStrPrefix(), this.getRadix(), this.isUppercase(), builder);
                        }
                        if (++i > lastIndex) break;
                        if (separator == null) continue;
                        builder.append(separator);
                        continue;
                    }
                    if (segIndex == (reverse ? this.nextUncompressedIndex - 1 : this.firstCompressedSegmentIndex) && separator != null) {
                        builder.append(separator);
                        if (i == 0) {
                            builder.append(separator);
                        }
                    }
                    if (++i > lastIndex) break;
                }
                return builder;
            }

            @Override
            public int getSegmentsStringLength(IPv6AddressSection part) {
                int count = 0;
                int divCount = part.getDivisionCount();
                if (divCount != 0) {
                    IPAddressSection.WildcardOptions wildcardOptions = this.getWildcardOption();
                    IPAddressSection.WildcardOptions.WildcardOption wildcardOption = wildcardOptions.wildcardOption;
                    boolean isAll = wildcardOption == IPAddressSection.WildcardOptions.WildcardOption.ALL;
                    Character separator = this.getSeparator();
                    int i = 0;
                    while (true) {
                        if (i < this.firstCompressedSegmentIndex || i >= this.nextUncompressedIndex) {
                            IPAddressDivision seg = part.getDivision(i);
                            int leadingZeroCount = this.getLeadingZeros(i);
                            count = isAll || this.isSplitDigits() ? (count += seg.getWildcardString(wildcardOptions.wildcards, leadingZeroCount, this.getSegmentStrPrefix(), this.getRadix(), this.isUppercase(), this.isSplitDigits(), separator.charValue(), this.isReverse(), null)) : (count += seg.getPrefixAdjustedWildcardString(wildcardOptions.wildcards, leadingZeroCount, this.getSegmentStrPrefix(), this.getRadix(), this.isUppercase(), null));
                            if (++i >= divCount) break;
                            if (separator == null) continue;
                            ++count;
                            continue;
                        }
                        if (i == this.firstCompressedSegmentIndex && separator != null) {
                            ++count;
                            if (i == 0) {
                                ++count;
                            }
                        }
                        if (++i >= divCount) break;
                    }
                }
                return count;
            }

            @Override
            public IPv6StringParams clone() {
                return (IPv6StringParams)super.clone();
            }
        }

        static class IPv6v4MixedParams
        extends IPAddressPartStringParams<IPv6v4MixedAddressSection> {
            private IPAddressPartStringCollection.StringParams<IPAddressPart> ipv4Params;
            private IPv6StringParams ipv6Params;

            IPv6v4MixedParams(IPv6AddressSectionString ipv6Variation, IPAddressPartConfiguredString<?, ?> ipv4Variation) {
                this.ipv4Params = (IPAddressPartStringCollection.StringParams)ipv4Variation.stringParams;
                this.ipv6Params = (IPv6StringParams)ipv6Variation.stringParams;
            }

            IPv6v4MixedParams(IPv6StringParams ipv6Params, IPAddressSection.StringOptions ipv4Opts) {
                this.ipv4Params = IPv6AddressSection.toParams(ipv4Opts);
                this.ipv6Params = ipv6Params;
            }

            @Override
            public char getTrailingSegmentSeparator() {
                return this.ipv4Params.getTrailingSegmentSeparator();
            }

            @Override
            public int getTrailingSeparatorCount(IPv6v4MixedAddressSection addr) {
                return this.ipv4Params.getTrailingSeparatorCount(addr.ipv4Section);
            }

            @Override
            protected int getStringLength(IPv6v4MixedAddressSection addr) {
                int ipv6length = this.ipv6Params.getSegmentsStringLength(addr.ipv6Section);
                int ipv4length = this.ipv4Params.getSegmentsStringLength(addr.ipv4Section);
                int length = ipv6length + ipv4length;
                if (this.ipv6Params.nextUncompressedIndex < addr.ipv6Section.getSegmentCount()) {
                    ++length;
                }
                length += this.getPrefixStringLength(addr);
                length += this.ipv6Params.getZoneLength();
                length += this.ipv6Params.getAddressSuffixLength();
                return length += this.ipv6Params.getAddressLabelLength();
            }

            @Override
            public String toString(IPv6v4MixedAddressSection addr) {
                int length = this.getStringLength(addr);
                StringBuilder builder = new StringBuilder(length);
                this.append(builder, addr);
                this.checkLengths(length, builder);
                return builder.toString();
            }

            @Override
            public StringBuilder append(StringBuilder builder, IPv6v4MixedAddressSection addr) {
                this.ipv6Params.appendLabel(builder);
                this.ipv6Params.appendSegments(builder, addr.ipv6Section);
                if (this.ipv6Params.nextUncompressedIndex < addr.ipv6Section.getSegmentCount()) {
                    builder.append(this.ipv6Params.getTrailingSegmentSeparator());
                }
                this.ipv4Params.appendSegments(builder, addr.ipv4Section);
                this.ipv6Params.appendZone(builder);
                this.ipv6Params.appendSuffix(builder);
                this.appendPrefixIndicator(builder, addr);
                return builder;
            }

            protected int getPrefixStringLength(IPv6v4MixedAddressSection addr) {
                if (this.requiresPrefixIndicator(addr.ipv6Section) || this.requiresPrefixIndicator(addr.ipv4Section)) {
                    return addr.getPrefixStringLength();
                }
                return 0;
            }

            @Override
            protected void appendPrefixIndicator(StringBuilder builder, IPv6v4MixedAddressSection addr) {
                if (this.requiresPrefixIndicator(addr.ipv6Section) || this.requiresPrefixIndicator(addr.ipv4Section)) {
                    super.appendPrefixIndicator(builder, addr);
                }
            }

            protected boolean requiresPrefixIndicator(IPv4AddressSection ipv4Section) {
                return ipv4Section.isPrefixed() && this.ipv4Params.getWildcardOption().wildcardOption != IPAddressSection.WildcardOptions.WildcardOption.ALL;
            }

            protected boolean requiresPrefixIndicator(IPv6AddressSection ipv6Section) {
                return ipv6Section.isPrefixed() && (this.ipv6Params.getWildcardOption().wildcardOption != IPAddressSection.WildcardOptions.WildcardOption.ALL || this.ipv6Params.hostCompressed);
            }

            @Override
            public IPv6v4MixedParams clone() {
                IPv6v4MixedParams params = (IPv6v4MixedParams)super.clone();
                params.ipv6Params = this.ipv6Params.clone();
                params.ipv4Params = this.ipv4Params.clone();
                return params;
            }
        }

        static class IPv6v4MixedStringBuilder
        extends IPAddressPartStringCollection.AddressPartStringBuilder<IPv6v4MixedAddressSection, IPv6v4MixedParams, IPAddressPartConfiguredString<IPv6v4MixedAddressSection, IPv6v4MixedParams>, IPv6v4MixedStringCollection, IPv6StringBuilderOptions> {
            private final String zone;

            IPv6v4MixedStringBuilder(IPv6v4MixedAddressSection address, IPv6StringBuilderOptions opts, String zone) {
                super(address, opts, new IPv6v4MixedStringCollection(address));
                this.zone = zone;
            }

            @Override
            protected void addAllVariations() {
                IPv6StringBuilder ipv6Builder = new IPv6StringBuilder(((IPv6v4MixedAddressSection)this.addressSection).ipv6Section, (IPv6StringBuilderOptions)this.options, this.zone);
                IPv6AddressSectionStringCollection ipv6Variations = (IPv6AddressSectionStringCollection)ipv6Builder.getVariations();
                IPAddressPartStringCollection ipv4Collection = ((IPv6v4MixedAddressSection)this.addressSection).ipv4Section.toStringCollection(((IPv6StringBuilderOptions)this.options).mixedOptions);
                for (IPv6AddressSectionString ipv6Variation : ipv6Variations) {
                    for (IPAddressPartConfiguredString<?, ?> ipv4Variation : ipv4Collection) {
                        IPv6v4MixedParams mixed = new IPv6v4MixedParams(ipv6Variation, ipv4Variation);
                        this.addStringParam(mixed);
                    }
                }
            }
        }
    }

    private static class IPv6StringMatcher
    extends SQLStringMatcher<IPv6AddressSection, IPv6StringCollection.IPv6StringParams, IPv6AddressSectionString> {
        IPv6StringMatcher(IPv6AddressSectionString networkString, IPAddressSQLTranslator translator) {
            super(networkString, ((IPv6AddressSection)networkString.addr).isEntireAddress(), translator);
        }

        @Override
        public StringBuilder getSQLCondition(StringBuilder builder, String columnName) {
            if (((IPv6AddressSection)((IPv6AddressSectionString)this.networkString).addr).isEntireAddress()) {
                this.matchString(builder, columnName, ((IPv6AddressSectionString)this.networkString).getString());
            } else if (((IPv6AddressSectionString)this.networkString).endIsCompressed()) {
                char sep = ((IPv6AddressSectionString)this.networkString).getTrailingSegmentSeparator();
                String searchStr = ((IPv6AddressSectionString)this.networkString).getString().substring(0, ((IPv6AddressSectionString)this.networkString).getString().length() - 1);
                builder.append('(');
                this.matchSubString(builder, columnName, sep, ((IPv6AddressSectionString)this.networkString).getTrailingSeparatorCount(), searchStr);
                int extraSeparatorCountMax = 7 - ((IPv6AddressSection)((IPv6AddressSectionString)this.networkString).addr).getSegmentCount();
                builder.append(") AND (");
                this.boundSeparatorCount(builder, columnName, sep, extraSeparatorCountMax + ((IPv6AddressSectionString)this.networkString).getTrailingSeparatorCount());
                builder.append(')');
            } else if (((IPv6AddressSectionString)this.networkString).isCompressed()) {
                char sep = ((IPv6AddressSectionString)this.networkString).getTrailingSegmentSeparator();
                builder.append('(');
                this.matchSubString(builder, columnName, sep, ((IPv6AddressSectionString)this.networkString).getTrailingSeparatorCount() + 1, ((IPv6AddressSectionString)this.networkString).getString());
                int extraSeparatorCount = 8 - ((IPv6AddressSection)((IPv6AddressSectionString)this.networkString).addr).getSegmentCount();
                builder.append(") AND (");
                this.matchSeparatorCount(builder, columnName, sep, extraSeparatorCount + ((IPv6AddressSectionString)this.networkString).getTrailingSeparatorCount());
                builder.append(')');
            } else {
                this.matchSubString(builder, columnName, ((IPv6AddressSectionString)this.networkString).getTrailingSegmentSeparator(), ((IPv6AddressSectionString)this.networkString).getTrailingSeparatorCount() + 1, ((IPv6AddressSectionString)this.networkString).getString());
            }
            return builder;
        }
    }

    public static class IPv6StringOptions
    extends IPAddressSection.StringOptions {
        public final IPAddressSection.StringOptions ipv4Opts;
        public final CompressOptions compressOptions;
        public final char zoneSeparator;

        IPv6StringOptions(int base, boolean expandSegments, IPAddressSection.WildcardOptions wildcardOptions, String segmentStrPrefix, boolean makeMixed, IPAddressSection.StringOptions ipv4Opts, CompressOptions compressOptions, Character separator, char zoneSeparator, String addressPrefix, String addressSuffix, boolean reverse, boolean splitDigits, boolean uppercase) {
            super(base, expandSegments, wildcardOptions, segmentStrPrefix, separator, addressPrefix, addressSuffix, reverse, splitDigits, uppercase);
            this.compressOptions = compressOptions;
            this.zoneSeparator = zoneSeparator;
            if (makeMixed) {
                if (ipv4Opts == null) {
                    ipv4Opts = new IPAddressSection.StringOptions.Builder().setExpandedSegments(expandSegments).setWildcardOptions(wildcardOptions).toParams();
                }
                this.ipv4Opts = ipv4Opts;
            } else {
                this.ipv4Opts = null;
            }
        }

        boolean makeMixed() {
            return this.ipv4Opts != null;
        }

        private IPv6StringCollection.IPv6StringParams from(IPv6AddressSection addr) {
            boolean makeMixed;
            int[] vals;
            IPv6StringCollection.IPv6StringParams result = new IPv6StringCollection.IPv6StringParams();
            if (this.compressOptions != null && (vals = addr.getCompressIndexAndCount(this.compressOptions, makeMixed = this.makeMixed())) != null) {
                int maxIndex = vals[0];
                int maxCount = vals[1];
                result.firstCompressedSegmentIndex = maxIndex;
                result.nextUncompressedIndex = maxIndex + maxCount;
                result.hostCompressed = this.compressOptions.rangeSelection.compressHost() && result.nextUncompressedIndex > IPv6AddressSection.getSegmentIndex(addr.getNetworkPrefixLength(), 16, 2);
            }
            result.expandSegments(this.expandSegments);
            result.setWildcardOption(this.wildcardOptions);
            result.setSeparator(this.separator);
            result.setAddressSuffix(this.addrSuffix);
            result.setAddressLabel(this.addrPrefix);
            result.setReverse(this.reverse);
            result.setSplitDigits(this.splitDigits);
            result.setZoneSeparator(this.zoneSeparator);
            result.setUppercase(this.uppercase);
            result.setRadix(this.base);
            result.setSegmentStrPrefix(this.segmentStrPrefix);
            return result;
        }

        public static IPv6StringOptions from(IPAddressSection.StringOptions opts) {
            if (opts instanceof IPv6StringOptions) {
                return (IPv6StringOptions)opts;
            }
            return new IPv6StringOptions(opts.base, opts.expandSegments, opts.wildcardOptions, opts.segmentStrPrefix, false, null, null, opts.separator, '%', opts.addrPrefix, opts.addrSuffix, opts.reverse, opts.splitDigits, opts.uppercase);
        }

        public static class Builder
        extends IPAddressSection.StringOptions.Builder {
            private boolean makeMixed;
            private IPAddressSection.StringOptions ipv4Options;
            private CompressOptions compressOptions;
            private char zoneSeparator = (char)37;

            public Builder() {
                super(16, ':');
            }

            public Builder setCompressOptions(CompressOptions compressOptions) {
                this.compressOptions = compressOptions;
                return this;
            }

            public Builder setMakeMixed(boolean makeMixed) {
                this.makeMixed = makeMixed;
                return this;
            }

            public Builder setMakeMixed(IPAddressSection.StringOptions ipv4Options) {
                this.makeMixed = true;
                this.ipv4Options = ipv4Options;
                return this;
            }

            @Override
            public Builder setWildcardOptions(IPAddressSection.WildcardOptions wildcardOptions) {
                return (Builder)super.setWildcardOptions(wildcardOptions);
            }

            @Override
            public Builder setExpandedSegments(boolean expandSegments) {
                return (Builder)super.setExpandedSegments(expandSegments);
            }

            @Override
            public Builder setRadix(int base) {
                return (Builder)super.setRadix(base);
            }

            @Override
            public Builder setSeparator(Character separator) {
                return (Builder)super.setSeparator(separator);
            }

            public Builder setZoneSeparator(char separator) {
                this.zoneSeparator = separator;
                return this;
            }

            @Override
            public Builder setAddressSuffix(String suffix) {
                return (Builder)super.setAddressSuffix(suffix);
            }

            @Override
            public Builder setSegmentStrPrefix(String prefix) {
                return (Builder)super.setSegmentStrPrefix(prefix);
            }

            @Override
            public Builder setReverse(boolean reverse) {
                return (Builder)super.setReverse(reverse);
            }

            @Override
            public Builder setUppercase(boolean upper) {
                return (Builder)super.setUppercase(upper);
            }

            @Override
            public Builder setSplitDigits(boolean splitDigits) {
                return (Builder)super.setSplitDigits(splitDigits);
            }

            @Override
            public IPv6StringOptions toParams() {
                return new IPv6StringOptions(this.base, this.expandSegments, this.wildcardOptions, this.segmentStrPrefix, this.makeMixed, this.ipv4Options, this.compressOptions, this.separator, this.zoneSeparator, this.addrPrefix, this.addrSuffix, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }

    public static class IPv6v4MixedAddressSection
    extends IPAddressSegmentGrouping {
        private static final long serialVersionUID = 1L;
        private final IPv6AddressSection ipv6Section;
        private final IPv4AddressSection ipv4Section;

        private IPv6v4MixedAddressSection(IPv6AddressSection ipv6Section, IPv4AddressSection ipv4Section) {
            super(IPv6v4MixedAddressSection.createSegments(ipv6Section, ipv4Section));
            this.ipv4Section = ipv4Section;
            this.ipv6Section = ipv6Section;
        }

        private static IPAddressDivision[] createSegments(IPv6AddressSection ipv6Section, IPv4AddressSection ipv4Section) {
            int ipv6Len = ipv6Section.getSegmentCount();
            int ipv4Len = ipv4Section.getSegmentCount();
            IPAddressDivision[] allSegs = new IPAddressSegment[ipv6Len + ipv4Len];
            ipv6Section.copySegments(0, ipv6Len, (IPAddressSegment[])allSegs, 0);
            ipv4Section.copySegments(0, ipv4Len, (IPAddressSegment[])allSegs, ipv6Len);
            return allSegs;
        }

        @Override
        public int getByteCount() {
            return this.ipv6Section.getByteCount() + this.ipv4Section.getByteCount();
        }

        @Override
        public int getBitCount() {
            return this.ipv6Section.getBitCount() + this.ipv4Section.getBitCount();
        }

        @Override
        public String toString() {
            if (this.string == null) {
                IPv6StringOptions mixedParams = IPv6StringCache.mixedParams;
                IPv6StringCollection.IPv6StringParams ipv6Params = mixedParams.from(this.ipv6Section);
                IPAddressSection.StringOptions ipv4Opts = mixedParams.ipv4Opts;
                IPv6StringCollection.IPv6v4MixedParams parms = new IPv6StringCollection.IPv6v4MixedParams(ipv6Params, ipv4Opts);
                this.string = parms.toString(this);
            }
            return this.string;
        }

        @Override
        protected boolean isSameGrouping(IPAddressSegmentGrouping o) {
            if (o instanceof IPv6v4MixedAddressSection) {
                IPv6v4MixedAddressSection other = (IPv6v4MixedAddressSection)o;
                return this.ipv6Section.equals(other.ipv6Section) && this.ipv4Section.equals(other.ipv4Section);
            }
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof IPv6v4MixedAddressSection) {
                IPv6v4MixedAddressSection other = (IPv6v4MixedAddressSection)o;
                return this.ipv6Section.equals(other.ipv6Section) && this.ipv4Section.equals(other.ipv4Section);
            }
            return false;
        }
    }

    static class IPv6v4MixedStringCollection
    extends IPAddressPartStringSubCollection<IPv6v4MixedAddressSection, IPv6StringCollection.IPv6v4MixedParams, IPAddressPartConfiguredString<IPv6v4MixedAddressSection, IPv6StringCollection.IPv6v4MixedParams>> {
        public IPv6v4MixedStringCollection(IPv6v4MixedAddressSection part) {
            super(part);
        }

        @Override
        public Iterator<IPAddressPartConfiguredString<IPv6v4MixedAddressSection, IPv6StringCollection.IPv6v4MixedParams>> iterator() {
            return new IPAddressPartStringSubCollection.IPAddressConfigurableStringIterator(this){

                @Override
                public IPAddressPartConfiguredString<IPv6v4MixedAddressSection, IPv6StringCollection.IPv6v4MixedParams> next() {
                    return new IPAddressPartConfiguredString<IPv6v4MixedAddressSection, IPv6StringCollection.IPv6v4MixedParams>((IPv6v4MixedAddressSection)part, (IPv6StringCollection.IPv6v4MixedParams)this.iterator.next());
                }
            };
        }
    }
}

