/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.format.IPAddressJoinedSegments;
import inet.ipaddr.ipv4.IPv4Address;

public class IPv4JoinedSegments
extends IPAddressJoinedSegments {
    private static final long serialVersionUID = 1L;
    private static int[] MAX_CHARS = new int[3];

    public IPv4JoinedSegments(int joinedCount, int value) {
        super(joinedCount, value);
        if (joinedCount >= 4) {
            throw new IllegalArgumentException();
        }
    }

    public IPv4JoinedSegments(int joinedCount, long value, Integer segmentPrefix) {
        super(joinedCount, value, segmentPrefix == null ? null : Integer.valueOf(Math.min((joinedCount + 1) * 8, segmentPrefix)));
        if (joinedCount >= 4) {
            throw new IllegalArgumentException();
        }
    }

    public IPv4JoinedSegments(int joinedCount, long lower, long upper, Integer segmentPrefix) {
        super(joinedCount, lower, upper, segmentPrefix == null ? null : Integer.valueOf(Math.min((joinedCount + 1) * 8, segmentPrefix)));
        if (joinedCount >= 4) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int getDefaultMaxChars() {
        int result = MAX_CHARS[this.joinedCount - 1];
        if (result == 0) {
            int n = super.getDefaultMaxChars();
            IPv4JoinedSegments.MAX_CHARS[this.joinedCount - 1] = n;
            result = n;
        }
        return result;
    }

    @Override
    protected long getDivisionNetworkMask(int bits) {
        return IPv4Address.network().getSegmentNetworkMask(bits, this.joinedCount);
    }

    @Override
    protected long getDivisionHostMask(int bits) {
        return IPv4Address.network().getSegmentHostMask(bits, this.joinedCount);
    }

    @Override
    protected int getBitsPerSegment() {
        return 8;
    }

    @Override
    protected int getBytesPerSegment() {
        return 1;
    }

    @Override
    public int getDefaultTextualRadix() {
        return 10;
    }
}

