/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.HostName;
import inet.ipaddr.HostNameException;
import inet.ipaddr.HostNameParameters;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.format.validate.AddressProvider;
import inet.ipaddr.format.validate.ParsedAddressCreator;
import inet.ipaddr.format.validate.ParsedAddressQualifier;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ParsedHost
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final AddressProvider addressProvider;
    private String[] normalizedLabels;
    private int[] separatorIndices;
    private boolean[] normalizedFlags;
    public final ParsedAddressQualifier labelsQualifier;
    String host;
    private final String originalStr;

    public ParsedHost(String originalStr, AddressProvider valueProvider) {
        this.addressProvider = valueProvider;
        this.labelsQualifier = null;
        this.originalStr = originalStr;
    }

    ParsedHost(String originalStr, int[] separatorIndices, boolean[] normalizedFlags, ParsedAddressQualifier labelsQualifier) {
        this.addressProvider = null;
        this.labelsQualifier = labelsQualifier;
        this.normalizedFlags = normalizedFlags;
        this.separatorIndices = separatorIndices;
        this.originalStr = originalStr;
    }

    public IPAddressString asGenericAddressString() {
        if (this.addressProvider != null) {
            if (this.addressProvider.isAllAddresses()) {
                return IPAddressString.ALL_ADDRESSES;
            }
            if (this.addressProvider.isPrefixOnly()) {
                return IPAddressNetwork.getPrefix(this.addressProvider.getNetworkPrefixLength());
            }
            if (this.addressProvider.isEmpty()) {
                return IPAddressString.EMPTY_ADDRESS;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNormalizedLabels() {
        String[] labels = this.normalizedLabels;
        if (labels == null) {
            ParsedHost parsedHost = this;
            synchronized (parsedHost) {
                labels = this.normalizedLabels;
                if (labels == null) {
                    if (this.addressProvider != null) {
                        IPAddress addr = this.addressProvider.getAddress();
                        if (addr == null) {
                            if (this.addressProvider.isEmpty()) {
                                return new String[0];
                            }
                            return new String[]{this.asGenericAddressString().toString()};
                        }
                        return addr.getSegmentStrings();
                    }
                    labels = new String[this.separatorIndices.length];
                    int i = 0;
                    int lastSep = -1;
                    while (i < labels.length) {
                        int index = this.separatorIndices[i];
                        if (this.normalizedFlags != null && !this.normalizedFlags[i]) {
                            StringBuilder second = new StringBuilder(index - lastSep - 1);
                            int j = lastSep + 1;
                            while (j < index) {
                                char c = this.originalStr.charAt(j);
                                second.append(c >= 'A' && c <= 'Z' ? (char)(c + 32) : c);
                                ++j;
                            }
                            labels[i] = second.toString();
                        } else {
                            labels[i] = this.originalStr.substring(lastSep + 1, index);
                        }
                        lastSep = index;
                        ++i;
                    }
                    this.separatorIndices = null;
                    this.normalizedFlags = null;
                    this.normalizedLabels = labels;
                }
            }
        }
        return labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHost() {
        String str = this.host;
        if (str == null) {
            if (this.originalStr.length() > 0) {
                ParsedHost parsedHost = this;
                synchronized (parsedHost) {
                    str = this.host;
                    if (str == null) {
                        StringBuilder builder = new StringBuilder(this.originalStr.length());
                        String[] labels = this.normalizedLabels;
                        if (labels == null) {
                            int labelIndex = 0;
                            boolean isNormalized = this.normalizedFlags[0];
                            int j = 0;
                            while (j < this.originalStr.length()) {
                                char c = this.originalStr.charAt(j);
                                if (c == '.') {
                                    isNormalized = this.normalizedFlags[++labelIndex];
                                    builder.append(c);
                                } else {
                                    if (c == '/') break;
                                    if (isNormalized || c < 'A' || c > 'Z') {
                                        builder.append(c);
                                    } else {
                                        builder.append((char)(c + 32));
                                    }
                                }
                                ++j;
                            }
                        } else {
                            builder.append(this.normalizedLabels[0]);
                            int i = 1;
                            while (i < this.normalizedLabels.length) {
                                builder.append('.').append(this.normalizedLabels[i]);
                                ++i;
                            }
                        }
                        str = builder.toString();
                    }
                }
            }
            str = this.originalStr;
            this.host = str;
        }
        return str;
    }

    public boolean isIPv6Address() {
        return this.addressProvider != null && this.addressProvider.isIPv6();
    }

    public IPAddress resolveAddress(HostName originatingHost, HostNameParameters options) throws HostNameException, UnknownHostException {
        IPAddress result;
        if (this.addressProvider != null) {
            result = this.addressProvider.getAddress();
        } else {
            String strHost = this.getHost();
            if (strHost.length() == 0 && !options.emptyIsLoopback) {
                result = null;
            } else {
                InetAddress inetAddress = InetAddress.getByName(strHost);
                byte[] bytes = inetAddress.getAddress();
                if (bytes.length == 16) {
                    String zone = this.labelsQualifier.getZone();
                    IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.network().getAddressCreator();
                    result = this.createAddress(originatingHost, bytes, zone, creator);
                } else {
                    IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
                    result = this.createAddress(originatingHost, bytes, null, creator);
                }
            }
        }
        return result;
    }

    private <T extends IPAddress> T createAddress(HostName originatingHost, byte[] bytes, String zone, ParsedAddressCreator<T, ?, ?> creator) throws HostNameException {
        IPAddress mask;
        Integer networkPrefixLength = this.labelsQualifier.getNetworkPrefixLength();
        if (networkPrefixLength == null && (mask = this.labelsQualifier.getMask()) != null) {
            byte[] maskBytes = mask.getBytes();
            if (maskBytes.length != bytes.length) {
                throw new HostNameException(this.originalStr, "ipaddress.error.ipMismatch");
            }
            int i = 0;
            while (i < bytes.length) {
                int n = i;
                bytes[n] = (byte)(bytes[n] & maskBytes[i]);
                ++i;
            }
            networkPrefixLength = mask.getMaskPrefixLength(true);
        }
        return creator.createAddressInternal(bytes, networkPrefixLength, zone, originatingHost);
    }
}

