/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.HostName;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.validate.ParsedAddressCreator;
import inet.ipaddr.format.validate.ParsedAddressQualifier;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.io.Serializable;

class ParsedAddress
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IPAddress.IPVersion ipVersion;
    private final ParsedAddressQualifier qualifier;
    private final String addressString;
    private final IPAddressString fromString;
    private HostName fromHost;
    private final ParseData parseData;

    ParsedAddress(HostName fromHost, IPAddressString fromString, String addressString, ParseData parseData, IPAddress.IPVersion ipVersion, ParsedAddressQualifier qualifier) {
        this.ipVersion = ipVersion;
        this.parseData = parseData;
        this.qualifier = qualifier;
        this.addressString = addressString;
        this.fromString = fromString;
        this.fromHost = fromHost;
    }

    IPAddress.IPVersion getIPVersion() {
        return this.ipVersion;
    }

    boolean isMixedIPv6() {
        return this.parseData.mixedParsedAddress != null;
    }

    boolean isIPv6() {
        return this.parseData.ipVersion.isIPv6();
    }

    boolean isIPv4() {
        return this.parseData.ipVersion.isIPv4();
    }

    Integer getNetworkPrefixLength() {
        return this.qualifier.getNetworkPrefixLength();
    }

    boolean isPrefixed() {
        return this.getNetworkPrefixLength() != null;
    }

    IPAddresses<?, ?> createAddresses() {
        IPAddress.IPVersion version = this.ipVersion;
        if (version == IPAddress.IPVersion.IPV4) {
            return this.createIPv4Addresses();
        }
        if (version == IPAddress.IPVersion.IPV6) {
            return this.createIPv6Addresses();
        }
        return null;
    }

    private static <S extends IPAddressSegment> S[] allocateHostSegments(S[] segments, S[] originalSegments, IPAddressTypeNetwork.IPAddressSegmentCreator<S> creator, int segmentCount, int originalCount) {
        if (segments == null) {
            segments = creator.createSegmentArray(segmentCount);
            System.arraycopy(originalSegments, 0, segments, 0, originalCount);
        }
        return segments;
    }

    private IPAddresses<IPv4Address, IPv4AddressSection> createIPv4Addresses() {
        IPAddress mask = this.qualifier.getMask();
        int segmentCount = this.parseData.segmentCount;
        IPv4AddressNetwork.IPv4AddressCreator creator = ParsedAddress.getIPv4AddressCreator();
        int ipv4SegmentCount = 4;
        int missingCount = ipv4SegmentCount - segmentCount;
        IPAddressSegment[] hostSegments = null;
        IPAddressSegment[] segments = creator.createSegmentArray(ipv4SegmentCount);
        boolean expandedSegments = missingCount <= 0;
        int i = 0;
        int normalizedSegmentIndex = 0;
        while (i < segmentCount) {
            Integer segmentMask;
            long[] vals = this.parseData.values[i];
            boolean[] flags = this.parseData.flags[i];
            int[] indices = this.parseData.indices[i];
            long lower = vals[0];
            long upper = vals[1];
            if (!expandedSegments && i == segmentCount - 1 && !this.parseData.isWildcard(i)) {
                int count = missingCount;
                boolean previousAdjustedWasRange = false;
                while (count >= 0) {
                    Integer segmentMask2;
                    int newUpper;
                    int newLower;
                    Integer currentPrefix = ParsedAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, this.qualifier);
                    boolean[] segFlags = flags;
                    if (lower != upper) {
                        boolean isStillRange;
                        int shift = 8 * count;
                        int segmentMask3 = 255;
                        newLower = (int)(lower >> shift) & segmentMask3;
                        newUpper = (int)(upper >> shift) & segmentMask3;
                        boolean bl = isStillRange = newLower != newUpper;
                        if (currentPrefix != null) {
                            IPv4AddressNetwork network = IPv4Address.network();
                            int segMask = network.getSegmentNetworkMask(currentPrefix);
                            newLower &= segMask;
                            int upperMask = network.getSegmentHostMask(currentPrefix);
                            newUpper |= upperMask;
                        }
                        if (previousAdjustedWasRange && newUpper - newLower != 255) {
                            throw new IPAddressTypeException(this.addressString, "ipaddress.error.invalid.joined.ranges");
                        }
                        if (isStillRange) {
                            previousAdjustedWasRange = true;
                            if (count == 0 && (long)newLower == lower) {
                                if ((long)newUpper != upper) {
                                    segFlags[3] = false;
                                }
                            } else {
                                segFlags = null;
                            }
                        } else if (count == 0 && (long)newLower == lower) {
                            segFlags[3] = false;
                        } else {
                            segFlags = null;
                        }
                    } else {
                        newLower = newUpper = (int)(lower >> 8 * count) & 0xFF;
                        if (count != 0 || (long)newLower != lower) {
                            segFlags = null;
                        }
                    }
                    Integer n = segmentMask2 = mask == null ? null : Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue());
                    if (segmentMask2 != null || currentPrefix != null) {
                        hostSegments = (IPv4AddressSegment[])ParsedAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (IPAddressTypeNetwork.IPAddressSegmentCreator)creator, (int)ipv4SegmentCount, (int)normalizedSegmentIndex);
                        hostSegments[normalizedSegmentIndex] = ParsedAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, newLower, newUpper, flags, indices, null, null, creator);
                    }
                    segments[normalizedSegmentIndex] = ParsedAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, newLower, newUpper, segFlags, indices, currentPrefix, segmentMask2, creator);
                    ++normalizedSegmentIndex;
                    --count;
                }
                break;
            }
            Integer segmentPrefixLength = ParsedAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, this.qualifier);
            Integer n = segmentMask = mask == null ? null : Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue());
            if (segmentMask != null || segmentPrefixLength != null) {
                hostSegments = (IPv4AddressSegment[])ParsedAddress.allocateHostSegments(hostSegments, (IPAddressSegment[])segments, (IPAddressTypeNetwork.IPAddressSegmentCreator)creator, (int)ipv4SegmentCount, (int)normalizedSegmentIndex);
                hostSegments[normalizedSegmentIndex] = ParsedAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)upper, flags, indices, null, null, creator);
            }
            segments[normalizedSegmentIndex] = ParsedAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)upper, flags, indices, segmentPrefixLength, segmentMask, creator);
            if (!expandedSegments && this.parseData.isWildcard(i)) {
                boolean expandSegments = true;
                int j = i + 1;
                while (j < segmentCount) {
                    if (this.parseData.isWildcard(j)) {
                        expandSegments = false;
                        break;
                    }
                    ++j;
                }
                if (expandSegments) {
                    expandedSegments = true;
                    int count = missingCount;
                    while (count-- > 0) {
                        segmentMask = mask == null ? null : Integer.valueOf(mask.getSegment(++normalizedSegmentIndex).getLowerSegmentValue());
                        segmentPrefixLength = ParsedAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, this.qualifier);
                        if (segmentMask != null || segmentPrefixLength != null) {
                            hostSegments = (IPv4AddressSegment[])ParsedAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (IPAddressTypeNetwork.IPAddressSegmentCreator)creator, (int)ipv4SegmentCount, (int)normalizedSegmentIndex);
                            hostSegments[normalizedSegmentIndex] = ParsedAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)upper, flags, indices, null, null, creator);
                        }
                        segments[normalizedSegmentIndex] = ParsedAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, 0, 255, null, null, segmentPrefixLength, segmentMask, creator);
                    }
                }
            }
            ++i;
            ++normalizedSegmentIndex;
        }
        IPv4AddressNetwork.IPv4AddressCreator addressCreator = creator;
        IPv4AddressSection result = (IPv4AddressSection)addressCreator.createSectionInternal(segments);
        IPv4AddressSection hostResult = hostSegments != null ? (IPv4AddressSection)addressCreator.createSectionInternal(hostSegments) : null;
        return new IPAddresses<IPv4Address, IPv4AddressSection>(this, result, hostResult){

            @Override
            ParsedAddressCreator<IPv4Address, IPv4AddressSection, ?> getCreator() {
                return ParsedAddress.getIPv4AddressCreator();
            }
        };
    }

    IPAddresses<IPv6Address, IPv6AddressSection> createIPv6Addresses() {
        IPv6AddressSection result;
        IPAddress mask = this.qualifier.getMask();
        int segmentCount = this.parseData.segmentCount;
        IPv6AddressNetwork.IPv6AddressCreator creator = ParsedAddress.getIPv6AddressCreator();
        int ipv6SegmentCount = 8;
        IPAddressSegment[] hostSegments = null;
        IPAddressSegment[] segments = creator.createSegmentArray(ipv6SegmentCount);
        boolean mixed = this.isMixedIPv6();
        int normalizedSegmentIndex = 0;
        int missingSegmentCount = (mixed ? 6 : 8) - segmentCount;
        boolean expandedSegments = missingSegmentCount <= 0;
        int i = 0;
        while (i < segmentCount) {
            long[] vals = this.parseData.values[i];
            boolean[] flags = this.parseData.flags[i];
            int[] indices = this.parseData.indices[i];
            long lower = vals[0];
            long upper = vals[1];
            Integer segmentMask = mask == null ? null : Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue());
            Integer segmentPrefixLength = ParsedAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, this.qualifier);
            if (segmentMask != null || segmentPrefixLength != null) {
                hostSegments = (IPv6AddressSegment[])ParsedAddress.allocateHostSegments(hostSegments, (IPAddressSegment[])segments, (IPAddressTypeNetwork.IPAddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                hostSegments[normalizedSegmentIndex] = ParsedAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV6, (int)lower, (int)upper, flags, indices, null, null, creator);
            }
            segments[normalizedSegmentIndex] = ParsedAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV6, (int)lower, (int)upper, flags, indices, segmentPrefixLength, segmentMask, creator);
            ++normalizedSegmentIndex;
            int expandValueLower = 0;
            int expandValueUpper = 0;
            if (!expandedSegments) {
                boolean expandSegments = false;
                if (this.parseData.isWildcard(i)) {
                    expandValueLower = 0;
                    expandValueUpper = 65535;
                    expandSegments = true;
                    int j = i + 1;
                    while (j < segmentCount) {
                        if (this.parseData.isWildcard(j) || this.parseData.isCompressed(j)) {
                            expandSegments = false;
                            break;
                        }
                        ++j;
                    }
                } else if (this.parseData.isCompressed(i)) {
                    expandSegments = true;
                    expandValueUpper = 0;
                    expandValueLower = 0;
                }
                if (expandSegments) {
                    expandedSegments = true;
                    int count = missingSegmentCount;
                    while (count-- > 0) {
                        segmentMask = mask == null ? null : Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue());
                        segmentPrefixLength = ParsedAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, this.qualifier);
                        if (segmentMask != null || segmentPrefixLength != null) {
                            hostSegments = (IPv6AddressSegment[])ParsedAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (IPAddressTypeNetwork.IPAddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                            hostSegments[normalizedSegmentIndex] = ParsedAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV6, expandValueLower, expandValueUpper, null, null, null, null, creator);
                        }
                        segments[normalizedSegmentIndex] = ParsedAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV6, expandValueLower, expandValueUpper, null, null, segmentPrefixLength, segmentMask, creator);
                        ++normalizedSegmentIndex;
                    }
                }
            }
            ++i;
        }
        IPv6AddressSection hostResult = null;
        IPv6AddressNetwork.IPv6AddressCreator addressCreator = creator;
        if (mixed) {
            IPv4AddressSection ipv4AddressSection = (IPv4AddressSection)((IPAddresses)this.parseData.mixedParsedAddress.createIPv4Addresses()).getSection();
            boolean embeddedSectionIsChanged = false;
            int n = 0;
            while (n < 2) {
                IPv6AddressSegment newSegment;
                boolean doHostSegment;
                int m = n << 1;
                IPv4AddressSegment one = ipv4AddressSection.getSegment(m);
                IPv4AddressSegment two = ipv4AddressSection.getSegment(m + 1);
                Integer segmentMask = mask == null ? null : Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue());
                Integer segmentPrefixLength = ParsedAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, this.qualifier);
                boolean bl = doHostSegment = segmentMask != null || segmentPrefixLength != null;
                if (doHostSegment) {
                    hostSegments = (IPv6AddressSegment[])ParsedAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (IPAddressTypeNetwork.IPAddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                }
                int oneLower = one.getLowerSegmentValue();
                int twoLower = two.getLowerSegmentValue();
                if (!one.isMultiple() && !two.isMultiple()) {
                    if (doHostSegment) {
                        hostSegments[normalizedSegmentIndex] = ParsedAddress.createSegment(oneLower, twoLower, null, null);
                    }
                    newSegment = ParsedAddress.createSegment(oneLower, twoLower, segmentPrefixLength, segmentMask);
                    segments[normalizedSegmentIndex] = newSegment;
                } else {
                    int oneUpper = one.getUpperSegmentValue();
                    int twoUpper = two.getUpperSegmentValue();
                    if (doHostSegment) {
                        hostSegments[normalizedSegmentIndex] = ParsedAddress.createSegment(one, two, oneLower, oneUpper, twoLower, twoUpper, null, null);
                    }
                    newSegment = ParsedAddress.createSegment(one, two, oneLower, oneUpper, twoLower, twoUpper, segmentPrefixLength, segmentMask);
                    segments[normalizedSegmentIndex] = newSegment;
                }
                embeddedSectionIsChanged |= newSegment.isPrefixed() || newSegment.getLowerSegmentValue() != (one.getLowerSegmentValue() << 8 | two.getLowerSegmentValue()) || newSegment.getUpperSegmentValue() != (one.getUpperSegmentValue() << 8 | two.getUpperSegmentValue());
                ++normalizedSegmentIndex;
                ++n;
            }
            if (embeddedSectionIsChanged) {
                if (hostSegments != null) {
                    hostResult = (IPv6AddressSection)addressCreator.createSectionInternal(hostSegments);
                }
                result = (IPv6AddressSection)addressCreator.createSectionInternal(segments);
            } else {
                if (hostSegments != null) {
                    hostResult = (IPv6AddressSection)addressCreator.createSectionInternal(hostSegments, ipv4AddressSection);
                }
                result = (IPv6AddressSection)addressCreator.createSectionInternal(segments, ipv4AddressSection);
            }
        } else {
            if (hostSegments != null) {
                hostResult = (IPv6AddressSection)addressCreator.createSectionInternal(hostSegments);
            }
            result = (IPv6AddressSection)addressCreator.createSectionInternal(segments);
        }
        return new IPAddresses<IPv6Address, IPv6AddressSection>(this, result, hostResult){

            @Override
            ParsedAddressCreator<IPv6Address, IPv6AddressSection, ?> getCreator() {
                return ParsedAddress.getIPv6AddressCreator();
            }
        };
    }

    private static <S extends IPAddressSegment> S createSegment(String addressString, IPAddress.IPVersion version, int val, int upperVal, boolean[] flags, int[] indices, Integer segmentPrefixLength, Integer mask, ParsedAddressCreator<?, ?, S> creator) {
        if (val != upperVal) {
            return ParsedAddress.createRangeSegment(addressString, version, val, upperVal, flags, indices, segmentPrefixLength, mask, creator);
        }
        int stringVal = val;
        if (mask != null) {
            val &= mask.intValue();
        }
        S result = flags == null ? creator.createSegment(val, val, segmentPrefixLength) : creator.createSegmentInternal(val, segmentPrefixLength, addressString, stringVal, flags[2], indices[3], indices[4]);
        return result;
    }

    private static IPv6AddressSegment createSegment(int value1, int value2, Integer segmentPrefixLength, Integer mask) {
        int value = value1 << 8 | value2;
        if (mask != null) {
            value &= mask.intValue();
        }
        IPv6AddressSegment result = ParsedAddress.getIPv6AddressCreator().createSegment(value, segmentPrefixLength);
        return result;
    }

    private static IPv6AddressSegment createSegment(IPv4AddressSegment one, IPv4AddressSegment two, int upperRangeLower, int upperRangeUpper, int lowerRangeLower, int lowerRangeUpper, Integer segmentPrefixLength, Integer mask) throws IPAddressTypeException {
        boolean hasMask;
        boolean bl = hasMask = mask != null;
        if (hasMask) {
            int maskInt = mask;
            int shift = 8;
            int shiftedMask = maskInt >> shift;
            upperRangeLower &= shiftedMask;
            upperRangeUpper &= shiftedMask;
            lowerRangeLower &= maskInt;
            lowerRangeUpper &= maskInt;
        }
        IPv6AddressSegment result = IPv6AddressSegment.join(one, two, upperRangeLower, upperRangeUpper, lowerRangeLower, lowerRangeUpper, segmentPrefixLength);
        if (hasMask && !result.isMaskCompatibleWithRange(mask, segmentPrefixLength)) {
            throw new IPAddressTypeException((IPAddressDivision)result, (int)mask, "ipaddress.error.maskMismatch");
        }
        return result;
    }

    private static <S extends IPAddressSegment> S createRangeSegment(String addressString, IPAddress.IPVersion version, int stringLower, int stringUpper, boolean[] flags, int[] indices, Integer segmentPrefixLength, Integer mask, ParsedAddressCreator<?, ?, S> creator) {
        boolean hasMask;
        int lower = stringLower;
        int upper = stringUpper;
        boolean bl = hasMask = mask != null;
        if (hasMask) {
            int maskInt = mask;
            lower &= maskInt;
            upper &= maskInt;
        }
        S result = flags == null ? creator.createSegment(lower, upper, segmentPrefixLength) : creator.createSegmentInternal(lower, upper, segmentPrefixLength, addressString, stringLower, stringUpper, flags[2], flags[3], indices[3], indices[4], indices[7]);
        if (hasMask && !((IPAddressSegment)result).isMaskCompatibleWithRange(mask, segmentPrefixLength)) {
            throw new IPAddressTypeException((IPAddressDivision)result, (int)mask, "ipaddress.error.maskMismatch");
        }
        return result;
    }

    static IPAddress createAllAddress(IPAddress.IPVersion version, ParsedAddressQualifier qualifier, HostName fromHost, IPAddressString fromString) {
        boolean hasMask;
        int segmentCount = IPAddress.segmentCount(version);
        IPAddress mask = qualifier.getMask();
        boolean bl = hasMask = mask != null;
        if (version.isIPv4()) {
            IPv4AddressNetwork.IPv4AddressCreator creator = ParsedAddress.getIPv4AddressCreator();
            IPv4AddressSegment[] segments = (IPv4AddressSegment[])creator.createSegmentArray(segmentCount);
            int i = 0;
            while (i < segmentCount) {
                Integer segmentMask = hasMask ? Integer.valueOf(mask.getSegment(i).getLowerSegmentValue()) : null;
                segments[i] = ParsedAddress.createRangeSegment(null, version, 0, 255, null, null, ParsedAddress.getSegmentPrefixLength(i, version, qualifier), segmentMask, creator);
                ++i;
            }
            return ((ParsedAddressCreator)creator).createAddressInternal(segments, (String)null, fromString, fromHost);
        }
        IPv6AddressNetwork.IPv6AddressCreator creator = ParsedAddress.getIPv6AddressCreator();
        IPv6AddressSegment[] segments = (IPv6AddressSegment[])creator.createSegmentArray(segmentCount);
        int i = 0;
        while (i < segmentCount) {
            Integer segmentMask = hasMask ? Integer.valueOf(mask.getSegment(i).getLowerSegmentValue()) : null;
            segments[i] = ParsedAddress.createRangeSegment(null, version, 0, 65535, null, null, ParsedAddress.getSegmentPrefixLength(i, version, qualifier), segmentMask, creator);
            ++i;
        }
        return ((ParsedAddressCreator)creator).createAddressInternal(segments, qualifier.getZone(), fromString, fromHost);
    }

    private static IPv6AddressNetwork.IPv6AddressCreator getIPv6AddressCreator() {
        IPv6AddressNetwork network = IPv6Address.network();
        return network.getAddressCreator();
    }

    private static IPv4AddressNetwork.IPv4AddressCreator getIPv4AddressCreator() {
        IPv4AddressNetwork network = IPv4Address.network();
        return network.getAddressCreator();
    }

    private static Integer getSegmentPrefixLength(int segmentIndex, int bitsPerSegment, ParsedAddressQualifier qualifier) {
        IPAddress mask = qualifier.getMask();
        Integer networkPrefixLength = qualifier.getNetworkPrefixLength();
        Integer bits = mask != null ? mask.getMaskPrefixLength(true) : networkPrefixLength;
        return IPAddressSection.getSegmentPrefixLength(bitsPerSegment, bits, segmentIndex);
    }

    private static Integer getSegmentPrefixLength(int segmentIndex, IPAddress.IPVersion version, ParsedAddressQualifier qualifier) {
        return ParsedAddress.getSegmentPrefixLength(segmentIndex, IPAddressSection.bitsPerSegment(version), qualifier);
    }

    public String toString() {
        return this.addressString;
    }

    static class CachedIPAddresses<T extends IPAddress>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected T address;
        protected T hostAddress;

        CachedIPAddresses() {
        }

        public CachedIPAddresses(T address) {
            this(address, address);
        }

        public CachedIPAddresses(T address, T hostAddress) {
            this.address = address;
            this.hostAddress = hostAddress;
        }

        public T getAddress() {
            return this.address;
        }

        public T getHostAddress() {
            return this.hostAddress;
        }
    }

    static abstract class IPAddresses<T extends IPAddress, R extends IPAddressSection>
    extends CachedIPAddresses<T> {
        private static final long serialVersionUID = 1L;
        private final R section;
        private final R hostSection;
        final /* synthetic */ ParsedAddress this$0;

        IPAddresses(R section, R hostSection) {
            this.this$0 = var1_1;
            this.section = section;
            this.hostSection = hostSection;
        }

        abstract ParsedAddressCreator<T, R, ?> getCreator();

        @Override
        public T getAddress() {
            if (this.address == null) {
                this.address = this.getCreator().createAddressInternal(this.getSection(), this.this$0.qualifier.getZone(), this.this$0.fromString, this.this$0.fromHost);
            }
            return (T)this.address;
        }

        @Override
        public T getHostAddress() {
            if (this.hostSection == null) {
                return this.getAddress();
            }
            if (this.hostAddress == null) {
                this.hostAddress = this.getCreator().createAddressInternal(this.getHostSection(), this.this$0.qualifier.getZone(), null, null);
            }
            return (T)this.hostAddress;
        }

        private R getSection() {
            return this.section;
        }

        private R getHostSection() {
            if (this.hostSection == null) {
                return this.getSection();
            }
            return this.hostSection;
        }
    }

    static class ParseData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int LOWER_INDEX = 0;
        public static final int UPPER_INDEX = 1;
        public static final int LOWER_RADIX_INDEX = 0;
        public static final int UPPER_RADIX_INDEX = 1;
        public static final int LOWER_STR_DIGITS_INDEX = 2;
        public static final int LOWER_STR_START_INDEX = 3;
        public static final int LOWER_STR_END_INDEX = 4;
        public static final int UPPER_STR_DIGITS_INDEX = 5;
        public static final int UPPER_STR_START_INDEX = 6;
        public static final int UPPER_STR_END_INDEX = 7;
        public static final int WILDCARD_INDEX = 0;
        public static final int SINGLE_WILDCARD_INDEX = 1;
        public static final int STANDARD_STR_INDEX = 2;
        public static final int STANDARD_RANGE_STR_INDEX = 3;
        boolean[][] flags;
        int[][] indices;
        long[][] values;
        int segmentCount;
        int addressEndIndex;
        int consecutiveIPv6SepIndex = -1;
        int qualifierIndex = -1;
        boolean anyWildcard;
        boolean isEmpty;
        boolean isAll;
        boolean isPrefixed;
        boolean isZoned;
        IPAddress.IPVersion ipVersion;
        ParsedAddress mixedParsedAddress;

        ParseData() {
        }

        void initSegmentData(int segmentCapacity) {
            this.flags = new boolean[segmentCapacity][4];
            this.indices = new int[segmentCapacity][8];
            this.values = new long[segmentCapacity][2];
        }

        boolean isCompressed() {
            return this.consecutiveIPv6SepIndex >= 0;
        }

        boolean isCompressed(int index) {
            int[] inds = this.indices[index];
            int strLength = inds[4] - inds[3];
            return strLength == 0;
        }

        boolean isWildcard(int index) {
            boolean[] flgs = this.flags[index];
            return flgs[0];
        }
    }
}

