/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.IPAddressDivision;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class IPAddressSegment
extends IPAddressDivision {
    private static final long serialVersionUID = 1L;
    private final int value;
    private final int upperValue;

    protected IPAddressSegment(int value) {
        this.value = this.upperValue = value;
    }

    protected IPAddressSegment(int value, Integer segmentPrefixLength) {
        this(value, value, segmentPrefixLength);
    }

    protected IPAddressSegment(int lower, int upper, Integer segmentPrefixLength) {
        super(segmentPrefixLength);
        segmentPrefixLength = this.getSegmentPrefixLength();
        if (segmentPrefixLength == null) {
            this.value = lower;
            this.upperValue = upper;
        } else {
            int mask = this.getSegmentNetworkMask(segmentPrefixLength);
            this.value = lower & mask;
            this.upperValue = upper | this.getSegmentHostMask(segmentPrefixLength);
        }
    }

    public boolean isIPv4() {
        return false;
    }

    public boolean isIPv6() {
        return false;
    }

    public abstract IPAddress.IPVersion getIPVersion();

    protected static Integer getSplitSegmentPrefix(int bitsPerSegment, Integer networkPrefixLength, int segmentIndex) {
        return IPAddressSection.getSplitSegmentPrefixLength(bitsPerSegment, networkPrefixLength, segmentIndex);
    }

    protected static Integer getJoinedSegmentPrefix(int bitsPerSegment, Integer highBits, Integer lowBits) {
        return IPAddressSection.getJoinedSegmentPrefixLength(bitsPerSegment, highBits, lowBits);
    }

    static int getSegmentNetworkMask(IPAddress.IPVersion version, int bits) {
        return IPAddress.network(version).getSegmentNetworkMask(bits);
    }

    static int getSegmentHostMask(IPAddress.IPVersion version, int bits) {
        return IPAddress.network(version).getSegmentHostMask(bits);
    }

    @Override
    protected long getDivisionNetworkMask(int bits) {
        return this.getSegmentNetworkMask(bits);
    }

    @Override
    protected long getDivisionHostMask(int bits) {
        return this.getSegmentHostMask(bits);
    }

    protected abstract int getSegmentNetworkMask(int var1);

    protected abstract int getSegmentHostMask(int var1);

    public int getMinPrefix() {
        int upperOnes;
        if (this.isPrefixed() && this.getSegmentPrefixLength() == 0) {
            return 0;
        }
        int result = this.getBitCount();
        int lowerZeros = Integer.numberOfTrailingZeros(this.value);
        if (lowerZeros != 0 && (upperOnes = Integer.numberOfTrailingZeros(~this.upperValue)) != 0) {
            int prefixedBitCount = Math.min(lowerZeros, upperOnes);
            result -= prefixedBitCount;
        }
        return result;
    }

    public static int getMaxSegmentValue(IPAddress.IPVersion version) {
        return version.isIPv4() ? 255 : 65535;
    }

    protected boolean isNetworkChangedByPrefix(Integer bits, boolean withPrefixLength) {
        boolean hasBits;
        boolean bl = hasBits = bits != null;
        if (hasBits && (bits < 0 || bits > this.getBitCount())) {
            throw new IPAddressTypeException((IPAddressDivision)this, (int)bits, "ipaddress.error.prefixSize");
        }
        boolean thisHasPrefix = this.isPrefixed();
        if ((withPrefixLength &= hasBits) != thisHasPrefix) {
            return true;
        }
        return thisHasPrefix ? bits < this.getSegmentPrefixLength() : !this.isRangeUnchanged(bits);
    }

    public IPAddressSegment toNetworkSegment(Integer segmentPrefixLength) {
        return this.toNetworkSegment(segmentPrefixLength, true);
    }

    public abstract IPAddressSegment toNetworkSegment(Integer var1, boolean var2);

    protected <T extends IPAddressSegment> T toNetworkSegment(Integer segmentPrefixLength, boolean withPrefixLength, IPAddressTypeNetwork.IPAddressSegmentCreator<T> creator) {
        int newLower = this.value;
        int newUpper = this.upperValue;
        if (segmentPrefixLength != null) {
            int mask = this.getSegmentNetworkMask(segmentPrefixLength);
            newLower &= mask;
            newUpper &= mask;
            newUpper |= this.getSegmentHostMask(segmentPrefixLength);
        }
        if (newLower != newUpper) {
            if (!withPrefixLength) {
                return creator.createSegment(newLower, newUpper, null);
            }
            if (segmentPrefixLength == null || !this.isRangeEquivalent(newLower, newUpper, segmentPrefixLength)) {
                return creator.createSegment(newLower, newUpper, segmentPrefixLength);
            }
            return creator.createSegment(newLower, segmentPrefixLength);
        }
        return withPrefixLength ? creator.createSegment(newLower, segmentPrefixLength) : creator.createSegment(newLower);
    }

    public abstract IPAddressSegment toHostSegment(Integer var1);

    protected <T extends IPAddressSegment> T toHostSegment(Integer segmentPrefixLength, IPAddressTypeNetwork.IPAddressSegmentCreator<T> creator) {
        int newUpper;
        int mask = segmentPrefixLength == null ? 0 : this.getSegmentHostMask(segmentPrefixLength);
        int newLower = this.value & mask;
        if (newLower != (newUpper = this.upperValue & mask)) {
            return creator.createSegment(newLower, newUpper, null);
        }
        return creator.createSegment(newLower);
    }

    protected boolean isHostChangedByPrefix(Integer bits) {
        int mask;
        boolean hasBits;
        boolean bl = hasBits = bits != null;
        if (hasBits && (bits < 0 || bits > this.getBitCount())) {
            throw new IPAddressTypeException((IPAddressDivision)this, (int)bits, "ipaddress.error.prefixSize");
        }
        if (this.isPrefixed()) {
            return true;
        }
        int n = mask = !hasBits ? 0 : this.getSegmentHostMask(bits);
        return this.value != (this.value & mask) || this.upperValue != (this.upperValue & mask);
    }

    public abstract IPAddressSegment toMaskedSegment(IPAddressSegment var1, Integer var2) throws IPAddressTypeException;

    protected boolean isChangedByMask(int maskValue, Integer segmentPrefixLength) throws IPAddressTypeException {
        boolean hasBits;
        boolean bl = hasBits = segmentPrefixLength != null;
        if (hasBits && (segmentPrefixLength < 0 || segmentPrefixLength > this.getBitCount())) {
            throw new IPAddressTypeException((IPAddressDivision)this, (int)segmentPrefixLength, "ipaddress.error.prefixSize");
        }
        return this.value != (this.value & maskValue) || this.upperValue != (this.upperValue & maskValue) || !(this.isPrefixed() ? this.getSegmentPrefixLength().equals(segmentPrefixLength) : !hasBits);
    }

    public boolean isMaskCompatibleWithRange(IPAddressSegment maskSegment, Integer segmentPrefixLength) {
        IPAddress.IPVersion version = this.getIPVersion();
        if (!version.equals((Object)maskSegment.getIPVersion())) {
            throw new IPAddressTypeException(this, maskSegment, "ipaddress.error.typeMismatch");
        }
        int maskValue = maskSegment.value;
        return this.isMaskCompatibleWithRange(maskValue, segmentPrefixLength);
    }

    public boolean isMaskCompatibleWithRange(int maskValue, Integer segmentPrefix) {
        return super.isMaskCompatibleWithRange(maskValue, segmentPrefix);
    }

    public abstract IPAddressSegment getLower();

    public abstract IPAddressSegment getUpper();

    protected static <S extends IPAddressSegment> S getLowestOrHighest(S original, IPAddressTypeNetwork.IPAddressSegmentCreator<S> segmentCreator, boolean lowest) {
        if (!original.isMultiple() && !original.isPrefixed()) {
            return original;
        }
        return segmentCreator.createSegment(lowest ? original.getLowerSegmentValue() : original.getUpperSegmentValue());
    }

    public abstract Iterator<? extends IPAddressSegment> iterator();

    protected static <S extends IPAddressSegment> Iterator<S> iterator(final S original, final IPAddressTypeNetwork.IPAddressSegmentCreator<S> creator) {
        if (!original.isMultiple()) {
            return new Iterator<S>(){
                boolean done;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public S next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    IPAddressSegment thisSegment = original;
                    if (thisSegment.isPrefixed()) {
                        Object result = creator.createSegment(thisSegment.getLowerSegmentValue());
                        return result;
                    }
                    return thisSegment;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<S>(){
            boolean done;
            int current;
            {
                this.current = iPAddressSegment.getLowerSegmentValue();
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public S next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                Object result = creator.createSegment(this.current);
                this.done = ++this.current > original.getUpperSegmentValue();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int getBitCount(IPAddress.IPVersion version) {
        return version.isIPv4() ? 8 : 16;
    }

    public static int getByteCount(IPAddress.IPVersion version) {
        return version.isIPv4() ? 1 : 2;
    }

    public static int getDefaultTextualRadix(IPAddress.IPVersion version) {
        return version.isIPv4() ? 10 : 16;
    }

    public boolean matches(int value) {
        return super.matches(value);
    }

    public boolean matchesWithPrefix(int value, Integer segmentPrefixLength) {
        return super.matchesWithPrefix(value, segmentPrefixLength);
    }

    public boolean matchesWithMask(int value, int mask) {
        return super.matchesWithMask(value, mask);
    }

    @Override
    public long getCount() {
        return this.upperValue - this.value + 1;
    }

    protected int highByte() {
        return IPAddressSegment.highByte(this.value);
    }

    protected int lowByte() {
        return IPAddressSegment.lowByte(this.value);
    }

    protected static int highByte(int value) {
        return value >> 8;
    }

    protected static int lowByte(int value) {
        return value & 0xFF;
    }

    @Override
    public long getMaxValue() {
        return this.getMaxSegmentValue();
    }

    public abstract int getMaxSegmentValue();

    @Override
    public boolean isMultiple() {
        return this.value != this.upperValue;
    }

    public int getLowerSegmentValue() {
        return this.value;
    }

    public int getUpperSegmentValue() {
        return this.upperValue;
    }

    @Override
    public long getLowerValue() {
        return this.value;
    }

    @Override
    public long getUpperValue() {
        return this.upperValue;
    }

    public Integer getSegmentPrefixLength() {
        return this.getDivisionPrefixLength();
    }

    @Override
    protected boolean isSameValues(IPAddressDivision other) {
        if (other instanceof IPAddressSegment) {
            return this.isSameValues((IPAddressSegment)other);
        }
        return false;
    }

    protected boolean isSameValues(IPAddressSegment otherSegment) {
        return this.value == otherSegment.value && this.upperValue == otherSegment.upperValue;
    }

    public int hashCode() {
        return IPAddressSegment.hash(this.value, this.upperValue, this.getBitCount());
    }

    static int hash(int lower, int upper, int bitCount) {
        return lower | upper << bitCount;
    }

    public boolean contains(IPAddressSegment other) {
        return other.value >= this.value && other.upperValue <= this.upperValue;
    }

    public static boolean isFullRange(int lower, int upper, Integer prefix, IPAddress.IPVersion version) {
        if (prefix != null) {
            lower &= IPAddressSegment.getSegmentNetworkMask(version, prefix);
            upper |= IPAddressSegment.getSegmentHostMask(version, prefix);
        }
        return IPAddressSegment.isFullRange(lower, upper, version);
    }

    public static boolean isFullRange(int lower, int upper, IPAddress.IPVersion version) {
        return lower == 0 && upper == IPAddressSegment.getMaxSegmentValue(version);
    }

    protected static boolean toUnsignedStringFast(int value, int radix, StringBuilder appendable) {
        return IPAddressSegment.toUnsignedStringFast(value, radix, false, appendable);
    }

    protected static void getRangeString(int lower, int upper, int radix, StringBuilder appendable) {
        IPAddressSegment.getRangeString(lower, upper, IPAddress.RANGE_SEPARATOR_STR, 0, 0, null, radix, false, appendable);
    }

    void setStandardString(String addressStr, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex, int originalLowerValue) {
        if (this.cachedString == null && isStandardString && (long)originalLowerValue == this.getLowerValue()) {
            this.cachedString = addressStr.substring(lowerStringStartIndex, lowerStringEndIndex);
        }
    }

    void setWildcardString(String addressStr, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex, int lowerValue) {
        if (this.cachedWildcardString == null && isStandardString && (long)lowerValue == this.getLowerValue() && (long)lowerValue == this.getUpperValue()) {
            this.cachedWildcardString = addressStr.substring(lowerStringStartIndex, lowerStringEndIndex);
        }
    }

    void setStandardString(String addressStr, boolean isStandardString, boolean isStandardRangeString, int lowerStringStartIndex, int lowerStringEndIndex, int upperStringEndIndex, int rangeLower, int rangeUpper) {
        if (this.cachedString == null) {
            if (this.isRangeEquivalentToPrefix()) {
                if (isStandardString && (long)rangeLower == this.getLowerValue()) {
                    this.cachedString = addressStr.substring(lowerStringStartIndex, lowerStringEndIndex);
                }
            } else if (this.isFullRange()) {
                this.cachedString = IPAddress.SEGMENT_WILDCARD_STR;
            } else if (isStandardRangeString && (long)rangeLower == this.getLowerValue()) {
                long upper = this.getUpperValue();
                if (this.isPrefixed()) {
                    upper &= this.getDivisionNetworkMask(this.getDivisionPrefixLength());
                }
                if ((long)rangeUpper == upper) {
                    this.cachedString = addressStr.substring(lowerStringStartIndex, upperStringEndIndex);
                }
            }
        }
    }

    void setWildcardString(String addressStr, boolean isStandardRangeString, int lowerStringStartIndex, int upperStringEndIndex, int rangeLower, int rangeUpper) {
        if (this.cachedWildcardString == null) {
            if (this.isFullRange()) {
                this.cachedWildcardString = IPAddress.SEGMENT_WILDCARD_STR;
            } else if (isStandardRangeString && (long)rangeLower == this.getLowerValue() && (long)rangeUpper == this.getUpperValue()) {
                this.cachedWildcardString = addressStr.substring(lowerStringStartIndex, upperStringEndIndex);
            }
        }
    }
}

