/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.BaseComparator;
import inet.ipaddr.IPAddress;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressSegmentGrouping;
import java.math.BigInteger;
import java.util.Comparator;

public interface IPAddressComparator
extends Comparator<IPAddress> {
    @Override
    public int compare(IPAddressSegmentGrouping var1, IPAddressSegmentGrouping var2);

    @Override
    public int compare(IPAddressDivision var1, IPAddressDivision var2);

    public static class CountComparator
    extends BaseComparator {
        @Override
        protected int compareParts(IPAddressSegmentGrouping one, IPAddressSegmentGrouping two) {
            int result = one.getByteCount() - two.getByteCount();
            if (result == 0) {
                if (one.isMultiple()) {
                    if (two.isMultiple()) {
                        if (one.isRangeEquivalentToPrefix() && two.isRangeEquivalentToPrefix()) {
                            result = CountComparator.compareCountByPrefix(one.getNetworkPrefixLength(), two.getNetworkPrefixLength());
                        } else {
                            BigInteger oneCount = one.getCount();
                            BigInteger otherCount = two.getCount();
                            result = oneCount.subtract(otherCount).signum();
                        }
                        if (result == 0) {
                            result = this.compareSegmentGroupings(one, two);
                        }
                    } else {
                        result = 1;
                    }
                } else {
                    result = two.isMultiple() ? -1 : this.compareSegmentGroupings(one, two);
                }
            }
            return result;
        }

        private static int compareCountByPrefix(Integer thisBits, Integer otherBits) {
            if (thisBits == null) {
                thisBits = 128;
            }
            if (otherBits == null) {
                otherBits = 128;
            }
            return otherBits - thisBits;
        }

        private int compareSegmentGroupings(IPAddressSegmentGrouping one, IPAddressSegmentGrouping two) {
            long twoLower;
            int twoIndex = 0;
            int oneIndex = 0;
            int twoByteCount = 0;
            int oneByteCount = 0;
            long twoUpper = twoLower = (long)0;
            long oneLower = twoLower;
            long oneUpper = twoLower;
            while (oneIndex < one.getDivisionCount() || twoIndex < two.getDivisionCount()) {
                if (oneByteCount == 0) {
                    IPAddressDivision oneCombo = one.getDivision(oneIndex++);
                    oneByteCount = oneCombo.getByteCount();
                    oneUpper = oneCombo.getUpperValue();
                    oneLower = oneCombo.getLowerValue();
                }
                if (twoByteCount == 0) {
                    IPAddressDivision twoCombo = two.getDivision(twoIndex++);
                    twoByteCount = twoCombo.getByteCount();
                    twoUpper = twoCombo.getUpperValue();
                    twoLower = twoCombo.getLowerValue();
                }
                long oneResultUpper = oneUpper;
                long oneResultLower = oneLower;
                long twoResultUpper = twoUpper;
                long twoResultLower = twoLower;
                if (twoByteCount == oneByteCount) {
                    twoByteCount = 0;
                    oneByteCount = 0;
                } else {
                    long mask;
                    int diffBits;
                    int diffBytes = twoByteCount - oneByteCount;
                    if (diffBytes > 0) {
                        diffBits = diffBytes << 3;
                        twoResultUpper >>= diffBits;
                        twoResultLower >>= diffBits;
                        mask = -1L << diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                        twoUpper &= mask;
                        twoLower &= mask;
                        twoByteCount = diffBytes;
                        oneByteCount = 0;
                    } else {
                        diffBytes = -diffBytes;
                        diffBits = diffBytes << 3;
                        oneResultUpper >>= diffBits;
                        oneResultLower >>= diffBits;
                        mask = -1L << diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                        oneUpper &= mask;
                        oneLower &= mask;
                        oneByteCount = diffBytes;
                        twoByteCount = 0;
                    }
                }
                long result = this.compareValues(oneResultUpper, oneResultLower, twoResultUpper, twoResultLower);
                if (result == 0L) continue;
                return CountComparator.convertResult(result);
            }
            return 0;
        }

        @Override
        protected long compareValues(long oneUpper, long oneLower, long twoUpper, long twoLower) {
            long result = oneUpper - oneLower - (twoUpper - twoLower);
            if (result == 0L) {
                result = oneLower - twoLower;
            }
            return result;
        }
    }

    public static class ValueComparator
    extends BaseComparator {
        private final boolean compareHighValue;

        public ValueComparator(boolean compareHighValue) {
            this.compareHighValue = compareHighValue;
        }

        @Override
        protected int compareParts(IPAddressSegmentGrouping one, IPAddressSegmentGrouping two) {
            int sizeResult = one.getByteCount() - two.getByteCount();
            if (sizeResult != 0) {
                return sizeResult;
            }
            boolean compareHigh = this.compareHighValue;
            do {
                long twoValue;
                int twoIndex = 0;
                int oneIndex = 0;
                int twoByteCount = 0;
                int oneByteCount = 0;
                long oneValue = twoValue = (long)0;
                while (oneIndex < one.getDivisionCount() || twoIndex < two.getDivisionCount()) {
                    if (oneByteCount == 0) {
                        IPAddressDivision oneCombo = one.getDivision(oneIndex++);
                        oneByteCount = oneCombo.getByteCount();
                        long l = oneValue = compareHigh ? oneCombo.getUpperValue() : oneCombo.getLowerValue();
                    }
                    if (twoByteCount == 0) {
                        IPAddressDivision twoCombo = two.getDivision(twoIndex++);
                        twoByteCount = twoCombo.getByteCount();
                        twoValue = compareHigh ? twoCombo.getUpperValue() : twoCombo.getLowerValue();
                    }
                    long oneResultValue = oneValue;
                    long twoResultValue = twoValue;
                    if (twoByteCount == oneByteCount) {
                        twoByteCount = 0;
                        oneByteCount = 0;
                    } else {
                        int diffBits;
                        int diffBytes = twoByteCount - oneByteCount;
                        if (diffBytes > 0) {
                            diffBits = diffBytes << 3;
                            twoResultValue >>= diffBits;
                            twoValue &= -1L << diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                            twoByteCount = diffBytes;
                            oneByteCount = 0;
                        } else {
                            diffBytes = -diffBytes;
                            diffBits = diffBytes << 3;
                            oneResultValue >>= diffBits;
                            oneValue &= -1L << diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                            oneByteCount = diffBytes;
                            twoByteCount = 0;
                        }
                    }
                    long result = oneResultValue - twoResultValue;
                    if (result == 0L) continue;
                    return ValueComparator.convertResult(result);
                }
            } while ((compareHigh = !compareHigh) != this.compareHighValue);
            return 0;
        }

        @Override
        protected long compareValues(long oneUpper, long oneLower, long twoUpper, long twoLower) {
            long result;
            if (this.compareHighValue) {
                result = oneUpper - twoUpper;
                if (result == 0L) {
                    result = oneLower - twoLower;
                }
            } else {
                result = oneLower - twoLower;
                if (result == 0L) {
                    result = oneUpper - twoUpper;
                }
            }
            return result;
        }
    }
}

