/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.format.IPAddressDivision;

public abstract class IPAddressJoinedSegments
extends IPAddressDivision {
    private static final long serialVersionUID = 1L;
    protected final int joinedCount;
    protected final long value;
    protected final long upperValue;

    public IPAddressJoinedSegments(int joinedCount, int value) {
        this.value = this.upperValue = (long)value;
        this.joinedCount = joinedCount;
        if (joinedCount <= 0) {
            throw new IllegalArgumentException();
        }
    }

    public IPAddressJoinedSegments(int joinedCount, long value, Integer segmentPrefixLength) {
        this(joinedCount, value, value, segmentPrefixLength);
    }

    public IPAddressJoinedSegments(int joinedCount, long lower, long upper, Integer segmentPrefixLength) {
        super(segmentPrefixLength);
        this.value = lower;
        this.upperValue = upper;
        this.joinedCount = joinedCount;
        if (joinedCount <= 0) {
            throw new IllegalArgumentException();
        }
    }

    public int getJoinedCount() {
        return this.joinedCount;
    }

    @Override
    public long getLowerValue() {
        return this.value;
    }

    @Override
    public long getUpperValue() {
        return this.upperValue;
    }

    @Override
    protected abstract long getDivisionNetworkMask(int var1);

    @Override
    protected abstract long getDivisionHostMask(int var1);

    protected abstract int getBitsPerSegment();

    protected abstract int getBytesPerSegment();

    @Override
    public long getMaxValue() {
        return -1L << this.getBitCount() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public int getBitCount() {
        return (this.joinedCount + 1) * this.getBitsPerSegment();
    }

    @Override
    public int getByteCount() {
        return (this.joinedCount + 1) * this.getBytesPerSegment();
    }

    @Override
    protected int getLeadingZerosAdjustment() {
        return 64 - this.getBitCount();
    }

    @Override
    public int getDefaultMaxChars() {
        return IPAddressJoinedSegments.getCharWidth(this.getMaxValue(), this.getDefaultTextualRadix());
    }

    @Override
    protected boolean isSameValues(IPAddressDivision other) {
        if (other instanceof IPAddressJoinedSegments) {
            return this.isSameValues((IPAddressJoinedSegments)other);
        }
        return false;
    }

    protected boolean isSameValues(IPAddressJoinedSegments otherSegment) {
        return otherSegment.joinedCount == this.joinedCount && this.value == otherSegment.value && this.upperValue == otherSegment.upperValue;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IPAddressJoinedSegments) {
            IPAddressJoinedSegments otherSegments = (IPAddressJoinedSegments)other;
            return this.isSameValues(otherSegments);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value | this.upperValue << this.getBitCount());
    }
}

