/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.HostName;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.format.IPAddressSegmentGrouping;
import inet.ipaddr.format.validate.ParsedAddressCreator;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiFunction;

public abstract class IPAddressTypeNetwork<T extends IPAddress, S extends IPAddressSegment>
extends IPAddressNetwork {
    private final T[] subnets;
    private final T[] subnetMasks;
    private final T[] hostMasks;
    private final long[][] networkSegmentMasks;
    private final long[][] hostSegmentMasks;
    private T loopback;
    private String[] loopbackStrings;
    private IPAddressCreator<T, ?, S> creator;

    protected IPAddressTypeNetwork(Class<T> addressType) {
        IPAddress.IPVersion version = this.getIPVersion();
        int bitSize = IPAddress.bitCount(version);
        this.subnets = (IPAddress[])Array.newInstance(addressType, bitSize + 1);
        this.subnetMasks = (IPAddress[])this.subnets.clone();
        this.hostMasks = (IPAddress[])this.subnets.clone();
        this.creator = this.createAddressCreator();
        int segmentBitSize = IPAddressSegment.getBitCount(version);
        int segmentCount = IPAddress.segmentCount(version);
        this.networkSegmentMasks = new long[segmentCount][];
        this.hostSegmentMasks = (long[][])this.networkSegmentMasks.clone();
        int h = 0;
        int allBitSize = segmentBitSize;
        while (h < segmentCount && allBitSize < 64) {
            long fullMask = -1L << allBitSize ^ 0xFFFFFFFFFFFFFFFFL;
            this.networkSegmentMasks[h] = new long[allBitSize + 1];
            this.hostSegmentMasks[h] = (long[])this.networkSegmentMasks[h].clone();
            int i = 0;
            while (i <= allBitSize) {
                long l = fullMask & fullMask << allBitSize - i;
                this.networkSegmentMasks[h][i] = l;
                long networkMask = l;
                this.hostSegmentMasks[h][i] = (networkMask ^ 0xFFFFFFFFFFFFFFFFL) & fullMask;
                ++i;
            }
            ++h;
            allBitSize += segmentBitSize;
        }
    }

    protected abstract BiFunction<T, Integer, S> getSegmentProducer();

    protected abstract IPAddressCreator<T, ?, S> createAddressCreator();

    protected IPAddressCreator<T, ?, S> getAddressCreator() {
        return this.creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getLoopback() {
        if (this.loopback == null) {
            IPAddressTypeNetwork iPAddressTypeNetwork = this;
            synchronized (iPAddressTypeNetwork) {
                if (this.loopback == null) {
                    this.loopback = this.createLoopback();
                }
            }
        }
        return this.loopback;
    }

    protected abstract T createLoopback();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getStandardLoopbackStrings() {
        if (this.loopbackStrings == null) {
            IPAddressTypeNetwork iPAddressTypeNetwork = this;
            synchronized (iPAddressTypeNetwork) {
                if (this.loopbackStrings == null) {
                    this.loopbackStrings = ((IPAddress)this.getLoopback()).toStandardStrings();
                }
            }
        }
        return this.loopbackStrings;
    }

    @Override
    public int getSegmentNetworkMask(int segmentPrefixLength) {
        return (int)this.networkSegmentMasks[0][segmentPrefixLength];
    }

    @Override
    public int getSegmentHostMask(int segmentPrefixLength) {
        return (int)this.hostSegmentMasks[0][segmentPrefixLength];
    }

    @Override
    public long getSegmentNetworkMask(int segmentPrefixLength, int joinedSegments) {
        return this.networkSegmentMasks[joinedSegments][segmentPrefixLength];
    }

    @Override
    public long getSegmentHostMask(int segmentPrefixLength, int joinedSegments) {
        return this.hostSegmentMasks[joinedSegments][segmentPrefixLength];
    }

    public T getNetworkMask(int networkPrefixLength) {
        return this.getNetworkMask(networkPrefixLength, true);
    }

    public T getNetworkMask(int networkPrefixLength, boolean withPrefixLength) {
        return (T)this.getMask(networkPrefixLength, (IPAddress[])(withPrefixLength ? this.subnets : this.subnetMasks), true, withPrefixLength);
    }

    public T getHostMask(int networkPrefixLength) {
        return (T)this.getMask(networkPrefixLength, (IPAddress[])this.hostMasks, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private T getMask(int networkPrefixLength, T[] cache, boolean network, boolean withPrefixLength) {
        block20: {
            bits = networkPrefixLength;
            version = this.getIPVersion();
            addressBitLength = IPAddress.bitCount(version);
            if (bits < 0) throw new IPAddressTypeException(bits, version, "ipaddress.error.prefixSize");
            if (bits > addressBitLength) {
                throw new IPAddressTypeException(bits, version, "ipaddress.error.prefixSize");
            }
            cacheIndex = bits;
            subnet /* !! */  = cache[cacheIndex];
            if (subnet /* !! */  != null) return subnet /* !! */ ;
            if (network) {
                onesSubnetIndex = addressBitLength;
                zerosSubnetIndex = 0;
            } else {
                onesSubnetIndex = 0;
                zerosSubnetIndex = addressBitLength;
            }
            onesSubnet /* !! */  = cache[onesSubnetIndex];
            zerosSubnet /* !! */  = cache[zerosSubnetIndex];
            if (onesSubnet /* !! */  == null || zerosSubnet /* !! */  == null) {
                var14_14 = cache;
                // MONITORENTER : cache
                segmentCount = IPAddress.segmentCount(version);
                bitsPerSegment = IPAddress.bitsPerSegment(version);
                onesSubnet /* !! */  = cache[onesSubnetIndex];
                if (onesSubnet /* !! */  == null) {
                    creator = this.getAddressCreator();
                    newSegments = creator.createSegmentArray(segmentCount);
                    maxSegmentValue = IPAddress.maxSegmentValue(version);
                    if (network && withPrefixLength) {
                        segment = creator.createSegment(maxSegmentValue, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, addressBitLength));
                        Arrays.fill(newSegments, 0, newSegments.length - 1, segment);
                        lastSegment = creator.createSegment(maxSegmentValue, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, bitsPerSegment));
                        newSegments[newSegments.length - 1] = lastSegment;
                    } else {
                        segment = creator.createSegment(maxSegmentValue);
                        Arrays.fill(newSegments, segment);
                    }
                    onesSubnet /* !! */  = creator.createAddressInternal((IPAddressSegment[])newSegments);
                    this.initMaskCachedValues(onesSubnet /* !! */ .addressSection, network, withPrefixLength, addressBitLength, onesSubnetIndex, segmentCount, bitsPerSegment);
                    cache[onesSubnetIndex] = onesSubnet /* !! */ ;
                }
                if ((zerosSubnet /* !! */  = cache[zerosSubnetIndex]) == null) {
                    creator = this.getAddressCreator();
                    newSegments = creator.createSegmentArray(segmentCount);
                    seg = network != false && withPrefixLength != false ? creator.createSegment(0, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, 0)) : creator.createSegment(0);
                    Arrays.fill(newSegments, seg);
                    zerosSubnet /* !! */  = creator.createAddressInternal((IPAddressSegment[])newSegments);
                    this.initMaskCachedValues(zerosSubnet /* !! */ .addressSection, network, withPrefixLength, addressBitLength, zerosSubnetIndex, segmentCount, bitsPerSegment);
                    cache[zerosSubnetIndex] = zerosSubnet /* !! */ ;
                }
                // MONITOREXIT : var14_14
            }
            var14_14 = cache;
            // MONITORENTER : cache
            subnet /* !! */  = cache[cacheIndex];
            if (subnet /* !! */  != null) break block20;
            segProducer = this.getSegmentProducer();
            segmentCount = IPAddress.segmentCount(version);
            bitsPerSegment = IPAddress.bitsPerSegment(version);
            prefix = bits;
            onesSegment = (IPAddressSegment)segProducer.apply(onesSubnet /* !! */ , 1);
            zerosSegment = (IPAddressSegment)segProducer.apply(zerosSubnet /* !! */ , 1);
            creator = this.getAddressCreator();
            segmentList = new ArrayList<IPAddressSegment>(segmentCount);
            i = 0;
            block6: while (bits > 0) {
                block21: {
                    if (bits > bitsPerSegment) break block21;
                    segment = null;
                    offset = (bits - 1) % bitsPerSegment + 1;
                    j = 0;
                    entry = offset;
                    if (true) ** GOTO lbl91
                }
                segmentList.add(network != false ? onesSegment : zerosSegment);
lbl77:
                // 2 sources

                while (true) {
                    ++i;
                    bits -= bitsPerSegment;
                    continue block6;
                    break;
                }
            }
            if (true) ** GOTO lbl102
            do {
                if (entry != cacheIndex && (prev = cache[entry]) != null) {
                    segment = (IPAddressSegment)segProducer.apply(prev, j);
                    break;
                }
                ++j;
                entry += bitsPerSegment;
lbl91:
                // 2 sources

            } while (j < segmentCount);
            if (segment == null) {
                mask = this.getSegmentNetworkMask(bits);
                segment = network ? (withPrefixLength ? creator.createSegment(mask, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, bits)) : (Object)creator.createSegment(mask)) : (Object)creator.createSegment(this.getSegmentHostMask(bits));
            }
            segmentList.add((IPAddressSegment)segment);
            ** while (true)
            do {
                segmentList.add(network != false ? zerosSegment : onesSegment);
                ++i;
lbl102:
                // 2 sources

            } while (i < segmentCount);
            newSegments = creator.createSegmentArray(segmentList.size());
            segmentList.toArray(newSegments);
            subnet /* !! */  = creator.createAddressInternal(newSegments);
            this.initMaskCachedValues(subnet /* !! */ .addressSection, network, withPrefixLength, addressBitLength, prefix, segmentCount, bitsPerSegment);
            cache[cacheIndex] = subnet /* !! */ ;
        }
        // MONITOREXIT : var14_14
        return subnet /* !! */ ;
    }

    private void initMaskCachedValues(IPAddressSection section, boolean network, boolean withPrefixLength, int addressBitLength, int networkPrefixLength, int segmentCount, int bitsPerSegment) {
        BigInteger cachedCount;
        Integer cachedEquivalentPrefix;
        Integer cachedMinPrefix;
        Integer cachedNetworkPrefix;
        IPAddressSegmentGrouping.RangeList zeroSegments;
        IPAddressSegmentGrouping.RangeList zeroRanges;
        boolean hasZeroRanges = network ? addressBitLength - networkPrefixLength >= bitsPerSegment : networkPrefixLength >= bitsPerSegment;
        IPAddressSegmentGrouping.RangeList noZeros = IPAddressSection.getNoZerosRange();
        if (hasZeroRanges) {
            int rangeLen;
            int rangeIndex;
            if (network) {
                int segmentIndex;
                rangeIndex = segmentIndex = (networkPrefixLength + bitsPerSegment - 1) / bitsPerSegment;
                rangeLen = segmentCount - segmentIndex;
            } else {
                rangeIndex = 0;
                rangeLen = networkPrefixLength / bitsPerSegment;
            }
            zeroRanges = IPAddressSection.getSingleRange(rangeIndex, rangeLen);
            zeroSegments = network && withPrefixLength ? noZeros : zeroRanges;
        } else {
            zeroSegments = zeroRanges = noZeros;
        }
        if (network && withPrefixLength) {
            cachedMinPrefix = cachedNetworkPrefix = Integer.valueOf(networkPrefixLength);
            cachedEquivalentPrefix = cachedNetworkPrefix;
            cachedCount = BigInteger.valueOf(2L).pow(addressBitLength - networkPrefixLength);
        } else {
            cachedEquivalentPrefix = cachedMinPrefix = Integer.valueOf(addressBitLength);
            cachedNetworkPrefix = -1;
            cachedCount = BigInteger.ONE;
        }
        section.initCachedValues(networkPrefixLength, network, cachedNetworkPrefix, cachedMinPrefix, cachedEquivalentPrefix, cachedCount, zeroSegments, zeroRanges);
    }

    protected static abstract class IPAddressCreator<T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment>
    extends ParsedAddressCreator<T, R, S>
    implements IPAddressSegmentCreator<S> {
        protected IPAddressCreator() {
        }

        @Override
        protected S createSegmentInternal(int value, Integer segmentPrefixLength, String addressStr, int originalVal, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex) {
            Object segment = this.createSegment(value, segmentPrefixLength);
            ((IPAddressSegment)segment).setStandardString(addressStr, isStandardString, lowerStringStartIndex, lowerStringEndIndex, originalVal);
            ((IPAddressSegment)segment).setWildcardString(addressStr, isStandardString, lowerStringStartIndex, lowerStringEndIndex, originalVal);
            return segment;
        }

        @Override
        protected S createSegmentInternal(int lower, int upper, Integer segmentPrefixLength, String addressStr, int originalLower, int originalUpper, boolean isStandardString, boolean isStandardRangeString, int lowerStringStartIndex, int lowerStringEndIndex, int upperStringEndIndex) {
            Object segment = this.createSegment(lower, upper, segmentPrefixLength);
            ((IPAddressSegment)segment).setStandardString(addressStr, isStandardString, isStandardRangeString, lowerStringStartIndex, lowerStringEndIndex, upperStringEndIndex, originalLower, originalUpper);
            ((IPAddressSegment)segment).setWildcardString(addressStr, isStandardRangeString, lowerStringStartIndex, upperStringEndIndex, originalLower, originalUpper);
            return segment;
        }

        protected abstract R[] createSectionArray(int var1);

        @Override
        protected abstract R createSectionInternal(S[] var1);

        protected T createAddressInternal(S[] segments) {
            return this.createAddress(this.createSectionInternal((IPAddressSegment[])segments), null);
        }

        protected T createAddressInternal(S[] segments, String zone) {
            return this.createAddress(this.createSectionInternal((IPAddressSegment[])segments), zone);
        }

        protected T createAddressInternal(byte[] bytes, Integer prefix, String zone) {
            return this.createAddress(this.createSectionInternal(bytes, prefix), zone);
        }

        @Override
        protected T createAddressInternal(R section, String zone, IPAddressString fromString, HostName fromHost) {
            T result = this.createAddress(section, zone);
            ((IPAddress)result).fromString = fromString;
            ((IPAddress)result).fromHost = fromHost;
            return result;
        }

        protected abstract T createAddress(R var1, String var2);
    }

    protected static interface IPAddressSegmentCreator<S extends IPAddressSegment> {
        public S[] createSegmentArray(int var1);

        public S createSegment(int var1);

        public S createSegment(int var1, Integer var2);

        public S createSegment(int var1, int var2, Integer var3);
    }
}

