/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.subtitles;

import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.model.Extension;
import com.github.kiulian.downloader.model.subtitles.OnSubtitlesDownloadListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class Subtitles {
    private final String url;
    private Extension format;
    private String translationLanguage;

    Subtitles(String url) {
        this.url = url;
    }

    public Subtitles formatTo(Extension extension) {
        this.format = extension;
        return this;
    }

    public Subtitles translateTo(String language) {
        this.translationLanguage = language;
        return this;
    }

    public String getDownloadUrl() {
        String downloadUrl = this.url;
        if (this.format != null && this.format.isSubtitle()) {
            downloadUrl = downloadUrl + "&fmt=" + this.format.value();
        }
        if (this.translationLanguage != null && !this.translationLanguage.isEmpty()) {
            downloadUrl = downloadUrl + "&tlang=" + this.translationLanguage;
        }
        return downloadUrl;
    }

    public String download() throws YoutubeException {
        URL url;
        try {
            url = new URL(this.getDownloadUrl());
        }
        catch (MalformedURLException e) {
            throw new YoutubeException.SubtitlesException("Failed to download subtitle: Invalid url: " + e.getMessage());
        }
        StringBuilder result = new StringBuilder();
        BufferedReader br = null;
        try {
            String inputLine;
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            int responseCode = urlConnection.getResponseCode();
            if (responseCode != 200) {
                throw new YoutubeException.SubtitlesException("Failed to download subtitle: HTTP " + responseCode);
            }
            if (urlConnection.getContentLength() == 0) {
                throw new YoutubeException.SubtitlesException("Failed to download subtitle: Response is empty");
            }
            br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
            while ((inputLine = br.readLine()) != null) {
                result.append(inputLine).append('\n');
            }
        }
        catch (IOException e) {
            throw new YoutubeException.SubtitlesException("Failed to download subtitle: " + e.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result.toString();
    }

    public Future<String> downloadAsync() {
        return this.downloadAsync(null);
    }

    public Future<String> downloadAsync(final OnSubtitlesDownloadListener downloadListener) {
        FutureTask<String> future = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() {
                String subtitles;
                block3: {
                    subtitles = null;
                    try {
                        subtitles = Subtitles.this.download();
                        if (downloadListener != null) {
                            downloadListener.onFinished(subtitles);
                        }
                    }
                    catch (YoutubeException e) {
                        if (downloadListener == null) break block3;
                        downloadListener.onError(e);
                    }
                }
                return subtitles;
            }
        });
        Thread thread = new Thread(future, "YtSubDownloader");
        thread.setDaemon(true);
        thread.start();
        return future;
    }
}

