/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model;

import com.github.kiulian.downloader.OnYoutubeDownloadListener;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.model.Extension;
import com.github.kiulian.downloader.model.Utils;
import com.github.kiulian.downloader.model.VideoDetails;
import com.github.kiulian.downloader.model.formats.AudioFormat;
import com.github.kiulian.downloader.model.formats.AudioVideoFormat;
import com.github.kiulian.downloader.model.formats.Format;
import com.github.kiulian.downloader.model.formats.VideoFormat;
import com.github.kiulian.downloader.model.quality.AudioQuality;
import com.github.kiulian.downloader.model.quality.VideoQuality;
import com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class YoutubeVideo {
    private VideoDetails videoDetails;
    private List<Format> formats;
    private List<SubtitlesInfo> subtitlesInfo;

    public YoutubeVideo(VideoDetails videoDetails, List<Format> formats, List<SubtitlesInfo> subtitlesInfo) {
        this.videoDetails = videoDetails;
        this.formats = formats;
        this.subtitlesInfo = subtitlesInfo;
    }

    public VideoDetails details() {
        return this.videoDetails;
    }

    public List<Format> formats() {
        return this.formats;
    }

    public List<SubtitlesInfo> subtitles() {
        return this.subtitlesInfo;
    }

    public Format findFormatByItag(int itag) {
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (format.itag().id() != itag) continue;
            return format;
        }
        return null;
    }

    public List<AudioVideoFormat> videoWithAudioFormats() {
        LinkedList<AudioVideoFormat> find = new LinkedList<AudioVideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioVideoFormat)) continue;
            find.add((AudioVideoFormat)format);
        }
        return find;
    }

    public List<VideoFormat> videoFormats() {
        LinkedList<VideoFormat> find = new LinkedList<VideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof VideoFormat)) continue;
            find.add((VideoFormat)format);
        }
        return find;
    }

    public List<VideoFormat> findVideoWithQuality(VideoQuality videoQuality) {
        LinkedList<VideoFormat> find = new LinkedList<VideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof VideoFormat) || ((VideoFormat)format).videoQuality() != videoQuality) continue;
            find.add((VideoFormat)format);
        }
        return find;
    }

    public List<VideoFormat> findVideoWithExtension(Extension extension) {
        LinkedList<VideoFormat> find = new LinkedList<VideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof VideoFormat) || !format.extension().equals(extension)) continue;
            find.add((VideoFormat)format);
        }
        return find;
    }

    public List<AudioFormat> audioFormats() {
        LinkedList<AudioFormat> find = new LinkedList<AudioFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioFormat)) continue;
            find.add((AudioFormat)format);
        }
        return find;
    }

    public List<AudioFormat> findAudioWithQuality(AudioQuality audioQuality) {
        LinkedList<AudioFormat> find = new LinkedList<AudioFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioFormat) || ((AudioFormat)format).audioQuality() != audioQuality) continue;
            find.add((AudioFormat)format);
        }
        return find;
    }

    public List<AudioFormat> findAudioWithExtension(Extension extension) {
        LinkedList<AudioFormat> find = new LinkedList<AudioFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioFormat) || format.extension() != extension) continue;
            find.add((AudioFormat)format);
        }
        return find;
    }

    public File download(Format format, File outDir) throws IOException, YoutubeException {
        return this.download(format, outDir, this.videoDetails.title());
    }

    public File download(Format format, File outDir, String fileName) throws IOException, YoutubeException {
        return this.download(format, outDir, fileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(Format format, File outDir, String fileName, boolean overwrite) throws IOException, YoutubeException {
        if (this.videoDetails.isLive() || this.videoDetails.isLiveContent() && this.videoDetails.lengthSeconds() == 0) {
            throw new YoutubeException.LiveVideoException("Can not download live stream");
        }
        Utils.createOutDir(outDir);
        File outputFile = Utils.getOutputFile(Utils.removeIllegalChars(fileName), format, outDir, overwrite);
        URL url = new URL(format.url());
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        try {
            bis = new BufferedInputStream(url.openStream());
            fos = new FileOutputStream(outputFile);
            byte[] buffer = new byte[4096];
            int count = 0;
            while ((count = bis.read(buffer, 0, 4096)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return outputFile;
    }

    public Future<File> downloadAsync(Format format, File outDir) throws YoutubeException.LiveVideoException, IOException {
        return this.downloadAsync(format, outDir, this.videoDetails.title());
    }

    public Future<File> downloadAsync(Format format, File outDir, String fileName) throws YoutubeException.LiveVideoException, IOException {
        return this.downloadAsync(format, outDir, fileName, false);
    }

    public Future<File> downloadAsync(final Format format, final File outDir, final String fileName, final boolean overwrite) throws YoutubeException.LiveVideoException, IOException {
        if (this.videoDetails.isLive() || this.videoDetails.isLiveContent() && this.videoDetails.lengthSeconds() == 0) {
            throw new YoutubeException.LiveVideoException("Can not download live stream");
        }
        Utils.createOutDir(outDir);
        FutureTask<File> future = new FutureTask<File>(new Callable<File>(){

            @Override
            public File call() throws IOException, YoutubeException {
                return YoutubeVideo.this.download(format, outDir, fileName, overwrite);
            }
        });
        Thread thread = new Thread(future, "YtDownloader");
        thread.setDaemon(true);
        thread.start();
        return future;
    }

    public void downloadAsync(Format format, File outDir, OnYoutubeDownloadListener listener) throws IOException, YoutubeException {
        this.downloadAsync(format, outDir, this.videoDetails.title(), listener);
    }

    public void downloadAsync(Format format, File outDir, String fileName, OnYoutubeDownloadListener listener) throws IOException, YoutubeException {
        this.downloadAsync(format, outDir, fileName, false, listener);
    }

    public void downloadAsync(Format format, File outDir, String fileName, boolean overwrite, final OnYoutubeDownloadListener listener) throws IOException, YoutubeException {
        if (this.videoDetails.isLive() || this.videoDetails.isLiveContent() && this.videoDetails.lengthSeconds() == 0) {
            throw new YoutubeException.LiveVideoException("Can not download live stream");
        }
        Utils.createOutDir(outDir);
        final File outputFile = Utils.getOutputFile(fileName, format, outDir, overwrite);
        final URL url = new URL(format.url());
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedInputStream bis = null;
                FileOutputStream fos = null;
                try {
                    URLConnection urlConnection = url.openConnection();
                    int contentLength = urlConnection.getContentLength();
                    bis = new BufferedInputStream(urlConnection.getInputStream());
                    fos = new FileOutputStream(outputFile);
                    double total = 0.0;
                    byte[] buffer = new byte[4096];
                    int count = 0;
                    int progress = 0;
                    while ((count = bis.read(buffer, 0, 4096)) != -1) {
                        fos.write(buffer, 0, count);
                        int newProgress = (int)((total += (double)count) / (double)contentLength * 100.0);
                        if (newProgress <= progress) continue;
                        progress = newProgress;
                        listener.onDownloading(progress);
                    }
                    listener.onFinished(outputFile);
                }
                catch (IOException e) {
                    listener.onError(e);
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }, "YtDownloader");
        thread.setDaemon(true);
        thread.start();
    }
}

