/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class VideoDetails {
    private String videoId;
    private String title;
    private int lengthSeconds;
    private List<String> keywords;
    private String shortDescription;
    private List<String> thumbnails;
    private String author;
    private long viewCount;
    private int averageRating;
    private boolean isLiveContent;
    private boolean isLive;
    private String liveUrl;

    public VideoDetails() {
    }

    public VideoDetails(JSONObject json, String liveHLSUrl) {
        this.videoId = json.getString("videoId");
        this.title = json.getString("title");
        this.lengthSeconds = json.getIntValue("lengthSeconds");
        this.keywords = json.containsKey((Object)"keywords") ? json.getJSONArray("keywords").toJavaList(String.class) : new ArrayList<String>();
        this.shortDescription = json.getString("shortDescription");
        JSONArray jsonThumbnails = json.getJSONObject("thumbnail").getJSONArray("thumbnails");
        this.thumbnails = new ArrayList<String>(jsonThumbnails.size());
        for (int i = 0; i < jsonThumbnails.size(); ++i) {
            JSONObject jsonObject = jsonThumbnails.getJSONObject(i);
            if (!jsonObject.containsKey((Object)"url")) continue;
            this.thumbnails.add(jsonObject.getString("url"));
        }
        this.averageRating = json.getIntValue("averageRating");
        this.viewCount = json.getLongValue("viewCount");
        this.author = json.getString("author");
        this.isLiveContent = json.getBooleanValue("isLiveContent");
        this.isLive = json.getBooleanValue("isLive");
        this.liveUrl = liveHLSUrl;
    }

    public String videoId() {
        return this.videoId;
    }

    public String title() {
        return this.title;
    }

    public int lengthSeconds() {
        return this.lengthSeconds;
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public String description() {
        return this.shortDescription;
    }

    public List<String> thumbnails() {
        return this.thumbnails;
    }

    public String author() {
        return this.author;
    }

    public long viewCount() {
        return this.viewCount;
    }

    public int averageRating() {
        return this.averageRating;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public boolean isLiveContent() {
        return this.isLiveContent;
    }

    public String liveUrl() {
        return this.liveUrl;
    }
}

