/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.okhttp;

import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.httpclient.okhttp.OkHttpFuture;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.Response;

class OAuthAsyncCompletionHandler<T>
implements Callback {
    private final OAuthAsyncRequestCallback<T> callback;
    private final OAuthRequestAsync.ResponseConverter<T> converter;
    private final OkHttpFuture<T> okHttpFuture;

    OAuthAsyncCompletionHandler(OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter, OkHttpFuture<T> okHttpFuture) {
        this.callback = callback;
        this.converter = converter;
        this.okHttpFuture = okHttpFuture;
    }

    public void onFailure(Call call, IOException e) {
        try {
            if (this.callback != null) {
                this.callback.onThrowable((Throwable)e);
            }
        }
        finally {
            this.okHttpFuture.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response okHttpResponse) throws IOException {
        try {
            Headers headers = okHttpResponse.headers();
            HashMap<String, String> headersMap = new HashMap<String, String>();
            for (String name : headers.names()) {
                headersMap.put(name, headers.get(name));
            }
            com.github.scribejava.core.model.Response response = new com.github.scribejava.core.model.Response(okHttpResponse.code(), okHttpResponse.message(), headersMap, null, okHttpResponse.body().byteStream());
            com.github.scribejava.core.model.Response t = this.converter == null ? response : this.converter.convert(response);
            this.okHttpFuture.setResult(t);
            if (this.callback != null) {
                this.callback.onCompleted((Object)t);
            }
        }
        finally {
            this.okHttpFuture.finish();
        }
    }
}

