/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.imgur;

import com.github.scribejava.apis.ImgurApi;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.OAuth20Service;

public class ImgurOAuthService
extends OAuth20Service {
    public ImgurOAuthService(DefaultApi20 api, String apiKey, String apiSecret, String callback, String defaultScope, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super(api, apiKey, apiSecret, callback, defaultScope, responseType, userAgent, httpClientConfig, httpClient);
    }

    protected OAuthRequest createAccessTokenRequest(String oauthVerifier) {
        DefaultApi20 api = this.getApi();
        OAuthRequest request = new OAuthRequest(api.getAccessTokenVerb(), api.getAccessTokenEndpoint());
        request.addBodyParameter("client_id", this.getApiKey());
        request.addBodyParameter("client_secret", this.getApiSecret());
        if (ImgurApi.isOob(this.getCallback())) {
            request.addBodyParameter("grant_type", "pin");
            request.addBodyParameter("pin", oauthVerifier);
        } else {
            request.addBodyParameter("grant_type", "authorization_code");
            request.addBodyParameter("code", oauthVerifier);
        }
        return request;
    }

    public void signRequest(String accessToken, OAuthRequest request) {
        request.addHeader("Authorization", accessToken == null ? "Client-ID " + this.getApiKey() : "Bearer " + accessToken);
    }
}

