/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.microsoftazureactivedirectory;

import com.github.scribejava.apis.microsoftazureactivedirectory.BaseMicrosoftAzureActiveDirectoryBearerSignature;
import com.github.scribejava.apis.microsoftazureactivedirectory.MicrosoftAzureActiveDirectory20BearerSignature;
import com.github.scribejava.apis.microsoftazureactivedirectory.MicrosoftAzureActiveDirectoryBearerSignature;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.oauth2.bearersignature.BearerSignature;
import com.github.scribejava.core.oauth2.clientauthentication.ClientAuthentication;
import com.github.scribejava.core.oauth2.clientauthentication.RequestBodyAuthenticationScheme;

public abstract class BaseMicrosoftAzureActiveDirectoryApi
extends DefaultApi20 {
    private static final String MSFT_LOGIN_URL = "https://login.microsoftonline.com";
    private static final String SLASH = "/";
    private static final String COMMON = "common";
    private static final String TOKEN_URI = "oauth2/token";
    private final String resource;
    private final BaseMicrosoftAzureActiveDirectoryBearerSignature bearerSignature;

    protected BaseMicrosoftAzureActiveDirectoryApi(String resource, BaseMicrosoftAzureActiveDirectoryBearerSignature bearerSignature) {
        this.resource = resource;
        this.bearerSignature = bearerSignature;
    }

    protected BaseMicrosoftAzureActiveDirectoryApi(MicrosoftAzureActiveDirectoryVersion version) {
        this.resource = version.getResource();
        this.bearerSignature = version.getBearerSignature();
    }

    public String getAccessTokenEndpoint() {
        return "https://login.microsoftonline.com/common/oauth2/token";
    }

    protected String getAuthorizationBaseUrl() {
        return "https://login.microsoftonline.com/common/oauth2/authorize?resource=" + this.resource;
    }

    public ClientAuthentication getClientAuthentication() {
        return RequestBodyAuthenticationScheme.instance();
    }

    public BearerSignature getBearerSignature() {
        return this.bearerSignature;
    }

    protected static enum MicrosoftAzureActiveDirectoryVersion {
        V_1_0("https://graph.windows.net", MicrosoftAzureActiveDirectoryBearerSignature.instance()),
        V_2_0("https://graph.microsoft.com", MicrosoftAzureActiveDirectory20BearerSignature.instance());

        private final String resource;
        private final BaseMicrosoftAzureActiveDirectoryBearerSignature bearerSignature;

        private MicrosoftAzureActiveDirectoryVersion(String resource, BaseMicrosoftAzureActiveDirectoryBearerSignature bearerSignature) {
            this.resource = resource;
            this.bearerSignature = bearerSignature;
        }

        protected String getResource() {
            return this.resource;
        }

        protected BaseMicrosoftAzureActiveDirectoryBearerSignature getBearerSignature() {
            return this.bearerSignature;
        }
    }
}

