/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.apis.service.ImgurOAuthService;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.ParameterList;
import java.util.Map;

public class ImgurApi
extends DefaultApi20 {
    protected ImgurApi() {
    }

    public static ImgurApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getAccessTokenEndpoint() {
        return "https://api.imgur.com/oauth2/token";
    }

    public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
        String state;
        String scope;
        ParameterList parameters = new ParameterList(additionalParams);
        parameters.add("response_type", ImgurApi.isOob(config) ? "pin" : "code");
        parameters.add("client_id", config.getApiKey());
        String callback = config.getCallback();
        if (callback != null) {
            parameters.add("redirect_uri", callback);
        }
        if ((scope = config.getScope()) != null) {
            parameters.add("scope", scope);
        }
        if ((state = config.getState()) != null) {
            parameters.add("state", state);
        }
        return parameters.appendTo("https://api.imgur.com/oauth2/authorize");
    }

    protected String getAuthorizationBaseUrl() {
        throw new UnsupportedOperationException("use getAuthorizationUrl instead");
    }

    public ImgurOAuthService createService(OAuthConfig config) {
        return new ImgurOAuthService(this, config);
    }

    public static boolean isOob(OAuthConfig config) {
        return "oob".equals(config.getCallback());
    }

    private static class InstanceHolder {
        private static final ImgurApi INSTANCE = new ImgurApi();

        private InstanceHolder() {
        }
    }
}

