/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.extractors.OAuth1AccessTokenJSONExtractor;
import com.github.scribejava.core.extractors.OAuth1RequestTokenJSONExtractor;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;

public class UcozApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "http://uapi.ucoz.com/accounts/oauthauthorizetoken?oauth_token=%s";

    protected UcozApi() {
    }

    public static UcozApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getAccessTokenEndpoint() {
        return "http://uapi.ucoz.com/accounts/oauthgetaccesstoken";
    }

    public String getRequestTokenEndpoint() {
        return "http://uapi.ucoz.com/accounts/oauthgetrequesttoken";
    }

    public String getAuthorizationUrl(OAuth1RequestToken requestToken) {
        return String.format(AUTHORIZE_URL, requestToken.getToken());
    }

    public TokenExtractor<OAuth1AccessToken> getAccessTokenExtractor() {
        return OAuth1AccessTokenJSONExtractor.instance();
    }

    public TokenExtractor<OAuth1RequestToken> getRequestTokenExtractor() {
        return OAuth1RequestTokenJSONExtractor.instance();
    }

    private static class InstanceHolder {
        private static final UcozApi INSTANCE = new UcozApi();

        private InstanceHolder() {
        }
    }
}

