/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.service;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.stream.Collectors;

public class OdnoklassnikiOAuthService
extends OAuth20Service {
    public OdnoklassnikiOAuthService(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
    }

    public void signRequest(String accessToken, OAuthRequest request) {
        try {
            String tokenDigest = OdnoklassnikiOAuthService.md5(accessToken + this.getConfig().getApiSecret());
            ParameterList queryParams = request.getQueryStringParams();
            queryParams.addAll(request.getBodyParams());
            List allParams = queryParams.getParams();
            Collections.sort(allParams);
            String stringParams = allParams.stream().map(param -> param.getKey() + '=' + param.getValue()).collect(Collectors.joining());
            String sigSource = URLDecoder.decode(stringParams, "UTF-8") + tokenDigest;
            request.addQuerystringParameter("sig", OdnoklassnikiOAuthService.md5(sigSource).toLowerCase());
            super.signRequest(accessToken, request);
        }
        catch (UnsupportedEncodingException unex) {
            throw new IllegalStateException(unex);
        }
    }

    public static String md5(String orgString) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(orgString.getBytes(Charset.forName("UTF-8")));
            Formatter builder = new Formatter();
            for (byte b : array) {
                builder.format("%02x", b);
            }
            return builder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 is unsupported?", e);
        }
    }
}

