/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.service;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public class MailruOAuthService
extends OAuth20Service {
    public MailruOAuthService(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
    }

    public void signRequest(String accessToken, OAuthRequest request) {
        request.addQuerystringParameter("session_key", accessToken);
        request.addQuerystringParameter("app_id", this.getConfig().getApiKey());
        String completeUrl = request.getCompleteUrl();
        try {
            String clientSecret = this.getConfig().getApiSecret();
            int queryIndex = completeUrl.indexOf(63);
            if (queryIndex != -1) {
                String urlPart = completeUrl.substring(queryIndex + 1);
                TreeMap<String, String> map = new TreeMap<String, String>();
                for (String param : urlPart.split("&")) {
                    String[] parts = param.split("=");
                    map.put(parts[0], parts.length == 1 ? "" : parts[1]);
                }
                String urlNew = map.entrySet().stream().map(entry -> (String)entry.getKey() + '=' + (String)entry.getValue()).collect(Collectors.joining());
                String sigSource = URLDecoder.decode(urlNew, "UTF-8") + clientSecret;
                request.addQuerystringParameter("sig", DigestUtils.md5Hex((String)sigSource));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

