/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.service;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Parameter;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class OdnoklassnikiServiceImpl
extends OAuth20Service {
    public OdnoklassnikiServiceImpl(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
    }

    public void signRequest(OAuth2AccessToken accessToken, OAuthRequest request) {
        try {
            String tokenDigest = DigestUtils.md5Hex((String)(accessToken.getAccessToken() + this.getConfig().getApiSecret()));
            ParameterList queryParams = request.getQueryStringParams();
            queryParams.addAll(request.getBodyParams());
            List allParams = queryParams.getParams();
            Collections.sort(allParams);
            StringBuilder builder = new StringBuilder();
            for (Parameter param : allParams) {
                builder.append(param.getKey()).append('=').append(param.getValue());
            }
            String sigSource = URLDecoder.decode(builder.toString(), "UTF-8") + tokenDigest;
            request.addQuerystringParameter("sig", DigestUtils.md5Hex((String)sigSource).toLowerCase());
            super.signRequest(accessToken, request);
        }
        catch (UnsupportedEncodingException unex) {
            throw new IllegalStateException(unex);
        }
    }
}

