/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.service;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;

public class OdnoklassnikiServiceImpl
extends OAuth20Service {
    public OdnoklassnikiServiceImpl(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
    }

    public void signRequest(OAuth2AccessToken accessToken, AbstractRequest request) {
        try {
            String tokenDigest = DigestUtils.md5Hex((String)(accessToken.getAccessToken() + this.getConfig().getApiSecret()));
            String completeUrl = request.getCompleteUrl();
            int queryIndex = completeUrl.indexOf(63);
            if (queryIndex != -1) {
                Object[] params = completeUrl.substring(queryIndex + 1).split("&");
                Arrays.sort(params);
                StringBuilder builder = new StringBuilder();
                for (Object param : params) {
                    builder.append((String)param);
                }
                String sigSource = URLDecoder.decode(builder.toString(), "UTF-8") + tokenDigest;
                request.addQuerystringParameter("sig", DigestUtils.md5Hex((String)sigSource).toLowerCase());
            }
            super.signRequest(accessToken, request);
        }
        catch (UnsupportedEncodingException unex) {
            throw new IllegalStateException(unex);
        }
    }
}

