/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.services.PlaintextSignatureService;
import com.github.scribejava.core.services.SignatureService;

public class YammerApi
extends DefaultApi10a {
    private static final String AUTHORIZATION_URL = "https://www.yammer.com/oauth/authorize?oauth_token=%s";

    private YammerApi() {
    }

    public static YammerApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getRequestTokenEndpoint() {
        return "https://www.yammer.com/oauth/request_token";
    }

    public String getAccessTokenEndpoint() {
        return "https://www.yammer.com/oauth/access_token";
    }

    public String getAuthorizationUrl(Token requestToken) {
        return String.format(AUTHORIZATION_URL, requestToken.getToken());
    }

    public SignatureService getSignatureService() {
        return new PlaintextSignatureService();
    }

    private static class InstanceHolder {
        private static final YammerApi INSTANCE = new YammerApi();

        private InstanceHolder() {
        }
    }
}

