/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.Token;

public class ConstantContactApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "https://oauth.constantcontact.com/ws/oauth/confirm_access?oauth_token=%s";

    private ConstantContactApi() {
    }

    public static ConstantContactApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getAccessTokenEndpoint() {
        return "https://oauth.constantcontact.com/ws/oauth/access_token";
    }

    public String getAuthorizationUrl(Token requestToken) {
        return String.format(AUTHORIZE_URL, requestToken.getToken());
    }

    public String getRequestTokenEndpoint() {
        return "https://oauth.constantcontact.com/ws/oauth/request_token";
    }

    private static class InstanceHolder {
        private static final ConstantContactApi INSTANCE = new ConstantContactApi();

        private InstanceHolder() {
        }
    }
}

