/*
 * Decompiled with CFR 0.152.
 */
package scopt;

import java.io.Serializable;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Iterable;
import scala.List$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scopt.ArgOptionDefinition;
import scopt.Argument;
import scopt.BooleanArgOptionDefinition;
import scopt.DoubleArgOptionDefinition;
import scopt.FlagOptionDefinition;
import scopt.IntArgOptionDefinition;
import scopt.KeyBooleanValueArgOptionDefinition;
import scopt.KeyDoubleValueArgOptionDefinition;
import scopt.KeyIntValueArgOptionDefinition;
import scopt.KeyValueArgOptionDefinition;
import scopt.OptionDefinition;
import scopt.OptionParser$;
import scopt.SeparatorDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionParser
implements ScalaObject,
Product,
Serializable {
    private Option<Argument> argList;
    private final String defaultValueName;
    private final String defaultKeyName;
    private final String NLNL;
    private final String NLTB;
    private final String TB;
    private final String NL;
    private final ListBuffer<Argument> arguments;
    private final ListBuffer<OptionDefinition> options;
    private final boolean errorOnUnknownArgument;
    private final Option<String> version;
    private final Option<String> programName;

    public OptionParser(Option<String> programName, Option<String> version, boolean errorOnUnknownArgument) {
        this.programName = programName;
        this.version = version;
        this.errorOnUnknownArgument = errorOnUnknownArgument;
        Product.class.$init$((Product)this);
        this.options = new ListBuffer();
        this.arguments = new ListBuffer();
        this.NL = System.getProperty("line.separator");
        this.TB = "        ";
        this.NLTB = new StringBuilder().append((Object)this.NL()).append((Object)this.TB()).toString();
        this.NLNL = new StringBuilder().append((Object)this.NL()).append((Object)this.NL()).toString();
        this.defaultKeyName = "<key>";
        this.defaultValueName = "<value>";
        this.argList = None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final /* synthetic */ boolean gd5$1(boolean x$1, Option x$2, Option x$3) {
        Option option = x$3;
        Option<String> option2 = this.programName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option option3 = x$2;
        Option<String> option4 = this.version();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (x$1 != this.errorOnUnknownArgument()) return false;
        return true;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.errorOnUnknownArgument());
                break;
            }
            case 1: {
                object = this.version();
                break;
            }
            case 0: {
                object = this.programName();
            }
        }
        return object;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "OptionParser";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (!(x$1 instanceof Object)) return false;
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof OptionParser)) return false;
        OptionParser optionParser = (OptionParser)object;
        boolean bl = this.gd5$1(optionParser.errorOnUnknownArgument(), optionParser.version(), optionParser.programName());
        if (!bl) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public int $tag() {
        return 710590143;
    }

    public boolean parse(Seq<String> args) {
        Buffer requiredArgs = this.arguments().clone();
        boolean answer = true;
        int argListCount = 0;
        boolean indexOutOfBounds = false;
        for (int i = 0; i < args.length(); ++i) {
            Option matchingOption;
            String arg$1 = (String)args.apply((Object)BoxesRunTime.boxToInteger((int)i));
            Option option = matchingOption = this.options().find((Function1)new $anonfun$5(this, arg$1));
            None$ none$ = None$.MODULE$;
            Option option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                if (arg$1.startsWith("-")) {
                    if (this.errorOnUnknownArgument()) {
                        System.err.println(new StringBuilder().append((Object)"Error: Unknown argument '").append((Object)arg$1).append((Object)"'").toString());
                        answer = false;
                        continue;
                    }
                    System.err.println(new StringBuilder().append((Object)"Warning: Unknown argument '").append((Object)arg$1).append((Object)"'").toString());
                    continue;
                }
                if (this.argList().isDefined()) {
                    ++argListCount;
                    if (this.applyArgument((OptionDefinition)this.argList().get(), arg$1)) continue;
                    answer = false;
                    continue;
                }
                if (requiredArgs.isEmpty()) {
                    if (this.errorOnUnknownArgument()) {
                        System.err.println(new StringBuilder().append((Object)"Error: Unknown argument '").append((Object)arg$1).append((Object)"'").toString());
                        answer = false;
                        continue;
                    }
                    System.err.println(new StringBuilder().append((Object)"Warning: Unknown argument '").append((Object)arg$1).append((Object)"'").toString());
                    continue;
                }
                Argument first = (Argument)requiredArgs.remove(0);
                if (this.applyArgument(first, arg$1)) continue;
                answer = false;
                continue;
            }
            if (option instanceof Some) {
                String argToPass;
                String string;
                Some some = (Some)option;
                OptionDefinition optionDefinition = (OptionDefinition)some.x();
                OptionDefinition option3 = optionDefinition;
                if (option3.gobbleNextArgument()) {
                    if (++i >= args.length()) {
                        indexOutOfBounds = true;
                        if (this.errorOnUnknownArgument()) {
                            System.err.println(new StringBuilder().append((Object)"Error: missing value after '").append((Object)arg$1).append((Object)"'").toString());
                            answer = false;
                        } else {
                            System.err.println(new StringBuilder().append((Object)"Warning: missing value after '").append((Object)arg$1).append((Object)"'").toString());
                        }
                        string = "";
                    } else {
                        string = (String)args.apply((Object)BoxesRunTime.boxToInteger((int)i));
                    }
                } else {
                    string = option3.keyValueArgument() && BoxesRunTime.unboxToBoolean((Object)option3.shortopt().map((Function1)new $anonfun$6(this, arg$1)).getOrElse((Function0)new $anonfun$7(this))) ? Predef$.MODULE$.forceRandomAccessCharSeq(Predef$.MODULE$.stringWrapper(arg$1).drop(new StringBuilder().append((Object)"-").append(option3.shortopt().get()).append((Object)":").toString().length())) : (argToPass = option3.keyValueArgument() && arg$1.startsWith(new StringBuilder().append((Object)"--").append((Object)option3.longopt()).append((Object)":").toString()) ? Predef$.MODULE$.forceRandomAccessCharSeq(Predef$.MODULE$.stringWrapper(arg$1).drop(new StringBuilder().append((Object)"--").append((Object)option3.longopt()).append((Object)":").toString().length())) : "");
                }
                if (indexOutOfBounds || this.applyArgument(option3, argToPass)) continue;
                answer = false;
                continue;
            }
            throw new MatchError((Object)option);
        }
        if (!requiredArgs.isEmpty() || argListCount == 0 && this.argList().isDefined()) {
            System.err.println(new StringBuilder().append((Object)"Error: missing arguments: ").append((Object)this.argumentNames().mkString(", ")).toString());
            answer = false;
        }
        if (!answer) {
            this.showUsage();
        }
        return answer;
    }

    /*
     * WARNING - void declaration
     */
    public boolean applyArgument(OptionDefinition option, String arg) {
        void var3_3;
        boolean exceptionResult1 = false;
        try {
            option.action().apply((Object)arg);
            exceptionResult1 = true;
        }
        catch (Throwable throwable) {
            System.err.println(new StringBuilder().append((Object)"Error: ").append((Object)option.shortDescription()).append((Object)" failed when given '").append((Object)arg).append((Object)"'. ").append((Object)throwable.getMessage()).toString());
            exceptionResult1 = false;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(new StringBuilder().append((Object)"Error: ").append((Object)option.shortDescription()).append((Object)" expects a number but was given '").append((Object)arg).append((Object)"'").toString());
            exceptionResult1 = false;
        }
        return (boolean)var3_3;
    }

    public Seq<String> argumentNames() {
        Option<Argument> option;
        block6: {
            Seq seq;
            block5: {
                block4: {
                    option = this.argList();
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    Argument argument = (Argument)some.x();
                    if (argument == null) {
                        throw new MatchError(option);
                    }
                    seq = List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{argument.valueName()}));
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option<Argument> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                seq = this.arguments().map((Function1)new $anonfun$argumentNames$1(this));
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public void showUsage() {
        Console$.MODULE$.err().println(this.usage());
    }

    public String usage() {
        String prorgamText = (String)this.programName().map((Function1)new $anonfun$1(this)).getOrElse((Function0)new $anonfun$2(this));
        String versionText = (String)this.programName().map((Function1)new $anonfun$3(this)).getOrElse((Function0)new $anonfun$4(this));
        String optionText = this.options().isEmpty() ? "" : "[options] ";
        String argumentList = this.argumentNames().mkString(" ");
        return new StringBuilder().append((Object)versionText).append((Object)this.NL()).append((Object)"Usage: ").append((Object)prorgamText).append((Object)optionText).append((Object)argumentList).append((Object)this.NLNL()).append((Object)"  ").append((Object)this.descriptions().mkString(new StringBuilder().append((Object)this.NL()).append((Object)"  ").toString())).append((Object)this.NL()).toString();
    }

    public Seq<String> descriptions() {
        Option<Argument> option;
        block6: {
            Seq seq;
            Seq seq2;
            block5: {
                block4: {
                    seq2 = this.options().map((Function1)new $anonfun$descriptions$1(this));
                    option = this.argList();
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    Argument argument = (Argument)some.x();
                    if (argument == null) {
                        throw new MatchError(option);
                    }
                    Argument x = argument;
                    seq = List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{new StringBuilder().append((Object)x.valueName()).append((Object)this.NLTB()).append((Object)x.description()).toString()}));
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option<Argument> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                seq = this.arguments().map((Function1)new $anonfun$descriptions$2(this));
            }
            return seq2.$plus$plus((Iterable)seq);
        }
        throw new MatchError(option);
    }

    public void arglist(String name, String description, Function1<String, Object> action) {
        this.add(new Argument(name, description, true, action));
    }

    public void arg(String name, String description, Function1<String, Object> action) {
        this.add(new Argument(name, description, false, action));
    }

    public void separator(String description) {
        this.add(new SeparatorDefinition(description));
    }

    public void help(Option<String> shortopt, String longopt, String description) {
        this.add(new FlagOptionDefinition(shortopt, longopt, description, new $anonfun$help$2(this)));
    }

    public void help(String shortopt, String longopt, String description) {
        this.add(new FlagOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, description, new $anonfun$help$1(this)));
    }

    public void keyBooleanValueOpt(Option<String> shortopt, String longopt, String keyName, String valueName, String description, Function2<String, Boolean, Object> action) {
        this.add(new KeyBooleanValueArgOptionDefinition(shortopt, longopt, keyName, valueName, description, action));
    }

    public void keyBooleanValueOpt(String shortopt, String longopt, String keyName, String valueName, String description, Function2<String, Boolean, Object> action) {
        this.add(new KeyBooleanValueArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, keyName, valueName, description, action));
    }

    public void keyBooleanValueOpt(String longopt, String description, Function2<String, Boolean, Object> action) {
        this.add(new KeyBooleanValueArgOptionDefinition((Option<String>)None$.MODULE$, longopt, this.defaultKeyName(), this.defaultValueName(), description, action));
    }

    public void keyBooleanValueOpt(String shortopt, String longopt, String description, Function2<String, Boolean, Object> action) {
        this.add(new KeyBooleanValueArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, this.defaultKeyName(), this.defaultValueName(), description, action));
    }

    public void keyDoubleValueOpt(Option<String> shortopt, String longopt, String keyName, String valueName, String description, Function2<String, Double, Object> action) {
        this.add(new KeyDoubleValueArgOptionDefinition(shortopt, longopt, keyName, valueName, description, action));
    }

    public void keyDoubleValueOpt(String shortopt, String longopt, String keyName, String valueName, String description, Function2<String, Double, Object> action) {
        this.add(new KeyDoubleValueArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, keyName, valueName, description, action));
    }

    public void keyDoubleValueOpt(String longopt, String description, Function2<String, Double, Object> action) {
        this.add(new KeyDoubleValueArgOptionDefinition((Option<String>)None$.MODULE$, longopt, this.defaultKeyName(), this.defaultValueName(), description, action));
    }

    public void keyDoubleValueOpt(String shortopt, String longopt, String description, Function2<String, Double, Object> action) {
        this.add(new KeyDoubleValueArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, this.defaultKeyName(), this.defaultValueName(), description, action));
    }

    public void keyIntValueOpt(Option<String> shortopt, String longopt, String keyName, String valueName, String description, Function2<String, Integer, Object> action) {
        this.add(new KeyIntValueArgOptionDefinition(shortopt, longopt, keyName, valueName, description, action));
    }

    public void keyIntValueOpt(String shortopt, String longopt, String keyName, String valueName, String description, Function2<String, Integer, Object> action) {
        this.add(new KeyIntValueArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, keyName, valueName, description, action));
    }

    public void keyIntValueOpt(String longopt, String description, Function2<String, Integer, Object> action) {
        this.add(new KeyIntValueArgOptionDefinition((Option<String>)None$.MODULE$, longopt, this.defaultKeyName(), this.defaultValueName(), description, action));
    }

    public void keyIntValueOpt(String shortopt, String longopt, String description, Function2<String, Integer, Object> action) {
        this.add(new KeyIntValueArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, this.defaultKeyName(), this.defaultValueName(), description, action));
    }

    public void keyValueOpt(Option<String> shortopt, String longopt, String keyName, String valueName, String description, Function2<String, String, Object> action) {
        this.add(new KeyValueArgOptionDefinition(shortopt, longopt, keyName, valueName, description, action));
    }

    public void keyValueOpt(String shortopt, String longopt, String keyName, String valueName, String description, Function2<String, String, Object> action) {
        this.add(new KeyValueArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, keyName, valueName, description, action));
    }

    public void keyValueOpt(String longopt, String description, Function2<String, String, Object> action) {
        this.add(new KeyValueArgOptionDefinition((Option<String>)None$.MODULE$, longopt, this.defaultKeyName(), this.defaultValueName(), description, action));
    }

    public void keyValueOpt(String shortopt, String longopt, String description, Function2<String, String, Object> action) {
        this.add(new KeyValueArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, this.defaultKeyName(), this.defaultValueName(), description, action));
    }

    public void booleanOpt(Option<String> shortopt, String longopt, String valueName, String description, Function1<Boolean, Object> action) {
        this.add(new BooleanArgOptionDefinition(shortopt, longopt, valueName, description, action));
    }

    public void booleanOpt(String shortopt, String longopt, String valueName, String description, Function1<Boolean, Object> action) {
        this.add(new BooleanArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, valueName, description, action));
    }

    public void booleanOpt(String longopt, String description, Function1<Boolean, Object> action) {
        this.add(new BooleanArgOptionDefinition((Option<String>)None$.MODULE$, longopt, this.defaultValueName(), description, action));
    }

    public void booleanOpt(String shortopt, String longopt, String description, Function1<Boolean, Object> action) {
        this.add(new BooleanArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, this.defaultValueName(), description, action));
    }

    public void doubleOpt(Option<String> shortopt, String longopt, String valueName, String description, Function1<Double, Object> action) {
        this.add(new DoubleArgOptionDefinition(shortopt, longopt, valueName, description, action));
    }

    public void doubleOpt(String shortopt, String longopt, String valueName, String description, Function1<Double, Object> action) {
        this.add(new DoubleArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, valueName, description, action));
    }

    public void doubleOpt(String longopt, String description, Function1<Double, Object> action) {
        this.add(new DoubleArgOptionDefinition((Option<String>)None$.MODULE$, longopt, this.defaultValueName(), description, action));
    }

    public void doubleOpt(String shortopt, String longopt, String description, Function1<Double, Object> action) {
        this.add(new DoubleArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, this.defaultValueName(), description, action));
    }

    public void intOpt(Option<String> shortopt, String longopt, String valueName, String description, Function1<Integer, Object> action) {
        this.add(new IntArgOptionDefinition(shortopt, longopt, valueName, description, action));
    }

    public void intOpt(String shortopt, String longopt, String valueName, String description, Function1<Integer, Object> action) {
        this.add(new IntArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, valueName, description, action));
    }

    public void intOpt(String longopt, String description, Function1<Integer, Object> action) {
        this.add(new IntArgOptionDefinition((Option<String>)None$.MODULE$, longopt, this.defaultValueName(), description, action));
    }

    public void intOpt(String shortopt, String longopt, String description, Function1<Integer, Object> action) {
        this.add(new IntArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, this.defaultValueName(), description, action));
    }

    public void opt(String longopt, String description, Function0<Object> action) {
        this.add(new FlagOptionDefinition((Option<String>)None$.MODULE$, longopt, description, action));
    }

    public void opt(String shortopt, String longopt, String description, Function0<Object> action) {
        this.add(new FlagOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, description, action));
    }

    public void opt(Option<String> shortopt, String longopt, String valueName, String description, Function1<String, Object> action) {
        this.add(new ArgOptionDefinition(shortopt, longopt, valueName, description, action));
    }

    public void opt(String shortopt, String longopt, String valueName, String description, Function1<String, Object> action) {
        this.add(new ArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, valueName, description, action));
    }

    public void opt(String longopt, String description, Function1<String, Object> action) {
        this.add(new ArgOptionDefinition((Option<String>)None$.MODULE$, longopt, this.defaultValueName(), description, action));
    }

    public void opt(String shortopt, String longopt, String description, Function1<String, Object> action) {
        this.add(new ArgOptionDefinition((Option<String>)new Some((Object)shortopt), longopt, this.defaultValueName(), description, action));
    }

    public void add(OptionDefinition option) {
        OptionDefinition optionDefinition = option;
        if (optionDefinition instanceof Argument) {
            Argument argument = (Argument)optionDefinition;
            Argument a = argument;
            if (a.allowMultiple()) {
                this.argList_$eq((Option<Argument>)new Some((Object)a));
            } else {
                this.arguments().$plus$eq((Object)a);
            }
        } else {
            this.options().$plus$eq((Object)option);
        }
    }

    public void argList_$eq(Option<Argument> x$1) {
        this.argList = x$1;
    }

    public Option<Argument> argList() {
        return this.argList;
    }

    public String defaultValueName() {
        return this.defaultValueName;
    }

    public String defaultKeyName() {
        return this.defaultKeyName;
    }

    public String NLNL() {
        return this.NLNL;
    }

    public String NLTB() {
        return this.NLTB;
    }

    public String TB() {
        return this.TB;
    }

    public String NL() {
        return this.NL;
    }

    public ListBuffer<Argument> arguments() {
        return this.arguments;
    }

    public ListBuffer<OptionDefinition> options() {
        return this.options;
    }

    public OptionParser(String programName, boolean errorOnUnknownArgument) {
        this((Option<String>)new Some((Object)programName), (Option<String>)None$.MODULE$, errorOnUnknownArgument);
    }

    public OptionParser(boolean errorOnUnknownArgument) {
        this((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, errorOnUnknownArgument);
    }

    public OptionParser(String programName, String version) {
        this((Option<String>)new Some((Object)programName), (Option<String>)new Some((Object)version), true);
    }

    public OptionParser(String programName) {
        this((Option<String>)new Some((Object)programName), (Option<String>)None$.MODULE$, true);
    }

    public OptionParser() {
        this((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, true);
    }

    public boolean errorOnUnknownArgument() {
        return this.errorOnUnknownArgument;
    }

    public Option<String> version() {
        return this.version;
    }

    public Option<String> programName() {
        return this.programName;
    }
}

