/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.avro.mojo;

import java.io.File;
import java.util.Objects;

public class AvroFileRef
implements Comparable<AvroFileRef> {
    private final File root;
    private final String path;

    public AvroFileRef(File file, String string) {
        this.root = file;
        this.path = string;
    }

    public File getFile() {
        return new File(this.root, this.path);
    }

    public String pathToClassName() {
        String string = this.path;
        if (string.endsWith(".avsc")) {
            string = string.substring(0, string.length() - 5);
        }
        return string.replace("/", ".");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AvroFileRef avroFileRef = (AvroFileRef)object;
        return Objects.equals(this.root, avroFileRef.root) && Objects.equals(this.path, avroFileRef.path);
    }

    public int hashCode() {
        return Objects.hash(this.root, this.path);
    }

    public String toString() {
        return this.getFile().toString();
    }

    @Override
    public int compareTo(AvroFileRef avroFileRef) {
        int n = this.root.compareTo(avroFileRef.root);
        if (n == 0) {
            n = this.path.compareTo(avroFileRef.path);
        }
        return n;
    }
}

