/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal.listeners;

import com.github.sbt.junit.jupiter.api.JupiterTestListener;
import com.github.sbt.junit.jupiter.internal.ColorTheme;
import com.github.sbt.junit.jupiter.internal.Configuration;
import com.github.sbt.junit.jupiter.internal.TestLogger;
import java.util.Objects;
import java.util.Optional;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class TreePrintingTestListener
implements JupiterTestListener {
    private TestPlan testPlan;
    private final TestLogger logger;
    private final ColorTheme colorTheme;
    private final Configuration configuration;
    private String indent = "";

    public TreePrintingTestListener(Configuration configuration) {
        this.colorTheme = configuration.getColorTheme();
        this.configuration = configuration;
        this.logger = configuration.getLogger();
    }

    @Override
    public void executionFailed(String string, Throwable throwable) {
        String string2 = "Execution of test " + string + " failed: " + throwable.getMessage();
        this.logger.error(string, string2, throwable);
    }

    @Override
    public void executionFiltered(TestDescriptor testDescriptor, String string) {
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
    }

    public void executionSkipped(TestIdentifier testIdentifier, String string) {
        this.maybeIncreaseIndent(testIdentifier);
        String string2 = this.colorTheme.info().format(testIdentifier.getDisplayName());
        String string3 = testIdentifier.isTest() ? this.colorTheme.ignoreCount().format("o ") : "";
        this.log(string3 + string2);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.maybeIncreaseIndent(testIdentifier);
        String string = this.colorTheme.info().format(testIdentifier.getDisplayName());
        String string2 = testIdentifier.isTest() ? this.colorTheme.successful().format("+ ") : "";
        this.log(string2 + string);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Throwable throwable = testExecutionResult.getThrowable().orElse(null);
        switch (testExecutionResult.getStatus()) {
            case ABORTED: {
                String string = this.configuration.buildErrorName(testIdentifier);
                String string2 = this.configuration.buildErrorMessage(throwable);
                string2 = "Test assumption in test " + string + " failed: " + string2;
                this.logger.warn(string2, new Object[0]);
                break;
            }
            case FAILED: {
                String string = this.configuration.buildErrorName(testIdentifier);
                String string3 = this.configuration.buildErrorMessage(throwable);
                string3 = "Test " + string + " failed: " + string3;
                this.logger.error(this.configuration.extractClassName(testIdentifier), string3, throwable);
                break;
            }
            case SUCCESSFUL: {
                String string = testIdentifier.getLegacyReportingName();
                String string4 = "Test " + string + " finished";
                this.logger.debug(string4, new Object[0]);
            }
        }
        this.maybeDecreaseIndent(testIdentifier);
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry reportEntry) {
    }

    private void maybeIncreaseIndent(TestIdentifier testIdentifier) {
        if (this.hasParentContainer(testIdentifier)) {
            this.indent = this.indent + "  ";
        }
    }

    private void maybeDecreaseIndent(TestIdentifier testIdentifier) {
        if (this.hasParentContainer(testIdentifier)) {
            this.indent = this.indent.length() > 1 ? this.indent.substring(2) : "";
        }
    }

    private boolean hasParentContainer(TestIdentifier testIdentifier2) {
        return Optional.of(testIdentifier2).flatMap(arg_0 -> ((TestPlan)this.testPlan).getParent(arg_0)).filter(Objects::nonNull).filter(TestIdentifier::isContainer).map(testIdentifier -> true).orElse(false);
    }

    private void log(String string) {
        this.logger.info(this.indent + string, new Object[0]);
    }
}

