/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import com.novocode.junit.EventDispatcher;
import com.novocode.junit.GlobFilter;
import com.novocode.junit.JUnitFingerprint;
import com.novocode.junit.JUnitRunner;
import com.novocode.junit.RichLogger;
import com.novocode.junit.RunSettings;
import com.novocode.junit.SilentFilterRequest;
import com.novocode.junit.TestFilter;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.experimental.categories.Categories;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Logger;
import sbt.testing.Task;
import sbt.testing.TaskDef;

final class JUnitTask
implements Task {
    private static final Fingerprint JUNIT_FP = new JUnitFingerprint();
    private final JUnitRunner runner;
    private final RunSettings settings;
    private final TaskDef taskDef;

    public JUnitTask(JUnitRunner jUnitRunner, RunSettings runSettings, TaskDef taskDef) {
        this.runner = jUnitRunner;
        this.settings = runSettings;
        this.taskDef = taskDef;
    }

    public String[] tags() {
        return new String[0];
    }

    public TaskDef taskDef() {
        return this.taskDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task[] execute(EventHandler eventHandler, Logger[] loggerArray) {
        Fingerprint fingerprint = this.taskDef.fingerprint();
        String string = this.taskDef.fullyQualifiedName();
        Description description = Description.createSuiteDescription((String)string, (Annotation[])new Annotation[0]);
        RichLogger richLogger = new RichLogger(loggerArray, this.settings, string);
        EventDispatcher eventDispatcher = new EventDispatcher(richLogger, eventHandler, this.settings, fingerprint, description, this.runner.runStatistics);
        JUnitCore jUnitCore = new JUnitCore();
        jUnitCore.addListener((RunListener)eventDispatcher);
        this.runner.runListeners.forEach(arg_0 -> ((JUnitCore)jUnitCore).addListener(arg_0));
        Map<String, Object> map = this.settings.overrideSystemProperties();
        try {
            try {
                Class<?> clazz = this.runner.testClassLoader.loadClass(string);
                if (this.shouldRun(fingerprint, clazz, this.settings)) {
                    Request request = Request.classes((Class[])new Class[]{clazz});
                    if (this.settings.globPatterns.size() > 0) {
                        request = new SilentFilterRequest(request, new GlobFilter(this.settings, this.settings.globPatterns));
                    }
                    if (this.settings.testFilter.length() > 0) {
                        request = new SilentFilterRequest(request, new TestFilter(this.settings.testFilter, eventDispatcher));
                    }
                    if (!this.settings.includeCategories.isEmpty() || !this.settings.excludeCategories.isEmpty()) {
                        request = new SilentFilterRequest(request, (Filter)Categories.CategoryFilter.categoryFilter((boolean)true, JUnitTask.loadClasses(this.runner.testClassLoader, this.settings.includeCategories), (boolean)true, JUnitTask.loadClasses(this.runner.testClassLoader, this.settings.excludeCategories)));
                    }
                    jUnitCore.run(request);
                }
            }
            catch (Exception exception) {
                eventDispatcher.testExecutionFailed(string, exception);
            }
        }
        finally {
            this.settings.restoreSystemProperties(map);
        }
        return new Task[0];
    }

    private boolean shouldRun(Fingerprint fingerprint, Class<?> clazz, RunSettings runSettings) {
        if (JUNIT_FP.equals(fingerprint)) {
            if (TestCase.class.isAssignableFrom(clazz)) {
                return false;
            }
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(RunWith.class)) continue;
                return false;
            }
            return true;
        }
        RunWith runWith = clazz.getAnnotation(RunWith.class);
        if (runWith != null) {
            return !runSettings.ignoreRunner(runWith.value().getName());
        }
        return true;
    }

    private static Set<Class<?>> loadClasses(ClassLoader classLoader, Set<String> set) throws ClassNotFoundException {
        HashSet hashSet = new HashSet();
        for (String string : set) {
            hashSet.add(classLoader.loadClass(string));
        }
        return hashSet;
    }
}

