/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit.jupiter;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.test.context.junit.jupiter.MethodParameterFactory;

abstract class ParameterAutowireUtils {
    private ParameterAutowireUtils() {
    }

    public static boolean isAutowirable(Parameter parameter) {
        return ApplicationContext.class.isAssignableFrom(parameter.getType()) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)parameter, Autowired.class) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)parameter, Qualifier.class) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)parameter, Value.class);
    }

    public static Object resolveDependency(Parameter parameter, Class<?> containingClass, ApplicationContext applicationContext) {
        boolean required = ParameterAutowireUtils.findMergedAnnotation(parameter, Autowired.class).map(Autowired::required).orElse(true);
        SynthesizingMethodParameter methodParameter = parameter.getDeclaringExecutable() instanceof Method ? MethodParameterFactory.createSynthesizingMethodParameter(parameter) : MethodParameterFactory.createMethodParameter(parameter);
        DependencyDescriptor descriptor = new DependencyDescriptor((MethodParameter)methodParameter, required);
        descriptor.setContainingClass(containingClass);
        return applicationContext.getAutowireCapableBeanFactory().resolveDependency(descriptor, null);
    }

    private static <A extends Annotation> Optional<A> findMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, annotationType));
    }
}

