/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit.jupiter;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.util.Assert;

abstract class MethodParameterFactory {
    private MethodParameterFactory() {
    }

    public static MethodParameter createMethodParameter(Parameter parameter) {
        Assert.notNull((Object)parameter, (String)"Parameter must not be null");
        Executable executable = parameter.getDeclaringExecutable();
        if (executable instanceof Method) {
            return new MethodParameter((Method)executable, MethodParameterFactory.getIndex(parameter));
        }
        return new MethodParameter((Constructor)executable, MethodParameterFactory.getIndex(parameter));
    }

    public static SynthesizingMethodParameter createSynthesizingMethodParameter(Parameter parameter) {
        Assert.notNull((Object)parameter, (String)"Parameter must not be null");
        Executable executable = parameter.getDeclaringExecutable();
        if (executable instanceof Method) {
            return new SynthesizingMethodParameter((Method)executable, MethodParameterFactory.getIndex(parameter));
        }
        throw new UnsupportedOperationException("Cannot create a SynthesizingMethodParameter for a constructor parameter: " + parameter);
    }

    private static int getIndex(Parameter parameter) {
        Assert.notNull((Object)parameter, (String)"Parameter must not be null");
        Executable executable = parameter.getDeclaringExecutable();
        Parameter[] parameters = executable.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] != parameter) continue;
            return i;
        }
        throw new IllegalStateException(String.format("Failed to resolve index of parameter [%s] in executable [%s]", parameter, executable.toGenericString()));
    }
}

