/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.io.File;
import org.apache.commons.lang3.ArrayUtils;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.process.ProcessManager;

class OfficeProcessConfig {
    public static final boolean DEFAULT_KILL_EXISTING_PROCESS = true;
    private File officeHome;
    private File workingDir;
    private ProcessManager processManager;
    private String[] runAsArgs;
    private File templateProfileDir;
    private boolean killExistingProcess = true;

    public OfficeProcessConfig() {
        this(null, null, null);
    }

    public OfficeProcessConfig(File officeHome, File workingDir, ProcessManager processManager) {
        this.officeHome = officeHome == null ? LocalOfficeUtils.getDefaultOfficeHome() : officeHome;
        this.workingDir = workingDir == null ? new File(System.getProperty("java.io.tmpdir")) : workingDir;
        this.processManager = processManager == null ? LocalOfficeUtils.findBestProcessManager() : processManager;
    }

    public File getOfficeHome() {
        return this.officeHome;
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public String[] getRunAsArgs() {
        return (String[])ArrayUtils.clone((Object[])this.runAsArgs);
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public File getTemplateProfileDir() {
        return this.templateProfileDir;
    }

    public boolean isKillExistingProcess() {
        return this.killExistingProcess;
    }

    public void setOfficeHome(File officeHome) {
        this.officeHome = officeHome;
    }

    public void setProcessManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public void setRunAsArgs(String ... runAsArgs) {
        this.runAsArgs = (String[])ArrayUtils.clone((Object[])runAsArgs);
    }

    public void setTemplateProfileDir(File templateProfileDir) {
        this.templateProfileDir = templateProfileDir;
    }

    public void setKillExistingProcess(boolean killExistingProcess) {
        this.killExistingProcess = killExistingProcess;
    }
}

