/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.netinject;

import com.github.sarxos.winreg.HKey;
import com.github.sarxos.winreg.RegistryException;
import com.github.sarxos.winreg.WindowsRegistry;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetFramework {
    private static final String NET_FRAMEWORK_KEY = "SOFTWARE\\Microsoft\\.NETFramework";
    public static final String INSTALL_ROOT = NetFramework.getFrameworksDirectory();
    private String version = null;
    private File directory = null;

    public NetFramework(String version) {
        this.version = version;
    }

    private static String getFrameworksDirectory() {
        try {
            return WindowsRegistry.getInstance().readString(HKey.HKLM, NET_FRAMEWORK_KEY, "InstallRoot");
        }
        catch (RegistryException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<NetFramework> getFrameworks() {
        File directory = new File(INSTALL_ROOT);
        File[] directories = directory.listFiles(new NetDirectoryFilter());
        ArrayList<NetFramework> frameworks = new ArrayList<NetFramework>();
        for (File d : directories) {
            frameworks.add(new NetFramework(d.getName()));
        }
        return Collections.unmodifiableList(frameworks);
    }

    public String getVersion() {
        return this.version;
    }

    public String getSimpleVersion() {
        return NetFramework.getSimpleVersion(this.version);
    }

    public static String getSimpleVersion(String version) {
        return version.substring(1, 4);
    }

    public static NetFramework getFramework(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null");
        }
        for (NetFramework nf : NetFramework.getFrameworks()) {
            if (!(version.startsWith("v") ? version.equals(nf.getVersion()) : version.equals(nf.getSimpleVersion()))) continue;
            return nf;
        }
        return null;
    }

    public File getDirectory() {
        if (this.directory == null) {
            this.directory = new File(INSTALL_ROOT + "/" + this.getVersion());
        }
        return this.directory;
    }

    private static class NetDirectoryFilter
    implements FilenameFilter {
        private NetDirectoryFilter() {
        }

        public boolean accept(File directory, String fileName) {
            File file = new File(directory + "/" + fileName);
            return file.isDirectory() && file.getName().startsWith("v");
        }
    }
}

