/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.netinject;

import com.github.sarxos.netinject.InjectorRuntimeException;
import com.github.sarxos.netinject.InjectorUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.zip.ZipException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Injector {
    private static final String X64_BOOTSTRAP_BIN = "bootstrap64.bin";
    private static final String X32_BOOTSTRAP_BIN = "bootstrap32.bin";
    private static final String INJECTDLL_EXE = "injectdll.exe";
    private static final String X86_RUNNER_EXE = "x86runner.exe";
    private static final String TESTINJECTEE_20_EXE = "test20.dll";
    private static final Logger LOG = LoggerFactory.getLogger(Injector.class);
    private static Injector instance = new Injector();
    private File x64bootstrapBin = null;
    private File x32bootstrapBin = null;
    private File injectdllExe = null;
    private File x86runnerExe = null;
    private File testinjecteeDll = null;
    private boolean initialized = false;

    private File getFile(String name) {
        try {
            return new File(InjectorUtils.resourceToLocalURI(name, Injector.class));
        }
        catch (ZipException e) {
            throw new InjectorRuntimeException(e);
        }
        catch (IOException e) {
            throw new InjectorRuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new InjectorRuntimeException(e);
        }
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        if (this.injectdllExe == null) {
            this.injectdllExe = this.getFile(INJECTDLL_EXE);
        }
        if (this.x32bootstrapBin == null) {
            this.x32bootstrapBin = this.getFile(X32_BOOTSTRAP_BIN);
        }
        if (this.x64bootstrapBin == null) {
            this.x64bootstrapBin = this.getFile(X64_BOOTSTRAP_BIN);
        }
        if (this.x86runnerExe == null) {
            this.x86runnerExe = this.getFile(X86_RUNNER_EXE);
        }
        if (this.testinjecteeDll == null) {
            this.testinjecteeDll = this.getFile(TESTINJECTEE_20_EXE);
        }
        this.initialized = true;
    }

    public static Injector getInstance() {
        return instance;
    }

    public boolean test(int pid) {
        this.initialize();
        return this.inject(pid, this.testinjecteeDll, "Test.Program.Main");
    }

    public boolean inject(int pid, File dll, String signature) {
        this.initialize();
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.injectdllExe.getAbsolutePath());
        command.add(String.format("--proc-id=%s", pid));
        command.add(String.format("--dll-path=%s", dll.getAbsolutePath()));
        command.add(String.format("--signature=%s", signature));
        command.add(String.format("--x86-runner-path=%s", this.x86runnerExe.getAbsolutePath()));
        command.add(String.format("--x64-bootstrap-path=%s", this.x64bootstrapBin.getAbsolutePath()));
        command.add(String.format("--x32-bootstrap-path=%s", this.x32bootstrapBin.getAbsolutePath()));
        if (LOG.isDebugEnabled()) {
            command.add("--verbose");
        }
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
            process.getOutputStream().close();
        }
        catch (IOException e) {
            throw new InjectorRuntimeException(e);
        }
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                LOG.info(String.format("NATIVE: %s", line));
            }
        }
        catch (IOException e) {
            throw new InjectorRuntimeException(e);
        }
        return true;
    }
}

