/*
 * Decompiled with CFR 0.152.
 */
package com.sarnava.textwriter;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.annotation.Nullable;

public class TextWriter
extends View {
    private Paint paint;
    private Path path;
    private int DELAY = 20;
    private int step;
    private int currentPosition;
    private float screenWidth;
    private float screenHeight;
    private float VERTICAL_BOUND = 100.0f;
    private float HORIZONTAL_BOUND;
    private float GAP = 50.0f;
    private float x;
    private float y;
    private float sweepAngle;
    private float centreX;
    private float centreY;
    private boolean hasDrawingStarted;
    private boolean startAnimationCalled;
    private String text;
    private char currentCharacter;
    private Configuration config = Configuration.RECTANGLE;
    private Listener listener;

    public TextWriter(Context context) {
        super(context);
        this.init(null);
    }

    public TextWriter(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public TextWriter(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(@Nullable AttributeSet attrs) {
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(10.0f);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint.setColor(-16777216);
        this.path = new Path();
    }

    public TextWriter setColor(int color) {
        this.paint.setColor(color);
        return this;
    }

    public TextWriter setWidth(float width) {
        this.paint.setStrokeWidth(width);
        return this;
    }

    public TextWriter setDelay(int delay) {
        this.DELAY = delay;
        return this;
    }

    public TextWriter setSizeFactor(float sizeFactor) {
        this.VERTICAL_BOUND = sizeFactor;
        return this;
    }

    public TextWriter setLetterSpacing(float spacing) {
        this.GAP = spacing;
        return this;
    }

    public TextWriter setConfig(Configuration config) {
        this.config = config;
        return this;
    }

    public TextWriter setText(String text) {
        this.text = text;
        return this;
    }

    public TextWriter setListener(Listener listener) {
        this.listener = listener;
        return this;
    }

    protected void onDraw(Canvas canvas) {
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        if (!this.hasDrawingStarted) {
            if (this.startAnimationCalled) {
                this.startAnimation();
            }
            return;
        }
        this.continueDrawing();
        canvas.drawPath(this.path, this.paint);
        this.postInvalidateDelayed(this.DELAY);
    }

    public void startAnimation() throws RuntimeException {
        this.startAnimationCalled = true;
        if (this.screenWidth <= 0.0f || this.screenHeight <= 0.0f) {
            Log.e((String)"boom", (String)"called invalidate() to calculate screenWidth and screenHeight");
            this.invalidate();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.text)) {
            throw new RuntimeException("Text is null or empty");
        }
        this.HORIZONTAL_BOUND = this.config == Configuration.SQUARE ? this.VERTICAL_BOUND : (this.config == Configuration.RECTANGLE ? this.VERTICAL_BOUND / 2.0f : 3.0f * this.VERTICAL_BOUND / 4.0f);
        float totalLetterWidth = 0.0f;
        for (int i = 0; i < this.text.length(); ++i) {
            if (!Character.isUpperCase(this.text.charAt(i)) && !Character.isSpaceChar(this.text.charAt(i))) {
                throw new RuntimeException("Text does not follow rules");
            }
            if (i == 0 && Character.isSpaceChar(this.text.charAt(i))) {
                throw new RuntimeException("First character cannot be a whitespace");
            }
            if (i == this.text.length() - 1 && Character.isSpaceChar(this.text.charAt(i))) {
                throw new RuntimeException("Last character cannot be a whitespace");
            }
            if (this.text.charAt(i) == 'I') {
                totalLetterWidth += 0.0f;
                continue;
            }
            if (this.text.charAt(i) == ' ') {
                totalLetterWidth += this.HORIZONTAL_BOUND;
                continue;
            }
            if (this.text.charAt(i) == 'C' || this.text.charAt(i) == 'G') {
                totalLetterWidth = (float)((double)totalLetterWidth + ((double)this.HORIZONTAL_BOUND + (double)this.HORIZONTAL_BOUND * Math.cos(-5.497787143782138)));
                continue;
            }
            if (this.text.charAt(i) == 'J' || this.text.charAt(i) == 'U' || this.text.charAt(i) == 'L') {
                totalLetterWidth += 3.0f * this.HORIZONTAL_BOUND / 2.0f;
                continue;
            }
            totalLetterWidth += 2.0f * this.HORIZONTAL_BOUND;
        }
        int letters = this.text.replaceAll(" ", "").length();
        float totalWidth = totalLetterWidth + this.GAP * (float)(letters - 1);
        float startX = (this.screenWidth - totalWidth) / 2.0f;
        float endX = (this.screenWidth + totalWidth) / 2.0f;
        this.centreY = this.screenHeight / 2.0f;
        this.currentPosition = 0;
        this.currentCharacter = this.text.charAt(this.currentPosition);
        this.hasDrawingStarted = true;
        this.centreX = this.currentCharacter == 'I' ? startX : (this.currentCharacter == ' ' ? startX + this.HORIZONTAL_BOUND / 2.0f : (this.currentCharacter == 'J' || this.currentCharacter == 'U' || this.currentCharacter == 'L' ? startX + 3.0f * this.HORIZONTAL_BOUND / 4.0f : startX + this.HORIZONTAL_BOUND));
        Log.e((String)"boom", (String)(startX + "  -  " + endX + "  -  " + this.screenWidth));
        this.startDrawing();
    }

    private void startDrawingA() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY + this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingB() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY + this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.sweepAngle = 0.0f;
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingC() {
        this.sweepAngle = 0.0f;
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingD() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY + this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.sweepAngle = 0.0f;
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingE() {
        this.x = this.centreX + this.HORIZONTAL_BOUND;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingF() {
        this.x = this.centreX + this.HORIZONTAL_BOUND;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingG() {
        this.sweepAngle = 0.0f;
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingH() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingI() {
        this.x = this.centreX;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingJ() {
        this.x = this.centreX + 3.0f * this.HORIZONTAL_BOUND / 4.0f;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.sweepAngle = 0.0f;
        this.invalidate();
    }

    private void startDrawingK() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingL() {
        this.x = this.centreX - 3.0f * this.HORIZONTAL_BOUND / 4.0f;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingM() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY + this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingN() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY + this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingO() {
        this.sweepAngle = 0.0f;
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingP() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY + this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.sweepAngle = 0.0f;
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingQ() {
        this.sweepAngle = 0.0f;
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingR() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY + this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.sweepAngle = 0.0f;
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingS() {
        this.sweepAngle = 0.0f;
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingT() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingU() {
        this.x = this.centreX - 3.0f * this.HORIZONTAL_BOUND / 4.0f;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.sweepAngle = 0.0f;
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingV() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingW() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingX() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingY() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingZ() {
        this.x = this.centreX - this.HORIZONTAL_BOUND;
        this.y = this.centreY - this.VERTICAL_BOUND;
        this.path.moveTo(this.x, this.y);
        this.step = 1;
        this.invalidate();
    }

    private void startDrawingSpace() {
        this.adjust();
    }

    private void drawA() {
        if (this.step == 1) {
            if (this.x > this.centreX - this.HORIZONTAL_BOUND / 8.0f && this.y < this.centreY - this.VERTICAL_BOUND) {
                this.x = this.centreX + this.HORIZONTAL_BOUND / 8.0f;
                this.y = this.centreY - this.VERTICAL_BOUND;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 4.0f - this.HORIZONTAL_BOUND / 32.0f;
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND && this.y > this.centreY + this.VERTICAL_BOUND) {
                this.x = this.centreX - this.HORIZONTAL_BOUND / 2.0f;
                this.y = this.centreY;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 4.0f - this.HORIZONTAL_BOUND / 32.0f;
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 3) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND / 2.0f) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
            }
        }
    }

    private void drawB() {
        if (this.step == 1) {
            if (this.y < this.centreY - this.VERTICAL_BOUND) {
                this.x = this.centreX;
                this.y = this.centreY - this.VERTICAL_BOUND;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.sweepAngle > 180.0f) {
                this.sweepAngle = 0.0f;
                this.x = this.centreX - this.HORIZONTAL_BOUND;
                this.y = this.centreY;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - this.HORIZONTAL_BOUND, this.centreY - this.VERTICAL_BOUND, this.centreX + this.HORIZONTAL_BOUND, this.centreY);
                this.path.addArc(rect, 270.0f, this.sweepAngle);
                this.sweepAngle += 45.0f;
            }
        } else if (this.step == 3) {
            if (this.sweepAngle > 180.0f) {
                this.sweepAngle = 0.0f;
                this.x = this.centreX - this.HORIZONTAL_BOUND;
                this.y = this.centreY + this.VERTICAL_BOUND;
                this.path.lineTo(this.x, this.y);
                ++this.step;
                this.adjust();
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - this.HORIZONTAL_BOUND, this.centreY, this.centreX + this.HORIZONTAL_BOUND, this.centreY + this.VERTICAL_BOUND);
                this.path.addArc(rect, 270.0f, this.sweepAngle);
                this.sweepAngle += 45.0f;
            }
        }
    }

    private void drawC() {
        if (this.step == 1) {
            if (this.sweepAngle < -270.0f) {
                ++this.step;
                this.adjust();
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - this.HORIZONTAL_BOUND, this.centreY - this.VERTICAL_BOUND, this.centreX + this.HORIZONTAL_BOUND, this.centreY + this.VERTICAL_BOUND);
                this.path.addArc(rect, -45.0f, this.sweepAngle);
                this.sweepAngle -= 45.0f;
            }
        }
    }

    private void drawD() {
        if (this.step == 1) {
            if (this.y < this.centreY - this.VERTICAL_BOUND) {
                this.y = this.centreY - this.VERTICAL_BOUND;
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.sweepAngle > 180.0f) {
                this.sweepAngle = 0.0f;
                ++this.step;
                this.adjust();
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - 3.0f * this.HORIZONTAL_BOUND, this.centreY - this.VERTICAL_BOUND, this.centreX + this.HORIZONTAL_BOUND, this.centreY + this.VERTICAL_BOUND);
                this.path.addArc(rect, 270.0f, this.sweepAngle);
                this.sweepAngle += 45.0f;
            }
        }
    }

    private void drawE() {
        if (this.step == 1) {
            if (this.x < this.centreX - this.HORIZONTAL_BOUND) {
                this.x = this.centreX - this.HORIZONTAL_BOUND;
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x -= this.HORIZONTAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.y > this.centreY + this.VERTICAL_BOUND) {
                this.y = this.centreY + this.VERTICAL_BOUND;
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 3) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND) {
                this.x = this.centreX - this.HORIZONTAL_BOUND;
                this.y = this.centreY;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
            }
        } else if (this.step == 4) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND / 2.0f) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
            }
        }
    }

    private void drawF() {
        if (this.step == 1) {
            if (this.x < this.centreX - this.HORIZONTAL_BOUND) {
                this.x = this.centreX - this.HORIZONTAL_BOUND;
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x -= this.HORIZONTAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.y > this.centreY + this.VERTICAL_BOUND) {
                this.y = this.centreY;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 3) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND / 2.0f) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
            }
        }
    }

    private void drawG() {
        if (this.step == 1) {
            if (this.sweepAngle < -270.0f) {
                this.x = (float)((double)this.centreX + (double)this.HORIZONTAL_BOUND * Math.cos(-5.497787143782138));
                this.y = (float)((double)this.centreY + (double)this.VERTICAL_BOUND * Math.sin(-5.497787143782138));
                ++this.step;
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - this.HORIZONTAL_BOUND, this.centreY - this.VERTICAL_BOUND, this.centreX + this.HORIZONTAL_BOUND, this.centreY + this.VERTICAL_BOUND);
                this.path.addArc(rect, -45.0f, this.sweepAngle);
                this.sweepAngle -= 45.0f;
            }
        } else if (this.step == 2) {
            if (this.y < this.centreY) {
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y -= this.VERTICAL_BOUND / 4.0f;
            }
        } else if (this.step == 3) {
            if (this.x < this.centreX) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x -= this.HORIZONTAL_BOUND / 2.0f;
            }
        }
    }

    private void drawH() {
        if (this.step == 1) {
            if (this.y > this.centreY + this.VERTICAL_BOUND) {
                this.y = this.centreY - this.VERTICAL_BOUND;
                this.x = this.centreX + this.HORIZONTAL_BOUND;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.y > this.centreY + this.VERTICAL_BOUND) {
                this.y = this.centreY;
                this.x = this.centreX - this.HORIZONTAL_BOUND;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 3) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
            }
        }
    }

    private void drawI() {
        if (this.step == 1) {
            if (this.y > this.centreY + this.VERTICAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawJ() {
        if (this.step == 1) {
            if (this.y > this.centreY + 3.0f * this.VERTICAL_BOUND / 4.0f) {
                this.y = this.centreY + 3.0f * this.VERTICAL_BOUND / 4.0f;
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.sweepAngle > 180.0f) {
                this.sweepAngle = 0.0f;
                ++this.step;
                this.adjust();
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - 3.0f * this.HORIZONTAL_BOUND / 4.0f, this.centreY, this.centreX + 3.0f * this.HORIZONTAL_BOUND / 4.0f, this.centreY + this.VERTICAL_BOUND);
                this.path.addArc(rect, 0.0f, this.sweepAngle);
                this.sweepAngle += 45.0f;
            }
        }
    }

    private void drawK() {
        if (this.step == 1) {
            if (this.y > this.centreY + this.VERTICAL_BOUND) {
                this.y = this.centreY;
                this.path.moveTo(this.x, this.y);
                this.x = this.centreX - this.HORIZONTAL_BOUND;
                this.y = this.centreY;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND && this.y < this.centreY - this.VERTICAL_BOUND) {
                this.x = this.centreX - this.HORIZONTAL_BOUND / 2.0f;
                this.y = this.centreY - this.VERTICAL_BOUND / 4.0f;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
                this.y -= this.VERTICAL_BOUND / 4.0f;
            }
        } else if (this.step == 3) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND && this.y > this.centreY + this.VERTICAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += 3.0f * this.HORIZONTAL_BOUND / 4.0f;
                this.y += 5.0f * this.VERTICAL_BOUND / 8.0f;
            }
        }
    }

    private void drawL() {
        if (this.step == 1) {
            if (this.y > this.centreY + this.VERTICAL_BOUND) {
                this.y = this.centreY + this.VERTICAL_BOUND;
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.x > this.centreX + 3.0f * this.HORIZONTAL_BOUND / 4.0f) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
            }
        }
    }

    private void drawM() {
        if (this.step == 1) {
            if (this.y < this.centreY - this.VERTICAL_BOUND) {
                this.y = this.centreY - this.VERTICAL_BOUND;
                this.x = this.centreX - this.HORIZONTAL_BOUND + this.HORIZONTAL_BOUND / 8.0f;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.x > this.centreX && this.y > this.centreY) {
                this.x = this.centreX;
                this.y = this.centreY;
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f - this.HORIZONTAL_BOUND / 16.0f;
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 3) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND - this.HORIZONTAL_BOUND / 8.0f && this.y < this.centreY - this.VERTICAL_BOUND) {
                this.x = this.centreX + this.HORIZONTAL_BOUND;
                this.y = this.centreY - this.VERTICAL_BOUND;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f - this.HORIZONTAL_BOUND / 16.0f;
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 4) {
            if (this.y > this.centreY + this.VERTICAL_BOUND) {
                this.y = this.centreY + this.VERTICAL_BOUND;
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawN() {
        if (this.step == 1) {
            if (this.y < this.centreY - this.VERTICAL_BOUND) {
                this.y = this.centreY - this.VERTICAL_BOUND;
                this.x = this.centreX - this.HORIZONTAL_BOUND + this.HORIZONTAL_BOUND / 8.0f;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND - this.HORIZONTAL_BOUND / 8.0f && this.y > this.centreY + this.VERTICAL_BOUND) {
                this.x = this.centreX + this.HORIZONTAL_BOUND;
                this.y = this.centreY + this.VERTICAL_BOUND;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f - this.HORIZONTAL_BOUND / 16.0f;
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 3) {
            if (this.y < this.centreY - this.VERTICAL_BOUND) {
                this.y = this.centreY - this.VERTICAL_BOUND;
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawO() {
        if (this.step == 1) {
            if (this.sweepAngle < -360.0f) {
                ++this.step;
                this.adjust();
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - this.HORIZONTAL_BOUND, this.centreY - this.VERTICAL_BOUND, this.centreX + this.HORIZONTAL_BOUND, this.centreY + this.VERTICAL_BOUND);
                this.path.addArc(rect, 0.0f, this.sweepAngle);
                this.sweepAngle -= 45.0f;
            }
        }
    }

    private void drawP() {
        if (this.step == 1) {
            if (this.y < this.centreY - this.VERTICAL_BOUND) {
                this.x = this.centreX;
                this.y = this.centreY - this.VERTICAL_BOUND;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.sweepAngle > 180.0f) {
                this.sweepAngle = 0.0f;
                this.x = this.centreX - this.HORIZONTAL_BOUND;
                this.y = this.centreY;
                this.path.lineTo(this.x, this.y);
                ++this.step;
                this.adjust();
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - this.HORIZONTAL_BOUND, this.centreY - this.VERTICAL_BOUND, this.centreX + this.HORIZONTAL_BOUND, this.centreY);
                this.path.addArc(rect, 270.0f, this.sweepAngle);
                this.sweepAngle += 45.0f;
            }
        }
    }

    private void drawQ() {
        if (this.step == 1) {
            if (this.sweepAngle < -360.0f) {
                this.x = this.centreX + this.HORIZONTAL_BOUND / 2.0f;
                this.y = this.centreY + this.VERTICAL_BOUND / 2.0f;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - this.HORIZONTAL_BOUND, this.centreY - this.VERTICAL_BOUND, this.centreX + this.HORIZONTAL_BOUND, this.centreY + this.VERTICAL_BOUND);
                this.path.addArc(rect, 0.0f, this.sweepAngle);
                this.sweepAngle -= 45.0f;
            }
        } else if (this.step == 2) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND && this.y > this.centreY + this.VERTICAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawR() {
        if (this.step == 1) {
            if (this.y < this.centreY - this.VERTICAL_BOUND) {
                this.x = this.centreX;
                this.y = this.centreY - this.VERTICAL_BOUND;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.sweepAngle > 180.0f) {
                this.sweepAngle = 0.0f;
                this.x = this.centreX - this.HORIZONTAL_BOUND;
                this.y = this.centreY;
                this.path.lineTo(this.x, this.y);
                this.x = this.centreX;
                this.y = this.centreY;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - this.HORIZONTAL_BOUND, this.centreY - this.VERTICAL_BOUND, this.centreX + this.HORIZONTAL_BOUND, this.centreY);
                this.path.addArc(rect, 270.0f, this.sweepAngle);
                this.sweepAngle += 45.0f;
            }
        } else if (this.step == 3) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND && this.y > this.centreY + this.VERTICAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawS() {
        if (this.step == 1) {
            if (this.sweepAngle < -270.0f) {
                this.sweepAngle = 0.0f;
                ++this.step;
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - this.HORIZONTAL_BOUND, this.centreY - this.VERTICAL_BOUND, this.centreX + this.HORIZONTAL_BOUND, this.centreY - this.VERTICAL_BOUND / 1024.0f);
                this.path.addArc(rect, 0.0f, this.sweepAngle);
                this.sweepAngle -= 45.0f;
            }
        } else if (this.step == 2) {
            if (this.sweepAngle > 270.0f) {
                ++this.step;
                this.adjust();
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - this.HORIZONTAL_BOUND, this.centreY + this.VERTICAL_BOUND / 1024.0f, this.centreX + this.HORIZONTAL_BOUND, this.centreY + this.VERTICAL_BOUND);
                this.path.addArc(rect, -90.0f, this.sweepAngle);
                this.sweepAngle += 45.0f;
            }
        }
    }

    private void drawT() {
        if (this.step == 1) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND) {
                this.x = this.centreX;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.y > this.centreY + this.VERTICAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawU() {
        if (this.step == 1) {
            if (this.y > this.centreY + this.VERTICAL_BOUND / 2.0f) {
                this.y = this.centreY + this.VERTICAL_BOUND / 2.0f;
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.sweepAngle < -180.0f) {
                this.x = this.centreX + 3.0f * this.HORIZONTAL_BOUND / 4.0f;
                this.sweepAngle = 0.0f;
                ++this.step;
            } else {
                RectF rect = new RectF();
                rect.set(this.centreX - 3.0f * this.HORIZONTAL_BOUND / 4.0f, this.centreY - this.VERTICAL_BOUND / 8.0f, this.centreX + 3.0f * this.HORIZONTAL_BOUND / 4.0f, this.centreY + this.VERTICAL_BOUND);
                this.path.addArc(rect, -180.0f, this.sweepAngle);
                this.sweepAngle -= 45.0f;
            }
        } else if (this.step == 3) {
            if (this.y < this.centreY - this.VERTICAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawV() {
        if (this.step == 1) {
            if (this.x > this.centreX - this.HORIZONTAL_BOUND / 8.0f && this.y > this.centreY + this.VERTICAL_BOUND) {
                this.x = this.centreX + this.HORIZONTAL_BOUND / 8.0f;
                this.y = this.centreY + this.VERTICAL_BOUND;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 4.0f - this.HORIZONTAL_BOUND / 32.0f;
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND && this.y < this.centreY + this.VERTICAL_BOUND / 2.0f) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 4.0f - this.HORIZONTAL_BOUND / 32.0f;
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawW() {
        if (this.step == 1) {
            if (this.x > this.centreX - this.HORIZONTAL_BOUND / 2.0f - this.HORIZONTAL_BOUND / 16.0f && this.y > this.centreY + this.VERTICAL_BOUND) {
                this.x = this.centreX - this.HORIZONTAL_BOUND / 2.0f + this.HORIZONTAL_BOUND / 16.0f;
                this.y = this.centreY + this.VERTICAL_BOUND;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 8.0f - this.HORIZONTAL_BOUND / 128.0f;
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            this.path.lineTo(this.centreX - this.HORIZONTAL_BOUND / 16.0f, this.centreY - this.VERTICAL_BOUND);
            this.path.lineTo(this.centreX + this.HORIZONTAL_BOUND / 16.0f, this.centreY - this.VERTICAL_BOUND);
            ++this.step;
        } else if (this.step == 3) {
            this.path.lineTo(this.centreX + this.HORIZONTAL_BOUND / 2.0f - this.HORIZONTAL_BOUND / 16.0f, this.centreY + this.VERTICAL_BOUND);
            this.x = this.centreX + this.HORIZONTAL_BOUND / 2.0f + this.HORIZONTAL_BOUND / 16.0f;
            this.y = this.centreY + this.VERTICAL_BOUND;
            this.path.lineTo(this.x, this.y);
            ++this.step;
        } else if (this.step == 4) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND && this.y < this.centreY - this.VERTICAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 8.0f - this.HORIZONTAL_BOUND / 128.0f;
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawX() {
        if (this.step == 1) {
            if (this.x > this.centreX - this.HORIZONTAL_BOUND && this.y > this.centreY + this.VERTICAL_BOUND) {
                this.x = this.centreX + this.HORIZONTAL_BOUND;
                this.y = this.centreY - this.VERTICAL_BOUND;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.x < this.centreX - this.HORIZONTAL_BOUND && this.y > this.centreY + this.VERTICAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x -= this.HORIZONTAL_BOUND / 2.0f;
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawY() {
        if (this.step == 1) {
            if (this.x > this.centreX && this.y > this.centreY) {
                this.x = this.centreX;
                this.y = this.centreY;
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND && this.y < this.centreY - this.VERTICAL_BOUND) {
                this.x = this.centreX;
                this.y = this.centreY;
                this.path.moveTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
                this.y -= this.VERTICAL_BOUND / 2.0f;
            }
        } else if (this.step == 3) {
            if (this.y > this.centreY + this.VERTICAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.y += this.VERTICAL_BOUND / 2.0f;
            }
        }
    }

    private void drawZ() {
        if (this.step == 1) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND) {
                this.x = this.centreX + this.HORIZONTAL_BOUND;
                this.y = this.centreY - this.VERTICAL_BOUND + this.VERTICAL_BOUND / 8.0f;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
            }
        } else if (this.step == 2) {
            if (this.x < this.centreX - this.HORIZONTAL_BOUND && this.y > this.centreY + this.VERTICAL_BOUND - this.VERTICAL_BOUND / 8.0f) {
                this.x = this.centreX - this.HORIZONTAL_BOUND;
                this.y = this.centreY + this.VERTICAL_BOUND;
                this.path.lineTo(this.x, this.y);
                ++this.step;
            } else {
                this.path.lineTo(this.x, this.y);
                this.x -= this.HORIZONTAL_BOUND / 2.0f;
                this.y += this.VERTICAL_BOUND / 2.0f - this.VERTICAL_BOUND / 16.0f;
            }
        } else if (this.step == 3) {
            if (this.x > this.centreX + this.HORIZONTAL_BOUND) {
                ++this.step;
                this.adjust();
            } else {
                this.path.lineTo(this.x, this.y);
                this.x += this.HORIZONTAL_BOUND / 2.0f;
            }
        }
    }

    private void startDrawing() {
        switch (this.currentCharacter) {
            case 'A': {
                this.startDrawingA();
                break;
            }
            case 'B': {
                this.startDrawingB();
                break;
            }
            case 'C': {
                this.startDrawingC();
                break;
            }
            case 'D': {
                this.startDrawingD();
                break;
            }
            case 'E': {
                this.startDrawingE();
                break;
            }
            case 'F': {
                this.startDrawingF();
                break;
            }
            case 'G': {
                this.startDrawingG();
                break;
            }
            case 'H': {
                this.startDrawingH();
                break;
            }
            case 'I': {
                this.startDrawingI();
                break;
            }
            case 'J': {
                this.startDrawingJ();
                break;
            }
            case 'K': {
                this.startDrawingK();
                break;
            }
            case 'L': {
                this.startDrawingL();
                break;
            }
            case 'M': {
                this.startDrawingM();
                break;
            }
            case 'N': {
                this.startDrawingN();
                break;
            }
            case 'O': {
                this.startDrawingO();
                break;
            }
            case 'P': {
                this.startDrawingP();
                break;
            }
            case 'Q': {
                this.startDrawingQ();
                break;
            }
            case 'R': {
                this.startDrawingR();
                break;
            }
            case 'S': {
                this.startDrawingS();
                break;
            }
            case 'T': {
                this.startDrawingT();
                break;
            }
            case 'U': {
                this.startDrawingU();
                break;
            }
            case 'V': {
                this.startDrawingV();
                break;
            }
            case 'W': {
                this.startDrawingW();
                break;
            }
            case 'X': {
                this.startDrawingX();
                break;
            }
            case 'Y': {
                this.startDrawingY();
                break;
            }
            case 'Z': {
                this.startDrawingZ();
                break;
            }
            case ' ': {
                this.startDrawingSpace();
            }
        }
    }

    private void continueDrawing() {
        switch (this.currentCharacter) {
            case 'A': {
                this.drawA();
                break;
            }
            case 'B': {
                this.drawB();
                break;
            }
            case 'C': {
                this.drawC();
                break;
            }
            case 'D': {
                this.drawD();
                break;
            }
            case 'E': {
                this.drawE();
                break;
            }
            case 'F': {
                this.drawF();
                break;
            }
            case 'G': {
                this.drawG();
                break;
            }
            case 'H': {
                this.drawH();
                break;
            }
            case 'I': {
                this.drawI();
                break;
            }
            case 'J': {
                this.drawJ();
                break;
            }
            case 'K': {
                this.drawK();
                break;
            }
            case 'L': {
                this.drawL();
                break;
            }
            case 'M': {
                this.drawM();
                break;
            }
            case 'N': {
                this.drawN();
                break;
            }
            case 'O': {
                this.drawO();
                break;
            }
            case 'P': {
                this.drawP();
                break;
            }
            case 'Q': {
                this.drawQ();
                break;
            }
            case 'R': {
                this.drawR();
                break;
            }
            case 'S': {
                this.drawS();
                break;
            }
            case 'T': {
                this.drawT();
                break;
            }
            case 'U': {
                this.drawU();
                break;
            }
            case 'V': {
                this.drawV();
                break;
            }
            case 'W': {
                this.drawW();
                break;
            }
            case 'X': {
                this.drawX();
                break;
            }
            case 'Y': {
                this.drawY();
                break;
            }
            case 'Z': {
                this.drawZ();
            }
        }
    }

    private void adjust() {
        this.centreX = this.currentCharacter == 'I' ? (this.centreX += 0.0f) : (this.currentCharacter == 'C' || this.currentCharacter == 'G' ? (float)((double)this.centreX + (double)this.HORIZONTAL_BOUND * Math.cos(-5.497787143782138)) : (this.currentCharacter == ' ' ? (this.centreX += this.HORIZONTAL_BOUND / 2.0f) : (this.currentCharacter == 'J' || this.currentCharacter == 'U' || this.currentCharacter == 'L' ? (this.centreX += 3.0f * this.HORIZONTAL_BOUND / 4.0f) : (this.centreX += this.HORIZONTAL_BOUND))));
        if (this.currentPosition + 1 < this.text.length()) {
            ++this.currentPosition;
            this.currentCharacter = this.text.charAt(this.currentPosition);
            this.setCentreX(this.currentCharacter);
            this.startDrawing();
        } else {
            Log.e((String)"boom", (String)(this.centreX + ""));
            if (this.listener != null) {
                this.listener.WritingFinished();
            }
        }
    }

    private void setCentreX(char currentCharacter) {
        this.centreX = currentCharacter == 'I' ? (this.centreX += this.GAP) : (currentCharacter == ' ' ? (this.centreX += this.HORIZONTAL_BOUND / 2.0f) : (currentCharacter == 'J' || currentCharacter == 'U' || currentCharacter == 'L' ? (this.centreX += this.GAP + 3.0f * this.HORIZONTAL_BOUND / 4.0f) : (this.centreX += this.GAP + this.HORIZONTAL_BOUND)));
    }

    public static interface Listener {
        public void WritingFinished();
    }

    public static enum Configuration {
        SQUARE(1),
        RECTANGLE(2),
        INTERMEDIATE(3);


        private Configuration(int config) {
        }
    }
}

