/*
 * Decompiled with CFR 0.152.
 */
package stardict_sanskrit;

import java.io.File;
import java.io.PrintWriter;
import org.slf4j.Logger;
import sanskritnlp.dictionary.BabylonDictionary;
import sanskritnlp.dictionary.BabylonDictionary$;
import sanskritnlp.dictionary.babylonTools$;
import sanskritnlp.transliteration.iast$;
import sanskritnlp.transliteration.transliterator$;
import sanskritnlp.vyAkaraNa.devanAgarI$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import stardict_sanskrit.BatchProcessor;
import stardict_sanskrit.BatchProcessor$class;
import stardict_sanskrit.Dictionary;
import stardict_sanskrit.babylonProcessor$;

public final class babylonProcessor$
implements BatchProcessor {
    public static final babylonProcessor$ MODULE$;
    private final Logger log;

    static {
        new babylonProcessor$();
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void stardict_sanskrit$BatchProcessor$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    @Override
    public File[] getRecursiveListOfFiles(File dir) {
        return BatchProcessor$class.getRecursiveListOfFiles(this, dir);
    }

    @Override
    public List<File> getMatchingDirectories(String file_pattern, String baseDir) {
        return BatchProcessor$class.getMatchingDirectories(this, file_pattern, baseDir);
    }

    @Override
    public String getMatchingDirectories$default$1() {
        return BatchProcessor$class.getMatchingDirectories$default$1(this);
    }

    @Override
    public String getMatchingDirectories$default$2() {
        return BatchProcessor$class.getMatchingDirectories$default$2(this);
    }

    @Override
    public String getMatchingDictionaries$default$1() {
        return BatchProcessor$class.getMatchingDictionaries$default$1(this);
    }

    @Override
    public List<Dictionary> getMatchingDictionaries(String file_pattern, String baseDir) {
        List dictionaries = (List)BatchProcessor$class.getMatchingDictionaries(this, file_pattern, baseDir).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Dictionary x$21) {
                return x$21.getFinalBabylonFile() != null;
            }
        });
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " babylon_final files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((LinearSeqOptimized)dictionaries.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Dictionary x$22) {
                return x$22.babylonFinalFile().isDefined();
            }
        })).length())})));
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", "  dicts without babylon_final files but with babylon file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((LinearSeqOptimized)dictionaries.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Dictionary x) {
                return x.babylonFile().isDefined() && !x.babylonFinalFile().isDefined();
            }
        })).length())})));
        return dictionaries;
    }

    @Override
    public String getMatchingDictionaries$default$2() {
        return ".";
    }

    public void fixHeadwordsInFinalFile(String file_pattern, String baseDir, Function1<String[], String[]> headwordTransformer) {
        Set files_to_ignore = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spokensanskrit.babylon"}));
        List dictionaries = (List)this.getMatchingDictionaries(file_pattern, baseDir).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Dictionary x$23) {
                return x$23.babylonFile().isDefined();
            }
        });
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " babylon files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dictionaries.length())})));
        List dictsToIgnore = (List)dictionaries.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Dictionary x$24) {
                return x$24.babylonFinalFileNewerThanBabylon();
            }
        });
        if (dictsToIgnore.nonEmpty()) {
            this.log().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring these files, whose final babylon files seem updated:"})).s((Seq)Nil$.MODULE$)).append((Object)dictsToIgnore.mkString("\n")).toString());
        }
        dictionaries = (List)dictionaries.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Dictionary x$25) {
                return x$25.babylonFinalFileNewerThanBabylon();
            }
        });
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " babylon files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dictionaries.length())})));
        List babylon_files = (List)dictionaries.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<File> apply(Dictionary x$26) {
                return x$26.babylonFile();
            }
        }, List$.MODULE$.canBuildFrom());
        ((List)babylon_files.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Option<File> x$27) {
                return ((File)x$27.get()).getCanonicalPath();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(headwordTransformer, files_to_ignore){
            public static final long serialVersionUID = 0L;
            private final Function1 headwordTransformer$1;
            private final Set files_to_ignore$1;

            public final void apply(String file) {
                if (this.files_to_ignore$1.contains((Object)file)) {
                    String arg$macro$2 = file;
                    babylonProcessor$.MODULE$.log().info(new StringOps("skipping: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2})));
                } else {
                    String arg$macro$3 = file;
                    babylonProcessor$.MODULE$.log().info(new StringOps("Fixing headwords in: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3})));
                    babylonTools$.MODULE$.fixHeadwords(file, ".babylon_final", (Function1<String[], String[]>)this.headwordTransformer$1);
                }
            }
            {
                this.headwordTransformer$1 = headwordTransformer$1;
                this.files_to_ignore$1 = files_to_ignore$1;
            }
        });
    }

    public String fixHeadwordsInFinalFile$default$1() {
        return ".*";
    }

    public String fixHeadwordsInFinalFile$default$2() {
        return ".";
    }

    public void addOptitrans(String file_pattern, String baseDir) {
        this.log().info("=======================Adding optitrans headwords, making final babylon file.");
        Serializable headwordTransformer = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String[] headwords_original) {
                return (String[])Predef$.MODULE$.refArrayOps((Object[])headwords_original).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])headwords_original).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x) {
                        return transliterator$.MODULE$.transliterate(x, "dev", "optitrans");
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
        };
        this.fixHeadwordsInFinalFile(file_pattern, baseDir, (Function1<String[], String[]>)headwordTransformer);
    }

    public String addOptitrans$default$1() {
        return ".*";
    }

    public String addOptitrans$default$2() {
        return ".";
    }

    public void stripNonOptitransHeadwords(String file_pattern, String baseDir) {
        this.log().info("=======================stripNonOptitransHeadwords, making final babylon file.");
        Serializable headwordTransformer = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String[] headwords_original) {
                return (String[])Predef$.MODULE$.refArrayOps((Object[])headwords_original).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$28) {
                        return iast$.MODULE$.isEncoding(x$28);
                    }
                });
            }
        };
        this.fixHeadwordsInFinalFile(file_pattern, baseDir, (Function1<String[], String[]>)headwordTransformer);
    }

    public String stripNonOptitransHeadwords$default$1() {
        return ".*";
    }

    public String stripNonOptitransHeadwords$default$2() {
        return ".";
    }

    public HashMap<String, ListBuffer<BabylonDictionary>> getWordToDictsMapFromPaths(Seq<String> basePaths, String wordPattern) {
        Seq babylonFiles = (Seq)((TraversableLike)basePaths.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<File> apply(String basePath) {
                return Predef$.MODULE$.refArrayOps((Object[])babylonProcessor$.MODULE$.getRecursiveListOfFiles(new File(basePath)));
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$29) {
                return x$29.getName().matches(".*\\.babylon(_final)?");
            }
        });
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " babylon files."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)babylonFiles.length())})));
        Seq babylonFinalFiles = (Seq)babylonFiles.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x) {
                return x.getName().matches(".*\\.babylon_final");
            }
        });
        Seq babylonDicts = (Seq)babylonFinalFiles.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final BabylonDictionary apply(File x) {
                void var2_5;
                String x$52 = x.getName();
                String x$53 = "";
                String x$54 = BabylonDictionary$.MODULE$.$lessinit$greater$default$2();
                BabylonDictionary dict = new BabylonDictionary(x$52, x$54, x$53);
                dict.fromFile(x.getCanonicalPath());
                return var2_5;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " babylon files."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)babylonDicts.length())})));
        HashMap<String, ListBuffer<BabylonDictionary>> wordToDicts = babylonTools$.MODULE$.mapWordToDicts((Seq<BabylonDictionary>)babylonDicts, wordPattern);
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " words"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)wordToDicts.size())})));
        return wordToDicts;
    }

    public String getWordToDictsMapFromPaths$default$2() {
        return "(\\p{IsDevanagari})+";
    }

    public void dumpWordToDictMap(Seq<String> basePaths, String wordPattern, String outFilePath) {
        HashMap<String, ListBuffer<BabylonDictionary>> words = this.getWordToDictsMapFromPaths(basePaths, wordPattern);
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " words"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)words.size())})));
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dumping to ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outFilePath})));
        File outFileObj = new File(outFilePath);
        new File(outFileObj.getParent()).mkdirs();
        PrintWriter destination = new PrintWriter(outFileObj);
        ((List)words.keys().toList().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable(words, destination){
            public static final long serialVersionUID = 0L;
            private final HashMap words$1;
            private final PrintWriter destination$1;

            public final void apply(String word) {
                ListBuffer dictNames = (ListBuffer)((TraversableLike)this.words$1.get((Object)word).get()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(BabylonDictionary x$30) {
                        return x$30.dict_name();
                    }
                }, ListBuffer$.MODULE$.canBuildFrom());
                this.destination$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word, dictNames.mkString(",")})));
            }
            {
                this.words$1 = words$1;
                this.destination$1 = destination$1;
            }
        });
        destination.close();
    }

    public String dumpWordToDictMap$default$2() {
        return "(\\p{IsDevanagari})+";
    }

    public void getDevanagariOptitransFromIast(String file_pattern, String baseDir) {
        this.log().info("=======================Adding optitrans headwords, making final babylon file.");
        Serializable toDevanAgarIAndOptitrans = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String[] headwords_original) {
                return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])headwords_original).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x) {
                        return transliterator$.MODULE$.transliterate(x, "iast", "dev");
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])headwords_original).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x) {
                        return transliterator$.MODULE$.transliterate(x, "iast", "optitrans");
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
        };
        this.fixHeadwordsInFinalFile(file_pattern, baseDir, (Function1<String[], String[]>)toDevanAgarIAndOptitrans);
    }

    public String getDevanagariOptitransFromIast$default$1() {
        return ".*";
    }

    public String getDevanagariOptitransFromIast$default$2() {
        return ".";
    }

    public void getDevanagariOptitransFromIastIfIndic(String file_pattern, String baseDir, HashSet<String> indicWordSet) {
        this.log().info("=======================Adding optitrans headwords, making final babylon file.");
        HashSet indicWordSetDev = (HashSet)indicWordSet.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String str_in) {
                return devanAgarI$.MODULE$.isEncoding(str_in);
            }
        });
        Serializable toDevanAgarIAndOptitrans = new Serializable(indicWordSetDev){
            public static final long serialVersionUID = 0L;
            public final HashSet indicWordSetDev$1;

            public final String[] apply(String[] headwords_original) {
                return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])headwords_original).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.19 $outer;

                    public final String apply(String x) {
                        return babylonProcessor$.MODULE$.stardict_sanskrit$babylonProcessor$$transliterateIfIndic$1(x, "dev", this.$outer.indicWordSetDev$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])headwords_original).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.19 $outer;

                    public final String apply(String x) {
                        return babylonProcessor$.MODULE$.stardict_sanskrit$babylonProcessor$$transliterateIfIndic$1(x, "optitrans", this.$outer.indicWordSetDev$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            {
                this.indicWordSetDev$1 = indicWordSetDev$1;
            }
        };
        this.fixHeadwordsInFinalFile(file_pattern, baseDir, (Function1<String[], String[]>)toDevanAgarIAndOptitrans);
    }

    public String getDevanagariOptitransFromIastIfIndic$default$1() {
        return ".*";
    }

    public String getDevanagariOptitransFromIastIfIndic$default$2() {
        return ".";
    }

    public HashSet<String> getDevanagariOptitransFromIastIfIndic$default$3() {
        return (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public void makeStardict(String file_pattern, String babylon_binary) {
        this.log().info("=======================makeStardict");
        List dictionaries = this.getMatchingDictionaries(file_pattern, this.getMatchingDictionaries$default$2());
        List dictsToIgnore = (List)dictionaries.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Dictionary x$31) {
                return x$31.ifoFileNewerThanBabylon();
            }
        });
        if (dictsToIgnore.nonEmpty()) {
            this.log().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring these files, whose dict files seem updated: "})).s((Seq)Nil$.MODULE$)).append((Object)dictsToIgnore.mkString("\n")).toString());
        }
        dictionaries = (List)dictionaries.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Dictionary x$32) {
                return x$32.ifoFileNewerThanBabylon();
            }
        });
        dictionaries.foreach((Function1)new Serializable(babylon_binary){
            public static final long serialVersionUID = 0L;
            private final String babylon_binary$1;

            public final Object apply(Dictionary x$33) {
                return x$33.makeStardictFromBabylonFile(this.babylon_binary$1);
            }
            {
                this.babylon_binary$1 = babylon_binary$1;
            }
        });
    }

    public String makeStardict$default$1() {
        return ".*";
    }

    public void transliterateAllIndicToDevanagarI(String inFilePath, String outFilePath, String sourceScheme, String wordListFilePath) {
        ObjectRef wordSet = ObjectRef.create((Object)Source$.MODULE$.fromFile(wordListFilePath, "utf8").getLines().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$34) {
                return (String)Predef$.MODULE$.refArrayOps((Object[])x$34.split("\t")).headOption().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "\u0928";
                    }
                });
            }
        }).map((Function1)new Serializable(sourceScheme){
            public static final long serialVersionUID = 0L;
            private final String sourceScheme$1;

            public final String apply(String x$35) {
                return transliterator$.MODULE$.transliterate(x$35, transliterator$.MODULE$.scriptDevanAgarI(), this.sourceScheme$1);
            }
            {
                this.sourceScheme$1 = sourceScheme$1;
            }
        }).toSet());
        File outFileObj = new File(outFilePath);
        new File(outFileObj.getParent()).mkdirs();
        PrintWriter destination = new PrintWriter(outFileObj);
        Iterator inFile = Source$.MODULE$.fromFile(inFilePath, "utf8").getLines().map((Function1)new Serializable(sourceScheme, wordSet, destination){
            public static final long serialVersionUID = 0L;
            private final String sourceScheme$1;
            private final ObjectRef wordSet$1;
            private final PrintWriter destination$2;

            public final void apply(String line) {
                String outStr = transliterator$.MODULE$.transliterateWordsIfIndic(line, (Set)this.wordSet$1.elem, this.sourceScheme$1, transliterator$.MODULE$.scriptDevanAgarI());
                this.destination$2.println(outStr);
            }
            {
                this.sourceScheme$1 = sourceScheme$1;
                this.wordSet$1 = wordSet$1;
                this.destination$2 = destination$2;
            }
        });
        destination.close();
    }

    public String transliterateAllIndicToDevanagarI$default$4() {
        return "/home/vvasuki/stardict-sanskrit/wordlists/words_sa_dev.txt";
    }

    public void main(String[] args) {
        String dictPattern = ".*";
        String workingDirInit = System.getProperty("user.dir");
        String workingDir = "/home/vvasuki/stardict-sanskrit/";
        System.setProperty("user.dir", workingDir);
    }

    private final boolean isIndic$1(String word, HashSet indicWordSetDev$1) {
        return indicWordSetDev$1.contains((Object)iast$.MODULE$.fromDevanagari(word)) || iast$.MODULE$.isEncoding(word);
    }

    public final String stardict_sanskrit$babylonProcessor$$transliterateIfIndic$1(String x, String destSchema, HashSet indicWordSetDev$1) {
        return this.isIndic$1(x, indicWordSetDev$1) ? transliterator$.MODULE$.transliterate(x, "iast", destSchema) : x;
    }

    private babylonProcessor$() {
        MODULE$ = this;
        BatchProcessor$class.$init$(this);
    }
}

