/*
 * Decompiled with CFR 0.152.
 */
package sanskritnlp.dictionary;

import java.io.File;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sanskritnlp.dictionary.BabylonDictionary;
import sanskritnlp.dictionary.babylonTools$;
import sanskritnlp.transliteration.as$;
import sanskritnlp.transliteration.kannaDa$;
import sanskritnlp.transliteration.optitrans$;
import sanskritnlp.transliteration.telugu$;
import sanskritnlp.vyAkaraNa.devanAgarI$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class babylonTools$ {
    public static final babylonTools$ MODULE$;
    private final Logger log;

    static {
        new babylonTools$();
    }

    public Logger log() {
        return this.log;
    }

    public void sutraNumbersToDevanagari(String infileStr) {
        this.log().info(new StringBuilder().append((Object)"Processing ").append((Object)infileStr).toString());
        String outfileStr = infileStr.replaceFirst(".babylon$", ".babylon_dev_sutra");
        BufferedSource src = Source$.MODULE$.fromFile(infileStr, "utf8");
        File outFileObj = new File(outfileStr);
        new File(outFileObj.getParent()).mkdirs();
        PrintWriter destination = new PrintWriter(outFileObj);
        Regex suutraPattern = new StringOps(Predef$.MODULE$.augmentString("(\\d+\\.\\d+\\.\\d+)")).r();
        src.getLines().foreach((Function1)new Serializable(destination, suutraPattern){
            public static final long serialVersionUID = 0L;
            private final PrintWriter destination$1;
            public final Regex suutraPattern$1;

            public final void apply(String line) {
                String newLine = this.suutraPattern$1.replaceAllIn((CharSequence)line, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.sutraNumbersToDevanagari.1 $outer;

                    public final String apply(Regex.Match x$1) {
                        Regex.Match match = x$1;
                        Option option = this.$outer.suutraPattern$1.unapplySeq(match);
                        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                            String latin_str = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String string = ((String)optitrans$.MODULE$.toDevanagari(latin_str).get()).replaceAll("\u0964", ".");
                            return string;
                        }
                        throw new MatchError((Object)match);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.destination$1.println(newLine);
            }
            {
                this.destination$1 = destination$1;
                this.suutraPattern$1 = suutraPattern$1;
            }
        });
        destination.close();
        this.log().info(new StringBuilder().append((Object)"Produced ").append((Object)outfileStr).toString());
    }

    public HashMap<String, ListBuffer<BabylonDictionary>> mapWordToDicts(Seq<BabylonDictionary> dictList, String headword_pattern) {
        HashMap wordToDicts = new HashMap();
        dictList.foreach((Function1)new Serializable(headword_pattern, wordToDicts){
            public static final long serialVersionUID = 0L;
            private final String headword_pattern$1;
            public final HashMap wordToDicts$1;

            public final void apply(BabylonDictionary dictionary) {
                dictionary.makeWordToMeaningsMap(this.headword_pattern$1);
                dictionary.getWords().foreach((Function1)new Serializable(this, dictionary){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.mapWordToDicts.1 $outer;
                    private final BabylonDictionary dictionary$1;

                    public final HashMap<String, ListBuffer<BabylonDictionary>> apply(String word) {
                        ListBuffer dictList = (ListBuffer)this.$outer.wordToDicts$1.getOrElse((Object)word, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ListBuffer<BabylonDictionary> apply() {
                                return (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }
                        });
                        dictList.$plus$eq((Object)this.dictionary$1);
                        return this.$outer.wordToDicts$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)word), (Object)dictList));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dictionary$1 = dictionary$1;
                    }
                });
            }
            {
                this.headword_pattern$1 = headword_pattern$1;
                this.wordToDicts$1 = wordToDicts$1;
            }
        });
        return wordToDicts;
    }

    public void fixHeadwords(String infileStr, String outputExt, Function1<String[], String[]> headwordTransformer) {
        this.log().info(new StringBuilder().append((Object)"Processing ").append((Object)infileStr).toString());
        String outfileStr = infileStr.replaceFirst("\\.[^.]+$", outputExt);
        this.log().info(new StringBuilder().append((Object)"Will produce ").append((Object)outfileStr).toString());
        File outFileObj = new File(outfileStr);
        new File(outFileObj.getParent()).mkdirs();
        PrintWriter destination = new PrintWriter(outFileObj);
        BufferedSource src = Source$.MODULE$.fromFile(infileStr, "utf8");
        src.getLines().takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return babylonTools$.MODULE$.sanskritnlp$dictionary$babylonTools$$isHeadLine$1(x$2);
            }
        }).foreach((Function1)new Serializable(destination){
            public static final long serialVersionUID = 0L;
            private final PrintWriter destination$2;

            public final void apply(String x$1) {
                this.destination$2.println(x$1);
            }
            {
                this.destination$2 = destination$2;
            }
        });
        src = Source$.MODULE$.fromFile(infileStr, "utf8");
        src.getLines().dropWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return babylonTools$.MODULE$.sanskritnlp$dictionary$babylonTools$$isHeadLine$1(x$3);
            }
        }).zipWithIndex().foreach((Function1)new Serializable(headwordTransformer, destination){
            public static final long serialVersionUID = 0L;
            private final Function1 headwordTransformer$1;
            private final PrintWriter destination$2;

            public final void apply(Tuple2<String, Object> t) {
                String line = (String)t._1();
                int index = t._2$mcI$sp();
                try {
                    if (index % 3 == 0) {
                        String[] headwordsOriginal = new StringOps(Predef$.MODULE$.augmentString(line)).split('|');
                        String[] headwordsFixed = (String[])this.headwordTransformer$1.apply((Object)headwordsOriginal);
                        this.destination$2.println(((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])headwordsFixed).toSet().toList().sortWith((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String a, String b) {
                                return babylonTools$.MODULE$.sanskritnlp$dictionary$babylonTools$$headwordSorter$1(a, b);
                            }
                        })).mkString("|"));
                    } else {
                        this.destination$2.println(line);
                    }
                }
                catch (Exception exception) {
                    babylonTools$.MODULE$.log().error(exception.toString());
                    babylonTools$.MODULE$.log().error(new StringBuilder().append((Object)"line: ").append((Object)t.toString()).toString());
                }
            }
            {
                this.headwordTransformer$1 = headwordTransformer$1;
                this.destination$2 = destination$2;
            }
        });
        destination.close();
        this.log().info(new StringBuilder().append((Object)"Produced ").append((Object)outfileStr).toString());
    }

    public void fixEntries(String infileStr, String outputExt, Function1<String, String> entryTransformer) {
        this.log().info(new StringBuilder().append((Object)"Processing ").append((Object)infileStr).toString());
        String outfileStr = infileStr.replaceFirst("\\.[^.]+$", outputExt);
        this.log().info(new StringBuilder().append((Object)"Will produce ").append((Object)outfileStr).toString());
        File outFileObj = new File(outfileStr);
        new File(outFileObj.getParent()).mkdirs();
        PrintWriter destination = new PrintWriter(outFileObj);
        BufferedSource src = Source$.MODULE$.fromFile(infileStr, "utf8");
        src.getLines().takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return babylonTools$.MODULE$.sanskritnlp$dictionary$babylonTools$$isHeadLine$2(x$4);
            }
        }).foreach((Function1)new Serializable(destination){
            public static final long serialVersionUID = 0L;
            private final PrintWriter destination$3;

            public final void apply(String x$1) {
                this.destination$3.println(x$1);
            }
            {
                this.destination$3 = destination$3;
            }
        });
        src = Source$.MODULE$.fromFile(infileStr, "utf8");
        src.getLines().dropWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return babylonTools$.MODULE$.sanskritnlp$dictionary$babylonTools$$isHeadLine$2(x$5);
            }
        }).zipWithIndex().foreach((Function1)new Serializable(entryTransformer, destination){
            public static final long serialVersionUID = 0L;
            private final Function1 entryTransformer$1;
            private final PrintWriter destination$3;

            public final void apply(Tuple2<String, Object> t) {
                String line = (String)t._1();
                int index = t._2$mcI$sp();
                try {
                    if ((index + 1) % 2 == 0) {
                        String entryOriginal = line;
                        String entryTransliterated = (String)this.entryTransformer$1.apply((Object)entryOriginal);
                        this.destination$3.println(((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(entryTransliterated)).toSet().toList().sorted((Ordering)Ordering.Char$.MODULE$)).mkString("|"));
                    } else {
                        this.destination$3.println(line);
                    }
                }
                catch (Exception exception) {
                    babylonTools$.MODULE$.log().error(exception.toString());
                    babylonTools$.MODULE$.log().error(new StringBuilder().append((Object)"line: ").append((Object)t.toString()).toString());
                }
            }
            {
                this.entryTransformer$1 = entryTransformer$1;
                this.destination$3 = destination$3;
            }
        });
        destination.close();
        this.log().info(new StringBuilder().append((Object)"Produced ").append((Object)outfileStr).toString());
    }

    public void asToDevanagari(String infileStr) {
        this.log().info(new StringBuilder().append((Object)"Processing ").append((Object)infileStr).toString());
        String outfileStr = infileStr.replaceFirst("\\.babylon$", ".babylonv1");
        BufferedSource src = Source$.MODULE$.fromFile(infileStr, "utf8");
        File outFileObj = new File(outfileStr);
        new File(outFileObj.getParent()).mkdirs();
        PrintWriter destination = new PrintWriter(outFileObj);
        Regex asPattern = new StringOps(Predef$.MODULE$.augmentString("\\{%(.+?)%\\}")).r();
        Regex asPatternUnmarked = new StringOps(Predef$.MODULE$.augmentString("(\\W)(\\w+?\\d\\w*?)(\\W)")).r();
        src.getLines().foreach((Function1)new Serializable(destination, asPattern, asPatternUnmarked){
            public static final long serialVersionUID = 0L;
            private final PrintWriter destination$4;
            public final Regex asPattern$1;
            public final Regex asPatternUnmarked$1;

            public final void apply(String line) {
                String newLine = this.asPattern$1.replaceAllIn((CharSequence)line, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.asToDevanagari.1 $outer;

                    public final String apply(Regex.Match x$6) {
                        Regex.Match match = x$6;
                        Option option = this.$outer.asPattern$1.unapplySeq(match);
                        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                            String as_str = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String string = (String)as$.MODULE$.toDevanagari(as_str).get();
                            return string;
                        }
                        throw new MatchError((Object)match);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                newLine = this.asPatternUnmarked$1.replaceAllIn((CharSequence)newLine, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.asToDevanagari.1 $outer;

                    public final String apply(Regex.Match x$7) {
                        Regex.Match match = x$7;
                        Option option = this.$outer.asPatternUnmarked$1.unapplySeq(match);
                        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                            String fore = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String as_str = (String)((LinearSeqOptimized)option.get()).apply(1);
                            String aft = (String)((LinearSeqOptimized)option.get()).apply(2);
                            String string = new StringBuilder().append((Object)fore).append((Object)as$.MODULE$.toDevanagari(as_str)).append((Object)aft).toString();
                            return string;
                        }
                        throw new MatchError((Object)match);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.destination$4.println(newLine);
                babylonTools$.MODULE$.log().info(newLine);
            }
            {
                this.destination$4 = destination$4;
                this.asPattern$1 = asPattern$1;
                this.asPatternUnmarked$1 = asPatternUnmarked$1;
            }
        });
        destination.close();
        this.log().info(new StringBuilder().append((Object)"Produced ").append((Object)outfileStr).toString());
    }

    private final boolean checkDistinctProperty$1(Function1 fn, String a$1, String b$1) {
        return BoxesRunTime.unboxToBoolean((Object)fn.apply((Object)a$1)) && !BoxesRunTime.unboxToBoolean((Object)fn.apply((Object)b$1));
    }

    private final float getScore$1(String x) {
        int score = x.length();
        if (x.contains("_")) {
            score += -1000;
        }
        if (devanAgarI$.MODULE$.isEncoding(x)) {
            score += 1000;
        }
        if (kannaDa$.MODULE$.isEncoding(x)) {
            score += 70;
        }
        if (telugu$.MODULE$.isEncoding(x)) {
            score += 69;
        }
        return score;
    }

    public final boolean sanskritnlp$dictionary$babylonTools$$headwordSorter$1(String a, String b) {
        if (this.getScore$1(a) == this.getScore$1(b)) {
            return new StringOps(Predef$.MODULE$.augmentString(a)).$less((Object)b);
        }
        return this.getScore$1(a) > this.getScore$1(b);
    }

    public final boolean sanskritnlp$dictionary$babylonTools$$isHeadLine$1(String x) {
        return x.startsWith("#") || x.trim().isEmpty();
    }

    public final boolean sanskritnlp$dictionary$babylonTools$$isHeadLine$2(String x) {
        return x.startsWith("#") || x.trim().isEmpty();
    }

    private babylonTools$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger((String)"babylonTools");
    }
}

