/*
 * Decompiled with CFR 0.152.
 */
package saman.zamani.persiandate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import saman.zamani.persiandate.PersianDate;

public class PersianDateFormat {
    private final String[] key = new String[]{"a", "l", "j", "F", "Y", "H", "i", "s", "d", "g", "n", "m", "t", "w", "y", "z", "A", "L", "X", "C", "E", "P", "Q", "R"};
    private String pattern = "l j F Y H:i:s";
    private PersianDateNumberCharacter numberCharacter = PersianDateNumberCharacter.ENGLISH;
    private final String[] key_parse = new String[]{"yyyy", "MM", "dd", "HH", "mm", "ss"};

    public PersianDateFormat(String pattern) {
        this.pattern = pattern;
    }

    public PersianDateFormat(String pattern, PersianDateNumberCharacter numberCharacter) {
        this.pattern = pattern;
        this.numberCharacter = numberCharacter;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setNumberCharacter(PersianDateNumberCharacter numberCharacter) {
        this.numberCharacter = numberCharacter;
    }

    public PersianDateFormat() {
    }

    public static String format(PersianDate date, String pattern) {
        return PersianDateFormat.format(date, pattern, PersianDateNumberCharacter.ENGLISH);
    }

    public static String format(PersianDate date, String pattern, PersianDateNumberCharacter numberFormatCharacter) {
        if (pattern == null) {
            pattern = "l j F Y H:i:s";
        }
        String[] key = new String[]{"a", "l", "j", "F", "Y", "H", "i", "s", "d", "g", "n", "m", "t", "w", "y", "z", "A", "L", "X", "C", "E", "P", "Q", "R"};
        String year2 = ("" + date.getShYear()).length() == 2 ? "" + date.getShYear() : (("" + date.getShYear()).length() == 3 ? ("" + date.getShYear()).substring(2, 3) : ("" + date.getShYear()).substring(2, 4));
        String[] values = new String[]{date.getShortTimeOfTheDay(), date.dayName(), "" + date.getShDay(), date.monthName(), "" + date.getShYear(), PersianDateFormat.textNumberFilterStatic("" + date.getHour()), PersianDateFormat.textNumberFilterStatic("" + date.getMinute()), PersianDateFormat.textNumberFilterStatic("" + date.getSecond()), PersianDateFormat.textNumberFilterStatic("" + date.getShDay()), "" + date.get12FormatHour(), "" + date.getShMonth(), PersianDateFormat.textNumberFilterStatic("" + date.getShMonth()), "" + date.getMonthDays(), "" + date.dayOfWeek(), year2, "" + date.getDayInYear(), date.getTimeOfTheDay(), date.isLeap() ? "1" : "0", date.AfghanMonthName(), date.KurdishMonthName(), date.PashtoMonthName(), date.FinglishMonthName(), date.dayFinglishName(), date.dayEnglishName()};
        if (numberFormatCharacter == PersianDateNumberCharacter.FARSI) {
            PersianDateFormat.farsiCharacter(values);
        }
        for (int i = 0; i < key.length; ++i) {
            pattern = pattern.replace(key[i], values[i]);
        }
        return pattern;
    }

    public String format(PersianDate date) {
        String year2 = ("" + date.getShYear()).length() == 2 ? "" + date.getShYear() : (("" + date.getShYear()).length() == 3 ? ("" + date.getShYear()).substring(2, 3) : ("" + date.getShYear()).substring(2, 4));
        String[] values = new String[]{date.getShortTimeOfTheDay(), date.dayName(), "" + date.getShDay(), date.monthName(), "" + date.getShYear(), this.textNumberFilter("" + date.getHour()), this.textNumberFilter("" + date.getMinute()), this.textNumberFilter("" + date.getSecond()), this.textNumberFilter("" + date.getShDay()), "" + date.get12FormatHour(), "" + date.getShMonth(), this.textNumberFilter("" + date.getShMonth()), "" + date.getMonthDays(), "" + date.dayOfWeek(), year2, "" + date.getDayInYear(), date.getTimeOfTheDay(), date.isLeap() ? "1" : "0", date.AfghanMonthName(), date.KurdishMonthName(), date.PashtoMonthName(), date.FinglishMonthName(), date.dayFinglishName(), date.dayEnglishName()};
        if (this.numberCharacter == PersianDateNumberCharacter.FARSI) {
            PersianDateFormat.farsiCharacter(values);
        }
        return this.stringUtils(this.pattern, this.key, values);
    }

    public PersianDate parse(String date) throws ParseException {
        return this.parse(date, this.pattern);
    }

    public PersianDate parse(String date, String pattern) throws ParseException {
        ArrayList<Integer> JalaliDate = new ArrayList<Integer>(){
            {
                this.add(0);
                this.add(0);
                this.add(0);
                this.add(0);
                this.add(0);
                this.add(0);
            }
        };
        for (int i = 0; i < this.key_parse.length; ++i) {
            int end_temp;
            if (!pattern.contains(this.key_parse[i])) continue;
            int start_temp = pattern.indexOf(this.key_parse[i]);
            String dateReplace = date.substring(start_temp, end_temp = start_temp + this.key_parse[i].length());
            if (dateReplace.matches("[-+]?\\d*\\.?\\d+")) {
                JalaliDate.set(i, Integer.parseInt(dateReplace));
                continue;
            }
            throw new ParseException("Parse Exception", 10);
        }
        return new PersianDate().initJalaliDate((Integer)JalaliDate.get(0), (Integer)JalaliDate.get(1), (Integer)JalaliDate.get(2), (Integer)JalaliDate.get(3), (Integer)JalaliDate.get(4), (Integer)JalaliDate.get(5));
    }

    public PersianDate parseGrg(String date) throws ParseException {
        return this.parseGrg(date, this.pattern);
    }

    public PersianDate parseGrg(String date, String pattern) throws ParseException {
        Date dateInGrg = new SimpleDateFormat(pattern).parse(date);
        return new PersianDate(dateInGrg.getTime());
    }

    private String stringUtils(String text, String[] key, String[] values) {
        for (int i = 0; i < key.length; ++i) {
            text = text.replace(key[i], values[i]);
        }
        return text;
    }

    private String textNumberFilter(String date) {
        if (date.length() < 2) {
            return "0" + date;
        }
        return date;
    }

    public static String textNumberFilterStatic(String date) {
        if (date.length() < 2) {
            return "0" + date;
        }
        return date;
    }

    public static String[] farsiCharacter(String[] values) {
        String[] persianChars = new String[]{"\u06f0", "\u06f1", "\u06f2", "\u0663", "\u06f4", "\u06f5", "\u06f6", "\u06f7", "\u06f8", "\u0669"};
        String[] englishChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        for (int i = 0; i < values.length; ++i) {
            String tmpValue = values[i];
            for (int j = 0; j < persianChars.length; ++j) {
                tmpValue = tmpValue.replaceAll(englishChars[j], persianChars[j]);
            }
            values[i] = tmpValue;
        }
        return values;
    }

    public static enum PersianDateNumberCharacter {
        ENGLISH,
        FARSI;

    }
}

