/*
 * Decompiled with CFR 0.152.
 */
package ir.androidexception.datatable.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import ir.androidexception.datatable.R;
import ir.androidexception.datatable.enums.Gravity;
import ir.androidexception.datatable.model.DataTableRow;
import ir.androidexception.datatable.utility.Util;
import ir.androidexception.datatable.utility.ViewGenerator;
import java.util.ArrayList;

public class RowItemAdapter
extends RecyclerView.Adapter<RowItemViewHolder> {
    private Context context;
    private ArrayList<DataTableRow> values;
    private ArrayList<Integer> weights;
    private Integer dividerThickness;
    private Integer dividerColor;
    private Integer rowTextColor;
    private Integer rowBackgroundColor;
    private float verticalPadding;
    private float horizontalPadding;
    private float verticalMargin;
    private float horizontalMargin;
    private float rowTextSize;
    private Typeface typeface;
    private Gravity rowGravity;
    private boolean persianNumber;

    public RowItemAdapter(Context context, ArrayList<DataTableRow> values, ArrayList<Integer> weights, Integer dividerThickness, Integer dividerColor, Integer rowTextColor, Integer rowBackgroundColor, float verticalPadding, float horizontalPadding, float verticalMargin, float horizontalMargin, float rowTextSize, Typeface typeface, Gravity rowGravity, boolean persianNumber) {
        this.context = context;
        this.values = values != null ? values : new ArrayList();
        this.weights = weights != null ? weights : new ArrayList();
        this.dividerThickness = dividerThickness;
        this.dividerColor = dividerColor;
        this.rowTextColor = rowTextColor;
        this.rowBackgroundColor = rowBackgroundColor;
        this.verticalPadding = verticalPadding;
        this.horizontalPadding = horizontalPadding;
        this.verticalMargin = verticalMargin;
        this.horizontalMargin = horizontalMargin;
        this.rowTextSize = rowTextSize;
        this.typeface = typeface;
        this.rowGravity = rowGravity;
        this.persianNumber = persianNumber;
    }

    @NonNull
    public RowItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new RowItemViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.row_item, parent, false));
    }

    public void onBindViewHolder(@NonNull RowItemViewHolder holder, int position) {
        holder.removeAllViews();
        LinearLayout itemLinearLayout = ViewGenerator.generateHorizontalLinearLayout(this.context);
        LinearLayout valueLinearLayout = ViewGenerator.generateHorizontalLinearLayout(this.context);
        if (this.values.get(position).getValues().size() != this.weights.size()) {
            return;
        }
        for (int j = 0; j < this.values.get(position).getValues().size(); ++j) {
            String text = this.values.get(position).getValues().get(j);
            if (this.persianNumber) {
                text = Util.convertToPersianNumbers(text);
            }
            TextView textView = ViewGenerator.generateTextView(this.context, text, this.weights.get(j), this.rowBackgroundColor, this.rowTextColor, this.horizontalPadding, this.verticalPadding, this.horizontalPadding, this.verticalPadding, this.horizontalMargin, this.verticalMargin, this.horizontalMargin, this.verticalMargin, this.rowTextSize, this.typeface, 0, this.rowGravity);
            valueLinearLayout.addView((View)textView);
        }
        itemLinearLayout.addView((View)valueLinearLayout);
        View divider = ViewGenerator.generateDivider(this.context, this.dividerThickness, this.dividerColor);
        holder.addView((View)itemLinearLayout);
        holder.addView(divider);
    }

    public int getItemCount() {
        return this.values.size();
    }

    public class RowItemViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout rootItem;

        public RowItemViewHolder(View itemView) {
            super(itemView);
            this.rootItem = (LinearLayout)itemView.findViewById(R.id.row_item_root);
        }

        private void removeAllViews() {
            this.rootItem.removeAllViews();
        }

        private void addView(View child) {
            this.rootItem.addView(child);
        }
    }
}

