/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.minicluster.impl;

import com.github.sakserv.minicluster.MiniCluster;
import com.github.sakserv.minicluster.util.FileUtils;
import java.io.File;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsqldbLocalServer
implements MiniCluster {
    private static final Logger LOG = LoggerFactory.getLogger(HsqldbLocalServer.class);
    private HsqlProperties hsqlProperties = new HsqlProperties();
    private Server server;
    private String hsqldbHostName;
    private String hsqldbPort;
    private String hsqldbTempDir;
    private String hsqldbDatabaseName;
    private String hsqldbCompatibilityMode;
    private String hsqldbJdbcDriver;
    private String hsqldbJdbcConnectionStringPrefix;

    public String getHsqldbHostName() {
        return this.hsqldbHostName;
    }

    public String getHsqldbPort() {
        return this.hsqldbPort;
    }

    public String getHsqldbTempDir() {
        return this.hsqldbTempDir;
    }

    public String getHsqldbDatabaseName() {
        return this.hsqldbDatabaseName;
    }

    public String getHsqldbCompatibilityMode() {
        return this.hsqldbCompatibilityMode;
    }

    public String getHsqldbJdbcDriver() {
        return this.hsqldbJdbcDriver;
    }

    public String getHsqldbJdbcConnectionStringPrefix() {
        return this.hsqldbJdbcConnectionStringPrefix;
    }

    private HsqldbLocalServer(Builder builder) {
        this.hsqldbHostName = builder.hsqldbHostName;
        this.hsqldbPort = builder.hsqldbPort;
        this.hsqldbTempDir = builder.hsqldbTempDir;
        this.hsqldbDatabaseName = builder.hsqldbDatabaseName;
        this.hsqldbCompatibilityMode = builder.hsqldbCompatibilityMode;
        this.hsqldbJdbcDriver = builder.hsqldbJdbcDriver;
        this.hsqldbJdbcConnectionStringPrefix = builder.hsqldbJdbcConnectionStringPrefix;
    }

    public void start() throws Exception {
        LOG.info("HSQLDB: Starting HSQLDB");
        this.configure();
        this.server = new Server();
        this.server.setProperties(this.hsqlProperties);
        this.server.start();
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean cleanUp) throws Exception {
        LOG.info("HSQLDB: Stopping HSQLDB");
        this.server.stop();
        if (cleanUp) {
            this.cleanUp();
        }
    }

    public void configure() throws Exception {
        this.hsqlProperties.setProperty("server.address", this.getHsqldbHostName());
        this.hsqlProperties.setProperty("server.port", this.getHsqldbPort());
        this.hsqlProperties.setProperty("server.database.0", "file:" + new File(this.getHsqldbTempDir()).getAbsolutePath());
        this.hsqlProperties.setProperty("server.dbname.0", this.getHsqldbDatabaseName());
        this.hsqlProperties.setProperty("server.remote_open", "true");
        this.hsqlProperties.setProperty("server.max_allowed_packet", "32M");
    }

    public void cleanUp() throws Exception {
        FileUtils.deleteFolder((String)(this.getHsqldbTempDir() + ".tmp"));
        FileUtils.deleteFolder((String)(this.getHsqldbTempDir() + ".log"));
        FileUtils.deleteFolder((String)(this.getHsqldbTempDir() + ".properties"));
        FileUtils.deleteFolder((String)(this.getHsqldbTempDir() + ".script"));
        FileUtils.deleteFolder((String)(this.getHsqldbTempDir() + ".lck"));
    }

    public String getHsqldbCompatibilityModeStatement() {
        String dbTypeString = "MYS";
        if (this.getHsqldbCompatibilityMode().equals("postresql")) {
            dbTypeString = "PGS";
        } else if (this.getHsqldbCompatibilityMode().equals("mysql")) {
            dbTypeString = "MYS";
        } else if (this.getHsqldbCompatibilityMode().equals("oracle")) {
            dbTypeString = "ORA";
        } else if (this.getHsqldbCompatibilityMode().equals("db2")) {
            dbTypeString = "DB2";
        } else if (this.getHsqldbCompatibilityMode().equals("mssql")) {
            dbTypeString = "MSS";
        }
        return "SET DATABASE SQL SYNTAX " + dbTypeString + " TRUE";
    }

    public static class Builder {
        private String hsqldbHostName;
        private String hsqldbPort;
        private String hsqldbTempDir;
        private String hsqldbDatabaseName;
        private String hsqldbCompatibilityMode;
        private String hsqldbJdbcDriver;
        private String hsqldbJdbcConnectionStringPrefix;

        public Builder setHsqldbHostName(String hsqldbHostName) {
            this.hsqldbHostName = hsqldbHostName;
            return this;
        }

        public Builder setHsqldbPort(String hsqldbPort) {
            this.hsqldbPort = hsqldbPort;
            return this;
        }

        public Builder setHsqldbTempDir(String hsqldbTempDir) {
            this.hsqldbTempDir = hsqldbTempDir;
            return this;
        }

        public Builder setHsqldbDatabaseName(String hsqldbDatabaseName) {
            this.hsqldbDatabaseName = hsqldbDatabaseName;
            return this;
        }

        public Builder setHsqldbCompatibilityMode(String hsqldbCompatibilityMode) {
            this.hsqldbCompatibilityMode = hsqldbCompatibilityMode;
            return this;
        }

        public Builder setHsqldbJdbcDriver(String hsqldbJdbcDriver) {
            this.hsqldbJdbcDriver = hsqldbJdbcDriver;
            return this;
        }

        public Builder setHsqldbJdbcConnectionStringPrefix(String hsqldbJdbcConnectionStringPrefix) {
            this.hsqldbJdbcConnectionStringPrefix = hsqldbJdbcConnectionStringPrefix;
            return this;
        }

        public HsqldbLocalServer build() {
            HsqldbLocalServer hsqldbLocalServer = new HsqldbLocalServer(this);
            this.validateObject(hsqldbLocalServer);
            return hsqldbLocalServer;
        }

        public void validateObject(HsqldbLocalServer hsqldbLocalServer) {
            if (hsqldbLocalServer.hsqldbHostName == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HSQLDB Host Name");
            }
            if (hsqldbLocalServer.hsqldbPort == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HSQLDB Port");
            }
            if (hsqldbLocalServer.hsqldbTempDir == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HSQLDB Temp Dir");
            }
            if (hsqldbLocalServer.hsqldbDatabaseName == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HSQLDB Database Name");
            }
            if (hsqldbLocalServer.hsqldbCompatibilityMode == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HSQLDB Compatibility Mode");
            }
            if (hsqldbLocalServer.hsqldbJdbcDriver == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HSQLDB JDBC Driver");
            }
            if (hsqldbLocalServer.hsqldbJdbcConnectionStringPrefix == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HSQLDB JDBC Connection String Prefix");
            }
        }
    }
}

