/*
 * Decompiled with CFR 0.152.
 */
package safety.com.br.android_shake_detector.core;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.IBinder;
import android.support.annotation.Nullable;
import java.util.List;
import safety.com.br.android_shake_detector.core.AppPreferences;
import safety.com.br.android_shake_detector.core.ShakeListener;
import safety.com.br.android_shake_detector.core.ShakeOptions;

public class ShakeService
extends Service {
    private AppPreferences appPreferences;
    private ShakeOptions shakeOptions;
    private ShakeListener shakeListener;
    private SensorManager sensorManager;
    private Sensor sensor;

    public void onCreate() {
        this.appPreferences = new AppPreferences(this.getBaseContext());
        super.onCreate();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.shakeOptions = new ShakeOptions().background(this.appPreferences.getBoolean("BACKGROUND", true)).sensibility(this.appPreferences.getFloat("SENSIBILITY", Float.valueOf(1.2f)).floatValue()).shakeCount(this.appPreferences.getInt("SHAKE_COUNT", 1)).interval(this.appPreferences.getInt("SHAKE_INTERVAL", 2000));
        this.startShakeService(this.getBaseContext());
        if (this.shakeOptions.isBackground()) {
            return 1;
        }
        return 2;
    }

    public void startShakeService(Context context) {
        this.shakeListener = new ShakeListener(this.shakeOptions, context);
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        List sensors = this.sensorManager.getSensorList(1);
        if (sensors.size() > 0) {
            this.sensor = (Sensor)sensors.get(0);
            this.sensorManager.registerListener((SensorEventListener)this.shakeListener, this.sensor, 1);
        }
    }

    public void onDestroy() {
        this.sensorManager.unregisterListener((SensorEventListener)this.shakeListener);
        super.onDestroy();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }
}

