/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mssql.change;

import java.util.ArrayList;
import liquibase.change.DatabaseChange;
import liquibase.change.core.LoadDataChange;
import liquibase.database.Database;
import liquibase.ext.mssql.database.MSSQLDatabase;
import liquibase.ext.mssql.statement.InsertSetStatementMSSQL;
import liquibase.ext.mssql.statement.InsertStatementMSSQL;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertSetStatement;
import liquibase.statement.core.InsertStatement;

@DatabaseChange(name="loadData", description="Load Data", priority=5, appliesTo={"table"})
public class LoadDataChangeMSSQL
extends LoadDataChange {
    private Boolean identityInsertEnabled;

    public Boolean getIdentityInsertEnabled() {
        return this.identityInsertEnabled;
    }

    public void setIdentityInsertEnabled(Boolean identityInsertEnabled) {
        this.identityInsertEnabled = identityInsertEnabled;
    }

    public SqlStatement[] generateStatements(Database database) {
        SqlStatement[] statements = super.generateStatements(database);
        if (!"Microsoft SQL Server".equals(database.getDatabaseProductName())) {
            return statements;
        }
        ArrayList<Object> wrappedStatements = new ArrayList<Object>(statements.length);
        for (SqlStatement statement : statements) {
            if (statement instanceof InsertStatement) {
                wrappedStatements.add((Object)new InsertStatementMSSQL((InsertStatement)statement, this.identityInsertEnabled));
                continue;
            }
            if (statement instanceof InsertSetStatement) {
                wrappedStatements.add((Object)new InsertSetStatementMSSQL((InsertSetStatement)statement, this.identityInsertEnabled));
                continue;
            }
            wrappedStatements.add(statement);
        }
        return wrappedStatements.toArray(new SqlStatement[0]);
    }

    public boolean supports(Database database) {
        return database instanceof MSSQLDatabase;
    }
}

