/*
 * Decompiled with CFR 0.152.
 */
package optimization;

import optimization.Lmder_fcn;
import optimization.Lmdif_fcn;

public class Minpack_f77 {
    static final double epsmch = 2.22044604926E-16;
    static final double minmag = 2.22507385852E-308;
    static final double zero = 0.0;
    static final double one = 1.0;
    static final double p0001 = 1.0E-4;
    static final double p001 = 0.001;
    static final double p05 = 0.05;
    static final double p1 = 0.1;
    static final double p25 = 0.25;
    static final double p5 = 0.5;
    static final double p75 = 0.75;

    public static void lmder1_f77(Lmder_fcn nlls, int m, int n, double[] x, double[] fvec, double[][] fjac, double tol, int[] info, int[] ipvt) {
        int[] nfev = new int[2];
        int[] njev = new int[2];
        double[] diag = new double[n + 1];
        double[] qtf = new double[n + 1];
        double factor = 100.0;
        info[1] = 0;
        if (n <= 0 || m < n || tol < 0.0) {
            return;
        }
        int maxfev = 100 * (n + 1);
        double ftol = tol;
        double xtol = tol;
        double gtol = 0.0;
        int mode = 1;
        int nprint = 0;
        Minpack_f77.lmder_f77(nlls, m, n, x, fvec, fjac, ftol, xtol, gtol, maxfev, diag, mode, factor, nprint, info, nfev, njev, ipvt, qtf);
        if (info[1] == 8) {
            info[1] = 4;
        }
    }

    public static void lmder_f77(Lmder_fcn nlls, int m, int n, double[] x, double[] fvec, double[][] fjac, double ftol, double xtol, double gtol, int maxfev, double[] diag, int mode, double factor, int nprint, int[] info, int[] nfev, int[] njev, int[] ipvt, double[] qtf) {
        int j;
        double[] par = new double[2];
        int[] iflag = new int[2];
        double[] wa1 = new double[n + 1];
        double[] wa2 = new double[n + 1];
        double[] wa3 = new double[n + 1];
        double[] wa4 = new double[m + 1];
        double delta = 0.0;
        double xnorm = 0.0;
        info[1] = 0;
        iflag[1] = 0;
        nfev[1] = 0;
        njev[1] = 0;
        if (n <= 0 || m < n || ftol < 0.0 || xtol < 0.0 || gtol < 0.0 || maxfev <= 0 || factor <= 0.0) {
            if (nprint > 0) {
                nlls.fcn(m, n, x, fvec, fjac, iflag);
            }
            return;
        }
        if (mode == 2) {
            for (j = 1; j <= n; ++j) {
                if (!(diag[j] <= 0.0)) continue;
                if (nprint > 0) {
                    nlls.fcn(m, n, x, fvec, fjac, iflag);
                }
                return;
            }
        }
        iflag[1] = 1;
        nlls.fcn(m, n, x, fvec, fjac, iflag);
        nfev[1] = 1;
        if (iflag[1] < 0) {
            info[1] = iflag[1];
            iflag[1] = 0;
            if (nprint > 0) {
                nlls.fcn(m, n, x, fvec, fjac, iflag);
            }
            return;
        }
        double fnorm = Minpack_f77.enorm_f77(m, fvec);
        par[1] = 0.0;
        int iter = 1;
        boolean doneout = false;
        while (!doneout) {
            int l;
            double temp;
            double sum;
            int i;
            iflag[1] = 2;
            nlls.fcn(m, n, x, fvec, fjac, iflag);
            njev[1] = njev[1] + 1;
            if (iflag[1] < 0) {
                info[1] = iflag[1];
                iflag[1] = 0;
                if (nprint > 0) {
                    nlls.fcn(m, n, x, fvec, fjac, iflag);
                }
                return;
            }
            if (nprint > 0) {
                iflag[1] = 0;
                if ((iter - 1) % nprint == 0) {
                    nlls.fcn(m, n, x, fvec, fjac, iflag);
                }
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                    iflag[1] = 0;
                    nlls.fcn(m, n, x, fvec, fjac, iflag);
                    return;
                }
            }
            Minpack_f77.qrfac_f77(m, n, fjac, true, ipvt, wa1, wa2, wa3);
            if (iter == 1) {
                if (mode != 2) {
                    for (j = 1; j <= n; ++j) {
                        diag[j] = wa2[j];
                        if (wa2[j] != 0.0) continue;
                        diag[j] = 1.0;
                    }
                }
                for (j = 1; j <= n; ++j) {
                    wa3[j] = diag[j] * x[j];
                }
                xnorm = Minpack_f77.enorm_f77(n, wa3);
                delta = factor * xnorm;
                if (delta == 0.0) {
                    delta = factor;
                }
            }
            for (i = 1; i <= m; ++i) {
                wa4[i] = fvec[i];
            }
            for (j = 1; j <= n; ++j) {
                if (fjac[j][j] != 0.0) {
                    sum = 0.0;
                    for (i = j; i <= m; ++i) {
                        sum += fjac[i][j] * wa4[i];
                    }
                    temp = -sum / fjac[j][j];
                    for (i = j; i <= m; ++i) {
                        int n2 = i;
                        wa4[n2] = wa4[n2] + fjac[i][j] * temp;
                    }
                }
                fjac[j][j] = wa1[j];
                qtf[j] = wa4[j];
            }
            double gnorm = 0.0;
            if (fnorm != 0.0) {
                for (j = 1; j <= n; ++j) {
                    l = ipvt[j];
                    if (wa2[l] == 0.0) continue;
                    sum = 0.0;
                    for (i = 1; i <= j; ++i) {
                        sum += fjac[i][j] * (qtf[i] / fnorm);
                    }
                    gnorm = Math.max(gnorm, Math.abs(sum / wa2[l]));
                }
            }
            if (gnorm <= gtol) {
                info[1] = 4;
            }
            if (info[1] != 0) {
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                }
                iflag[1] = 0;
                if (nprint > 0) {
                    nlls.fcn(m, n, x, fvec, fjac, iflag);
                }
                return;
            }
            if (mode != 2) {
                for (j = 1; j <= n; ++j) {
                    diag[j] = Math.max(diag[j], wa2[j]);
                }
            }
            boolean donein = false;
            while (!donein) {
                Minpack_f77.lmpar_f77(n, fjac, ipvt, diag, qtf, delta, par, wa1, wa2, wa3, wa4);
                for (j = 1; j <= n; ++j) {
                    wa1[j] = -wa1[j];
                    wa2[j] = x[j] + wa1[j];
                    wa3[j] = diag[j] * wa1[j];
                }
                double pnorm = Minpack_f77.enorm_f77(n, wa3);
                if (iter == 1) {
                    delta = Math.min(delta, pnorm);
                }
                iflag[1] = 1;
                nlls.fcn(m, n, wa2, wa4, fjac, iflag);
                nfev[1] = nfev[1] + 1;
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, fjac, iflag);
                    }
                    return;
                }
                double fnorm1 = Minpack_f77.enorm_f77(m, wa4);
                double actred = -1.0;
                if (0.1 * fnorm1 < fnorm) {
                    actred = 1.0 - fnorm1 / fnorm * (fnorm1 / fnorm);
                }
                for (j = 1; j <= n; ++j) {
                    wa3[j] = 0.0;
                    l = ipvt[j];
                    temp = wa1[l];
                    for (i = 1; i <= j; ++i) {
                        int n3 = i;
                        wa3[n3] = wa3[n3] + fjac[i][j] * temp;
                    }
                }
                double temp1 = Minpack_f77.enorm_f77(n, wa3) / fnorm;
                double temp2 = Math.sqrt(par[1]) * pnorm / fnorm;
                double prered = temp1 * temp1 + temp2 * temp2 / 0.5;
                double dirder = -(temp1 * temp1 + temp2 * temp2);
                double ratio = 0.0;
                if (prered != 0.0) {
                    ratio = actred / prered;
                }
                if (ratio <= 0.25) {
                    temp = actred >= 0.0 ? 0.5 : 0.5 * dirder / (dirder + 0.5 * actred);
                    if (0.1 * fnorm1 >= fnorm || temp < 0.1) {
                        temp = 0.1;
                    }
                    delta = temp * Math.min(delta, pnorm / 0.1);
                    par[1] = par[1] / temp;
                } else if (par[1] == 0.0 || ratio >= 0.75) {
                    delta = pnorm / 0.5;
                    par[1] = par[1] * 0.5;
                }
                if (ratio >= 1.0E-4) {
                    for (j = 1; j <= n; ++j) {
                        x[j] = wa2[j];
                        wa2[j] = diag[j] * x[j];
                    }
                    for (i = 1; i <= m; ++i) {
                        fvec[i] = wa4[i];
                    }
                    xnorm = Minpack_f77.enorm_f77(n, wa2);
                    fnorm = fnorm1;
                    ++iter;
                }
                if (Math.abs(actred) <= ftol && prered <= ftol && 0.5 * ratio <= 1.0) {
                    info[1] = 1;
                }
                if (delta <= xtol * xnorm) {
                    info[1] = 2;
                }
                if (Math.abs(actred) <= ftol && prered <= ftol && 0.5 * ratio <= 1.0 && info[1] == 2) {
                    info[1] = 3;
                }
                if (info[1] != 0) {
                    if (iflag[1] < 0) {
                        info[1] = iflag[1];
                    }
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, fjac, iflag);
                    }
                    return;
                }
                if (nfev[1] >= maxfev) {
                    info[1] = 5;
                }
                if (Math.abs(actred) <= 2.22044604926E-16 && prered <= 2.22044604926E-16 && 0.5 * ratio <= 1.0) {
                    info[1] = 6;
                }
                if (delta <= 2.22044604926E-16 * xnorm) {
                    info[1] = 7;
                }
                if (gnorm <= 2.22044604926E-16) {
                    info[1] = 8;
                }
                if (info[1] != 0) {
                    if (iflag[1] < 0) {
                        info[1] = iflag[1];
                    }
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, fjac, iflag);
                    }
                    return;
                }
                if (!(ratio >= 1.0E-4)) continue;
                donein = true;
            }
        }
    }

    public static double enorm_f77(int n, double[] x) {
        double rdwarf = 3.834E-20;
        double rgiant = 1.304E19;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double x1max = 0.0;
        double x3max = 0.0;
        double floatn = n;
        double agiant = rgiant / floatn;
        for (int i = 1; i <= n; ++i) {
            double xabs = Math.abs(x[i]);
            if (xabs <= rdwarf || xabs >= agiant) {
                if (xabs > rdwarf) {
                    if (xabs > x1max) {
                        s1 = 1.0 + s1 * (x1max / xabs) * (x1max / xabs);
                        x1max = xabs;
                        continue;
                    }
                    s1 += xabs / x1max * (xabs / x1max);
                    continue;
                }
                if (xabs > x3max) {
                    s3 = 1.0 + s3 * (x3max / xabs) * (x3max / xabs);
                    x3max = xabs;
                    continue;
                }
                if (xabs == 0.0) continue;
                s3 += xabs / x3max * (xabs / x3max);
                continue;
            }
            s2 += xabs * xabs;
        }
        double enorm = s1 != 0.0 ? x1max * Math.sqrt(s1 + s2 / x1max / x1max) : (s2 != 0.0 ? (s2 >= x3max ? Math.sqrt(s2 * (1.0 + x3max / s2 * (x3max * s3))) : Math.sqrt(x3max * (s2 / x3max + x3max * s3))) : x3max * Math.sqrt(s3));
        return enorm;
    }

    public static void qrfac_f77(int m, int n, double[][] a, boolean pivot, int[] ipvt, double[] rdiag, double[] acnorm, double[] wa) {
        int i;
        int j;
        double[] tempvec = new double[m + 1];
        for (j = 1; j <= n; ++j) {
            for (i = 1; i <= m; ++i) {
                tempvec[i] = a[i][j];
            }
            acnorm[j] = Minpack_f77.enorm_f77(m, tempvec);
            rdiag[j] = acnorm[j];
            wa[j] = rdiag[j];
            if (!pivot) continue;
            ipvt[j] = j;
        }
        int minmn = Math.min(m, n);
        for (j = 1; j <= minmn; ++j) {
            double temp;
            int k;
            if (pivot) {
                int kmax = j;
                for (k = j; k <= n; ++k) {
                    if (!(rdiag[k] > rdiag[kmax])) continue;
                    kmax = k;
                }
                if (kmax != j) {
                    for (i = 1; i <= m; ++i) {
                        temp = a[i][j];
                        a[i][j] = a[i][kmax];
                        a[i][kmax] = temp;
                    }
                    rdiag[kmax] = rdiag[j];
                    wa[kmax] = wa[j];
                    k = ipvt[j];
                    ipvt[j] = ipvt[kmax];
                    ipvt[kmax] = k;
                }
            }
            for (i = j; i <= m; ++i) {
                tempvec[i - j + 1] = a[i][j];
            }
            double ajnorm = Minpack_f77.enorm_f77(m - j + 1, tempvec);
            if (ajnorm != 0.0) {
                if (a[j][j] < 0.0) {
                    ajnorm = -ajnorm;
                }
                for (i = j; i <= m; ++i) {
                    double[] dArray = a[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] / ajnorm;
                }
                double[] dArray = a[j];
                int n3 = j;
                dArray[n3] = dArray[n3] + 1.0;
                int jp1 = j + 1;
                if (n >= jp1) {
                    for (k = jp1; k <= n; ++k) {
                        double sum = 0.0;
                        for (i = j; i <= m; ++i) {
                            sum += a[i][j] * a[i][k];
                        }
                        temp = sum / a[j][j];
                        for (i = j; i <= m; ++i) {
                            double[] dArray2 = a[i];
                            int n4 = k;
                            dArray2[n4] = dArray2[n4] - temp * a[i][j];
                        }
                        if (!pivot || rdiag[k] == 0.0) continue;
                        temp = a[j][k] / rdiag[k];
                        int n5 = k;
                        rdiag[n5] = rdiag[n5] * Math.sqrt(Math.max(0.0, 1.0 - temp * temp));
                        double fac = rdiag[k] / wa[k];
                        if (!(0.05 * fac * fac <= 2.22044604926E-16)) continue;
                        for (i = jp1; i <= m; ++i) {
                            tempvec[i - j] = a[i][k];
                        }
                        rdiag[k] = Minpack_f77.enorm_f77(m - j, tempvec);
                        wa[k] = rdiag[k];
                    }
                }
            }
            rdiag[j] = -ajnorm;
        }
    }

    public static void qrsolv_f77(int n, double[][] r, int[] ipvt, double[] diag, double[] qtb, double[] x, double[] sdiag, double[] wa) {
        int k;
        int l;
        int i;
        int j;
        for (j = 1; j <= n; ++j) {
            for (i = j; i <= n; ++i) {
                r[i][j] = r[j][i];
            }
            x[j] = r[j][j];
            wa[j] = qtb[j];
        }
        for (j = 1; j <= n; ++j) {
            l = ipvt[j];
            if (diag[l] != 0.0) {
                for (k = j; k <= n; ++k) {
                    sdiag[k] = 0.0;
                }
                sdiag[j] = diag[l];
                double qtbpj = 0.0;
                for (k = j; k <= n; ++k) {
                    int kp1;
                    double cos;
                    double sin;
                    if (sdiag[k] == 0.0) continue;
                    if (Math.abs(r[k][k]) < Math.abs(sdiag[k])) {
                        double cotan = r[k][k] / sdiag[k];
                        sin = 0.5 / Math.sqrt(0.25 + 0.25 * cotan * cotan);
                        cos = sin * cotan;
                    } else {
                        double tan = sdiag[k] / r[k][k];
                        cos = 0.5 / Math.sqrt(0.25 + 0.25 * tan * tan);
                        sin = cos * tan;
                    }
                    r[k][k] = cos * r[k][k] + sin * sdiag[k];
                    double temp = cos * wa[k] + sin * qtbpj;
                    qtbpj = -sin * wa[k] + cos * qtbpj;
                    wa[k] = temp;
                    for (i = kp1 = k + 1; i <= n; ++i) {
                        temp = cos * r[i][k] + sin * sdiag[i];
                        sdiag[i] = -sin * r[i][k] + cos * sdiag[i];
                        r[i][k] = temp;
                    }
                }
            }
            sdiag[j] = r[j][j];
            r[j][j] = x[j];
        }
        int nsing = n;
        for (j = 1; j <= n; ++j) {
            if (sdiag[j] == 0.0 && nsing == n) {
                nsing = j - 1;
            }
            if (nsing >= n) continue;
            wa[j] = 0.0;
        }
        for (k = 1; k <= nsing; ++k) {
            int jp1;
            j = nsing - k + 1;
            double sum = 0.0;
            for (i = jp1 = j + 1; i <= nsing; ++i) {
                sum += r[i][j] * wa[i];
            }
            wa[j] = (wa[j] - sum) / sdiag[j];
        }
        for (j = 1; j <= n; ++j) {
            l = ipvt[j];
            x[l] = wa[j];
        }
    }

    public static void lmpar_f77(int n, double[][] r, int[] ipvt, double[] diag, double[] qtb, double delta, double[] par, double[] x, double[] sdiag, double[] wa1, double[] wa2) {
        double sum;
        int l;
        int i;
        int jm1;
        double temp;
        int j;
        double dwarf = 2.22507385852E-308;
        int nsing = n;
        for (j = 1; j <= n; ++j) {
            wa1[j] = qtb[j];
            if (r[j][j] == 0.0 && nsing == n) {
                nsing = j - 1;
            }
            if (nsing >= n) continue;
            wa1[j] = 0.0;
        }
        for (int k = 1; k <= nsing; ++k) {
            int n2 = j = nsing - k + 1;
            wa1[n2] = wa1[n2] / r[j][j];
            temp = wa1[j];
            jm1 = j - 1;
            for (i = 1; i <= jm1; ++i) {
                int n3 = i;
                wa1[n3] = wa1[n3] - r[i][j] * temp;
            }
        }
        for (j = 1; j <= n; ++j) {
            l = ipvt[j];
            x[l] = wa1[j];
        }
        int iter = 0;
        for (j = 1; j <= n; ++j) {
            wa2[j] = diag[j] * x[j];
        }
        double dxnorm = Minpack_f77.enorm_f77(n, wa2);
        double fp = dxnorm - delta;
        if (fp <= 0.1 * delta) {
            par[1] = 0.0;
            return;
        }
        double parl = 0.0;
        if (nsing >= n) {
            for (j = 1; j <= n; ++j) {
                l = ipvt[j];
                wa1[j] = diag[l] * (wa2[l] / dxnorm);
            }
            for (j = 1; j <= n; ++j) {
                sum = 0.0;
                jm1 = j - 1;
                for (i = 1; i <= jm1; ++i) {
                    sum += r[i][j] * wa1[i];
                }
                wa1[j] = (wa1[j] - sum) / r[j][j];
            }
            temp = Minpack_f77.enorm_f77(n, wa1);
            parl = fp / delta / temp / temp;
        }
        for (j = 1; j <= n; ++j) {
            sum = 0.0;
            for (i = 1; i <= j; ++i) {
                sum += r[i][j] * qtb[i];
            }
            l = ipvt[j];
            wa1[j] = sum / diag[l];
        }
        double gnorm = Minpack_f77.enorm_f77(n, wa1);
        double paru = gnorm / delta;
        if (paru == 0.0) {
            paru = dwarf / Math.min(delta, 0.1);
        }
        par[1] = Math.max(par[1], parl);
        par[1] = Math.min(par[1], paru);
        if (par[1] == 0.0) {
            par[1] = gnorm / dxnorm;
        }
        boolean loop = true;
        while (loop) {
            ++iter;
            if (par[1] == 0.0) {
                par[1] = Math.max(dwarf, 0.001 * paru);
            }
            temp = Math.sqrt(par[1]);
            for (j = 1; j <= n; ++j) {
                wa1[j] = temp * diag[j];
            }
            Minpack_f77.qrsolv_f77(n, r, ipvt, wa1, qtb, x, sdiag, wa2);
            for (j = 1; j <= n; ++j) {
                wa2[j] = diag[j] * x[j];
            }
            dxnorm = Minpack_f77.enorm_f77(n, wa2);
            temp = fp;
            fp = dxnorm - delta;
            if (Math.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= temp && temp < 0.0 || iter == 10) {
                if (iter == 0) {
                    par[1] = 0.0;
                }
                return;
            }
            for (j = 1; j <= n; ++j) {
                l = ipvt[j];
                wa1[j] = diag[l] * (wa2[l] / dxnorm);
            }
            for (j = 1; j <= n; ++j) {
                int jp1;
                int n4 = j;
                wa1[n4] = wa1[n4] / sdiag[j];
                temp = wa1[j];
                for (i = jp1 = j + 1; i <= n; ++i) {
                    int n5 = i;
                    wa1[n5] = wa1[n5] - r[i][j] * temp;
                }
            }
            temp = Minpack_f77.enorm_f77(n, wa1);
            double parc = fp / delta / temp / temp;
            if (fp > 0.0) {
                parl = Math.max(parl, par[1]);
            }
            if (fp < 0.0) {
                paru = Math.min(paru, par[1]);
            }
            par[1] = Math.max(parl, par[1] + parc);
        }
    }

    public static void lmdif1_f77(Lmdif_fcn nlls, int m, int n, double[] x, double[] fvec, double tol, int[] info) {
        double[] diag = new double[n + 1];
        int[] nfev = new int[2];
        double[][] fjac = new double[m + 1][n + 1];
        int[] ipvt = new int[n + 1];
        double[] qtf = new double[n + 1];
        double factor = 100.0;
        info[1] = 0;
        if (n <= 0 || m < n || tol < 0.0) {
            return;
        }
        int maxfev = 200 * (n + 1);
        double ftol = tol;
        double xtol = tol;
        double gtol = 0.0;
        double epsfcn = 0.0;
        int mode = 1;
        int nprint = 0;
        Minpack_f77.lmdif_f77(nlls, m, n, x, fvec, ftol, xtol, gtol, maxfev, epsfcn, diag, mode, factor, nprint, info, nfev, fjac, ipvt, qtf);
        if (info[1] == 8) {
            info[1] = 4;
        }
    }

    public static void lmdif_f77(Lmdif_fcn nlls, int m, int n, double[] x, double[] fvec, double ftol, double xtol, double gtol, int maxfev, double epsfcn, double[] diag, int mode, double factor, int nprint, int[] info, int[] nfev, double[][] fjac, int[] ipvt, double[] qtf) {
        int j;
        double[] par = new double[2];
        int[] iflag = new int[2];
        double[] wa1 = new double[n + 1];
        double[] wa2 = new double[n + 1];
        double[] wa3 = new double[n + 1];
        double[] wa4 = new double[m + 1];
        double delta = 0.0;
        double xnorm = 0.0;
        info[1] = 0;
        iflag[1] = 0;
        nfev[1] = 0;
        if (n <= 0 || m < n || ftol < 0.0 || xtol < 0.0 || gtol < 0.0 || maxfev <= 0 || factor <= 0.0) {
            if (nprint > 0) {
                nlls.fcn(m, n, x, fvec, iflag);
            }
            return;
        }
        if (mode == 2) {
            for (j = 1; j <= n; ++j) {
                if (!(diag[j] <= 0.0)) continue;
                if (nprint > 0) {
                    nlls.fcn(m, n, x, fvec, iflag);
                }
                return;
            }
        }
        iflag[1] = 1;
        nlls.fcn(m, n, x, fvec, iflag);
        nfev[1] = 1;
        if (iflag[1] < 0) {
            info[1] = iflag[1];
            iflag[1] = 0;
            if (nprint > 0) {
                nlls.fcn(m, n, x, fvec, iflag);
            }
            return;
        }
        double fnorm = Minpack_f77.enorm_f77(m, fvec);
        par[1] = 0.0;
        int iter = 1;
        boolean doneout = false;
        while (!doneout) {
            int l;
            double temp;
            double sum;
            int i;
            iflag[1] = 2;
            Minpack_f77.fdjac2_f77(nlls, m, n, x, fvec, fjac, iflag, epsfcn, wa4);
            nfev[1] = nfev[1] + n;
            if (iflag[1] < 0) {
                info[1] = iflag[1];
                iflag[1] = 0;
                if (nprint > 0) {
                    nlls.fcn(m, n, x, fvec, iflag);
                }
                return;
            }
            if (nprint > 0) {
                iflag[1] = 0;
                if ((iter - 1) % nprint == 0) {
                    nlls.fcn(m, n, x, fvec, iflag);
                }
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                    iflag[1] = 0;
                    nlls.fcn(m, n, x, fvec, iflag);
                    return;
                }
            }
            Minpack_f77.qrfac_f77(m, n, fjac, true, ipvt, wa1, wa2, wa3);
            if (iter == 1) {
                if (mode != 2) {
                    for (j = 1; j <= n; ++j) {
                        diag[j] = wa2[j];
                        if (wa2[j] != 0.0) continue;
                        diag[j] = 1.0;
                    }
                }
                for (j = 1; j <= n; ++j) {
                    wa3[j] = diag[j] * x[j];
                }
                xnorm = Minpack_f77.enorm_f77(n, wa3);
                delta = factor * xnorm;
                if (delta == 0.0) {
                    delta = factor;
                }
            }
            for (i = 1; i <= m; ++i) {
                wa4[i] = fvec[i];
            }
            for (j = 1; j <= n; ++j) {
                if (fjac[j][j] != 0.0) {
                    sum = 0.0;
                    for (i = j; i <= m; ++i) {
                        sum += fjac[i][j] * wa4[i];
                    }
                    temp = -sum / fjac[j][j];
                    for (i = j; i <= m; ++i) {
                        int n2 = i;
                        wa4[n2] = wa4[n2] + fjac[i][j] * temp;
                    }
                }
                fjac[j][j] = wa1[j];
                qtf[j] = wa4[j];
            }
            double gnorm = 0.0;
            if (fnorm != 0.0) {
                for (j = 1; j <= n; ++j) {
                    l = ipvt[j];
                    if (wa2[l] == 0.0) continue;
                    sum = 0.0;
                    for (i = 1; i <= j; ++i) {
                        sum += fjac[i][j] * (qtf[i] / fnorm);
                    }
                    gnorm = Math.max(gnorm, Math.abs(sum / wa2[l]));
                }
            }
            if (gnorm <= gtol) {
                info[1] = 4;
            }
            if (info[1] != 0) {
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                }
                iflag[1] = 0;
                if (nprint > 0) {
                    nlls.fcn(m, n, x, fvec, iflag);
                }
                return;
            }
            if (mode != 2) {
                for (j = 1; j <= n; ++j) {
                    diag[j] = Math.max(diag[j], wa2[j]);
                }
            }
            boolean donein = false;
            while (!donein) {
                Minpack_f77.lmpar_f77(n, fjac, ipvt, diag, qtf, delta, par, wa1, wa2, wa3, wa4);
                for (j = 1; j <= n; ++j) {
                    wa1[j] = -wa1[j];
                    wa2[j] = x[j] + wa1[j];
                    wa3[j] = diag[j] * wa1[j];
                }
                double pnorm = Minpack_f77.enorm_f77(n, wa3);
                if (iter == 1) {
                    delta = Math.min(delta, pnorm);
                }
                iflag[1] = 1;
                nlls.fcn(m, n, wa2, wa4, iflag);
                nfev[1] = nfev[1] + 1;
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, iflag);
                    }
                    return;
                }
                double fnorm1 = Minpack_f77.enorm_f77(m, wa4);
                double actred = -1.0;
                if (0.1 * fnorm1 < fnorm) {
                    actred = 1.0 - fnorm1 / fnorm * (fnorm1 / fnorm);
                }
                for (j = 1; j <= n; ++j) {
                    wa3[j] = 0.0;
                    l = ipvt[j];
                    temp = wa1[l];
                    for (i = 1; i <= j; ++i) {
                        int n3 = i;
                        wa3[n3] = wa3[n3] + fjac[i][j] * temp;
                    }
                }
                double temp1 = Minpack_f77.enorm_f77(n, wa3) / fnorm;
                double temp2 = Math.sqrt(par[1]) * pnorm / fnorm;
                double prered = temp1 * temp1 + temp2 * temp2 / 0.5;
                double dirder = -(temp1 * temp1 + temp2 * temp2);
                double ratio = 0.0;
                if (prered != 0.0) {
                    ratio = actred / prered;
                }
                if (ratio <= 0.25) {
                    temp = actred >= 0.0 ? 0.5 : 0.5 * dirder / (dirder + 0.5 * actred);
                    if (0.1 * fnorm1 >= fnorm || temp < 0.1) {
                        temp = 0.1;
                    }
                    delta = temp * Math.min(delta, pnorm / 0.1);
                    par[1] = par[1] / temp;
                } else if (par[1] == 0.0 || ratio >= 0.75) {
                    delta = pnorm / 0.5;
                    par[1] = par[1] * 0.5;
                }
                if (ratio >= 1.0E-4) {
                    for (j = 1; j <= n; ++j) {
                        x[j] = wa2[j];
                        wa2[j] = diag[j] * x[j];
                    }
                    for (i = 1; i <= m; ++i) {
                        fvec[i] = wa4[i];
                    }
                    xnorm = Minpack_f77.enorm_f77(n, wa2);
                    fnorm = fnorm1;
                    ++iter;
                }
                if (Math.abs(actred) <= ftol && prered <= ftol && 0.5 * ratio <= 1.0) {
                    info[1] = 1;
                }
                if (delta <= xtol * xnorm) {
                    info[1] = 2;
                }
                if (Math.abs(actred) <= ftol && prered <= ftol && 0.5 * ratio <= 1.0 && info[1] == 2) {
                    info[1] = 3;
                }
                if (info[1] != 0) {
                    if (iflag[1] < 0) {
                        info[1] = iflag[1];
                    }
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, iflag);
                    }
                    return;
                }
                if (nfev[1] >= maxfev) {
                    info[1] = 5;
                }
                if (Math.abs(actred) <= 2.22044604926E-16 && prered <= 2.22044604926E-16 && 0.5 * ratio <= 1.0) {
                    info[1] = 6;
                }
                if (delta <= 2.22044604926E-16 * xnorm) {
                    info[1] = 7;
                }
                if (gnorm <= 2.22044604926E-16) {
                    info[1] = 8;
                }
                if (info[1] != 0) {
                    if (iflag[1] < 0) {
                        info[1] = iflag[1];
                    }
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, iflag);
                    }
                    return;
                }
                if (!(ratio >= 1.0E-4)) continue;
                donein = true;
            }
        }
    }

    public static void fdjac2_f77(Lmdif_fcn nlls, int m, int n, double[] x, double[] fvec, double[][] fjac, int[] iflag, double epsfcn, double[] wa) {
        double eps = Math.sqrt(Math.max(epsfcn, 2.22044604926E-16));
        for (int j = 1; j <= n; ++j) {
            double temp = x[j];
            double h = eps * Math.abs(temp);
            if (h == 0.0) {
                h = eps;
            }
            x[j] = temp + h;
            nlls.fcn(m, n, x, wa, iflag);
            if (iflag[1] < 0) {
                return;
            }
            x[j] = temp;
            for (int i = 1; i <= m; ++i) {
                fjac[i][j] = (wa[i] - fvec[i]) / h;
            }
        }
    }
}

