/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseArgumentsIllegalValueException;
import com.github.rvesse.airline.parser.errors.ParseInvalidRestrictionException;
import com.github.rvesse.airline.parser.errors.ParseOptionIllegalValueException;
import com.github.rvesse.airline.restrictions.common.AbstractAllowedValuesRestriction;
import com.github.rvesse.airline.types.DefaultTypeConverter;
import com.github.rvesse.airline.types.TypeConverter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class AllowedValuesRestriction
extends AbstractAllowedValuesRestriction {
    private Object currentState = null;
    private Set<Object> allowedValues = null;

    public AllowedValuesRestriction(String ... rawValues) {
        super(false);
        this.rawValues.addAll(Arrays.asList(rawValues));
    }

    @Override
    public <T> void postValidate(ParseState<T> state, OptionMetadata option, Object value) {
        if (this.rawValues.isEmpty()) {
            return;
        }
        Set<Object> allowedValues = this.createAllowedValues(state, option.getTitle(), option.getJavaType(), option.getTypeConverterProvider().getTypeConverter(option, state));
        if (!allowedValues.contains(value)) {
            throw new ParseOptionIllegalValueException(option.getTitle(), value, allowedValues);
        }
    }

    protected synchronized <T> Set<Object> createAllowedValues(ParseState<T> state, String title, Class<?> type, TypeConverter converter) {
        if (this.currentState == state) {
            return this.allowedValues;
        }
        LinkedHashSet<Object> actualValues = new LinkedHashSet<Object>();
        if (converter == null) {
            converter = new DefaultTypeConverter();
        }
        for (String rawValue : this.rawValues) {
            try {
                actualValues.add(converter.convert(title, type, rawValue));
            }
            catch (Exception e) {
                throw new ParseInvalidRestrictionException(e, "Unable to parse raw value '%s' in order to apply allowed values restriction", rawValue);
            }
        }
        this.currentState = state;
        this.allowedValues = actualValues;
        return actualValues;
    }

    @Override
    public <T> void postValidate(ParseState<T> state, ArgumentsMetadata arguments, Object value) {
        if (this.rawValues.isEmpty()) {
            return;
        }
        String title = AllowedValuesRestriction.getArgumentTitle(state, arguments);
        Set<Object> allowedValues = this.createAllowedValues(state, title, arguments.getJavaType(), arguments.getTypeConverterProvider().getTypeConverter(arguments, state));
        if (!allowedValues.contains(value)) {
            throw new ParseArgumentsIllegalValueException(title, value, allowedValues);
        }
    }
}

