/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.AbstractParser;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.options.OptionParser;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.parser.AbbreviatedOptionFinder;
import com.github.rvesse.airline.utils.predicates.parser.OptionFinder;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AbstractOptionParser<T>
extends AbstractParser<T>
implements OptionParser<T> {
    private static final Pattern SHORT_OPTIONS_PREFIX = Pattern.compile("-[^-].*");

    protected final OptionMetadata findOption(ParseState<T> state, List<OptionMetadata> options, String name) {
        return this.findOption(state, options, name, null);
    }

    protected final OptionMetadata findOption(ParseState<T> state, List<OptionMetadata> options, String name, OptionMetadata defaultValue) {
        Object findOptionPredicate = state.getParserConfiguration().allowsAbbreviatedOptions() ? new AbbreviatedOptionFinder(name, (Collection<OptionMetadata>)options) : new OptionFinder(name);
        return AirlineUtils.find(options, findOptionPredicate, defaultValue);
    }

    protected boolean hasShortNamePrefix(String name) {
        return SHORT_OPTIONS_PREFIX.matcher(name).matches();
    }
}

